<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema"   
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan"
    >
    
    <!-- 
        
        This XSLT is used to check which user is denied for certain privilege.
        
        criteria (and)
             extend def
             criterion       access deny ( accesstoken test )  
             criterion       access deny ( accesstoken test ) 
              ...
    -->
    
    
    <xsl:variable name="Definitions"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
    <xsl:variable name="Tests"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests"/>
    <xsl:variable name="TestedItems"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests"/>
    <xsl:variable name="CollectedObjects"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:collected_objects"/>
    <xsl:variable name="SystemData"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data"/>
    <xsl:variable name="States"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states"/>
    <xsl:variable name="Objects"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects"/>
    <xsl:variable name="Variables"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables"/>
    <xsl:variable name="OvalResult"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions"/>
    
    <xsl:variable name="smallcase" select="'abcdefghijklmnopqrstuvwxyz'" />
    <xsl:variable name="uppercase" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'" />
    
    <xsl:template name="toggleBoolean">
        <xsl:param name="value"/>
        <xsl:choose>
            <xsl:when test="$value = 'true'">
                <xsl:value-of select="false()"/>
            </xsl:when>
            <xsl:when test="$value = 'false'">
                <xsl:value-of select="true()"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="true()"/>
            </xsl:otherwise>
        </xsl:choose>
        
        
    </xsl:template>
    
    
    <xsl:template name="getPrivilege">
        <xsl:param name="privilegeName"/>
        
        <xsl:choose>
            <xsl:when test="$privilegeName = 'seauditprivilege' ">
                <xsl:text>generate security audits</xsl:text>
            </xsl:when>
            
            <xsl:when test="$privilegeName = 'sebackupprivilege' ">
                <xsl:text>back up files and directories</xsl:text>
            </xsl:when>
            
            <xsl:when test="$privilegeName = 'secreateglobalprivilege' ">
                <xsl:text>create global privilage</xsl:text>
            </xsl:when>
            
            <xsl:when test="$privilegeName = 'secreateglobalprivilege' ">
                <xsl:text>create  pagefile</xsl:text>
            </xsl:when>
            
            <xsl:when test="$privilegeName = 'secreatepermanentprivilege' ">
                <xsl:text>create permanent shared objects</xsl:text>
            </xsl:when>
            
            <xsl:when test="$privilegeName = 'secreatesymboliclinkprivilege' ">
                <xsl:text>create a symbolic link</xsl:text>
            </xsl:when>
            
            <xsl:when test="$privilegeName = 'secreatetokenprivilege' ">
                <xsl:text>create a token object</xsl:text>
            </xsl:when>
            
            <xsl:when test="$privilegeName = 'sedebugprivilege' ">
                <xsl:text>debug programs</xsl:text>
            </xsl:when>
            
            <xsl:when test="$privilegeName = 'seloaddriverprivilege' ">
                <xsl:text> load and unload driver</xsl:text>
            </xsl:when>
            
            <xsl:when test="$privilegeName = 'selockmemoryprivilege' ">
                <xsl:text> lock pages in memory</xsl:text>
            </xsl:when>
            
            <xsl:when test="$privilegeName = 'semachineaccountprivilege' ">
                <xsl:text> add a computer account to a specific domain</xsl:text>
            </xsl:when>
            
            <xsl:when test="$privilegeName = 'semanagevolumeprivilege' ">
                <xsl:text> manage the files on a volume (volumes or disks)</xsl:text>
            </xsl:when>
            
            <xsl:when test="$privilegeName = 'seprofilesingleprocessprivilege' ">
                <xsl:text>sample the performance of an application process (application profiling rights)</xsl:text>
            </xsl:when>
            
            
            <xsl:when test="$privilegeName = 'seremoteshutdownprivilege' ">
                <xsl:text>shut down a computer from a remote location on the network</xsl:text>
            </xsl:when>
            
            <xsl:when test="$privilegeName = 'serestoreprivilege' ">
                <xsl:text>circumvent file and directory permissions when restoring backed-up files and directories and to set any valid security principal as the owner of an object</xsl:text>
            </xsl:when>
            
            
            <xsl:when test="$privilegeName = 'sesecurityprivilege' ">
                <xsl:text>specify object access auditing options for individual resources such as files, Active Directory objects, and registry keys</xsl:text>
            </xsl:when>
            
            <xsl:when test="$privilegeName = 'seshutdownprivilege' ">
                <xsl:text>shut down the local computer</xsl:text>
            </xsl:when>
            
            <xsl:when test="$privilegeName = 'sesyncagentprivilege' ">
                <xsl:text>synchronize directory service data (read all objects and properties in the directory, regardless of the protection on the objects and properties) </xsl:text>
            </xsl:when>
            
            <xsl:when test="$privilegeName = 'sesystemenvironmentprivilege' ">
                <xsl:text>modify firmware environment values (modify system environment variables either by a process through an API or by a user through System Properties)</xsl:text>
            </xsl:when>
            
            <xsl:when test="$privilegeName = 'sesystemprofileprivilege' ">
                <xsl:text>sample the performance of system processes (System Profiling  Rights)</xsl:text>
            </xsl:when>
            
            <xsl:when test="$privilegeName = 'sesystemtimeprivilege' ">
                <xsl:text>change the system time</xsl:text>
            </xsl:when>
            
            <xsl:when test="$privilegeName = 'setakeownershipprivilege' ">
                <xsl:text>take ownership of an object without being granted discretionary access, including Active Directory objects, NTFS files and folders, printers, registry keys, services, processes, and threads</xsl:text>
            </xsl:when>
            
            <xsl:when test="$privilegeName = 'setcbprivilege' ">
                <xsl:text>act as part of the operating system (only some trusted protected subsystems are granted this privilege)</xsl:text>
            </xsl:when>
            
            <xsl:when test="$privilegeName = 'setimezoneprivilege' ">
                <xsl:text>change the time zone</xsl:text>
            </xsl:when>
            
            <xsl:when test="$privilegeName = 'seundockprivilege' ">
                <xsl:text>remove computer from docking station</xsl:text>
            </xsl:when>
            
            <xsl:when test="$privilegeName = 'seunsolicitedinputprivilege' ">
                <xsl:text>read unsolicited data from a terminal device (SeUnsolicitedInputPrivilege)</xsl:text>
            </xsl:when>
            
            <xsl:when test="$privilegeName = 'sebatchlogonright' ">
                <xsl:text>log on as a batch job</xsl:text>
            </xsl:when>
            
            <xsl:when test="$privilegeName = 'seinteractivelogonright' ">
                <xsl:text>log on locally</xsl:text>
            </xsl:when>
            
            <xsl:when test="$privilegeName = 'senetworklogonright' ">
                <xsl:text>access this computer from the network</xsl:text>
            </xsl:when>
            
            <xsl:when test="$privilegeName = 'seremoteinteractivelogonright' ">
                <xsl:text>log on through Terminal Services (Remote Desktop Connection)</xsl:text>
            </xsl:when>
            
            <xsl:when test="$privilegeName = 'seservicelogonright' ">
                <xsl:text>log on as a service</xsl:text>
            </xsl:when>
            
            <xsl:when test="$privilegeName = 'sedenybatchLogonright' ">
                <xsl:text>log on as a batch job</xsl:text>
            </xsl:when>
            
            <xsl:when test="$privilegeName = 'sedenyinteractivelogonright' ">
                <xsl:text>log on locally</xsl:text>
            </xsl:when>
            
            <xsl:when test="$privilegeName = 'sedenynetworklogonright' ">
                <xsl:text>access this computer from the network</xsl:text>
            </xsl:when>
            
            <xsl:when test="$privilegeName = 'sedenyremoteInteractivelogonright' ">
                <xsl:text>log on through Terminal Services (Remote Desktop Connection)</xsl:text>
            </xsl:when>
            
            <xsl:when test="$privilegeName = 'sedenyservicelogonright' ">
                <xsl:text>log on as a service</xsl:text>
            </xsl:when>
            
            <xsl:when test="$privilegeName = 'serelabelprivilege' ">
                <xsl:text>relabel</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$privilegeName"/>
            </xsl:otherwise>
        </xsl:choose>
        
    </xsl:template>
    
    
    <xsl:template name="getMessageId">        
        <xsl:param name="privilegeValue"/>
        
        <xsl:choose>
            <xsl:when test="$privilegeValue = '1' ">
                <xsl:text>com.mcafee.pa.msg.accessdenyviolation01</xsl:text>            
            </xsl:when>
            <xsl:when test="$privilegeValue = '0' ">
                <xsl:text>com.mcafee.pa.msg.accessdenyviolation02</xsl:text>            
            </xsl:when>           
        </xsl:choose>
        
    </xsl:template>
    
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        
        <xsl:variable name="result"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <xsl:if test="$result='false' ">
            <xsl:call-template name="winUserAccessDenyChecks">
                <xsl:with-param name="definitionId" select="$definitionId"/>
            </xsl:call-template>
        </xsl:if>
        
    </xsl:template>
    
    <xsl:template name="winUserAccessDenyChecks">
        <xsl:param name="definitionId"/>       
        
        
        <xsl:variable name="exDefinitionId">
            <xsl:value-of select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/oval-res:extend_definition/@definition_ref"/>
        </xsl:variable>
        
       <xsl:variable name="tests">
           <xsl:for-each select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:criterion">
                
                   <xsl:variable name="test">
                       <xsl:value-of select="@test_ref"/>
                   </xsl:variable>
                   
                   <xsl:variable name="state">
                       <xsl:value-of select="$Tests/win-def:accesstoken_test[@id=$test]/win-def:state/@state_ref"/>
                   </xsl:variable>
                   
                   <xsl:variable name="privilegeName">
                       <xsl:for-each select="$States/win-def:accesstoken_state[@id=$state ]/*">
                           <xsl:value-of select="name()"/>
                       </xsl:for-each>             
                   </xsl:variable>      
                   
                   <xsl:variable name="privilegeValue">
                       <xsl:for-each select="$States/win-def:accesstoken_state[@id=$state ]/*">
                           <xsl:value-of select="."/>
                       </xsl:for-each>             
                   </xsl:variable>
                   
                   <!--   Get the finding messgae Id        -->
                   
                   <xsl:variable name="findingMessageId">
                       <xsl:call-template name="getMessageId">                           
                           <xsl:with-param name="privilegeValue" select="$privilegeValue"/>
                       </xsl:call-template>
                   </xsl:variable>
                   
                   <!--   Get the privilege     -->
                   
                   <xsl:variable name="privilege">
                       <xsl:call-template name="getPrivilege">
                           <xsl:with-param name="privilegeName" select="$privilegeName"/>
                       </xsl:call-template>
                   </xsl:variable>
                   
                    <xsl:element name="test">
                        <xsl:attribute name="id">
                            <xsl:value-of select="$test"/>
                        </xsl:attribute>       
                        <xsl:attribute name="message_id">
                            <xsl:value-of select="$findingMessageId"/>
                        </xsl:attribute>       
                        <xsl:attribute name="privilege">
                            <xsl:value-of select="$privilege"/>
                        </xsl:attribute>       
                    </xsl:element>          
                
                </xsl:for-each>
        </xsl:variable>
                
        <!-- result of ex def        -->
        <xsl:variable name="rs_exDefinition">
            <xsl:value-of select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/oval-res:extend_definition[ @definition_ref = $exDefinitionId ]/@result"/>
        </xsl:variable>
        
        <!-- if service status -->
       <xsl:variable name="security_principle">
            <xsl:for-each select="xalan:nodeset($tests)/*">

                <xsl:variable name="test">
                    <xsl:value-of select="@id"/>
                </xsl:variable>
            
        <!--  Get object Value      -->
        
                <xsl:variable name="object">
                    <xsl:value-of select="$Tests/win-def:accesstoken_test[@id=$test]/win-def:object/@object_ref"/>            
                </xsl:variable>

                <xsl:variable name="securityPrinciple">            
                    <xsl:value-of select="$Objects/win-def:accesstoken_object[@id=$object ]/win-def:security_principle"/>                             
                </xsl:variable>
        
        
                    <xsl:if test="$securityPrinciple = '.*'  ">
                        <xsl:text></xsl:text>
                     </xsl:if>
                        <xsl:if test="$securityPrinciple != '.*'  ">
                            <xsl:value-of select="$securityPrinciple"/>
                        </xsl:if>
                        <xsl:if test="position() != last()">
                              <xsl:text>,</xsl:text>
                        </xsl:if>
                </xsl:for-each>
        </xsl:variable>
   
    
        <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">       
            
            <xsl:if test=" $rs_exDefinition = 'true'  ">
                
                <xsl:for-each select="xalan:nodeset($tests)/*">
                    
                    <xsl:variable name="test" select="@id"/>
                    <xsl:variable name="privilege" select="@privilege"/>
                    <xsl:variable name="tmp_message_id" select="@message_id"/>
                    
                    <xsl:for-each  select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[ @result = 'false'  or @result = 'error'  or  @result='not evaluated' ] ">
                        
                        <xsl:variable name="result" select="@result"/>
                        <xsl:variable name="itemRef" select="@item_id"/>              
                        
                        <xsl:variable name="user"
                            select="$SystemData/win-sc:accesstoken_item[@id=$itemRef]/win-sc:security_principle"/>
                        
                        <xsl:variable name="status"
                            select="$SystemData/win-sc:accesstoken_item[@id=$itemRef]/win-sc:security_principle/@status"/>
                        
                        <xsl:variable name="message_id">
                            <xsl:choose>
                                <xsl:when test="$status = 'does not exist' ">
                                    <xsl:text>com.mcafee.pa.msg.accessviolationerror00</xsl:text>                                    
                                </xsl:when>
                                <xsl:when test="$result = 'error' or  $result='not evaluated' ">
                                    <xsl:text>com.mcafee.pa.msg.accessviolationerror01</xsl:text>                                    
                                </xsl:when>                                
                                <xsl:otherwise>                                
                                    <xsl:value-of select="$tmp_message_id"/>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:variable>
                        
                        <xsl:variable name="isViolation">
                            <xsl:call-template name="toggleBoolean">
                                <xsl:with-param name="value">
                                    <xsl:value-of select="$result"/>
                                </xsl:with-param>
                            </xsl:call-template>
                        </xsl:variable>
                
                        <finding messageId="{$message_id}" isViolation="{$isViolation}">                        
                            <instanceValue key="privilege">
                                <xsl:value-of select="$privilege"/>
                            </instanceValue>
                            <instanceValue key="user">
                                <xsl:value-of select="$user"/>
                            </instanceValue>                       
                        </finding>
                        
                </xsl:for-each>
                </xsl:for-each>
            </xsl:if>
            <xsl:if test=" $rs_exDefinition != 'true'  ">
                <finding messageId="com.mcafee.pa.msg.notWindowsPlatform" isViolation="false"/>             
            </xsl:if>
            
        </findings>       

    </xsl:template>
    
</xsl:stylesheet>