<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema"   
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan"    >
    
    <!--  FILENAME: winSoftwareVersionCheck_Java_plugin.xsl         DATE: 24th Jan, 2014     AUTHOR: Deepak Asawa   -->
    <!--  MAPPINGFILE: winSoftwareVersionCheck_Java_plugin_xsl.txt    -->
    
    <!-- THIS LIBRARY IS DEVELOPED FOR COMPLIANCE CHECKS WHERE FIRST TEST IS REGISTRY EXISTENCE AND SECOND TEST IS FILE TEST  -->
    
    <xsl:template name="getSoftwareNameFromTitle">
        <xsl:param name="title"/>
        
        <xsl:variable name="software">
            <xsl:if test="contains($title, 'Maximum' )">
                <xsl:value-of select="substring-before($title, 'Maximum' )"/>
            </xsl:if>
            <xsl:if test="contains($title, 'Minimum' )">
                <xsl:value-of select="substring-before($title, 'Minimum' )"/>
            </xsl:if>
            <xsl:if test="contains($title, 'Security Update' )">
                <xsl:value-of select="substring-before($title, 'Security' )"/>
            </xsl:if>
            <xsl:if test="contains($title, 'version installed' )">
                <xsl:value-of select="substring-before($title, 'version installed' )"/>
            </xsl:if>
        </xsl:variable>
        
        <xsl:choose>            
            <xsl:when test="$software != '' ">
                <xsl:value-of select="$software"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$title"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <!-- Entry Function for the library  -->
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        
        <xsl:variable name="definitionIdWithoutCommon">
            <xsl:choose>   
                <xsl:when test="contains($definitionId, '.common' )">
                    <xsl:value-of select="concat(substring-before($definitionId, '.common'), substring-after($definitionId, '.common'))"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$definitionId"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="Definitions"
            select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
        <xsl:variable name="Tests"
            select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests"/>
        <xsl:variable name="TestedItems"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests"/>
        <xsl:variable name="SystemData"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data"/>
        <xsl:variable name="States"
            select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states"/>
        <xsl:variable name="OvalResult"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions"/>
        
        <!-- Final result -->
        <xsl:variable name="result"  select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionIdWithoutCommon]/@result"/>
        
        <xsl:variable name="title">
            <xsl:value-of select="$Definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>            
        </xsl:variable>
        
        <xsl:variable name="software">
            <xsl:call-template name="getSoftwareNameFromTitle">
                <xsl:with-param name="title" select="$title"/>            
            </xsl:call-template>
        </xsl:variable>
        
        <xsl:variable name="patchNumber">
            <xsl:if test="contains($title, 'for')">
                <xsl:value-of select="substring-before(substring-after($title, 'Security Update' ), ' for' )"/>
            </xsl:if>
        </xsl:variable>
        
        <xsl:variable name="tests">        
            <xsl:for-each select="$OvalResult/oval-res:definition[ @definition_id = $definitionIdWithoutCommon ]/oval-res:criteria/descendant::oval-res:criterion">
                <xsl:variable name="test" select="@test_ref"/>
                <xsl:if test="$Tests/win-def:file_test[@id=$test]">
                    <xsl:variable name="state"  select="$Tests/win-def:file_test[@id=$test]/win-def:state/@state_ref"/>
                    <xsl:choose>
                        <xsl:when test="$States/win-def:file_state[@id=$state]/win-def:version">
                            <xsl:variable name="versionnode" select="name($States/win-def:file_state[@id=$state]/win-def:version)"/>
                            <xsl:variable name="externalVar" select="$States/win-def:file_state[@id=$state]/win-def:version/@var_ref"/>
                            <xsl:variable name="operation" select="$States/win-def:file_state[@id=$state]/win-def:version/@operation"/>
                            <xsl:variable name="datatype" select="$States/win-def:file_state[@id=$state]/win-def:version/@datatype"/>
                            
                            <xsl:element name="test">
                                <xsl:attribute name="id">
                                    <xsl:value-of select="$test"/>
                                </xsl:attribute>
                                <xsl:attribute name="versionnodename">
                                    <xsl:value-of select="$versionnode"/>
                                </xsl:attribute>
                                <xsl:attribute name="externalVar">
                                    <xsl:value-of select="$externalVar"/>
                                </xsl:attribute>
                                <xsl:attribute name="operation">
                                    <xsl:value-of select="$operation"/>
                                </xsl:attribute>
                                
                                <xsl:attribute name="testtype">
                                    <xsl:text>file</xsl:text>
                                </xsl:attribute>
                                
                            </xsl:element>
                        </xsl:when>
                        
                        
                        <xsl:when  test="$States/win-def:file_state[@id=$state]/win-def:product_version">
                            <xsl:variable name="versionnode" select="name($States/win-def:file_state[@id=$state]/win-def:product_version)"/>
                            <xsl:variable name="externalVar" select="$States/win-def:file_state[@id=$state]/win-def:product_version/@var_ref"/>
                            <xsl:variable name="operation" select="$States/win-def:file_state[@id=$state]/win-def:product_version/@operation"/>
                            <xsl:variable name="datatype" select="$States/win-def:file_state[@id=$state]/win-def:version/@datatype"/>
                            
                            <xsl:element name="test">
                                <xsl:attribute name="id">
                                    <xsl:value-of select="$test"/>
                                </xsl:attribute>
                                <xsl:attribute name="versionnodename">
                                    <xsl:value-of select="$versionnode"/>
                                </xsl:attribute>
                                <xsl:attribute name="externalVar">
                                    <xsl:value-of select="$externalVar"/>
                                </xsl:attribute>
                                <xsl:attribute name="operation">
                                    <xsl:value-of select="$operation"/>
                                </xsl:attribute>
                                
                                <xsl:attribute name="testtype">
                                    <xsl:text>file</xsl:text>
                                </xsl:attribute>
                                
                            </xsl:element>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:variable name="versionnode" select="name($States/win-def:file_state[@id=$state]/win-def:version)"/>
                            <xsl:variable name="externalVar" select="$States/win-def:file_state[@id=$state]/win-def:version/@var_ref"/>
                            <xsl:variable name="operation" select="$States/win-def:file_state[@id=$state]/win-def:version/@operation"/>
                            <xsl:variable name="datatype" select="$States/win-def:file_state[@id=$state]/win-def:version/@datatype"/>
                            
                            <xsl:element name="test">
                                <xsl:attribute name="id">
                                    <xsl:value-of select="$test"/>
                                </xsl:attribute>
                                <xsl:attribute name="versionnodename">
                                    <xsl:value-of select="$versionnode"/>
                                </xsl:attribute>
                                <xsl:attribute name="externalVar">
                                    <xsl:value-of select="$externalVar"/>
                                </xsl:attribute>
                                <xsl:attribute name="operation">
                                    <xsl:value-of select="$operation"/>
                                </xsl:attribute>
                                
                                <xsl:attribute name="testtype">
                                    <xsl:text>file</xsl:text>
                                </xsl:attribute>
                                
                            </xsl:element>
                        </xsl:otherwise>
                    </xsl:choose> 
                </xsl:if>
            </xsl:for-each>                        
        </xsl:variable>
        
        <xsl:variable name="resultCriterion1"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionIdWithoutCommon]/oval-res:criteria/descendant::oval-res:criterion[1]/@result"/>
        <xsl:variable name="resultCriterion2"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionIdWithoutCommon]/oval-res:criteria/descendant::oval-res:criterion[2]/@result"/>
        
        <xsl:variable name="actualVersion">
            <xsl:if test="$result = 'false' ">
                <xsl:for-each select="xalan:nodeset($tests)/descendant::test">
                    <xsl:choose>
                        <xsl:when test="xalan:nodeset($tests)/descendant::test[ @testtype = 'file']">
                            <xsl:variable name="test" select="@id"/>
                            <xsl:for-each select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[ @result = 'false'] ">
                                <xsl:variable name="itemRef" select="@item_id"/>
                                <xsl:choose>
                                    <xsl:when test="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:product_version">
                                        <xsl:value-of select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:product_version"/>
                                    </xsl:when>
                                    <xsl:when test="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:version">
                                        <xsl:value-of select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:version"/>
                                    </xsl:when>
                                </xsl:choose>
                                <xsl:value-of select="concat(current(), '  ' )"/>          
                            </xsl:for-each>
                        </xsl:when>
                    </xsl:choose>
                </xsl:for-each>
            </xsl:if>
            
            <xsl:if test="$result = 'true' ">
                <xsl:for-each select="xalan:nodeset($tests)/descendant::test">
                    <xsl:choose>
                        <xsl:when test="xalan:nodeset($tests)/descendant::test[ @testtype = 'file']">
                            <xsl:variable name="test" select="@id"/>
                            <xsl:for-each select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[ @result = 'true'] ">
                                <xsl:variable name="itemRef" select="@item_id"/>
                                <xsl:choose>
                                    <xsl:when test="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:product_version">
                                        <xsl:value-of select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:product_version"/>
                                    </xsl:when>
                                    <xsl:when test="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:version">
                                        <xsl:value-of select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:version"/>
                                    </xsl:when>
                                </xsl:choose>
                                <xsl:value-of select="concat(current(),'  ' )"/>          
                            </xsl:for-each>
                        </xsl:when>
                    </xsl:choose>
                </xsl:for-each>
            </xsl:if>
        </xsl:variable>
        
        <!-- Decide about the message id depending upon  the combination of results for various criterions ........................................................................................... -->
        
        <xsl:variable name="externalVarId" select="$States/win-def:file_state/win-def:product_version/@var_ref"/>
        <xsl:variable name="inputVersion" 
            select="$TestedItems/oval-res:test/oval-res:tested_variable[@variable_id = $externalVarId]"/>
        
        <xsl:variable name="message_id">
            <!-- Check if final result is false ........................................................................................... -->
            <xsl:if test="$result='false'">
                <xsl:text>com.mcafee.pa.msg.winsoftwareminimumversionmessage</xsl:text>
            </xsl:if>
            <!-- Check if final result is true ........................................................................................... -->
            <xsl:if test="$result='true'">
                <xsl:choose>
                    <xsl:when test="($resultCriterion1 = 'true')">
                        <xsl:text>com.mcafee.pa.msg.winsoftwareversionnotexist</xsl:text>
                    </xsl:when>
                    <xsl:when test="($resultCriterion1 = 'false'  and $resultCriterion2 = 'true')">
                        <xsl:text>com.mcafee.pa.msg.winsoftwareminimumversionmessage</xsl:text>
                    </xsl:when>
                </xsl:choose>
            </xsl:if>
        </xsl:variable>
        
        <!-- Decide about the isViolation value depending upon  the result of the check ........................................................................................... -->
        <xsl:variable name="isViolationValue">
            <xsl:choose>
                <xsl:when test="$result = 'true' ">
                    <xsl:text>false</xsl:text>                                              
                </xsl:when>
                <xsl:when test="$result = 'false' ">
                    <xsl:text>true</xsl:text>                                              
                </xsl:when>
            </xsl:choose>               
        </xsl:variable>
        
        <!--Now Create Finding xml with all the values extracted ........................................................................................... -->
        <findings id="{$definitionIdWithoutCommon}" xmlns="http://results.pa.mcafee.com/findings/5.2">
            <finding messageId="{$message_id}" isViolation="{$isViolationValue}">
                <instanceValue key="software">
                    <xsl:value-of select="$software"/>                                                    
                </instanceValue>
                <instanceValue key="inputVersion">
                    <xsl:value-of select="$inputVersion"/>                                                    
                </instanceValue>
                <actualValue key="actualVersion">
                    <xsl:value-of select="$actualVersion"/>                                                    
                </actualValue>
            </finding>
        </findings>
    </xsl:template>
</xsl:stylesheet>
