﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema"   
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan"    >
    
    <!--  FILENAME: winCompCredUI_2_SCAP.xsl         DATE: 17th Jan, 2013     AUTHOR: Nandini NR   -->
    <!--  MAPPINGFILE: winCompCredUI_SCAP_2_SCAP_xsl.txt    -->
    
    <!-- This library is a modified version of winCompCredUI_SCAP.xsl-->
    
    <!-- FOLLOWING ARE SOME OF THE ASSUMPTIONS TAKEN IN THE LOGIC FOR THE LIBRARY  -->
    <!--   1. Configuration/Policy name is extracted from the title of the check
             2. Following are the test cases which are taken into consideration for the logic:-
    ______________________________________________________________________________________________________________________________________________________________________
       Test Case	External Variable                              System Setting	         Check result             Message String                                                Is Violation        Message ID
    ______________________________________________________________________________________________________________________________________________________________________
       
       Result1    Not Configured/Disabled                     Not Configured	         Pass              <tilte> configuration is set as expected	                     FALSE                com.mcafee.pa.msg.winConf_SCAP
       Result2    Not Configured/Disabled                     Disabled        	                        Pass              <tilte> configuration is set as expected                     FALSE                com.mcafee.pa.msg.winConf_SCAP
       Result3    Not Configured/Disabled                     Enabled        	                        Fail                 <tilte> configuration setings are not as expected   TRUE                  com.mcafee.pa.msg.winConf_SCAP
       Result4    Enabled	                                                Enabled                                  Pass              <tilte> configuration is set as expected                     FALSE                com.mcafee.pa.msg.winConf_SCAP
       Result5    Enabled	                                                Disabled                                 Fail                 <tilte> configuration setings are not as expected    TRUE                 com.mcafee.pa.msg.winConf_SCAP
       Result5    Enabled	                                                Not Configured                      Fail                 <tilte> configuration setings are not as expected    TRUE                 com.mcafee.pa.msg.winConf_SCAP
       ______________________________________________________________________________________________________________________________________________________________________    
   -->

    
    <!-- Entry Function for the library  -->
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        
        <!-- Final result -->
        <xsl:variable name="result"  select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <xsl:variable name="Definitions"
            select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
        
        <!-- Extract configuration/policy name from the check title -->
        <xsl:variable name="title">
            <xsl:value-of select="$Definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>            
        </xsl:variable>
        
        <xsl:variable name="result1"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[1]/@result"/>
        <xsl:variable name="result2"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[2]/@result"/>
        <xsl:variable name="result3"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[3]/@result"/>
        <xsl:variable name="result4"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[4]/@result"/>
        
        <!-- Decide about the message id depending upon  the combination of results for various criterions ........................................................................................... -->

            <xsl:variable name="message_id">
                <xsl:text>com.mcafee.pa.msg.winConf_SCAP</xsl:text>
            </xsl:variable>
            
        <xsl:variable name="expectedValue">
            <xsl:choose>
                <xsl:when test="$result1 = 'true' ">
                    <xsl:text>Not Configured/Disabled(99999)</xsl:text>                                              
                </xsl:when>
                <xsl:when test="$result3 = 'true' ">
                    <xsl:text>Enabled(1)</xsl:text>                                              
                </xsl:when>
            </xsl:choose>               
        </xsl:variable>
        
        <xsl:variable name="actualValue">
            <xsl:choose>
                <xsl:when test="$result2 = 'true' ">
                    <xsl:text>Not Configured/Disabled</xsl:text>                                              
                </xsl:when>
                <xsl:when test="$result4 = 'true' ">
                    <xsl:text>Enabled (1)</xsl:text>                                     
                </xsl:when>
            </xsl:choose>               
        </xsl:variable>
        
        <!-- Decide about the isViolation value depending upon  the result of the check ........................................................................................... -->
            <xsl:variable name="isViolationValue">
                <xsl:choose>
                    <xsl:when test="$result = 'false' ">
                        <xsl:text>true</xsl:text>                                              
                    </xsl:when>
                    <xsl:when test="$result = 'true' ">
                        <xsl:text>false</xsl:text>                                              
                    </xsl:when>
                    </xsl:choose>               
            </xsl:variable>
        
        <!--Now Create Finding xml with all the values extracted ........................................................................................... -->
        <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">

            <finding messageId="{$message_id}" isViolation="{$isViolationValue}">
                <instanceValue key="title">
                    <xsl:value-of select="$title"/>                                                    
                </instanceValue>
                <instanceValue key="expectedValue">
                    <xsl:value-of select="$expectedValue"/>                                                    
                </instanceValue>
                <actualValue key="actualValue">
                    <xsl:value-of select="$actualValue"/>                                                    
                </actualValue>     
            </finding>
        </findings>
      
    </xsl:template>
</xsl:stylesheet>