<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema"   
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan"
    >
    
    <!--
       
       This XSLT is used to check which user allow for certain privilege and which is not.
       Schema is below 
       
       Criteria (and)
          extend def or family test         
          criterion  access allow     (accesstoken test) 
          .....            access allow    (accesstoken test)
          
          criterion access not allow (accesstoken test)
    -->
       
    <xsl:variable name="Definitions"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
    <xsl:variable name="Tests"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests"/>
    <xsl:variable name="TestedItems"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests"/>
    <xsl:variable name="CollectedObjects"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:collected_objects"/>
    <xsl:variable name="SystemData"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data"/>
    <xsl:variable name="States"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states"/>
    <xsl:variable name="Objects"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects"/>
    <xsl:variable name="Variables"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables"/>
    <xsl:variable name="OvalResult"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions"/>
   
   
    <xsl:template name="toggleBoolean">
        <xsl:param name="value"/>
        <xsl:choose>
            <xsl:when test="$value = 'true'">
                <xsl:value-of select="false()"/>
            </xsl:when>
            <xsl:when test="$value = 'false'">
                <xsl:value-of select="true()"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="true()"/>
            </xsl:otherwise>
        </xsl:choose>
        
        
    </xsl:template>
    
    
    <xsl:template name="getMessageId">
        <xsl:param name="privilegeName"/>
        <xsl:param name="privilegeValue"/>
        
        <xsl:choose>
            <xsl:when test="$privilegeValue = '0' or $privilegeValue = 'false' ">
                <xsl:value-of select="concat('com.mcafee.pa.msg.win',$privilegeName,'0')"/>            
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="concat('com.mcafee.pa.msg.win',$privilegeName,'1')"/>            
            </xsl:otherwise>            
        </xsl:choose>
        
    </xsl:template>
   
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        
        <xsl:variable name="result"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <xsl:if test="$result='false' ">
            <xsl:call-template name="winUserPrivilegeCheck">
                <xsl:with-param name="definitionId" select="$definitionId"/>
             </xsl:call-template>
        </xsl:if>
        
    </xsl:template>
    
    <xsl:template name="winUserPrivilegeCheck">
        <xsl:param name="definitionId"/>       
        
        
        <xsl:variable name="exDefinitionId">
            <xsl:value-of select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:extend_definition/@definition_ref"/>
        </xsl:variable>
        
        <!-- result of ex def        -->
        <xsl:variable name="rs_exDefinition">
            <xsl:value-of select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:extend_definition[ @definition_ref = $exDefinitionId ]/@result"/>
        </xsl:variable>
      
        <xsl:variable name="tests">
            <xsl:for-each select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:criterion">
                                    
                <xsl:variable name="test">
                    <xsl:value-of select="@test_ref"/>
                  </xsl:variable>
                
                <xsl:if test="$Tests/win-def:accesstoken_test[@id=$test]">
                    <xsl:variable name="state">
                        <xsl:value-of select="$Tests/win-def:accesstoken_test[@id=$test]/win-def:state/@state_ref"/>
                    </xsl:variable>
                   
                    <!--<xsl:variable name="privilegeName">
                        <xsl:value-of  select="name($States/win-def:accesstoken_state[@id=$state ]/*)"/>
                    </xsl:variable>-->
                    
                    <xsl:element name="test">
                        <xsl:attribute name="id">
                            <xsl:value-of select="$test"/>
                        </xsl:attribute>   
                        <!--<xsl:attribute name="privilegeName">
                            <xsl:value-of select="$privilegeName"/>
                            </xsl:attribute>-->
                        <xsl:attribute name="state">
                            <xsl:value-of select="$state"/>
                        </xsl:attribute>
                        <xsl:attribute name="type">
                            <xsl:text>accesstoken</xsl:text>
                        </xsl:attribute>            
                    </xsl:element>        
                </xsl:if>
                
                <xsl:if test="$Tests/oval-ind:family_test[@id=$test]">
                    <xsl:element name="test">
                        <xsl:attribute name="id">
                            <xsl:value-of select="$test"/>
                        </xsl:attribute>
                        <xsl:attribute name="type">
                            <xsl:text>family</xsl:text>
                        </xsl:attribute>
                    </xsl:element>
                </xsl:if>
                
            </xsl:for-each>
        </xsl:variable>
        
        <xsl:variable name="pre_test">
            <xsl:value-of select="xalan:nodeset($tests)/test[@type='family']/@id"/>
        </xsl:variable>
        
        <xsl:variable name="pre_test_result">
            <xsl:value-of select="$TestedItems/oval-res:test[@test_id=$pre_test ]/@result"/> 
        </xsl:variable>
        
        <xsl:variable name="result_precondition">
            <xsl:choose>
                <xsl:when test="normalize-space($pre_test_result) != '' ">
                    <xsl:value-of select="normalize-space($pre_test_result)"/>
                </xsl:when>
                <xsl:when test="normalize-space($pre_test_result) != '' ">
                    <xsl:value-of select="normalize-space($pre_test_result)"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="true()"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="isAnyFinding">
            <xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @type ='accesstoken' ]">
                <xsl:variable name="test" select="@id"/>
                <xsl:for-each  select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[ @result = 'false'  or @result ='not evaluated'] ">
                    <xsl:text>1</xsl:text>
                </xsl:for-each>        
            </xsl:for-each>
        </xsl:variable>
        
        
        
            <xsl:choose>
                <xsl:when test="$result_precondition = 'true' ">
                    <xsl:choose>
                          <xsl:when test="contains($isAnyFinding,'1')">                              
                                <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">
                                    <xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @type ='accesstoken' ]">
                                        
                                        <xsl:variable name="test" select="@id"/>
                                        <xsl:variable name="state" select="@state"/>
                                        
                                        <xsl:for-each  select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[ @result = 'false'  or @result = 'not evaluated'] ">
                                            
                                            <xsl:variable name="result" select="@result"/>
                                            <xsl:variable name="itemRef" select="@item_id"/>
                                            
                                            <xsl:variable name="user"
                                                select="$SystemData/win-sc:accesstoken_item[@id=$itemRef]/win-sc:security_principle"/>
                                            
                                            <xsl:variable name="status"
                                                select="$SystemData/win-sc:accesstoken_item[@id=$itemRef]/win-sc:security_principle/@status"/>
                                            
                                            <xsl:choose>
                                                <xsl:when test="$status = 'does not exist' ">
                                                    <finding messageId="com.mcafee.pa.msg.winuseraccountdoesnotexist" isViolation="true">
                                                        <instanceValue key="user">
                                                            <xsl:value-of select="$user"/>
                                                        </instanceValue>                                                                               
                                                    </finding>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <xsl:for-each select="$States/win-def:accesstoken_state[@id=$state ]/*">
                                                        <xsl:variable name="privilegeName" select="name(.)"/>
                                                        <xsl:variable name="externalVarId" select="@var_ref"/>
                                                        <xsl:variable name="externalVarValue" select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable[@variable_id = $externalVarId]"/>
                                                        <xsl:for-each select="$SystemData/win-sc:accesstoken_item[@id=$itemRef]/*">
                                                            <xsl:if test="name(.) = $privilegeName">
                                                                <xsl:variable name="privilegeValue" select="text()"/>
                                                                <xsl:variable name="message_id">
                                                                    <xsl:call-template name="getMessageId">
                                                                        <xsl:with-param name="privilegeName" select="$privilegeName"/>
                                                                        <xsl:with-param name="privilegeValue" select="$privilegeValue"/>
                                                                    </xsl:call-template>
                                                                </xsl:variable>
                                                                <xsl:if test="$message_id != '' and $externalVarValue != $privilegeValue">
                                                                    <finding messageId="{$message_id}" isViolation="true">
                                                                        <instanceValue key="user">
                                                                            <xsl:value-of select="$user"/>
                                                                        </instanceValue>
                                                                    </finding>
                                                                </xsl:if>
                                                            </xsl:if>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </xsl:for-each>
                                    </xsl:for-each>
                                </findings>
                        </xsl:when>
                          <xsl:otherwise>
                              <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">
                                  <xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @type ='accesstoken' ]">
                                      
                                      <xsl:variable name="test" select="@id"/>
                                      <xsl:variable name="state" select="@state"/>
                                      
                                      <xsl:for-each  select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[ @result = 'true'  ] ">
                                          
                                          <xsl:variable name="result" select="@result"/>
                                          <xsl:variable name="itemRef" select="@item_id"/>
                                          
                                          <xsl:variable name="user"
                                              select="$SystemData/win-sc:accesstoken_item[@id=$itemRef]/win-sc:security_principle"/>
                                          
                                          <xsl:variable name="status"
                                              select="$SystemData/win-sc:accesstoken_item[@id=$itemRef]/win-sc:security_principle/@status"/>
                                          
                                          <xsl:choose>
                                              <xsl:when test="$status = 'does not exist' ">
                                                  <finding messageId="com.mcafee.pa.msg.winuseraccountdoesnotexist" isViolation="false">
                                                      <instanceValue key="user">
                                                          <xsl:value-of select="$user"/>
                                                      </instanceValue>                                                                               
                                                  </finding>
                                              </xsl:when>
                                              <xsl:otherwise>
                                                  <xsl:for-each select="$States/win-def:accesstoken_state[@id=$state ]/*">
                                                      <xsl:variable name="privilegeName" select="name(.)"/>
                                                      <xsl:variable name="externalVarId" select="@var_ref"/>
                                                      <xsl:variable name="externalVarValue" select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable[@variable_id = $externalVarId]"/>
                                                      <xsl:for-each select="$SystemData/win-sc:accesstoken_item[@id=$itemRef]/*">
                                                          <xsl:if test="name(.) = $privilegeName">
                                                              <xsl:variable name="privilegeValue" select="text()"/>
                                                              <xsl:variable name="message_id">
                                                                  <xsl:call-template name="getMessageId">
                                                                      <xsl:with-param name="privilegeName" select="$privilegeName"/>
                                                                      <xsl:with-param name="privilegeValue" select="$privilegeValue"/>
                                                                  </xsl:call-template>
                                                              </xsl:variable>
                                                              <xsl:if test="$message_id != '' and $externalVarValue = $privilegeValue">
                                                                  <finding messageId="{$message_id}" isViolation="false">
                                                                      <instanceValue key="user">
                                                                          <xsl:value-of select="$user"/>
                                                                      </instanceValue>
                                                                  </finding>
                                                              </xsl:if>
                                                          </xsl:if>
                                                      </xsl:for-each>
                                                  </xsl:for-each>
                                              </xsl:otherwise>
                                          </xsl:choose>
                                      </xsl:for-each>
                                  </xsl:for-each>
                              </findings>                  
                          </xsl:otherwise>
                    </xsl:choose>                    
                </xsl:when>
                 <xsl:otherwise>
                     <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">
                         <finding messageId="com.mcafee.pa.msg.notWindowsPlatform" isViolation="false"/>
                     </findings>    
                 </xsl:otherwise>
             </xsl:choose>
                                        
    </xsl:template>
    
</xsl:stylesheet>