#! /sbin/sh
# PGP e-ppliance 2.0 Upgrade
#  
# UpgradeEPL2.0.sh 
#
# PGP Security, A Network Associates Business
# Copyright (c) 1993 - 2001, Network Associates Technology, Inc.

################################################################################
# exit status summary
################################################################################
# 1 wrong argument
# 2 validation failure
# 3 file operation failure
# 4 FTP failure [no file transferred]
# 5 FTP failure [file transferred has different size]
# 6 FTP failure [other]
# 7 EPL1.x backup size exceeds the limit
# 8 EPL1.x queued message size exceeds the limit

################################################################################
# upgrade state summary
################################################################################
# PGP_UPGRADE_VALIDATION
# PGP_UPGRADE_BACKUP
# PGP_UPGRADE_INITBOOT
# PGP_UPGRADE_FINALBOOT
# PGP_UPGRADE_FIN

################################################################################
# variables
################################################################################
PRODUCT_MODEL=""
PRODUCT_VERSION=""
REMOVE_EMAILS="" 
BACKUP_EMAILS=""
BACKUP_LOGS=""
BACKUP_EPL=""
FTPSERVER=""
USERNAME=""
PASSWORD=""
BACKUPDIR=""
EMAILADDR=""

NETPERM_TABLE="/usr/local/etc/netperm-table"
SENDMAILCONF="/etc/mail/sendmail.cf"
UPGRADEPREFFILE="./.preference"
UPGRADELOGFILE="./epl2.0.upgrade.log"
UPGRADESTATE="PGP_UPGRADE_VALIDATION"
SKIPINITQUEST="FALSE"

################################################################################
# functions
################################################################################
Exit ()
{
	 if [ $1 -eq 0 ]; then
		  exit $1
	 fi

	 # upon the current state, Exit performs in different way
	 # STATE                  ACTION  EMAIL
	 # PGP_UPGRADE_VALIDATION N/A     N/A
	 # PGP_UPGRADE_BACKUP     N/A     N/A
	 # PGP_UPGRADE_INITBOOT   N/A     N/A
	 # PGP_UPGRADE_FINALBOOT  (./restore; reboot -- "disk:a") YES
	 # PGP_UPGRADE_FIN        N/A     N/A

	 # If the INITBOOT failed, the system will boot from disk:a
	 # just before the reboot, a RC file should be generated
	 # /etc/rc3.d/S90report which should sends an emails to
	 # indicate that the system fails to reboot from /var/virtmp.
	 # The file /etc/rc3.d/S90report should be removed either 
	 # by FinalBootSunOS5.8.sh or a shell script which sends the
	 # warning email

	 ResumeFWServices
	 exit $1
}

AskFTPInfo ()
{
	 echo "Please enter FTP server address : \c"
	 read FTPSERVER
	 while [ -z "${FTPSERVER}" ]; do
		  echo "Please enter FTP server address : \c"
		  read FTPSERVER
	 done

	 echo "Please enter FTP username : \c"
	 read USERNAME
	 while [ -z "${USERNAME}" ]; do
		  echo "Please enter FTP username : \c"
		  read USERNAME
	 done

	 stty -echo
	 PASSDONE="FALSE"
	 while [ "${PASSDONE}" != "TRUE" ]; do
		  echo "Please enter FTP password : \c"
		  read PASSWORD1
		  echo ""
		  while [ -z "${PASSWORD1}" ]; do
				echo "UPGRADE::WRN Password cannot be empty"
				echo "Please enter FTP password : \c"
				read PASSWORD1
				echo ""
		  done
		  # confirm the password
		  echo "Please confirm FTP password : \c"
		  read PASSWORD2
		  echo ""
		  
		  if [ "${PASSWORD2}" != "${PASSWORD1}" ]; then
				echo "UPGRADE::WRN Password not matched"
				PASSDONE="FALSE"
		  else
				PASSWORD="${PASSWORD1}"
				PASSDONE="TRUE"
		  fi
	 done
	 stty echo

	 echo "Please enter upload directory : \c"
	 read BACKUPDIR
	 while [ -z "${BACKUPDIR}" ]; do
		  echo "Please enter upload directory : \c"
		  read BACKUPDIR
	 done
}

ShowPreference ()
{
	 # backup e-ppliance 
	 Log "- Backup the entire e-ppliance system \t : \c"
	 if [ ${BACKUP_EPL} = "TRUE" ]; then
		  Log "YES"
	 else
		  Log "NO"
	 fi
	 # backup logging messages
	 Log "- Backup the firewall logging messages \t : \c"
	 if [ ${BACKUP_LOGS} = "TRUE" ]; then
		  Log "YES"
	 else
		  Log "NO"
	 fi
	 # backup queued emails
	 if  [ "$ REMOVE_EMAILS" = "TRUE" ]; then
		  Log "- Backup the queued emails \t : \c"
		  if [ ${BACKUP_EMAILS} = "TRUE" ]; then
				Log "YES"
		  else
				Log "NO"
		  fi
		  Log "- Remove the queued emails \t : \c"
		  if [ ${REMOVE_EMAILS} = "TRUE" ]; then
				Log "YES"
		  else
				Log "NO"
		  fi
	 fi

	 if [ ${BACKUP_EMAILS} = "TRUE" ] || [ ${BACKUP_LOGS} = "TRUE" ] || \
		  [ ${BACKUP_EPL} = "TRUE" ]; then
		  Log "- FTP SERVER \t : ${FTPSERVER}"
		  Log "- FTP Upload Path \t : ${BACKUPDIR}"
		  Log "- FTP Username \t : ${USERNAME}"
#		  Log "- FTP PASSWORD \t : ${PASSWORD}"
	 fi

	 Log "- Your contact email address \t : ${EMAILADDR}"
	 Log "- Upgrade status log file \t : `pwd`/`basename ${UPGRADELOGFILE}`"
	 Log ""
}

ParseArgs ()
{
	 SKIPINITQUEST="FALSE"
	 ARGS=$*
	 if [ -n "${ARGS}" ]; then
		  for arg in $ARGS; do
				case "${arg}" in
				"-y")
					 SKIPINITQUEST="TRUE"
					 ;;
				*)
					 Log "UPGRADE::ERR Unknown upgrade argument found"
					 return 1
				esac
		  done
	 fi
	 Export "SKIPINITQUEST" ${SKIPINITQUEST}
	 return 0
}

################################################################################
# change dir to the root of upgrade source
################################################################################
UPGRADEROOT=`dirname $0`
BASENAME=`basename $0`
cd ${UPGRADEROOT} > /dev/null 2>&1
if [ $? -ne 0 ]; then
	 echo "UPGRADE::ERR Failed to change directory ${UPGRADEROOT}"
	 exit 3
fi

. ./Utils.sh

################################################################################
# the agreement
################################################################################
clear
Log ""
Log "################# Welcome to PGP e-ppliance 2.0 upgrade  ################# "
Log ""
Log "Please note the following information before performing this upgrade"
Log ""
Log "1.\tVerify that the system is in a stable state. If you have not done"
Log "  \tso,  please perform a complete  system maintenance,  including  a" 
Log "  \tcomplete system backup."
Log "2.\tThe upgrade utility does not expect and does not handle user data"
Log "  \ton the e-ppliance  system.  Any  detected  modifications  to  the"
Log "  \te-ppliance system,  including nonstandard  applications  and data,"
Log "  \twill halt the upgrade.  Undetected,  nonstandard  applications or"
Log "  \tdata will be permanently destoryed by the upgrade."
Log "3.\tThe e-ppliance will be temporarily off-line  during the  upgrade."
Log "  \tIt is possible that some queued e-mail may  be  lost  during  the"
Log "  \tupgrade."
Log "4.\tThe upgrade will not handle changes to /usr/local/etc/netperm-table."
Log "  \tAny modifications made to this file will be lost."
Log "5.\tThe upgrade will not restore DNS and sendmail configuration files"
Log "  \tbecause they are not compatible with SunOS5.8. You must manually"
Log "  \tupdate these files as appropriate."
echo ""
echo "Would you like to continue? [y/n] : \c"
read foo
if [ "$foo" != "y" -a "$foo" != "Y" ]; then
	 exit 1
fi

################################################################################
# check the user permission
################################################################################
# must be the root user
Log "# Check User Permission"
USER=`/usr/ucb/whoami`
if [ "$USER" != "root" ]; then
	 Log "UPGRADE::ERR User $USER does not have the sufficient privileges"
	 Log "UPGRADE::ERR Please login as a root user"
	 exit 1
fi

################################################################################
# keep the /var/virtmp as a safe upgrade source repository
################################################################################
Log "# Disable /var/virtmp Clean Routine"
if [ -f /usr/local/etc/mgmt/cleanse_vtmp.sh ]; then
	 mv /usr/local/etc/mgmt/cleanse_vtmp.sh \
		  /usr/local/etc/mgmt/disabled.cleanse_vtmp.sh > /dev/null 2>&1
fi

################################################################################
# load up the preference file and check out the state
################################################################################
# we need to see if there is any STATE set before
Log "# Load Upgrade Preference"
if [ -f ${UPGRADEPREFFILE} ]; then
	 . ${UPGRADEPREFFILE}

	 # validate the STATE
	 if [ "${UPGRADESTATE}" != "PGP_UPGRADE_VALIDATION" ] && \
		  [ "${UPGRADESTATE}" != "PGP_UPGRADE_BACKUP" ] && \
		  [ "${UPGRADESTATE}" != "PGP_UPGRADE_INITBOOT" ] && \
		  [ "${UPGRADESTATE}" != "PGP_UPGRADE_FINALBOOT" ] && \
		  [ "${UPGRADESTATE}" != "PGP_UPGRADE_FIN" ]; then
		  Log "UPGRADE::ERR Wrong state in ${UPGRADESTATEFILE}"
		  exit 1
	 fi
	 if [ "${UPGRADESTATE}" = "PGP_UPGRADE_FIN" ]; then
		  # seems we have nothing to do then
		  Log "UPGRADE::WRN The upgrade has been accomplished already"
		  Log "UPGRADE::WRN The upgrade is aborted."
		  exit 0
	 fi
else
	 UPGRADESTATE="PGP_UPGRADE_VALIDATION"
	 Export "UPGRADELOGFILE" ${UPGRADELOGFILE}
	 Export "UPGRADESTATE" ${UPGRADESTATE} 
	 Export "UPGRADEPREFFILE" ${UPGRADEPREFFILE}
fi

################################################################################
# parse the argument list 
################################################################################
ParseArgs $*
if [ $? -ne 0 ]; then
	 exit 1
fi

if [ "${UPGRADESTATE}" != "PGP_UPGRADE_FINALBOOT" ]; then
	 ################################################################################
	 # retrieve the message queue directories for smap and sendmail
	 ################################################################################
	 Log "# Retrieve EMail Queue Directories"
	 if [ -f ${SENDMAILCONF} ]; then
		  MQUEUEDIR=`grep "^OQ" ${SENDMAILCONF} | sed s/"^OQ"//1`
	 else
		  Log "UPGRADE::ERR Failed to locate sendmail configuration file ${SENDMAILCONF}"
		  exit 3
	 fi
	 if [ -f ${NETPERM_TABLE} ]; then
		  SMAPQUEUEDIR=`grep "smap: directory" $NETPERM_TABLE | awk '{ print $3 }'`
	 else
		  Log "UPGRADE::ERR Failed to locate firewall configuration file $NETPERM_TABLE"
		  exit 3
	 fi

	 Export "MQUEUEDIR" ${MQUEUEDIR}
	 Export "SMAPQUEUEDIR" ${SMAPQUEUEDIR}

	 ################################################################################
	 # shutdown the FW services
	 ################################################################################
	 Log ""
	 Log "##########################################################################"
	 Log "# Shut Down Firewall Services"
	 Log "##########################################################################"
	 Log ""
	 echo "The upgrade is about to shut down the firewall services."
	 echo ""
	 echo "Would you like to continue? [y/n] : \c"
	 read foo
	 if [ "$foo" != "y" -a "$foo" != "Y" ]; then
		  exit 0
	 fi

	 sh ./ShutdownFWServices.sh
	 if [ $? -ne 0 ]; then
		  Exit 1
	 fi
fi

################################################################################
# validation
################################################################################
if [ "${UPGRADESTATE}" != "PGP_UPGRADE_INITBOOT" ] && \
	 [ "${UPGRADESTATE}" != "PGP_UPGRADE_FINALBOOT" ]; then

Log ""
Log "##########################################################################"
Log "# Validate PGP e-ppliance System"
Log "##########################################################################"
Log ""

	 # Usually VALIDATION BACKUP must pass the validation again, the INITBOOT and
	 # FINALBOOT could skip the validation

	 ################################################################################
	 # verify e-mail queue directories
	 ################################################################################
	 if [ -n "${MQUEUEDIR}" ] && [ "${MQUEUEDIR}" != "/var/spool/mqueue" ]; then
		  Log "UPGRADE::ERR Sendmail queue directory modified as ${MQUEUEDIR}"
		  Log "UPGRADE::ERR rather than /var/spool/mqueue.  This  would  cause  the"
		  Log "UPGRADE::ERR failure of backup/restore queued e-mails by the upgrade."
		  Exit 1
	 fi
	 if [ -n "${SMAPQUEUEDIR}" ] && [ "${SMAPQUEUEDIR}" != "/var/spool/smap" ]; then
		  Log "UPGRADE::ERR Smap queue directory modified as ${SMAPQUEUEDIR}"
		  Log "UPGRADE::ERR rather  than /var/spool/smap.   This  would  cause  the"
		  Log "UPGRADE::ERR failure of backup/restore queued e-mails by the upgrade."
		  Exit 1
	 fi

	 ################################################################################
	 # verify the PGP e-ppliance 2.0 model and version
	 ################################################################################
	 # get the PGP e-ppliance 2.0 model and version
	 MANIFEST_FILE="./usr/local/etc/MANIFEST"
	 # product version must be 2.0
	 TMP_PRODUCT_VERSION=`cat $MANIFEST_FILE | grep PRODUCT_VERSION`
	 if [ $? -ne 0 ]; then
		  Log "UPGRADE::ERR Failed to find the PGP e-ppliance product version"
		  Exit 3
	 fi
	 PRODUCT_VERSION=`echo $TMP_PRODUCT_VERSION | awk '{ print $2 }'`
	 if [ "$PRODUCT_VERSION" != "2.0" ]; then
		  Log "UPGRADE::ERR Found unsupported PGP e-ppliance product version $PRODUCT_VERSION"
		  Exit 3
	 fi

	 # product model should be 300 or 1000
	 TMP_PRODUCT_MODEL=`cat $MANIFEST_FILE | grep PRODUCT_MODEL`
	 if [ $? -ne 0 ]; then
		  Log "UPGRADE::ERR Failed to find the PGP e-ppliance product model number"
		  Exit 3
	 fi
	 PRODUCT_MODEL=`echo $TMP_PRODUCT_MODEL | awk '{ print $2 }'`
	 if [ "$PRODUCT_MODEL" != "300" ] && [ "$PRODUCT_MODEL" != "1000" ] ; then
		  Log "UPGRADE::ERR Found unsupported PGP e-ppliance product model $PRODUCT_MODEL"
		  Exit 3
	 fi

	 Export "PRODUCT_MODEL" ${PRODUCT_MODEL}
	 Export "PRODUCT_VERSION" ${PRODUCT_VERSION}

	 ################################################################################
	 # validate the system
	 ################################################################################
	 # probably we would have some backup files, remove them first
	 rm -fr ./Backup
	 sh ./VerifySystem.sh UPGRADE
	 VERSTATUS=$?
	 if [ $VERSTATUS -ne 0 ] && [ $VERSTATUS -ne 8 ]; then
		  Exit 2
	 fi

	 Export "VERSTATUS" ${VERSTATUS}

fi ### !PGP_UPGRADE_INITBOOT OR !PGP_UPGRADE_FINALBOOT

################################################################################
# User Preference Input
################################################################################
# if the space allowed, the queued emails will be in /var partition backup
# the ./preference stores all user's inputs and system configurations
# confirm with the user whether the user would like to 
# reenter/change those inputs

# REMOVE_EMAILS 
# BACKUP_EMAILS
# BACKUP_LOGS
# BACKUP_EPL
# FTPSERVER
# USERNAME
# PASSWORD
# BACKUPDIR
# EMAILADDR

# MQUEUEDIR
# SMAPQUEUEDIR
# PRODUCT_MODEL
# PRODUCT_VERSION
# VERSTATUS

if [ "${UPGRADESTATE}" = "PGP_UPGRADE_VALIDATION" ] || \
	 [ "${UPGRADESTATE}" = "PGP_UPGRADE_BACKUP" ]; then

Log ""
Log "##########################################################################"	 
Log "# Enter/Update Upgrade Preference"
Log "##########################################################################"
Log ""

	 UPGRADESTATE="PGP_UPGRADE_BACKUP"
	 Export "UPGRADESTATE" ${UPGRADESTATE}

	 FTPASKED="FALSE"
	 DONE="FALSE"
	 if [ -n "${BACKUP_EPL}" ]; then
		  echo ""
		  echo "The upgrade preference found on the system, please"
		  echo "verify those seletions below: "
		  echo ""
		  ShowPreference
		  echo ""
		  echo "Would you like to change those selections? [y/n] : \c"
		  read foo
		  if [ "${foo}" = "n" -o "${foo}" = "N" ]; then
				DONE="TRUE"
		  fi
	 fi

	 while [ "${DONE}" != "TRUE" ]; do
		  echo ""
		  echo "Since remote connections will be shut down during"
		  echo "the upgrade, the upgrade utility will send you an"
		  echo "e-mail in the event that a problem is encountered."
		  echo ""
		  echo "Please enter your e-mail address : \c"
		  read EMAILADDR

		  while [ -z "${EMAILADDR}" ]; do
				echo "Please enter your e-mail address : \c"
				read EMAILADDR	
		  done
	 
		  # backup the system on an FTP server
		  echo ""
		  echo "There is a small risk of data loss  during  the  upgrade"
		  echo "due to the nature of the procedures involved. Therefore,"
		  echo "it is strongly recommended that  you back up the  entire"
		  echo "e-ppliance system on a  remote  host.  While the upgrade"
		  echo "makes a back up on the local system so  that  it  can be"
		  echo "restored  to  its  previous  state  in  the event that a"
		  echo "problem is encountered, you  should  not  rely  on  this" 
		  echo "backup to restore your entire system."
		  echo ""
		  echo "Would you like to backup the entire e-ppliance system to"
		  echo "a remote FTP server [y/n] : \c"
		  read foo
		  if [ "$foo" != "y" -a "$foo" != "Y" ]; then
				BACKUP_EPL="FALSE"
		  else
				BACKUP_EPL="TRUE"
		  fi
		  if [ ${BACKUP_EPL} = "TRUE" ] && [ ${FTPASKED} = "FALSE" ]; then
				AskFTPInfo
				FTPASKED="TRUE"
		  fi

		  # queued emails
		  if  [ "$VERSTATUS" = "8" ]; then
				echo ""
				echo "The amount of queued e-mail in the system causes the"
				echo "size limit of the backup to be exceeded."
				echo ""
				echo "Would you like to backup the queued e-mail to a remote"
				echo "FTP server [y/n] : \c"
				read foo
				if [ "$foo" != "y" -a "$foo" != "Y" ]; then
					 BACKUP_EMAILS="FALSE"
				else
					 BACKUP_EMAILS="TRUE"
				fi
				REMOVE_EMAILS="TRUE"
				if [ ${BACKUP_EMAILS} = "TRUE" ] && [ ${FTPASKED} = "FALSE" ]; then
					 AskFTPInfo
					 FTPASKED="TRUE"
				fi
		  else
				REMOVE_EMAILS="FALSE"
				BACKUP_EMAILS="FALSE"
		  fi

		  # logging messages
		  echo ""
		  echo "Would you like to save the firewall logging messages"
		  echo "to a remote FTP server [y/n] : \c"
		  read foo
		  if [ "$foo" != "y" -a "$foo" != "Y" ]; then
				BACKUP_LOGS="FALSE"
		  else
				BACKUP_LOGS="TRUE"
		  fi
		  if [ ${BACKUP_LOGS} = "TRUE" ] && [ ${FTPASKED} = "FALSE" ]; then
				AskFTPInfo
				FTPASKED="TRUE"
		  fi

		  echo ""
		  echo "Please verify your selections: "
		  echo ""
		  ShowPreference
		  echo ""
		  echo "Would you like to continue? [y/n/q]"
		  echo "[y] - continue [n] - update [q] - quit : \c"
		  read foo
		  if [ "$foo" = "y" -o "$foo" = "Y" ]; then
				DONE="TRUE"
		  elif [ "$foo" = "q" -o "$foo" = "Q" ]; then
				Exit 1
		  fi
	 
		  FTPASKED="FALSE"
	 done

	 Export "REMOVE_EMAILS" ${REMOVE_EMAILS}
	 Export "BACKUP_EMAILS" ${BACKUP_EMAILS} 
	 Export "BACKUP_LOGS" ${BACKUP_LOGS}
	 Export "BACKUP_EPL" ${BACKUP_EPL}
	 Export "FTPSERVER" ${FTPSERVER}
	 Export "USERNAME" ${USERNAME}
	 Export "PASSWORD" ${PASSWORD}
	 Export "BACKUPDIR" ${BACKUPDIR}
	 Export "EMAILADDR" ${EMAILADDR}

fi ### PGP_UPGRADE_BACKUP OR PGP_UPGRADE_VALIDATION

################################################################################
# BACKUP EPL1.X
################################################################################
if [ "${UPGRADESTATE}" = "PGP_UPGRADE_BACKUP" ]; then
Log ""
Log "##########################################################################"
Log "# Backup PGP e-ppliance System"
Log "##########################################################################"
Log ""
	 BACKUPPATH="`pwd`/Backup"
	 if [ ! -d ${BACKUPPATH} ]; then
		  mkdir -p ${BACKUPPATH} > /dev/null 2>&1
		  if [ $? -ne 0 ]; then
				Log "UPGRADE::ERR Failed to make directory ${BACKUPPATH}"
				Exit 3
		  fi
	 fi
	 sh ./MakeEPLPkg.sh UPGRADE ${BACKUPPATH}
	 if [ $? -ne 0 ]; then
		  Exit 1
	 fi

	 BACKUPPATH="${BACKUPPATH}/Config"
	 if [ ! -d ${BACKUPPATH} ]; then
		  mkdir -p ${BACKUPPATH} > /dev/null 2>&1
		  if [ $? -ne 0 ]; then
				Log "UPGRADE::ERR Failed to make directory ${BACKUPPATH}"
				Exit 3
		  fi
	 fi
	 sh ./BackupEPL1.XConfig.sh ${BACKUPPATH}
	 if [ $? -ne 0 ]; then
		  Exit 1
	 fi

fi ### PGP_UPGRADE_BACKUP

################################################################################
# INITBOOT /var/virtmp partition
################################################################################
if [ "${UPGRADESTATE}" = "PGP_UPGRADE_BACKUP" ] || \
	 [ "${UPGRADESTATE}" = "PGP_UPGRADE_INITBOOT" ]; then

Log ""
Log "##########################################################################"
Log "# InitBoot SunOS-5.8 "
Log "##########################################################################"
Log ""

	 UPGRADESTATE="PGP_UPGRADE_INITBOOT"
	 Export "UPGRADESTATE" ${UPGRADESTATE}
	 
	 Log "# Upgrade PGP e-ppliance Configuration Data"
	 sh ./UpgradeConfig.sh
	 if [ $? -ne 0 ]; then
		  Exit 1
	 fi

	 sh ./InitBootSunOS5.8.sh 
	 if [ $? -ne 0 ]; then
		  Exit 1
	 fi

fi ### PGP_UPGRADE_INITBOOT

################################################################################
# FINALBOOT / partition
################################################################################
# NOTE if the process reaches here, the system must be restored and be reboot
# from disk:a
if [ "${UPGRADESTATE}" = "PGP_UPGRADE_FINALBOOT" ]; then

Log ""
Log "##########################################################################"
Log "# FinalBoot SunOS-5.8 with EPL2.0 "
Log "##########################################################################"
Log ""

	 # since the user can do 
	 # ok boot disk:f -s 
	 # to recover from an interrupted upgrade, the upgrade
	 # must check the current boot partition
	 # if the root partition is on c0t0d0s0, then reboot to /var/virtmp
	 # if the root partition is on c0t0d0s5 already, directly resume the upgrade

	 # check the boot partition	 
	 Log "# Check Current Boot Partition"
	 VIRDEV=c0t0d0s5
	 mount -a > /dev/null 2>&1
	 TMP_ROOTMNT=`df -k | grep ${VIRDEV}`
	 if [ -z "${TMP_ROOTMNT}" ]; then
		  Log "UPGRADE::FATALERR Failed to find the ${VIRDEV} partition"
		  Exit 1
	 fi

	 # if /dev/dsk/c0t0d0s5 is mounted on "/var/virtmp", must reboot
	 # the system to disk:f which is the /var/virtmp partition
	 TMP_ROOTMNT=`echo ${TMP_ROOTMNT} | awk '{ print $6 }'`
	 if [ "${TMP_ROOTMNT}" = "/var/virtmp" ]; then
		  # boot from /var/virtmp
		  INITBOOTROOT="/var/virtmp"
		  FINALPATH=`pwd`
		  TMP_INITBOOTROOT="\\${INITBOOTROOT}"
		  FINALPATH=`echo ${FINALPATH} | sed s%$TMP_INITBOOTROOT%%1`

		  Log ""
		  Log "The upgrade is about to reboot the system to /var/virtmp"
		  Log "partition in single user mode. "
		  Log ""
		  echo "Would you like to continue? [y/n] : \c"
		  read foo
		  if [ "${foo}" != "y" -a "${foo}" != "Y" ]; then
				Exit 1
		  fi

		  if [ -f ${INITBOOTROOT}/etc/rcS.d/S99upgrade ]; then
				rm -f ${INITBOOTROOT}/etc/rcS.d/S99upgrade
		  fi
		  echo "sh ${FINALPATH}/FinalBootSunOS5.8.sh" \
				> ${INITBOOTROOT}/etc/rcS.d/S99upgrade
		  echo "rm -f /etc/rcS.d/S99upgrade" \
				>> ${INITBOOTROOT}/etc/rcS.d/S99upgrade

		  sync; reboot -- "disk:f -s"
 
	 else
		  # check for single user mode
		  WHO=`who -r`
		  if [ "${WHO}" != "" ]; then
				echo ${WHO} | grep "run-level S" > /dev/null 2>/dev/null
				if [ $? -ne 0 ]; then
					 Log "UPGRADE::ERR The system must be running in single-user mode."
					 Exit 1
				fi
		  fi

		  # resume the upgrade
		  sh ./FinalBootSunOS5.8.sh

	 fi
fi

################################################################################
# finish
################################################################################
exit 0

