#! /sbin/sh
# PGP e-ppliance 2.0 Upgrade
#  
# Utils.sh 
#
# PGP Security, A Network Associates Business
# Copyright (c) 1993 - 2001, Network Associates Technology, Inc.

################################################################################
# functions
################################################################################
Log ()
{
	 TIME=`date '+%Y-%m-%d %H.%M.%S'`
	 if [ -z "${UPGRADELOGFILE}" ]; then
		  UPGRADELOGFILE="./epl2.0.upgrade.log"
	 fi
	 echo ${TIME} [${BASENAME}] "$1" >> ${UPGRADELOGFILE}
	 echo "$1"
}

# arg1 -- name of variable
# arg2 -- value of variable
Export ()
{
	 VARNAME=$1
	 VARVAL=$2
	 if [ -f ${UPGRADEPREFFILE} ]; then
		  cat ${UPGRADEPREFFILE} | sed /$VARNAME/d > ${UPGRADEPREFFILE}.$$
		  mv ${UPGRADEPREFFILE}.$$ ${UPGRADEPREFFILE}
	 fi
	 
	 echo "${VARNAME}=\"${VARVAL}\"" >> ${UPGRADEPREFFILE}
	 echo "export ${VARNAME}" >> ${UPGRADEPREFFILE}
	 export ${VARNAME}
}

# arg1 -- name of the directory
# arg2 -- file size
FindHugeFiles ()
{
	 DIR=$1
	 FILESIZE=$2

	 du -dk ${DIR} | awk '{ \
		  if ( int($1) > int(AWKFILESIZE))  { \
				print $1, "\t" $2 \
		  }\
	 }' AWKFILESIZE=$FILESIZE
}

ResumeFWServices ()
{
	 if [ ! -x /usr/local/etc/mgmt/proxymgr ]; then
		  Log "UPGRADE::ERR /usr/local/etc/mgmt/proxymgr not found"
		  exit 1
	 fi
	 /usr/local/etc/mgmt/proxymgr start -all > /dev/null 2>&1
	 Log "UPGRADE::MSG The firewall services have been resumed"
}
