# VERSION 0226b
#
# This is a template file for upgrading from 
# Gauntlet 5.x versions to Gauntlet 6.0
#
# format:
#
# verb object1 [object2]
#
#	Generally, if both objects are specified, object1 is the source, 
#	and object2 is the target
#
#	A leading pound sign ("#") indicates a comment, and MUST appear as
#	the first character on the line.  All other #'s are considered 
#	part of the verb or object in question.
#
#	Object nomenclature: In any given object or netperm entry, the 
#	various sections between the underscores are called branches.  
#	The last section before the = sign is the "object name", and the 
#	value after the = sign is called the "value".  All of the 
#	branches taken together are called the "path."  The object name 
#	and value taken together comprise a "leaf".
#	Ex:
#		branch1_branch2_branch3_name=value
#		^---------path--------^ ^--leaf--^
#
#	Exception: The string "num_" is always taken to be part of the name
#	of the object. This indicates a special type of object - a counter.
#	Ex:
#		branch1_branch2_branch3_num_items=12
#		^---------path--------^ ^--name-^ ^-value
#								^---leaf---^
#
#	An object path may contain one and only one wildcard.  Currently 
#	valid wildcards are:
#		**		Match any object branch or leaf name
#		##		Match an object branch that is entirely a number
#				Ex:
#					def_proxy_##_name matches def_proxy_000_name
#						but does not match def_proxy_ftp-01_name
#	An additional wildcard is permitted in the leaf value.
#
#	The actions in this file are processed in the order in which 
#	they appear - ensure that action objects are modified to deal with 
#	the changes as they occur (for example, if you rename a tag in one 
#	action, be sure to only search for the new name in subsequent actions).
#
#	This template file has two sections:
#
#		[PREPROCESS]	This section is applied to the old gauntlet.conf
#						tree BEFORE the old gauntlet.conf is merged with 
#						the new initial.env.
#		[POSTPROCESS]	This section is applied to the new tree.
#
#	Merge Behavior: During the merge of the old tree with the new 
#	initial.env, paths/tags that do not exist in the new tree are 
#	carried over.  If a path/tag already exists, the old value is 
#	used.  As targets are found for entries from the old tree, 
#	they are removed from the old tree.
#
# Verbs:					Example objects/Description:
#	replace_name_with_value	def_proxy_##_name=**
#							Find all ocurrences of the object, and move 
#							the ** value to the ## number
#	rename_branch			def_proxy_smap			def_proxy_csmap
#							Find the first branch and rename it as the 
#							second branch.
#	join_branches			def_proxy_smapd			def_proxy_csmap
#							Move all child elements of the first branch/path
#							over to the second branch/path, eliminating 
#							duplicate elements.
#	delete_branch			def_proxy_moocow
#							Remove the specified branch and all of its 
#							children
#	merge_name_value		def_proxy_**_parm_##	def_proxy_**
#							Sometimes the name and value for a configuration
#							element were kept in two distinct objects, one
#							with an object name of "name" and another with an 
#							object name of "leaf".  The two objects were kept
#							in a numbered list of parameters or parms.  This 
#							verb merges the two objects into one and 
#							eliminates the parm branches.
#

[PREPROCESS]

##########################
# Misc.
##########################

# generic obsolete leaves
delete_leaf					**_num_entries=**
delete_leaf					**_**_num_entries=**
delete_leaf					**_**_**_num_entries=**
delete_leaf					**_**_**_**_num_entries=**
delete_leaf					**_num_group=**
delete_leaf					**_**_num_group=**
delete_leaf					**_**_**_num_group=**
delete_leaf					**_**_**_**_num_group=**
delete_leaf					**_num_list=**
delete_leaf					**_**_num_list=**
delete_leaf					**_**_**_num_list=**
delete_leaf					**_**_**_**_num_list=**
delete_leaf					**_num_members=**
delete_leaf					**_**_num_members=**
delete_leaf					**_**_**_num_members=**
delete_leaf					**_**_**_**_num_members=**
delete_leaf					**_num_parms=**
delete_leaf					**_**_num_parms=**
delete_leaf					**_**_**_num_parms=**
delete_leaf					**_**_**_**_num_parms=**
delete_leaf					**_num_proxies=**
delete_leaf					**_**_num_proxies=**
delete_leaf					**_**_**_num_proxies=**
delete_leaf					**_**_**_**_num_proxies=**
delete_leaf					**_numrules=**
delete_leaf					**_**_numrules=**

delete_branch				backup
delete_leaf					rcsid=**
delete_leaf					tag=**

# deal with blank proxy names...
#if_leaf						cust_proxy_##_name=
#	edit_leaf				cust_proxy_##_name=			make_counter	1
#	edit_leaf				cust_proxy_##_name=**		insert			blankname
#end_if

# funky leaf names that we have to deal with RIGHT NOW!
#							def_proxy_42_parm_1_name=use_name_logs
change_value				**_proxy_**_parm_##_name=use_name_logs				use-name-logs
#							def_proxy_23_parm_12_name=force_source_address
change_value				**_proxy_**_parm_##_name=force_source_address		force-source-address
change_value				**_proxy_**_parm_##_name=force%5Fsource%5Faddress	force-source-address

# sql-gw (5.5 only?) - a lot of tags were redone without underscores
change_value				**_proxy_##_parm_##_name=answer_error_countdown		answer-error-countdown
change_value				**_proxy_##_parm_##_name=answer_timeout				answer-timeout
change_value				**_proxy_##_parm_##_name=authentication_level		authentication-level
change_value				**_proxy_##_parm_##_name=event_timer				event-timer
change_value				**_proxy_##_parm_##_name=event_timer				event-timer
change_value				**_proxy_##_parm_##_name=log_level					log-level
change_value				**_proxy_##_parm_##_name=maximum_connect_data		maximum-connect-data
change_value				**_proxy_##_parm_##_name=maximum_relays				maximum-relays
change_value				**_proxy_##_parm_##_name=relay_connected_timer		relay-connected-timer
change_value				**_proxy_##_parm_##_name=relay_idle_timer			relay-idle-timer
change_value				**_proxy_##_parm_##_name=show_tns_info				show-tns-info
change_value				**_proxy_##_parm_##_name=tns_tracing				tns-tracing
change_value				**_proxy_##_parm_##_name=use_async_call				use-async-call

# cyberpatrol stuff - best dealt with early - we will need to promote these to keys later
change_value				def_proxy_##_parm_##_name=cyber_serial_no			serial
change_value				def_proxy_##_name=HTTP								cyber
change_value				def_proxy_##_realname=HTTP					cyber
change_value				cust_proxy_##_parm_##_name=cyber_masks				cybermasks
edit_leaf					def_proxy_##_parm_##_name=work_time					make_counter	1

# HTTP pre-preprocessing

edit_leaf					cust_proxy_**_parm_##_name=**				nuke_after	header
if_leaf						cust_proxy_**_parm_##_name=header
	edit_leaf				cust_proxy_**_parm_##_name=header		make_counter	1
	merge_name_value		cust_proxy_**_parm_##						cust_proxy_**
end_if
insert_branch				cust_proxy_**_##=**							cust_proxy_**_header_##=**
demote_leaf					cust_proxy_**_header_##=**				value
insert_branch				cust_proxy_**_header_##_value=**		cust_proxy_**_config-sets_header_##_value=**
insert_branch				cust_proxy_**_config-sets_header_##_value=**	cust_proxy_**_config-sets_tempname_header_##_value=**
rename_branch				cust_proxy_**_config-sets_**_header			headers
rename_leaf					cust_proxy_**_config-sets_**_headers_##_value=**	header

edit_leaf					cust_proxy_##_parm_##_name=**				delete	url_

# lp-gw pre-preprocessing
edit_leaf					cust_proxy_##_parm_##_name=**				delete		printer_
edit_leaf					cust_proxy_##_parm_##_name=**				nuke_after	client

# ck-gw pre-preprocessing
edit_leaf					cust_proxy_##_parm_##_name=**				delete		user-servers_
edit_leaf					def_proxy_##_parm_##_name=**				delete		server_

# snmp pre-preprocessing
edit_leaf					def_proxy_##_parm_##_name=**				delete		agent_

# sql-gw pre-preprocessing
edit_leaf					def_proxy_##_parm_##_name=**				delete			host_
edit_leaf					def_proxy_##_parm_##_name=**				delete_except	sid_
change_value				def_proxy_##_parm_##_name=sid_				oracle-sid
rename_leaf					def_proxy_##_parm_##_name=oracle-sid		sid

# IIOP-pdk pre-processing	def_proxy_29_parm_1_name=bind-address_1
edit_leaf					def_proxy_##_parm_##_name=**				delete		bind-address_

# Auth pre-preprocessing
change_value				def_proxy_##_parm_##_name=base_dir				base-dir
change_value				def_proxy_##_parm_##_name=username_attribute	username-attribute
change_value				def_proxy_##_parm_##_name=authorization_filter	authorization-filter

######################
# Proxy Stuff
######################

# first we need to prep the cust_proxy and def_proxy branches together.
# The cust proxies will become config sets within the def_proxies.
# The "realname" leaf is the key field used to marry the two branches
# together.

merge_name_value			cust_proxy_**_parm_##		cust_proxy_**
merge_name_value			def_proxy_**_parm_##		def_proxy_**

# deal with blank proxy names...
user_warning			cust_proxy_##_name=			Your old configuration contained one or more proxies set up with blank names; blank names were and are illegal, and these proxies probably were not functional. The configuration data for these proxies have been removed. This message may appear multiple times...
user_warning			cust_proxy_##_realname=		Your old configuration contained one or more proxies set up with blank names; blank names were and are illegal, and these proxies probably were not functional. The configuration data for these proxies have been removed. This message may appear multiple times...
user_warning			def_proxy_##_name=			Your old configuration contained one or more proxies set up with blank names; blank names were and are illegal, and these proxies probably were not functional. The configuration data for these proxies have been removed. This message may appear multiple times...
user_warning			def_proxy_##_realname=		Your old configuration contained one or more proxies set up with blank names; blank names were and are illegal, and these proxies probably were not functional. The configuration data for these proxies have been removed. This message may appear multiple times...

# remove illegal characters from proxy names - they will be becoming branch names later
#edit_leaf				cust_proxy_##_name=**			make_legal		ignore-me
#edit_leaf				cust_proxy_##_realname=**		make_legal		ignore-me
#edit_leaf				def_proxy_##_name=**			make_legal		ignore-me
#edit_leaf				def_proxy_##_realname=**		make_legal		ignore-me

#if_leaf						cust_proxy_##_name=
#	edit_leaf				cust_proxy_##_name=			make_counter	1
#	edit_leaf				cust_proxy_##_name=**		insert			blankname
#end_if
#if_leaf						cust_proxy_##_realname=
#	edit_leaf				cust_proxy_##_realname=			make_counter	1
#	edit_leaf				cust_proxy_##_realname=**		insert			blankproxyname
#end_if
#if_leaf						def_proxy_##_realname=
#	edit_leaf				def_proxy_##_realname=			make_counter	1
#	edit_leaf				def_proxy_##_realname=**		insert			blankproxyname
#	if_leaf					def_proxy_##_name=
#		copy_leaf			def_proxy_##_realname=**		def_proxy_##_name=**
#	end_if
#end_if

# proxies MUST have names
if_leaf						cust_proxy_##_name=
	delete_branch			cust_proxy_##
end_if
if_leaf						cust_proxy_##_realname=
	delete_branch			cust_proxy_##
end_if

# expand the cust proxies to become the def_proxy config-sets
insert_branch				cust_proxy_**_**=**						cust_proxy_**_tempname_**=**
insert_branch				cust_proxy_**_tempname					cust_proxy_**_config-sets_tempname

# the proxy "name" becomes the config-set name, and the "realname" becomes the service name
replace_name_with_value		cust_proxy_**_config-sets_**_name=**
replace_name_with_value		cust_proxy_##_config-sets_**_realname=**	##

# URL Filtering
# From: cust_proxy_10_parm_6_name=url_1
#       cust_proxy_10_parm_6_value=deny www.microsoft.com
# To:   def_proxy_http-gw_config-sets_AS_url_1_access=Deny
#       def_proxy_http-gw_config-sets_AS_url_1_value=www.abc.com
# We have to do this now because cyberpatrol is also using a number in the leaf name
demote_leaf					cust_proxy_http-gw_config-sets_**_##=**					access
demote_leaf					cust_proxy_gopher-gw_config-sets_**_##=**				access
insert_branch				cust_proxy_http-gw_config-sets_**_##_access=**			cust_proxy_http-gw_config-sets_**_url_##_access=**
insert_branch				cust_proxy_gopher-gw_config-sets_**_##_access=**		cust_proxy_gopher-gw_config-sets_**_url_##_access=**

copy_leaf					cust_proxy_http-gw_config-sets_**_url_##_access=**		cust_proxy_http-gw_config-sets_**_url_##_value=**
copy_leaf					cust_proxy_gopher-gw_config-sets_**_url_##_access=**	cust_proxy_gopher-gw_config-sets_**_url_##_value=**

edit_leaf					cust_proxy_http-gw_config-sets_**_url_##_access=**		nuke_from	' '
edit_leaf					cust_proxy_gopher-gw_config-sets_**_url_##_access=**	nuke_from	' '
edit_leaf					cust_proxy_http-gw_config-sets_**_url_##_value=**		nuke_thru	' '
edit_leaf					cust_proxy_gopher-gw_config-sets_**_url_##_value=**		nuke_thru	' '

change_value				cust_proxy_**_config-sets_**_url_##_access=deny			Deny
change_value				cust_proxy_**_config-sets_**_url_##_access=permit		Permit

delete_leaf					cust_proxy_**_config-sets_**_cyberurlcount=**


# proxies MUST have names
if_leaf						def_proxy_**_realname=
	delete_branch			def_proxy_**
end_if
if_leaf						def_proxy_**_name=
	delete_branch			def_proxy_**
end_if

replace_name_with_value		def_proxy_**_realname=**					**
join_branches				cust_proxy					def_proxy
replace_name_with_value		def_proxy_**_name=**						**

## now deal with cleaning up the def_proxy list

# obsolete leaves/branches
delete_leaf					def_proxy_**_realname=**
delete_leaf					def_proxy_**_config-sets_**_realname=**
delete_leaf					def_proxy_smapd_wakeup=**
delete_leaf					def_proxy_smapd_name=**
delete_leaf					def_proxy_http-gw_backend=**
delete_branch				def_proxy_pcxdpp
delete_branch				def_proxy_pwcached
delete_leaf					def_proxy_http-gw_pdkbackend-port=**

# Stuff we are going to delete and force the user to reeenter
user_warning				def_proxy_**_userid=**		All proxy userid and groupid settings were removed in favor of the new defaults.
delete_leaf					def_proxy_**_groupid=**
delete_leaf					def_proxy_**_userid=**
delete_branch				dns

# csmap stuff - do non-destructive join (older values take precedence)
delete_leaf					def_proxy_smapd_proxy-exec=**
delete_leaf					def_proxy_smapd_proxy-type=**
change_value				def_proxy_smap_proxy-exec=**		./csmap
change_value				def_proxy_smap_proxy-type=**		csmap
delete_leaf					def_proxy_smap_bind-port=**
join_branches				def_proxy_smap						def_proxy_csmap
join_branches				def_proxy_smapd						def_proxy_csmap
#delete_branch				def_proxy_csmap_config-sets_smap
#delete_leaf					def_proxy_csmap_quarantine-dir=
#user_warning				def_proxy_csmap_quarantine-dir=**	The SMTP quarantine directory setting of $$ was deleted - this must be manually reconfigured on the new firewall.
#delete_leaf					def_proxy_csmap_quarantine-dir=**
#delete_leaf					def_proxy_csmap_baddir=**
# we will come back and fill these in later if there is anything in these lists...
delete_leaf					def_proxy_csmap_deny-spam=**
delete_leaf					def_proxy_csmap_permit-relay=**
delete_leaf					def_proxy_csmap_local-domain=**

copy_leaf					mail_rewriteall=**						def_proxy_csmap_rewriteall=**
copy_leaf					mail_postmaster=**						def_proxy_csmap_postmaster=**
# Upgrade mail hub information. mail_internalhub and mail_internaladdr must exists.
edit_leaf		mail_internalhub=none		delete		none
edit_leaf		mail_internalhubaddr=none	delete		none
edit_leaf		mail_internalhub=**		is_null		+++
edit_leaf		mail_internalhubaddr=**		is_null		+++
if_leaf			mail_internalhub=+++
	delete_leaf		mail_internalhub=**
	delete_leaf		mail_internalhubaddr=**
end_if
if_leaf			mail_internalhubaddr=+++
	delete_leaf		mail_internalhub=**
	delete_leaf		mail_internalhubaddr=**
end_if
if_leaf			mail_internalhub=**
	copy_leaf		mail_internalhub=**		mailhub_mailobj_MailPRE20_domain=**
	copy_leaf		mail_internalhubaddr=**		mailhub_mailobj_MailPRE20_mailhub=**
	add_leaf		mailhub_group_MailPRE20_name=MailPRE20
	add_to_branch		mailhub_group_MailPRE20		elem_1_obj=mailhub_mailobj_MailPRE20
								desc=Internal mail hub conversion.
								count=1

	add_leaf		mailhub_table=mailhub_group_MailPRE20
	address_convert		mailhub_mailobj_MailPRE20_domain=**	mailhub_mailobj_MailPRE20_domain=**
	address_convert		mailhub_mailobj_MailPRE20_mailhub=**	mailhub_mailobj_MailPRE20_mailhub=**
end_if

# the ones that are left are obsolete from 6.0
delete_branch				mail

# proxy execs and types
change_value				def_proxy_**_proxy-type=plug-gw		plug-pdk
change_value				def_proxy_whois_proxy-type=**		whois
change_value				def_proxy_fingerd_proxy-type=**		fingerd
delete_branch				def_proxy_afwd
delete_branch				def_proxy_afwd-timer

if_leaf						def_proxy_**_proxy-type=http-gw
	change_value				def_proxy_**_proxy-exec=**		./http-pdk
end_if
if_leaf						def_proxy_**_proxy-type=gopher-gw
	change_value				def_proxy_**_proxy-exec=**		./http-pdk
end_if
if_leaf						def_proxy_**_proxy-type=plug-pdk
	change_value				def_proxy_**_proxy-exec=**		./plug-pdk
end_if
if_leaf						def_proxy_**_proxy-type=ftp-gw
	change_value				def_proxy_**_proxy-exec=**		./ftp-pdk
end_if
change_value				def_proxy_mssql-gw_proxy-exec=**	./mssql-gw
change_value				def_proxy_**_proxy-exec=./mmp-gw	./mmp

# delete empty leaves that really need a value
delete_leaf					def_proxy_**_accept-count=
delete_leaf					def_proxy_**_child-limit=
delete_leaf					def_proxy_**_proxy-exec=
delete_leaf					def_proxy_**_proxy-type=
delete_leaf					def_proxy_**_timeout=

# rename proxies
rename_branch				def_proxy_aol-gw									AOL
rename_branch				def_proxy_cserve-gw									CompuServe
rename_branch				def_proxy_cserve-gw-0								CompuServe
rename_branch				def_proxy_ldap-gw									LDAP
rename_branch				def_proxy_lnotes-gw									LotusNotes
rename_branch				def_proxy_netacl-ftpd								Local-FTP
rename_branch				def_proxy_netacl-rlogind							Local-Rlogin
rename_branch				def_proxy_netacl-telnetd							Local-Telnet
rename_branch				def_proxy_nntp-gw									NNTP
rename_branch				def_proxy_oracle-gw									sql-gw
rename_branch				def_proxy_ssl-gw-0									SSL
rename_branch				def_proxy_ssl-gw									SSL

# need to do this to get the new names into the leaves
replace_value_with_name		def_proxy_**_name=**
rename_branch				def_proxy_*											global
change_value				def_proxy_global_name=**							global

# obsolete proxy
delete_branch				def_proxy_pcxdpp

# rename default config sets
rename_branch				def_proxy_AOL_config-sets_aol-gw					AOL
rename_branch				def_proxy_authsrv_config-sets_authsrv				AuthServer
rename_branch				def_proxy_ck-gw_config-sets_ck-gw					Circuit
rename_branch				def_proxy_CompuServe_config-sets_cserve-gw			CompuServe
rename_branch				def_proxy_espmd_config-sets_espmd					ESPMD
rename_branch				def_proxy_fingerd_config-sets_finger-block			Finger-Block
rename_branch				def_proxy_fingerd_config-sets_finger-out			Finger-Out
rename_branch				def_proxy_ftp-gw_config-sets_ftp-gw					FTP
rename_branch				def_proxy_gopher-gw_config-sets_gopher-gw			Gopher
rename_branch				def_proxy_http-gw_config-sets_http-gw				HTTP
rename_branch				def_proxy_iiop-pdk_config-sets_iiop-pdk				IIOP
rename_branch				def_proxy_info-gw_config-sets_info-gw				Info
rename_branch				def_proxy_LDAP_config-sets_ldap-gw					LDAP
rename_branch				def_proxy_LotusNotes_config-sets_lnotes-gw			LotusNotes
rename_branch				def_proxy_lp-gw_config-sets_lp-gw					LP
rename_branch				def_proxy_NNTP_config-sets_nntp-gw					NNTP
rename_branch				def_proxy_NNTP_config-sets_nntp-ext					NewsFeed
rename_branch				def_proxy_pop3-gw_config-sets_pop3-gw				POP3
rename_branch				def_proxy_rlogin-gw_config-sets_rlogin-gw			Rlogin
rename_branch				def_proxy_rsh-gw_config-sets_rsh-gw					Rsh
rename_branch				def_proxy_csmap_config-sets_smap					SMTP
rename_branch				def_proxy_snmp-gw_config-sets_snmp-gw				SNMP
rename_branch				def_proxy_snmpd_config-sets_snmpd					SNMP-Agent
rename_branch				def_proxy_socks5-gw_config-sets_socks5-gw			SOCKS5
rename_branch				def_proxy_sql-gw_config-sets_oracle-gw				sql-gw
rename_branch				def_proxy_mssql-gw_config-sets_mssql-gw				SQLServer
rename_branch				def_proxy_SSL_config-sets_ssl-gw					SSL
rename_branch				def_proxy_strmwrks-gw_config-sets_strmwrks-gw		StreamWorks
rename_branch				def_proxy_syb-gw_config-sets_syb-gw					Sybase
rename_branch				def_proxy_tn-gw_config-sets_tn-gw					Telnet
rename_branch				def_proxy_whois_config-sets_whois-block				Whois-Block
rename_branch				def_proxy_whois_config-sets_whois-out				Whois-Out
rename_branch				def_proxy_x-gw_config-sets_x-gw						X-Server
rename_branch				def_proxy_Local-FTP_config-sets_netacl-ftpd			Local-FTP
rename_branch				def_proxy_Local-Rlogin_config-sets_netacl-rlogind	Local-Rlogin
rename_branch				def_proxy_Local-Telnet_config-sets_netacl-telnetd	Local-Telnet
rename_branch				def_proxy_X.500_config-sets_X.500					x.500

add_to_branch				def_proxy_**_config-sets_**			name=

replace_value_with_name		def_proxy_**_config-sets_**_name=**

# bind ports and addresses - only change for PDK-based proxies (since they now 
#support multiple binds...)
delete_leaf					def_proxy_**_bind-port=
delete_leaf					def_proxy_**_bind-address=


if_leaf						def_proxy_**_proxy-exec=./plug-pdk
# put in a default one at first in case there is no setting
	copy_leaf				def_proxy_**_proxy-exec=**			def_proxy_**_addresses_1_IP=net_ipaddr_0.0.0.0
	address_convert			def_proxy_**_bind-address=**		def_proxy_**_addresses_1_IP=**
	copy_leaf				def_proxy_**_bind-port=**			def_proxy_**_addresses_1_PORT=**
	delete_leaf				def_proxy_**_bind-address=**
	delete_leaf				def_proxy_**_bind-port=**
end_if
if_leaf						def_proxy_**_proxy-exec=./ftp-pdk
	copy_leaf				def_proxy_**_proxy-exec=**			def_proxy_**_addresses_1_IP=net_ipaddr_0.0.0.0
	address_convert			def_proxy_**_bind-address=**		def_proxy_**_addresses_1_IP=**
	copy_leaf				def_proxy_**_bind-port=**			def_proxy_**_addresses_1_PORT=**
	delete_leaf				def_proxy_**_bind-address=**
	delete_leaf				def_proxy_**_bind-port=**
end_if
if_leaf						def_proxy_**_proxy-exec=./http-pdk
	copy_leaf				def_proxy_**_proxy-exec=**			def_proxy_**_addresses_1_IP=net_ipaddr_0.0.0.0
	address_convert			def_proxy_**_bind-address=**		def_proxy_**_addresses_1_IP=**
	copy_leaf				def_proxy_**_bind-port=**			def_proxy_**_addresses_1_PORT=**
	delete_leaf				def_proxy_**_bind-address=**
	delete_leaf				def_proxy_**_bind-port=**
end_if
if_leaf						def_proxy_snmp-gw_bind-address=**
	address_convert			def_proxy_snmp-gw_bind-address=**			def_proxy_snmp-gw_address_1_bind-address=**
	copy_leaf				def_proxy_snmp-gw_managed-port=**			def_proxy_snmp-gw_address_1_bind-port=**
	copy_leaf				def_proxy_snmp-gw_proxy-type=snmp-gw		def_proxy_snmp-gw_address_1_request-type=manager
	address_convert			def_proxy_snmp-gw_manager=**				def_proxy_snmp-gw_address_1_dest-address=**
	copy_leaf				def_proxy_snmp-gw_address_1_dest-address=**	def_proxy_snmp-gw_address_1_dest-port=

	address_convert			def_proxy_snmp-gw_bind-address=**			def_proxy_snmp-gw_address_2_bind-address=**
	copy_leaf				def_proxy_snmp-gw_trap-port=**				def_proxy_snmp-gw_address_2_bind-port=**
	copy_leaf				def_proxy_snmp-gw_proxy-type=snmp-gw		def_proxy_snmp-gw_address_2_request-type=trap
	address_convert			def_proxy_snmp-gw_manager=**				def_proxy_snmp-gw_address_2_dest-address=**
	copy_leaf				def_proxy_snmp-gw_address_2_dest-address=**	def_proxy_snmp-gw_address_2_dest-port=
end_if

delete_leaf				def_proxy_snmp-gw_bind-address=**
delete_leaf				def_proxy_snmp-gw_managed-port=**
delete_leaf				def_proxy_snmp-gw_manager=**
delete_leaf				def_proxy_snmp-gw_trap-port=**
delete_leaf				def_proxy_snmp-gw_bind-port=**

# in 5.0, the IIOP bind address looks like 
# def_proxy_29_parm_1_name=bind-address_1  <-- we got rid of the bind-address_ part a while ago
# def_proxy_29_parm_1_value=0.0.0.0 683
address_convert				def_proxy_iiop-pdk_##=**				def_proxy_iiop-pdk_addresses_##_IP=**

delete_leaf					def_proxy_ftp-gw_bind-address=**
delete_leaf					def_proxy_gopher-gw_bind-address=**
delete_leaf					def_proxy_http-gw_bind-address=**
delete_leaf					def_proxy_AOL_bind-address=**
delete_leaf					def_proxy_CompuServe_bind-address=**
delete_leaf					def_proxy_LDAP_bind-address=**
delete_leaf					def_proxy_LotusNotes_bind-address=**
delete_leaf					def_proxy_NetMeeting_bind-address=**
delete_leaf					def_proxy_NNTP_bind-address=**
delete_leaf					def_proxy_SSL_bind-address=**
delete_leaf					def_proxy_X.500_bind-address=**

# convert the rest
address_convert				def_proxy_**_bind-address=**			def_proxy_**_bind-address=**

# translate old service names into port numbers
change_value				def_proxy_snmp-gw_address_##_bind-port=snmp		161
delete_leaf					def_proxy_sql-gw_bind-port=sqlnet
delete_leaf					def_proxy_ck-gw_bind-port=ck-gw-port-needs-to-be-configured
delete_leaf					def_proxy_rlogin-gw_bind-port=rloginbindport
delete_leaf					def_proxy_ck-gw_bind-port=ckgwport
delete_leaf					def_proxy_rlogin-gw_bind-port=login
change_value				def_proxy_http-gw_addresses_##_PORT=http		80
change_value				def_proxy_ftp-gw_addresses_##_PORT=ftp			21

delete_leaf					def_proxy_espmd_bind-port=8004
user_warning				def_proxy_espmd_bind-port=**		Your configuration has a non-standard GUI bind-port of $$.  This value has been changed back to the Gauntlet 6 default value of 8004.
delete_leaf					def_proxy_espmd_bind-port=**

# delete child-limits for proxies that are now pdk-based
delete_leaf					def_proxy_ftp-gw_child-limit=**
delete_leaf					def_proxy_gopher-gw_child-limit=**
delete_leaf					def_proxy_AOL_child-limit=**
delete_leaf					def_proxy_CompuServe_child-limit=**
delete_leaf					def_proxy_LDAP_child-limit=**
delete_leaf					def_proxy_LotusNotes_child-limit=**
delete_leaf					def_proxy_NetMeeting_child-limit=**
delete_leaf					def_proxy_NNTP_child-limit=**
delete_leaf					def_proxy_SSL_child-limit=**
delete_leaf					def_proxy_X.500_child-limit=**

# we used to say handoff=ip:port or handoff-host=ip and handoff-port=port
# now we just say desthost=ip and destport=port
rename_leaf					def_proxy_**_config-sets_**_handoff-host=**		desthost
rename_leaf					def_proxy_**_config-sets_**_handoff-port=**		destport

copy_leaf					def_proxy_ftp-gw_config-sets_**_handoff=**		def_proxy_ftp-gw_config-sets_**_destport=**
copy_leaf					def_proxy_http-gw_config-sets_**_handoff=**		def_proxy_http-gw_config-sets_**_destport=**
copy_leaf					def_proxy_gopher-gw_config-sets_**_handoff=**	def_proxy_gopher-gw_config-sets_**_destport=**
edit_leaf					def_proxy_**_config-sets_**_handoff=**			nuke_from	:
rename_leaf					def_proxy_**_config-sets_**_handoff=**			desthost
edit_leaf					def_proxy_**_config-sets_**_destport=**			nuke_thru	:

# specific changed leaves
add_leaf					kernel_alerts_log_dns=
add_to_branch				kernel_alerts_log				ipfragments=
															ipoptions=
															none=
															redir=
															screen=
															source=
															tcp=
															udp=

tokenize_leaf2branches		def_proxy_alerts_enable=**						kernel_alerts_log
edit_leaf					kernel_alerts_log_**=**							notnull				yes
edit_leaf					kernel_alerts_log_**=**							is_null				no
delete_leaf					kernel_alerts_log_none=**

delete_branch				def_proxy_alerts

# deny-function and log-function
# Delete the empty ones and those set to "none"
delete_leaf					def_proxy_**_config-sets_**_log=
delete_leaf					def_proxy_**_config-sets_**_log=none
delete_leaf					def_proxy_**_config-sets_**_deny-function=
delete_leaf					def_proxy_**_config-sets_**_deny-function=none
delete_leaf					def_proxy_**_config-sets_**_deny-feature=
delete_leaf					def_proxy_**_config-sets_**_deny-feature=none

tokenize_leaf2branches		def_proxy_http-gw_config-sets_**_deny-function=**		def_proxy_http-gw_config-sets_**_operation_deny
delete_leaf					def_proxy_http-gw_config-sets_**_deny-function=**
edit_leaf					def_proxy_http-gw_config-sets_**_operation_deny_**=**	notnull		yes
tokenize_leaf2branches		def_proxy_gopher-gw_config-sets_**_deny-function=**		def_proxy_gopher-gw_config-sets_**_operation_deny
delete_leaf					def_proxy_gopher-gw_config-sets_**_deny-function=**
edit_leaf					def_proxy_gopher-gw_config-sets_**_operation_deny_**=**	notnull		yes
tokenize_leaf2branches		def_proxy_ftp-gw_config-sets_**_deny-function=**		def_proxy_ftp-gw_config-sets_**_operation_deny
delete_leaf					def_proxy_ftp-gw_config-sets_**_deny-function=**
edit_leaf					def_proxy_ftp-gw_config-sets_**_operation_deny_**=**	notnull		yes

tokenize_leaf2branches		def_proxy_http-gw_config-sets_**_deny-feature=**		def_proxy_http-gw_config-sets_**
delete_leaf					def_proxy_http-gw_config-sets_**_deny-feature=**
edit_leaf					def_proxy_http-gw_config-sets_**_activex=**				notnull		on
edit_leaf					def_proxy_http-gw_config-sets_**_html2=**				notnull		on
edit_leaf					def_proxy_http-gw_config-sets_**_java=**				notnull		on
edit_leaf					def_proxy_http-gw_config-sets_**_script=**				notnull		on
tokenize_leaf2branches		def_proxy_gopher-gw_config-sets_**_deny-feature=**		def_proxy_gopher-gw_config-sets_**
delete_leaf					def_proxy_gopher-gw_config-sets_**_deny-feature=**
edit_leaf					def_proxy_gopher-gw_config-sets_**_activex=**			notnull		on
edit_leaf					def_proxy_gopher-gw_config-sets_**_html2=**				notnull		on
edit_leaf					def_proxy_gopher-gw_config-sets_**_java=**				notnull		on
edit_leaf					def_proxy_gopher-gw_config-sets_**_script=**			notnull		on

tokenize_leaf2branches		def_proxy_http-gw_config-sets_**_log=**					def_proxy_http-gw_config-sets_**_operation_log
delete_leaf					def_proxy_http-gw_config-sets_**_log=**
edit_leaf					def_proxy_http-gw_config-sets_**_operation_log_**=**	notnull		yes
tokenize_leaf2branches		def_proxy_gopher-gw_config-sets_**_log=**				def_proxy_gopher-gw_config-sets_**_operation_log
delete_leaf					def_proxy_gopher-gw_config-sets_**_log=**
edit_leaf					def_proxy_gopher-gw_config-sets_**_operation_log_**=**	notnull		yes
tokenize_leaf2branches		def_proxy_ftp-gw_config-sets_**_log=**					def_proxy_ftp-gw_config-sets_**_operation_log
delete_leaf					def_proxy_ftp-gw_config-sets_**_log=**
edit_leaf					def_proxy_ftp-gw_config-sets_**_operation_log_**=**		notnull		yes

tokenize_leaf2branches		def_proxy_http-gw_config-sets_**_permit-feature=**		def_proxy_http-gw_config-sets_**_features
delete_leaf					def_proxy_http-gw_config-sets_**_permit-feature=**
edit_leaf					def_proxy_http-gw_config-sets_**_features_**=**			notnull		on
promote_leaf				def_proxy_http-gw_config-sets_**_features_**=**
tokenize_leaf2branches		def_proxy_gopher-gw_config-sets_**_permit-feature=**	def_proxy_gopher-gw_config-sets_**_features
delete_leaf					def_proxy_gopher-gw_config-sets_**_permit-feature=**
edit_leaf					def_proxy_gopher-gw_config-sets_**_features_**=**		notnull		on
promote_leaf				def_proxy_gopher-gw_config-sets_**_features_**=**

#							def_proxy_http-gw_config-sets_HTTP_cybermasks=9fff 9fff
insert_branch				def_proxy_http-gw_config-sets_**_cybermasks=**			def_proxy_http-gw_config-sets_**_cyber_cybermasks=**
insert_branch				def_proxy_http-gw_config-sets_**_cyber_cybermasks=**	def_proxy_http-gw_config-sets_**_cyber_masks_cybermasks=**
translate_cybermasks		def_proxy_http-gw_config-sets_**_cyber_masks_cybermasks=**
#delete_leaf					def_proxy_http-gw_config-sets_**_cyber_masks_cybermasks=**

spread_leaf					def_proxy_http-gw_##=**													def_proxy_http-gw_config-sets_**
copy_leaf					def_proxy_http-gw_config-sets_**_##=**									def_proxy_http-gw_config-sets_**_cyber_masks_worktime_work-time_##=**
demote_leaf					def_proxy_http-gw_config-sets_**_cyber_masks_worktime_work-time_##=**	mask
delete_leaf					def_proxy_http-gw_##=**
delete_leaf					def_proxy_http-gw_worktimecount=**
delete_leaf					def_proxy_http-gw_config-sets_**_##=**

delete_leaf					def_proxy_http-gw_timeout=7200
#change_value				def_proxy_csmap_baddir=/tmp/badmail				/var/

# External file with Cyberpatrol and radius keys
import_file					keys.conf
insert_branch				proxy						keys_proxy

# OK - if it has one, then we can be sure it will at least have the cyberpatrol stuff
# if it does NOT have one, then it will get one when we merge
copy_leaf					keys_proxy_##_name=http		keys_proxy_##_cyber_lastupdate_yday=1
copy_leaf					keys_proxy_##_name=http		keys_proxy_##_cyber_lastupdate_year=1993

# spray usedpf=on all over the place...I would like to be selective, but there is just 
# no easier way to do this at this point.  (plugs are the problem...)
delete_leaf					def_proxy_**_config-sets_**_usedpf=**
add_to_branch				def_proxy_**_config-sets_**		usedpf=on

delete_leaf					def_proxy_authsrv_config-sets_**_usedpf=**
delete_leaf					def_proxy_ck-gw_config-sets_**_usedpf=**
delete_leaf					def_proxy_csmap_config-sets_**_usedpf=**
delete_leaf					def_proxy_espmd_config-sets_**_usedpf=**
delete_leaf					def_proxy_iiop-pdk_config-sets_**_usedpf=**
delete_leaf					def_proxy_info-gw_config-sets_**_usedpf=**
delete_leaf					def_proxy_lp-gw_config-sets_**_usedpf=**
delete_leaf					def_proxy_mssql-gw_config-sets_**_usedpf=**
delete_leaf					def_proxy_fingerd_config-sets_**_usedpf=**
delete_leaf					def_proxy_fingerd_config-sets_**_usedpf=**
delete_leaf					def_proxy_pop3-gw_config-sets_**_usedpf=**
delete_leaf					def_proxy_RealAudio_config-sets_**_usedpf=**
delete_leaf					def_proxy_rlogin-gw_config-sets_**_usedpf=**
delete_leaf					def_proxy_rsh-gw_config-sets_**_usedpf=**
delete_leaf					def_proxy_snmp-gw_config-sets_**_usedpf=**
delete_leaf					def_proxy_snmpd_config-sets_**_usedpf=**
delete_leaf					def_proxy_strmwrks-gw_config-sets_**_usedpf=**
delete_leaf					def_proxy_tn-gw_config-sets_**_usedpf=**
delete_leaf					def_proxy_x-gw_config-sets_**_usedpf=**

# authsrv stuff promoted to config set
insert_branch				def_proxy_authsrv_radiussrvport1=**				def_proxy_authsrv_config-sets_radiussrvport1=**
insert_branch				def_proxy_authsrv_config-sets_radiussrvport1=**	def_proxy_authsrv_config-sets_AuthServer_radiussrvport1=**
insert_branch				def_proxy_authsrv_radiussrvport2=**				def_proxy_authsrv_config-sets_radiussrvport2=**
insert_branch				def_proxy_authsrv_config-sets_radiussrvport2=**	def_proxy_authsrv_config-sets_AuthServer_radiussrvport2=**

insert_branch				def_proxy_authsrv_radiushost1=**				def_proxy_authsrv_config-sets_radiushost1=**
insert_branch				def_proxy_authsrv_config-sets_radiushost1=**	def_proxy_authsrv_config-sets_AuthServer_radiushost1=**
insert_branch				def_proxy_authsrv_radiushost2=**				def_proxy_authsrv_config-sets_radiushost2=**
insert_branch				def_proxy_authsrv_config-sets_radiushost2=**	def_proxy_authsrv_config-sets_AuthServer_radiushost2=**

insert_branch				def_proxy_authsrv_nobogus=**					def_proxy_authsrv_config-sets_nobogus=**
insert_branch				def_proxy_authsrv_config-sets_nobogus=**		def_proxy_authsrv_config-sets_AuthServer_nobogus=**
insert_branch				def_proxy_authsrv_securidhost=**				def_proxy_authsrv_config-sets_securidhost=**
insert_branch				def_proxy_authsrv_config-sets_securidhost=**	def_proxy_authsrv_config-sets_AuthServer_securidhost=**

insert_branch				def_proxy_authsrv_badsleep=**					def_proxy_authsrv_config-sets_badsleep=**
insert_branch				def_proxy_authsrv_config-sets_badsleep=**		def_proxy_authsrv_config-sets_AuthServer_badsleep=**
insert_branch				def_proxy_authsrv_maxbad=**						def_proxy_authsrv_config-sets_maxbad=**
insert_branch				def_proxy_authsrv_config-sets_maxbad=**			def_proxy_authsrv_config-sets_AuthServer_maxbad=**

insert_branch				def_proxy_authsrv_dssagent=**					def_proxy_authsrv_config-sets_dssagent=**
insert_branch				def_proxy_authsrv_config-sets_dssagent=**		def_proxy_authsrv_config-sets_AuthServer_dssagent=**
insert_branch				def_proxy_authsrv_dsshost=**					def_proxy_authsrv_config-sets_dsshost=**
insert_branch				def_proxy_authsrv_config-sets_dsshost=**		def_proxy_authsrv_config-sets_AuthServer_dsshost=**
insert_branch				def_proxy_authsrv_dsskey=**						def_proxy_authsrv_config-sets_dsskey=**
insert_branch				def_proxy_authsrv_config-sets_dsskey=**			def_proxy_authsrv_config-sets_AuthServer_dsskey=**
insert_branch				def_proxy_authsrv_dssport=**					def_proxy_authsrv_config-sets_dssport=**
insert_branch				def_proxy_authsrv_config-sets_dssport=**		def_proxy_authsrv_config-sets_AuthServer_dssport=**

change_value				def_proxy_authsrv_config-sets_AuthServer_nobogus=		no
change_value				def_proxy_authsrv_config-sets_AuthServer_nobogus=off	no
change_value				def_proxy_authsrv_config-sets_AuthServer_nobogus=on		yes

# move all ldap auth stuff to authsrv
copy_leaf					def_proxy_ldapauth_host=**						def_proxy_authsrv_config-sets_AuthServer_host=**
copy_leaf					def_proxy_ldapauth_host=**						def_proxy_authsrv_config-sets_AuthServer_port=**
edit_leaf					def_proxy_authsrv_config-sets_AuthServer_host=**	nuke_from	' '
edit_leaf					def_proxy_authsrv_config-sets_AuthServer_port=**	nuke_thru	' '
copy_leaf					def_proxy_ldapauth_host2=**						def_proxy_authsrv_config-sets_AuthServer_host2=**
copy_leaf					def_proxy_ldapauth_host2=**						def_proxy_authsrv_config-sets_AuthServer_port2=**
edit_leaf					def_proxy_authsrv_config-sets_AuthServer_host2=**	nuke_from	' '
edit_leaf					def_proxy_authsrv_config-sets_AuthServer_port2=**	nuke_thru	' '

copy_leaf					def_proxy_ldapauth_base-dir=**					def_proxy_authsrv_config-sets_AuthServer_base-dir=**
# this = looks like it is SUPPOSED to be here...
#edit_leaf					def_proxy_authsrv_config-sets_AuthServer_base-dir=**	nuke_thru	=

copy_leaf					def_proxy_ldapauth_username-attribute=**		def_proxy_authsrv_config-sets_AuthServer_username-attribute=**

# We copy required fields and delete branch. Following two fields are present under auth_obj which is done at the end.
copy_leaf					def_proxy_ldapauth_authorization-filter=**		def_proxy_authsrv_config-sets_AuthServer_authorization-filter=**
copy_leaf					def_proxy_ldapauth_timeout=**				def_proxy_authsrv_config-sets_AuthServer_timeout=**

delete_branch				def_proxy_ldapauth

copy_leaf					radius_client_secret1=**						def_proxy_authsrv_config-sets_AuthServer_radius-client-secret1=**
copy_leaf					radius_client_secret2=**						def_proxy_authsrv_config-sets_AuthServer_radius-client-secret2=**
delete_branch				radius_client

# verify that all auth databases are where they need to be
delete_leaf					def_proxy_authsrv_database=/usr/local/etc/fw-authdb
user_warning				def_proxy_authsrv_database=**		WARNING! Your firewall user authorization database has been moved to a non-standard location: $$  If you wish this file to be properly transferred during upgrade, please exit now, relocate the file to /usr/local/etc/fw-authdb, reconfigure the product, and restart the upgrade process.
delete_leaf					def_proxy_authsrv_database=**

delete_leaf					def_proxy_pop3-gw_database=/usr/local/etc/mgmt/pop3-authdb
user_warning				def_proxy_pop3-gw_database=**		WARNING! Your pop3 authorization database has been moved to a non-standard location: $$  If you wish this file to be properly transferred during upgrade, please exit now, relocate the file to /usr/local/etc/mgmt/pop3-authdb, reconfigure the product, and restart the upgrade process.
delete_leaf					def_proxy_pop3-gw_database=**

# X400
# Ok - this is a bizarre one.  All of the entries in the old x400 take the form:
# def_proxy_X400_amta-description-2=mta for junk
# Where everything after X400 needs to end up looking like: amta_2_amta-description=mta
# unless I see a compelling reason not to, I am going to write a cheater verb that will parse this into a pile
# of symbols with underscores and simply rename the leaf, rather than build branches.  For now anyway.  As long as
# it ends up looking correct, it should be ok.
edit_leaf					def_proxy_X400_**=**							do_x400_thang	to it
copy_leaf					def_proxy_X400_amta_count=**					def_proxy_X400_amta-count=**
delete_leaf					def_proxy_X400_amta_count=**
change_value				def_proxy_X400_amta_##_def-policy=Allow			Allow messages
# just guessing on this one...
change_value				def_proxy_X400_amta_##_def-policy=Restrict		Restrict messages

change_value				def_proxy_X400_amta_##_restriction_**_type=Restrict		Deny


# delete the state if it is off - this prevents it from showing up in the GUI unless they actually installed it in 6.0
delete_leaf					def_proxy_X400_state=off

# virus scanning
delete_leaf					def_proxy_**_cvp-server=
delete_leaf					def_proxy_**_config-sets_**_cvp-server=
delete_leaf					def_proxy_**_cvp-handling=
delete_leaf					def_proxy_**_config-sets_**_cvp-handling=
user_warning				def_proxy_gopher-gw_config-sets_**_cvp-server=**	Virus scanning for gopher is no longer supported - your gopher scan setting has been removed.
delete_leaf					def_proxy_gopher-gw_config-sets_**_cvp-server=**
change_value				def_proxy_**_content-failunsafe=**					off
change_value				def_proxy_**_config-sets_**_content-failunsafe=**	off

# FTP scanning
# 5.5		def_proxy_ftp-gw_config-sets_FTP_content-ftpchk=stor retr
# becomes	def_proxy_ftp-gw_config-sets_FTP_ftp-get=on
#			def_proxy_ftp-gw_config-sets_FTP_ftp-put=on
tokenize_leaf2branches		def_proxy_ftp-gw_config-sets_**_content-ftpchk=**		def_proxy_ftp-gw_config-sets_**
rename_leaf					def_proxy_ftp-gw_config-sets_**_stor=**					ftp-put
rename_leaf					def_proxy_ftp-gw_config-sets_**_retr=**					ftp-get
edit_leaf					def_proxy_ftp-gw_config-sets_**_ftp-put=**				notnull	on
edit_leaf					def_proxy_ftp-gw_config-sets_**_ftp-get=**				notnull	on
delete_leaf					def_proxy_ftp-gw_config-sets_**_content-ftpchk=**

# if there was a quarantine dir set before, change it to /var/quarantine and warn.  Otherwise keep it blank
copy_leaf					def_proxy_**_virus-quarantine-dir=**		def_proxy_**_tmpquar=**
delete_leaf					def_proxy_**_virus-quarantine-dir=
if_leaf						def_proxy_**_virus-quarantine-dir=**
	delete_leaf				def_proxy_**_virus-quarantine-dir=/var/quarantine
	user_warning			def_proxy_**_virus-quarantine-dir=**		The local virus scanning agent quarantine directory of $$ has been changed to the new system default location of /var/quarantine - please ensure that this directory is configured in accordance with the Getting Started Guide.
	copy_leaf				def_proxy_**_proxy-type=contentscanner		def_proxy_**_tmpquar=/var/quarantine
end_if
copy_leaf					def_proxy_**_tmpquar=**						def_proxy_**_virus-quarantine-dir=**
delete_leaf					def_proxy_**_tmpquar=**

# if there was a quarantine dir set before, change it to /var/quarantine and warn.  Otherwise keep it blank
copy_leaf					def_proxy_**_tmp-directory=**		def_proxy_**_tmpvir=**
delete_leaf					def_proxy_**_tmp-directory=
if_leaf						def_proxy_**_tmp-directory=**
	delete_leaf				def_proxy_**_tmp-directory=/var/virtmp
	user_warning			def_proxy_**_tmp-directory=**				The local virus scanning agent temporary directory of $$ has been changed to the new system default location of /var/virtmp - please ensure that this directory is configured in accordance with the Getting Started Guide.
	copy_leaf				def_proxy_**_proxy-type=contentscanner		def_proxy_**_tmpvir=/var/virtmp
end_if
copy_leaf					def_proxy_**_tmpvir=**						def_proxy_**_tmp-directory=**
delete_leaf					def_proxy_**_tmpvir=**

# Epl 1.x is based on 5.5, but can't depend on version_firewall
set_version					version_firewall=**
copy_leaf				def_proxy_**_cvp-server=**		def_proxy_**_cvp-host=**
edit_leaf				def_proxy_**_cvp-host=**		nuke_from		' '
copy_leaf				def_proxy_**_cvp-server=**		def_proxy_**_cvp-port=**
edit_leaf				def_proxy_**_cvp-port=**		nuke_thru			' '
edit_leaf				def_proxy_**_cvp-port=**		nuke_containing		.
delete_leaf				def_proxy_**_cvp-server=**

# Circuit
delete_leaf					def_proxy_ck-gw_config-sets_**_denial-msg=**
delete_leaf					def_proxy_ck-gw_config-sets_**_help-msg=**
delete_leaf					def_proxy_ck-gw_config-sets_**_welcome-msg=**
# Convert the entry that looks like:
# def_proxy_ck-gw_config-sets_Circuit_user-servers_1=user user1 -deny testck
demote_leaf					def_proxy_ck-gw_config-sets_**_##=**					group
insert_branch				def_proxy_ck-gw_config-sets_**_##_group=**				def_proxy_ck-gw_config-sets_**_user-servers_##_group=**
copy_leaf					def_proxy_ck-gw_config-sets_**_user-servers_##_group=**	def_proxy_ck-gw_config-sets_**_user-servers_##_user=**
copy_leaf					def_proxy_ck-gw_config-sets_**_user-servers_##_group=**	def_proxy_ck-gw_config-sets_**_user-servers_##_permitdeny=**
copy_leaf					def_proxy_ck-gw_config-sets_**_user-servers_##_group=**	def_proxy_ck-gw_config-sets_**_user-servers_##_service=**
edit_leaf					def_proxy_ck-gw_config-sets_**_user-servers_##_group=**			nuke_from	' '	
edit_leaf					def_proxy_ck-gw_config-sets_**_user-servers_##_user=**			nuke_thru	' '
edit_leaf					def_proxy_ck-gw_config-sets_**_user-servers_##_user=**			nuke_from	' '
edit_leaf					def_proxy_ck-gw_config-sets_**_user-servers_##_permitdeny=**	nuke_thru	-
edit_leaf					def_proxy_ck-gw_config-sets_**_user-servers_##_permitdeny=**	nuke_from	' '
edit_leaf					def_proxy_ck-gw_config-sets_**_user-servers_##_service=**		nuke_thru	' '
edit_leaf					def_proxy_ck-gw_config-sets_**_user-servers_##_service=**		nuke_thru	' '
edit_leaf					def_proxy_ck-gw_config-sets_**_user-servers_##_service=**		nuke_thru	' '
add_to_branch				def_proxy_ck-gw_config-sets_**_user-servers_##					name=

replace_value_with_name		def_proxy_ck-gw_config-sets_**_user-servers_**_name=**

# Convert the entry that looks like:
# def_proxy_ck-gw_server_1=testck -port 4001 -host 10.99.100.205 -hostport 4002 -timeout 1200
demote_leaf					def_proxy_ck-gw_##=**	name
insert_branch				def_proxy_ck-gw_##_name=**			def_proxy_ck-gw_servers_##_name=**
copy_leaf					def_proxy_ck-gw_servers_##_name=**	def_proxy_ck-gw_servers_##_port=**
copy_leaf					def_proxy_ck-gw_servers_##_name=**	def_proxy_ck-gw_servers_##_has-host=**
copy_leaf					def_proxy_ck-gw_servers_##_name=**	def_proxy_ck-gw_servers_##_has-hostport=**
copy_leaf					def_proxy_ck-gw_servers_##_name=**	def_proxy_ck-gw_servers_##_has-timeout=**

edit_leaf					def_proxy_ck-gw_servers_##_port=**			nuke_thru	-port
edit_leaf					def_proxy_ck-gw_servers_##_port=**			nuke_from	' '

# set up blanks in case we need them...
copy_leaf					def_proxy_ck-gw_servers_##_name=**			def_proxy_ck-gw_servers_##_host=
copy_leaf					def_proxy_ck-gw_servers_##_name=**			def_proxy_ck-gw_servers_##_hostport=
copy_leaf					def_proxy_ck-gw_servers_##_name=**			def_proxy_ck-gw_servers_##_timeout=

# look for -host
edit_leaf					def_proxy_ck-gw_servers_##_has-host=**		nuke_from	-hostport
edit_leaf					def_proxy_ck-gw_servers_##_has-host=**		nuke_except	-host
if_leaf						def_proxy_ck-gw_servers_##_has-host=-host
	copy_leaf				def_proxy_ck-gw_servers_##_name=**			def_proxy_ck-gw_servers_##_host=**
	edit_leaf				def_proxy_ck-gw_servers_##_host=**			nuke_thru	-host
	edit_leaf				def_proxy_ck-gw_servers_##_host=**			nuke_from	' '
end_if

edit_leaf					def_proxy_ck-gw_servers_##_has-hostport=**	nuke_except	-hostport
if_leaf						def_proxy_ck-gw_servers_##_has-hostport=-hostport
	copy_leaf				def_proxy_ck-gw_servers_##_name=**			def_proxy_ck-gw_servers_##_hostport=**
	edit_leaf				def_proxy_ck-gw_servers_##_hostport=**		nuke_thru	-hostport
	edit_leaf				def_proxy_ck-gw_servers_##_hostport=**		nuke_from	' '
end_if

edit_leaf					def_proxy_ck-gw_servers_##_has-timeout=**	nuke_except	-timeout
if_leaf						def_proxy_ck-gw_servers_##_has-timeout=-timeout
	copy_leaf				def_proxy_ck-gw_servers_##_name=**			def_proxy_ck-gw_servers_##_timeout=**
	edit_leaf				def_proxy_ck-gw_servers_##_timeout=**		nuke_thru	-timeout
	edit_leaf				def_proxy_ck-gw_servers_##_timeout=**		nuke_from	' '
end_if

# clean up
edit_leaf					def_proxy_ck-gw_servers_##_name=**			nuke_from	' '
delete_leaf					def_proxy_ck-gw_servers_##_has-host=**
delete_leaf					def_proxy_ck-gw_servers_##_has-hostport=**
delete_leaf					def_proxy_ck-gw_servers_##_has-timeout=**

# pop3

# looks like old fsa setting was in config set....  Not any more!
copy_leaf					def_proxy_pop3-gw_config-sets_POP3_force-source-address=**	def_proxy_pop3-gw_force-source-address=**
delete_leaf					def_proxy_pop3-gw_config-sets_POP3_force-source-address=**

# socks5 conversion
# start with blanks for protocols
copy_leaf					def_proxy_socks5-gw_config-sets_**_protocol-support=**	def_proxy_socks5-gw_config-sets_**_tcp=
copy_leaf					def_proxy_socks5-gw_config-sets_**_protocol-support=**	def_proxy_socks5-gw_config-sets_**_udp=
tokenize_leaf2branches		def_proxy_socks5-gw_config-sets_**_protocol-support=**  def_proxy_socks5-gw_config-sets_**

edit_leaf					def_proxy_socks5-gw_config-sets_**_tcp=**		notnull				on
edit_leaf					def_proxy_socks5-gw_config-sets_**_tcp=**		is_null				off
edit_leaf					def_proxy_socks5-gw_config-sets_**_udp=**		notnull				on
edit_leaf					def_proxy_socks5-gw_config-sets_**_udp=**		is_null				off

delete_leaf					def_proxy_socks5-gw_config-sets_**_protocol-support=**

# get new sql-gw defaults
delete_leaf					def_proxy_sql-gw_event-timer=8
if_leaf						def_proxy_sql-gw_state=on
	user_warning				def_proxy_sql-gw_maximum-relays=9			This version of Gauntlet now supports up to 1024 Oracle relay connections - your default value of 9 'Maximum Connections' has been changed to the new default value.
end_if
delete_leaf					def_proxy_sql-gw_maximum-relays=9
delete_leaf					def_proxy_sql-gw_answer-error-countdown=8
delete_leaf					def_proxy_sql-gw_log-level=1
delete_leaf					def_proxy_sql-gw_relay-connected-timer=60
delete_leaf					def_proxy_sql-gw_relay-idle-timer=10
change_value				def_proxy_sql-gw_directory=/usr/local/etc		/var/log
delete_leaf					def_proxy_sql-gw_numconns=**
delete_leaf					def_proxy_sql-gw_numsids=**

# sql-gw hosts
# should be	def_proxy_sql-gw_host_1_interface=*
#			def_proxy_sql-gw_host_1_port=123
# from		def_proxy_sql-gw_host_1=10.99.100.213 80001

demote_leaf					def_proxy_sql-gw_##=**							interface
insert_branch				def_proxy_sql-gw_##_interface=**				def_proxy_sql-gw_host_##_interface=**
copy_leaf					def_proxy_sql-gw_host_##_interface=**			def_proxy_sql-gw_host_##_port=**
edit_leaf					def_proxy_sql-gw_host_##_interface=**			nuke_from	' '
edit_leaf					def_proxy_sql-gw_host_##_port=**				nuke_thru	' '

# SIDs
# Up in preprocessing, we made the sids look like:
#	def_proxy_sql-gw_parm_11_sid=oracle-sid
#	def_proxy_sql-gw_parm_11_value=permit garth.nai.com wayne.nai.com testdb
#	def_proxy_sql-gw_parm_13_sid=oracle-sid
#	def_proxy_sql-gw_parm_13_value=deny 1.2.3.4 10.2.3.4 moocow
# We need to make the look like:
#	def_proxy_sql-gw_sid_1_access=permit
#	def_proxy_sql-gw_sid_1_server=garth.nai.com
#	def_proxy_sql-gw_sid_1_client=wayne.nai.com
#	def_proxy_sql-gw_sid_1_database=testdb
delete_leaf					def_proxy_sql-gw_parm_##_sid=oracle-sid
rename_branch				def_proxy_sql-gw_parm						sid
copy_leaf					def_proxy_sql-gw_sid_##_value=**			def_proxy_sql-gw_sid_##_access=**
copy_leaf					def_proxy_sql-gw_sid_##_value=**			def_proxy_sql-gw_sid_##_server=**
copy_leaf					def_proxy_sql-gw_sid_##_value=**			def_proxy_sql-gw_sid_##_client=**
copy_leaf					def_proxy_sql-gw_sid_##_value=**			def_proxy_sql-gw_sid_##_database=**

edit_leaf					def_proxy_sql-gw_sid_##_access=**			nuke_from	' '
edit_leaf					def_proxy_sql-gw_sid_##_client=**			nuke_thru	' '
edit_leaf					def_proxy_sql-gw_sid_##_client=**			nuke_from	' '
edit_leaf					def_proxy_sql-gw_sid_##_server=**			nuke_thru	' '
edit_leaf					def_proxy_sql-gw_sid_##_server=**			nuke_thru	' '
edit_leaf					def_proxy_sql-gw_sid_##_server=**			nuke_from	' '
edit_leaf					def_proxy_sql-gw_sid_##_database=**			nuke_thru	' '
edit_leaf					def_proxy_sql-gw_sid_##_database=**			nuke_thru	' '
edit_leaf					def_proxy_sql-gw_sid_##_database=**			nuke_thru	' '

delete_leaf					def_proxy_sql-gw_sid_##_value=**
renumber_branches			def_proxy_sql-gw_sid

# lp-gw
delete_leaf					def_proxy_lp-gw_config-sets_**_client=**
insert_branch				def_proxy_lp-gw_config-sets_**_##=**						def_proxy_lp-gw_config-sets_**_printer_##=**
demote_leaf					def_proxy_lp-gw_config-sets_**_printer_##=**				client-queue
copy_leaf					def_proxy_lp-gw_config-sets_**_printer_##_client-queue=**	def_proxy_lp-gw_config-sets_**_printer_##_print-server=**
copy_leaf					def_proxy_lp-gw_config-sets_**_printer_##_client-queue=**	def_proxy_lp-gw_config-sets_**_printer_##_server-queue=**
edit_leaf					def_proxy_lp-gw_config-sets_**_printer_##_client-queue=**	nuke_from	' '
edit_leaf					def_proxy_lp-gw_config-sets_**_printer_##_print-server=**	nuke_thru	-host
edit_leaf					def_proxy_lp-gw_config-sets_**_printer_##_print-server=**	nuke_from	' '
edit_leaf					def_proxy_lp-gw_config-sets_**_printer_##_server-queue=**	nuke_thru	-printer

# reports and logs
insert_branch				report					def_report
insert_branch				def_report				def_reports_report
rename_leaf					log_keepdays=**			log-keepdays
promote_leaf				log_log-keepdays=**
copy_leaf					log-keepdays=**			def_reports_report_log-keepdays=**
delete_leaf					log-keepdays=**
change_value				def_reports_report_**=Enabled	enabled
change_value				def_reports_report_**=Disabled	disabled

change_value				def_reports_report_alarmfreq=15Min		15 Minutes
change_value				def_reports_report_alarmfreq=30Min		30 Minutes

# SNMP (5.5 only?)
# convert from def_proxy_snmp-gw_1=10.10.1.14 permit get set traps
demote_leaf					def_proxy_snmp-gw_##=**							host
insert_branch				def_proxy_snmp-gw_##_host=**					def_proxy_snmp-gw_agents_##_host=**
copy_leaf					def_proxy_snmp-gw_agents_##_host=**				def_proxy_snmp-gw_agents_##_access=**
copy_leaf					def_proxy_snmp-gw_agents_##_host=**				def_proxy_snmp-gw_agents_##_get=**

# host and access are the only ones we can count on being there...
edit_leaf					def_proxy_snmp-gw_agents_##_host=**				nuke_from	' '
edit_leaf					def_proxy_snmp-gw_agents_##_access=**			nuke_thru	' '
edit_leaf					def_proxy_snmp-gw_agents_##_access=**			nuke_from	' '

if_leaf						def_proxy_snmp-gw_agents_##_access=permit
	edit_leaf					def_proxy_snmp-gw_agents_##_get=**				nuke_thru	' '
	edit_leaf					def_proxy_snmp-gw_agents_##_get=**				nuke_thru	' '
	copy_leaf					def_proxy_snmp-gw_agents_##_get=**				def_proxy_snmp-gw_agents_##_set=**
	copy_leaf					def_proxy_snmp-gw_agents_##_get=**				def_proxy_snmp-gw_agents_##_receive=**

	# after this, the settings start getting optional
	edit_leaf					def_proxy_snmp-gw_agents_##_get=**				nuke_except	!get
	change_value				def_proxy_snmp-gw_agents_##_get=				on
	change_value				def_proxy_snmp-gw_agents_##_get=!get			off
	edit_leaf					def_proxy_snmp-gw_agents_##_set=**				nuke_except	!set
	change_value				def_proxy_snmp-gw_agents_##_set=				on
	change_value				def_proxy_snmp-gw_agents_##_set=!set			off
	edit_leaf					def_proxy_snmp-gw_agents_##_receive=**			nuke_except	!traps
	change_value				def_proxy_snmp-gw_agents_##_receive=			on
	change_value				def_proxy_snmp-gw_agents_##_receive=!traps		off
end_if
if_leaf						def_proxy_snmp-gw_agents_##_access=deny
	copy_leaf				def_proxy_snmp-gw_agents_##_access=deny				def_proxy_snmp-gw_agents_##_get=off
	copy_leaf				def_proxy_snmp-gw_agents_##_access=deny				def_proxy_snmp-gw_agents_##_set=off
	copy_leaf				def_proxy_snmp-gw_agents_##_access=deny				def_proxy_snmp-gw_agents_##_receive=off
end_if

insert_branch				def_proxy_snmp-gw_agents_##_host=**				def_proxy_snmp-gw_config-sets_agents_##_host=**
insert_branch				def_proxy_snmp-gw_config-sets_agents_##_host=**	def_proxy_snmp-gw_config-sets_SNMP_agents_##_host=**

#copy_leaf					def_proxy_snmp-gw_manager=**						def_proxy_snmp-gw_config-sets_SNMP_agents_temp_1_host=**
#add_to_branch				def_proxy_snmp-gw_config-sets_SNMP_agents_temp_1	get=on
#																				set=on
#																				receive=on
#
#merge_unique_num_branch		def_proxy_snmp-gw_config-sets_SNMP_agents_temp

delete_leaf					def_proxy_snmp-gw_numagents=**
count						def_proxy_snmp-gw_config-sets_SNMP_agents_##_host=**		def_proxy_snmp-gw_numagents=**

# snmpd has both a port and a bind-port - not in 6.0
delete_leaf					def_proxy_snmpd_port=**

# VDOLive
change_value				def_proxy_VDOLive_check-server-ip=1				on

##########################
# Platform transition
##########################

## Delete stuff that MUST use the values from the new machine

user_warning				def_proxy_csmap_sendmail=**		The settings for the sendmail and local firewall services (ftp, rlogin, and telnet) were deleted in favor of the new defaults.
delete_leaf					def_proxy_csmap_sendmail=**
delete_leaf					def_proxy_Local-FTP_exec=**
delete_leaf					def_proxy_Local-Rlogin_exec=**
delete_leaf					def_proxy_Local-Telnet_exec=**
delete_leaf				def_proxy_Local-FTP_bind-address=**
delete_leaf				def_proxy_Local-Rlogin_bind-address=**
delete_leaf				def_proxy_Local-Telnet_bind-address=**

# this is no mistake - I have been told that this is an illegal 
# entry that sometimes shows up
delete_branch				def_proxy_*

## save the old version and OS information
copy_leaf					OS_Type=**			version_OS-Type=**
delete_branch				OS
insert_branch				version_**=**		version_old_**=**

# delete old proxy-based authentication
delete_leaf					def_proxy_**_authenticate=**
delete_leaf					def_proxy_**_config-sets_**_authenticate=**

##########################
# Generic Network Object
##########################

address_convert				extperm_**_dest=**			extperm_**_dest=**
# As of 2/14 this appears to want to be * again instead of All.
# Unless Initial env is wrong???
#change_value				extperm_**_who=*			All

###### Net groups Phase 1

# get rid of easy unnecessary stuff
delete_leaf					netobj_list_##_element_##_addr=
delete_leaf					netobj_list_##_element_##_broadcast=
delete_leaf					netobj_list_##_element_##_interface=
delete_leaf					netobj_list_##_element_##_MACAddr=
delete_leaf					netobj_list_##_element_##_name=
delete_leaf					netobj_list_##_element_##_reference=
delete_leaf					netobj_list_##_element_##_inat=
delete_leaf					netobj_list_##_element_##_nat=
delete_leaf					netobj_list_##_element_##_netmask=
delete_leaf					netobj_list_##_element_##_transparency=
delete_leaf					netobj_list_##_element_##_interfaceflags=

# dump interfaces
if_leaf						netobj_list_##_name=all_interfaces
	delete_branch			netobj_list_##
end_if
if_leaf						netobj_list_##_name=Inside
	delete_branch			netobj_list_##
end_if
if_leaf						netobj_list_##_name=Outside
	delete_branch			netobj_list_##
end_if
if_leaf						netobj_list_##_name=Unknown
	delete_branch			netobj_list_##
end_if
if_leaf						netobj_list_##_name=Service
	delete_branch			netobj_list_##
end_if

if_leaf						netobj_list_##_element_##_interfaceflags=**
	user_warning			netobj_list_##_element_##_interfaceflags=**		Please note that all interface flags from your old aliased interfaces have been reset - please consult the documentation for the new operating system to see if the flags are still required, and reset them as necessary.
	delete_leaf				netobj_list_##_element_##_interfaceflags=**
end_if

# what the heck is this??
if_leaf						netobj_list_##_name=virtualnet_trusted
	delete_branch			netobj_list_##
end_if

############# Deal with netobj_list

#if it has an addr, but it is empty, then kill it
#if_leaf						netobj_list_**_element_##_addr=
#	delete_leaf				netobj_list_**_element_##
#end_if

# if it is empty, delete it
if_leaf						netobj_list_**_num_elements=0
	delete_branch			netobj_list_**
end_if

change_value				netobj_list_**_name=SMAP$SPAM		MailAspam
replace_name_with_value		netobj_list_**_name=MailAspam
change_value				netobj_list_**_name=SMAP$RELAY		MailPermitRelay
replace_name_with_value		netobj_list_**_name=MailPermitRelay
change_value				netobj_list_**_name=SMAP$LOCAL		MailLocalDomain
replace_name_with_value		netobj_list_**_name=MailLocalDomain

# this is where we will deal with alias interfaces

copy_leaf					netobj_list_**_name=**					netobj_list_**_IFNAME=**
edit_leaf					netobj_list_**_IFNAME=**				delete_except	$INTERFACE
if_leaf						netobj_list_**_IFNAME=$INTERFACE
	delete_branch			netobj_list_**
end_if
delete_leaf					netobj_list_**_IFNAME=**

if_leaf						netobj_list_**_element_##_interface=**
	delete_branch			netobj_list_**_element_##
end_if

# if it has an addr, then convert it
if_leaf						netobj_list_**_element_##_addr=**
	edit_leaf				netobj_list_**_name=**					delete	$LIST
	address_convert			netobj_list_**_element_##_addr=**		netobj_list_**_element_##_obj=**	name
	copy_leaf				netobj_list_**_element_##_obj=**		netobj_list_**_element_##_type=**
	edit_leaf				netobj_list_**_element_##_type=**		nuke_thru		_
	edit_leaf				netobj_list_**_element_##_type=**		nuke_from		_
	delete_leaf				netobj_list_**_element_##_addr=**
end_if

rename_branch				netobj_list_**_element					elem

replace_name_with_value		netobj_list_**_name=**

delete_leaf					**_num_elements=**
delete_leaf					**_**_num_elements=**
delete_leaf					**_**_**_num_elements=**
delete_leaf					**_**_**_**_num_elements=**

###### Net groups Phase 2

# just pick up the description of list groups - we will get the name and everything else
# when we join the netobj_list with netobj_group
if_leaf						netobj_group_**_member_##_type=L
	delete_branch			netobj_group_**_member_##
#	change_value			netobj_group_**_member_##_type=L	group
#	edit_leaf				netobj_group_**_member_##_name=**	delete	$LIST
#	edit_leaf				netobj_group_**_member_##_name=**	insert	net_group_
#	edit_leaf				netobj_group_**_member_##_name=**	append	-list
#	rename_leaf				netobj_group_**_member_##_name=**	obj
end_if

if_leaf						netobj_group_**_member_##_type=G
	change_value			netobj_group_**_member_##_type=G	group
	edit_leaf				netobj_group_**_member_##_name=**	insert	net_group_
	rename_leaf				netobj_group_**_member_##_name=**	obj
end_if

# promote netobj_group so we can merge it with the netobj_list
# the only thing we want to keep in netobj_group is desc
replace_name_with_value		netobj_group_**_name=**

rename_branch				netobj_group_**_member				elem

# insert a temp branch so we can later ensure that we do not overwrite any elements that
# are already there
insert_branch				netobj_list_**_elem_##				netobj_list_**_elem_temp_##

join_branches				netobj_group						net_group
rename_branch				netobj_list							group
join_branches				netobj								net

merge_unique_num_branch		net_group_**_elem_temp
renumber_branches			net_group_**_elem

# in 6.0, the name comes from the path
delete_leaf					net_group_**_elem_##_name=**
delete_leaf					net_group_**_name=**

# Delete the descriptions that are better in 6.0
delete_leaf					net_group_Authsrv_desc=**
delete_leaf					net_group_Netacl_desc=**
delete_leaf					net_group_ESPMD_desc=**
delete_leaf					net_group_Trusted_desc=**
delete_leaf					net_group_Untrusted_desc=**
delete_leaf					net_group_Mail_desc=**
delete_leaf					net_group_MailAspam_desc=**
delete_leaf					net_group_MailPermitRelay_desc=**
delete_leaf					net_group_MailLocalDomain_desc=**

###### Policies
merge_name_value			policy_##_parm_##			policy_##
insert_branch				policy_##					policy_group_##
rename_branch				policy						service
replace_name_with_value		service_group_##_name=**	##
rename_branch				service_group_**_proxy		elem
rename_leaf					service_group_**_elem_##_name=**	obj
add_to_branch				service_group_Local_elem_##		type=config-sets

delete_leaf					service_group_**_desc=

# obsolete proxy
delete_leaf					service_group_**_elem_##_obj=pcxdpp
#delete_leaf					service_group_**_elem_##_obj=smap

# rename all of the default objects that have changed
change_value				service_group_**_elem_##_obj=smap				SMTP
change_value				service_group_**_elem_##_obj=aol-gw					AOL
change_value				service_group_**_elem_##_obj=authsrv				AuthServer
change_value				service_group_**_elem_##_obj=ck-gw					Circuit
change_value				service_group_**_elem_##_obj=cserve-gw				CompuServe
change_value				service_group_**_elem_##_obj=espmd					ESPMD
change_value				service_group_**_elem_##_obj=finger-block			Finger-Block
change_value				service_group_**_elem_##_obj=finger-out				Finger-Out
change_value				service_group_**_elem_##_obj=ftp-gw					FTP
change_value				service_group_**_elem_##_obj=gopher-gw				Gopher
change_value				service_group_**_elem_##_obj=http-gw				HTTP
change_value				service_group_**_elem_##_obj=iiop-pdk				IIOP
change_value				service_group_**_elem_##_obj=info-gw				Info
change_value				service_group_**_elem_##_obj=ldap-gw				LDAP
change_value				service_group_**_elem_##_obj=lnotes-gw				LotusNotes
change_value				service_group_**_elem_##_obj=lp-gw					LP
change_value				service_group_**_elem_##_obj=nntp-gw				NNTP
change_value				service_group_**_elem_##_obj=nntp-ext				NewsFeed
change_value				service_group_**_elem_##_obj=pop3-gw				POP3
change_value				service_group_**_elem_##_obj=rlogin-gw				Rlogin
change_value				service_group_**_elem_##_obj=rsh-gw					Rsh
change_value				service_group_**_elem_##_obj=smapd					SMTP
change_value				service_group_**_elem_##_obj=snmp-gw				SNMP
change_value				service_group_**_elem_##_obj=snmpd					SNMP-Agent
change_value				service_group_**_elem_##_obj=socks5-gw				SOCKS5
change_value				service_group_**_elem_##_obj=oracle-gw				sql-gw
change_value				service_group_**_elem_##_obj=mssql-gw				SQLServer
change_value				service_group_**_elem_##_obj=ssl-gw					SSL
change_value				service_group_**_elem_##_obj=strmwrks-gw			StreamWorks
change_value				service_group_**_elem_##_obj=syb-gw					Sybase
change_value				service_group_**_elem_##_obj=tn-gw					Telnet
change_value				service_group_**_elem_##_obj=whois-block			Whois-Block
change_value				service_group_**_elem_##_obj=whois-out				Whois-Out
change_value				service_group_**_elem_##_obj=x-gw					X-Server
change_value				service_group_**_elem_##_obj=netacl-ftpd			Local-FTP
change_value				service_group_**_elem_##_obj=netacl-rlogind			Local-Rlogin
change_value				service_group_**_elem_##_obj=netacl-telnetd			Local-Telnet
change_value				service_group_**_elem_##_obj=X.500					x.500


# now that all of the old default objects are updated, 
# fill the group elements with the actual object path
object_lookup				service_group_**_elem_##_obj=**		def_proxy_**_config-sets

delete_leaf					service_group_**_desc=
delete_leaf					service_group_**_name=**

###### Destination groups
# TODO: warn about following:
if_leaf						dest_##_service=
	delete_branch			dest_##
end_if

insert_branch				dest_##							dest_group_##
rename_branch				dest							destination
delete_leaf					destination_group_##_desc=**
#replace_name_with_value		destination_group_##_service=**

#rename_leaf				destination_group_##_dest=**	addr
#address_convert			destination_group_##_addr=**	destination_group_##_addr=**

###### Basic proxy rules
insert_branch				map_##							map_proxy_##
rename_branch				map								rule

# obsolete proxy
delete_leaf					rule_proxy_##_proxy=pcxdpp

# rename the default config sets that have changed
change_value				rule_proxy_##_proxy=aol-gw				AOL
change_value				rule_proxy_##_proxy=authsrv				AuthServer
change_value				rule_proxy_##_proxy=ck-gw				Circuit
change_value				rule_proxy_##_proxy=cserve-gw			CompuServe
change_value				rule_proxy_##_proxy=espmd				ESPMD
change_value				rule_proxy_##_proxy=finger-block		Finger-Block
change_value				rule_proxy_##_proxy=finger-out			Finger-Out
change_value				rule_proxy_##_proxy=ftp-gw				FTP
change_value				rule_proxy_##_proxy=gopher-gw			Gopher
change_value				rule_proxy_##_proxy=http-gw				HTTP
change_value				rule_proxy_##_proxy=iiop-pdk			IIOP
change_value				rule_proxy_##_proxy=info-gw				Info
change_value				rule_proxy_##_proxy=ldap-gw				LDAP
change_value				rule_proxy_##_proxy=lnotes-gw			LotusNotes
change_value				rule_proxy_##_proxy=lp-gw				LP
change_value				rule_proxy_##_proxy=nntp-gw				NNTP
change_value				rule_proxy_##_proxy=nntp-ext			NewsFeed
change_value				rule_proxy_##_proxy=pop3-gw				POP3
change_value				rule_proxy_##_proxy=rlogin-gw			Rlogin
change_value				rule_proxy_##_proxy=rsh-gw				Rsh
change_value				rule_proxy_##_proxy=smapd				SMTP
change_value				rule_proxy_##_proxy=snmp-gw				SNMP
change_value				rule_proxy_##_proxy=snmpd				SNMP-Agent
change_value				rule_proxy_##_proxy=socks5-gw			SOCKS5
change_value				rule_proxy_##_proxy=oracle-gw			sql-gw
change_value				rule_proxy_##_proxy=mssql-gw			SQLServer
change_value				rule_proxy_##_proxy=ssl-gw				SSL
change_value				rule_proxy_##_proxy=strmwrks-gw			StreamWorks
change_value				rule_proxy_##_proxy=syb-gw				Sybase
change_value				rule_proxy_##_proxy=tn-gw				Telnet
change_value				rule_proxy_##_proxy=whois-block			Whois-Block
change_value				rule_proxy_##_proxy=whois-out			Whois-Out
change_value				rule_proxy_##_proxy=x-gw				X-Server
change_value				rule_proxy_##_proxy=netacl-ftpd			Local-FTP
change_value				rule_proxy_##_proxy=netacl-rlogind		Local-Rlogin
change_value				rule_proxy_##_proxy=netacl-telnetd		Local-Telnet
change_value				rule_proxy_##_proxy=X.500				x.500

# Permit/Deny
rename_leaf					rule_proxy_##_pd=**				action
change_value				rule_proxy_##_action=P			Permit
change_value				rule_proxy_##_action=D			Deny

# src will be either a defined network object group or a specific IP

# fill in the services that are actually associated with a specific source
edit_leaf					rule_proxy_##_src=**				delete	$$NETOBJ.
object_lookup				rule_proxy_##_src=**				net_group
change_value				rule_proxy_##_src=net_group_ESPMD	net_group_GUI-Clients

# make sure we get the sources of things that were not already groups
copy_leaf					rule_proxy_##_src=**				rule_proxy_##_tmpsrc=**
edit_leaf					rule_proxy_##_tmpsrc=**				nuke_from	net_
delete_leaf					rule_proxy_##_tmpsrc=
if_leaf						rule_proxy_##_tmpsrc=**
	address_convert			rule_proxy_##_src=**				rule_proxy_##_src=**
end_if
delete_leaf					rule_proxy_##_tmpsrc=**

# the policy map can either have
# policy=something
# proxy=*
#
# policy=*
# proxy=something
#
# policy=*
# proxy=*
#
# do the case where they are BOTH *
if_leaf						rule_proxy_##_policy=*
	if_leaf					rule_proxy_##_proxy=*
		copy_leaf			rule_proxy_##_proxy=*			rule_proxy_##_service=service_group_AllServiceGroupsFromUpgrade6.0
		delete_leaf			rule_proxy_##_proxy=**
		delete_leaf			rule_proxy_##_policy=**
		# Deal with upgrading the feature: deny all services
		# This feature is not in Gauntlet 6 (yet)
		user_warning		rule_proxy_##_policy=*			This version of the firewall does not have an 'all services' selection for rules; a list of all of your current services have been placed in a new service group called AllServiceGroupsFromUpgrade6.0 - be sure to manually add any new services you create to this group.
	end_if
end_if

object_lookup				rule_proxy_##_proxy=**			def_proxy_**_config-sets
object_lookup				rule_proxy_##_policy=**			service_group

# prepare to make sure we got a good conversion
copy_leaf					rule_proxy_##_proxy=**			rule_proxy_##_oldproxy=**
copy_leaf					rule_proxy_##_policy=**			rule_proxy_##_oldpolicy=**
edit_leaf					rule_proxy_##_oldproxy=**		nuke_from	def_proxy
edit_leaf					rule_proxy_##_oldpolicy=**		nuke_from	service_group
edit_leaf					rule_proxy_##_oldproxy=**		notnull		bad!
edit_leaf					rule_proxy_##_oldpolicy=**		notnull		bad!
	
# deal with the case where the policy is defined
if_leaf						rule_proxy_**_proxy=*
	if_leaf					rule_proxy_**_oldpolicy=bad!
		replace_value_with_name		rule_proxy_**_oldpolicy=**
		user_warning				rule_proxy_**_oldpolicy=**		Upgrade was unable to identify a safe conversion for the service group indicated in your old rule $$ - this rule has been deleted.
		delete_branch				rule_proxy_**
	end_if
	rename_leaf				rule_proxy_**_policy=**			service
#	edit_leaf				rule_proxy_**_service=**		insert	service_group
	delete_leaf				rule_proxy_**_proxy=**
	delete_leaf				rule_proxy_**_policy=**
	delete_leaf				rule_proxy_**_oldpolicy=**
	delete_leaf				rule_proxy_**_oldproxy=**
end_if

# anything that is left just has proxy defined, and we will try to just link the service, rather than create a new service group
if_leaf					rule_proxy_**_oldproxy=bad!
	replace_value_with_name		rule_proxy_**_oldproxy=**
	user_warning				rule_proxy_**_oldproxy=**		Upgrade was unable to identify a safe conversion for the proxy indicated in your old rule $$ - this rule has been deleted.
	delete_branch				rule_proxy_**
end_if
rename_leaf					rule_proxy_**_proxy=**		service
delete_leaf					rule_proxy_**_proxy=**
delete_leaf					rule_proxy_**_policy=**
delete_leaf					rule_proxy_**_oldproxy=**

copy_leaf					rule_proxy_##_service=**		rule_proxy_##_rulelabel=**
edit_leaf					rule_proxy_##_rulelabel=**		nuke_thru	config-sets_
edit_leaf					rule_proxy_##_rulelabel=**		delete		service_group_

change_value				rule_proxy_##_rulelabel=Local	Netacl
change_value				rule_proxy_##_rulelabel=ESPMD	Management-Access

# nuke the ones for which lookup failed (illegal rules!)
if_leaf						rule_proxy_**_src=net_group
	replace_value_with_name	rule_proxy_**_src=**
	user_warning			rule_proxy_**_src=**		Upgrade was unable to identify a safe conversion for the source in your old rule $$ - this rule has been deleted.
	delete_branch			rule_proxy_**
end_if

# Add a new auth object to deal with service groups that allow for changing the password
add_leaf					auth_obj_change_cache-server=def_proxy_http-authcache
add_leaf					auth_obj_change_description=Default authentication with password change permitted
add_leaf					auth_obj_change_member_attribute=uniqueMember
add_leaf					auth_obj_change_name=change
add_leaf					auth_obj_change_password=change
add_leaf					auth_obj_change_pwtimeout=28800
add_leaf					auth_obj_change_server=def_proxy_authsrv
add_leaf					auth_obj_change_sso-abstimeout=28800
add_leaf					auth_obj_change_sso-idletimeout=1800
add_leaf					auth_obj_change_sso=no

##########################
# More Misc.
##########################

# NAT rules
rename_branch				nat_rule							natrule
join_branches				nat									rule

# temporarily hide global proxy setting
rename_leaf					def_proxy_global_logging=**			hide-logging
rename_leaf					def_proxy_**_logging=**				log-enabled
copy_leaf					def_proxy_**_log-enabled=**			def_proxy_**_tmp-log-enabled=**

change_value				def_proxy_**_log-enabled=none		no

edit_leaf					def_proxy_**_tmp-log-enabled=**		nuke_except	none
if_leaf						def_proxy_**_tmp-log-enabled=
	change_value			def_proxy_**_log-enabled=**			yes
end_if
delete_leaf					def_proxy_**_tmp-log-enabled=**

# bring back global proxy setting
rename_leaf					def_proxy_global_hide-logging=**	logging

copy_leaf					audit_config_count=**				def_reports_report_audit-config-count=**
delete_leaf					audit_config_count=**

copy_leaf					def_proxy_global_use-name-logs=**	def_reports_report_use-name-logs=**
delete_leaf					def_proxy_global_use-name-logs=**
edit_leaf					def_reports_report_log-keepdays=**	append	' '
edit_leaf					def_reports_report_log-keepdays=**	append	Days

rename_leaf					extperm_**_who_type=**	who-type		
promote_leaf				extperm_**_who_who-type=**


# ASSUMPTION: User MUST configure ESPMD properly or upgrade will not be able to connect
# do not delete branch for epl 2.0
#delete_branch				net_group_ESPMD

########################################################################################
########################################################################################
# VPN-related items
########################################################################################
########################################################################################

# obsolete stuff - clean it up so we do not have to mess with it as we are searching the links
copy_leaf					vpn_version=**			version_old_vpn=**
edit_leaf					vpn_version=**			nuke_from	' '
set_version					vpn_version=**

delete_branch				vpn
delete_leaf					pki_CRLs=**
delete_leaf					pki_default_port=**
delete_leaf					pki_default_server=**
delete_leaf					pki_expiration_days=**
delete_leaf					pki_LDAP=**
delete_leaf					pki_updates=**
delete_leaf					pki_Xcerts=**
delete_leaf					link_##_interface=**
delete_leaf					link_##_encaps=**
delete_leaf					link_##_key=**
delete_leaf					link_##_trust=**
delete_leaf					link_##_sqnum=**
delete_leaf					link_##_iv64=**
delete_leaf					link_##_ispi=**
delete_leaf					link_##_ospi=**
delete_leaf					link_##_iaspi=**
delete_leaf					link_##_oaspi=**
delete_leaf					link_##_ikey=**
delete_leaf					link_##_okey=**

###########################
# 5.0 Pre-processing
###########################

####### If this is 5.0, we need to use the pki_## entries...

if_version					5.0
	add_to_branch			pki_##						http-port=444
														req_password=True
														act_password=True

	insert_branch			pki_##						sys_pki_##
	copy_leaf				sys_pki_##_primary=**		sys_pki_##_primary-gvpn=**
	add_to_branch			link_##						ipcomp=off

end_if

# Preprocess 5.0 swipe links - they are missing some crucial information
if_leaf					link_##_mode=swipe
	add_to_branch		link_##					hash=SHA-1
												encr=TripleDES
												aalgo=HMAC SHA-1
												ealgo=CAST
												group=1024-bit

end_if

change_value		link_##_aalgo=hmd5		HMAC MD5
change_value		link_##_ealgo=des		DES

# remove illegal characters from link names - they will be becoming branch names
edit_leaf			link_##_lname=**		make_legal		ignore-me

######################
# PASSTHROUGH LINKS
######################

# A link that was previously defined as a passthrough link is converted to three packet 
# filter rules with action bi-directional forward
#
# After being converted, the passthrough links are deleted to prevent other VPN objects from 
# being created for them.

if_leaf						link_##_type=pass

	add_leaf				fpf-serv_PassthroughAH_comment=PassthroughAH
	add_to_branch			fpf-serv_PassthroughAH		proto=51
														interface=*
														srcport1=*
														srcport2=*
														dstport1=*
														dstport2=*

	add_leaf				fpf-serv_PassthroughESP_comment=PassthroughESP
	add_to_branch			fpf-serv_PassthroughESP		proto=50
														interface=*
														srcport1=*
														srcport2=*
														dstport1=*
														dstport2=*

	add_leaf				fpf-serv_PassthroughIKE_comment=PassthroughIKE
	add_to_branch			fpf-serv_PassthroughIKE		proto=udp
														interface=*
														srcport1=500
														srcport2=500
														dstport1=500
														dstport2=500

# first packet filter rule
	copy_leaf				link_##_lname=**			rule_pffwd_temp_##_label=**
	edit_leaf				rule_pffwd_temp_##_label=**	append		-PassAH

	copy_leaf				link_##_debug=None			rule_pffwd_temp_##_loglevel_number=0
	copy_leaf				link_##_debug=Critical		rule_pffwd_temp_##_loglevel_number=1
	copy_leaf				link_##_debug=Normal		rule_pffwd_temp_##_loglevel_number=2
	copy_leaf				link_##_debug=Medium		rule_pffwd_temp_##_loglevel_number=3
	copy_leaf				link_##_debug=High			rule_pffwd_temp_##_loglevel_number=4

	# if this is a client link, hook it to a net_vpnclient object
	# if it is anything else, hook it to a net_vpnnetwork object

	copy_leaf				link_##_lname=**			rule_pffwd_temp_##_src=**
	edit_leaf				rule_pffwd_temp_##_src=**	insert	net_vpnnetwork_

	# now if it is a client, just overwrite what we just did...
	if_leaf					link_##_mode=client
		copy_leaf			link_##_lname=**			rule_pffwd_temp_##_src=**
		edit_leaf			rule_pffwd_temp_##_src=**	insert	net_vpnclient_
	end_if

	address_convert			link_##_laddress=**			rule_pffwd_temp_##_dst=**
	add_to_branch			rule_pffwd_temp_##			service=fpf-serv_PassthroughAH
														type=Bi-dir

# synthesize a temporary leaf that will tell us the original sequence number of this rule
	copy_leaf				link_##_raddress=**			rule_pffwd_temp_##_PREUPGRADE-SEQ=
	replace_value_with_name	rule_pffwd_temp_##_PREUPGRADE-SEQ=**

end_if
merge_unique_num_branch		rule_pffwd_temp

if_leaf						link_##_type=pass
# second packet filter rule
	copy_leaf				link_##_lname=**			rule_pffwd_temp_##_label=**
	edit_leaf				rule_pffwd_temp_##_label=**	append		-PassESP

	copy_leaf				link_##_debug=None			rule_pffwd_temp_##_loglevel_number=0
	copy_leaf				link_##_debug=Critical		rule_pffwd_temp_##_loglevel_number=1
	copy_leaf				link_##_debug=Normal		rule_pffwd_temp_##_loglevel_number=2
	copy_leaf				link_##_debug=Medium		rule_pffwd_temp_##_loglevel_number=3
	copy_leaf				link_##_debug=High			rule_pffwd_temp_##_loglevel_number=4

	# if this is a client link, hook it to a net_vpnclient object
	# if it is anything else, hook it to a net_vpnnetwork object

	copy_leaf				link_##_lname=**			rule_pffwd_temp_##_src=**
	edit_leaf				rule_pffwd_temp_##_src=**	insert	net_vpnnetwork_

	# now if it is a client, just overwrite what we just did...
	if_leaf					link_##_mode=client
		copy_leaf			link_##_lname=**			rule_pffwd_temp_##_src=**
		edit_leaf			rule_pffwd_temp_##_src=**	insert	net_vpnclient_
	end_if

	address_convert			link_##_laddress=**			rule_pffwd_temp_##_dst=**
	add_to_branch			rule_pffwd_temp_##			service=fpf-serv_PassthroughESP
														type=Bi-dir

# synthesize a temporary leaf that will tell us the original sequence number of this rule
	copy_leaf				link_##_raddress=**			rule_pffwd_temp_##_PREUPGRADE-SEQ=
	replace_value_with_name	rule_pffwd_temp_##_PREUPGRADE-SEQ=**

end_if
merge_unique_num_branch		rule_pffwd_temp

# third packet filter rule
if_leaf						link_##_type=pass
	copy_leaf				link_##_lname=**			rule_pffwd_temp_##_label=**
	edit_leaf				rule_pffwd_temp_##_label=**	append		-PassIKE

	copy_leaf				link_##_debug=None			rule_pffwd_temp_##_loglevel_number=0
	copy_leaf				link_##_debug=Critical		rule_pffwd_temp_##_loglevel_number=1
	copy_leaf				link_##_debug=Normal		rule_pffwd_temp_##_loglevel_number=2
	copy_leaf				link_##_debug=Medium		rule_pffwd_temp_##_loglevel_number=3
	copy_leaf				link_##_debug=High			rule_pffwd_temp_##_loglevel_number=4

	# if this is a client link, hook it to a net_vpnclient object
	# if it is anything else, hook it to a net_vpnnetwork object

	copy_leaf				link_##_lname=**			rule_pffwd_temp_##_src=**
	edit_leaf				rule_pffwd_temp_##_src=**	insert	net_vpnnetwork_

	# now if it is a client, just overwrite what we just did...
	if_leaf					link_##_mode=client
		copy_leaf			link_##_lname=**			rule_pffwd_temp_##_src=**
		edit_leaf			rule_pffwd_temp_##_src=**	insert	net_vpnclient_
	end_if

	address_convert			link_##_laddress=**			rule_pffwd_temp_##_dst=**
	add_to_branch			rule_pffwd_temp_##			service=fpf-serv_PassthroughIKE
														type=Bi-dir

# synthesize a temporary leaf that will tell us the original sequence number of this rule
	copy_leaf				link_##_raddress=**			rule_pffwd_temp_##_PREUPGRADE-SEQ=
	replace_value_with_name	rule_pffwd_temp_##_PREUPGRADE-SEQ=**

end_if
merge_unique_num_branch		rule_pffwd_temp

if_leaf						link_##_type=pass
	delete_branch			link_##
end_if

######################
# PKI Components
######################


# rename the old activated pki components per their name - this will help us sync them
# with the name as used under 6.0, since we are not guaranteed that the numbers are
# synced
replace_name_with_value		pki_##_name=**			##

rename_leaf					sys_pki_##_name=**				ca-name
replace_name_with_value		sys_pki_**_ca-name=**

# External file with current VPN Certs
import_file					gvpn_cert_status.conf

rename_leaf					sys_pki_**_CA=**				ca

copy_leaf					sys_pki_**_ca=XCERT				sys_pki_**_ca-type=Net Tools PKI
copy_leaf					sys_pki_**_ca=ENTRUST			sys_pki_**_ca-type=Entrust VPN Connector
copy_leaf					sys_pki_**_ca=VERISIGN			sys_pki_**_ca-type=VeriSign
copy_leaf					sys_pki_**_ca=OTHER				sys_pki_**_ca-type=Other

rename_leaf					sys_pki_**_LDAP=**				enable-pki
rename_leaf					sys_pki_**_CRLs=**				crl-required
rename_leaf					sys_pki_**_server=**			ip-address
rename_leaf					sys_pki_**_port=**				ldap-port
rename_leaf					sys_pki_**_http_port=**			http-port
promote_leaf				sys_pki_**_http_http-port=**
rename_leaf					sys_pki_**_commonName=**		fw-common-name
rename_leaf					sys_pki_**_orgunit=**			org-unit
rename_leaf					sys_pki_**_subjectAltName=**	subject-alt-name
rename_leaf					sys_pki_**_sigalg=**			sig-alg
rename_leaf					sys_pki_**_keysize=**			key-size
rename_leaf					sys_pki_**_email=**				e-mail
rename_leaf					sys_pki_**_keyUsage=**			key-usage

rename_leaf					sys_pki_**_subjectAltName_value=**			subject-alt-name-value
promote_leaf				sys_pki_**_subjectAltName_subject-alt-name-value=**

rename_leaf					sys_pki_**_num_certs=**			inter
promote_leaf				sys_pki_**_num_inter=**

# no change to				sys_pki_**_primary=**
# no change to				sys_pki_**_requested=**

rename_leaf					sys_pki_**_req_password=**					requested-password-used
promote_leaf				sys_pki_**_req_requested-password-used=**

rename_leaf					sys_pki_**_act_password=**					activated-password-used
promote_leaf				sys_pki_**_act_activated-password-used=**

change_value				sys_pki_**_**=Enabled			true
change_value				sys_pki_**_**=Disabled			false
change_value				sys_pki_**_**=True				true
change_value				sys_pki_**_**=False				false

# get the actual primary
copy_leaf					pki_**_primary=**		sys_pki_**_primary-gvpn=**
#delete_branch				pki

# this verb will keep reading lines until a blank line is found
if_leaf						sys_pki_**_ca-name=**
	add_to_branch				sys_pki_**				ca-scope=
														ca-check-pem=
														ca-attribute=
														ca-objclass=
														ca-md5=
														ca-country=
														ca-state=
														ca-locality=
														ca-org-unit=
														ca-organization=
														common-name=
														check-subject-alt-name=
														check-pem=
														attribute=
														objclass=
														base=
														serial-number=
														primary-ssl=
														ssl=
														iiop=
														primary-iiop=
														gvpn=
														net-inter=
														md5=
														scope=
														certificate-output=
														certificate-accept-clicked=true

end_if

if_leaf					sys_pki_verisignCA_ca=**
	add_leaf			sys_pki_verisignCA_name_type= -n verisignCA -a VERISIGN
	add_leaf			sys_pki_verisignCA_pki-file-list-accept-clicked=false
	add_leaf			sys_pki_verisignCA_pki-file-list-name=
	add_leaf			sys_pki_verisignCA_pki-file-list-output=
end_if

##################
# IPSec Policies
##################

############ select_1

copy_leaf			link_##_aalgo=**		vpn_ipsec_??-Pre20_description=IPSec Policy imported from upgraded Firewall

# both flavors need this one (I think)
copy_leaf			link_##_aalgo=**		vpn_ipsec_??-Pre20_select_1_hash=**
copy_leaf			link_##_ltimeIImax=**	vpn_ipsec_??-Pre20_select_1_lifetime=**
copy_leaf			link_##_ldataIImax=**	vpn_ipsec_??-Pre20_select_1_allow-mb=**
copy_leaf			link_##_ldataIImax=**	vpn_ipsec_??-Pre20_select_1_transfer-limit=**

# Do one thing if ealgo is set to "none"...
if_leaf				link_##_ealgo=none
	copy_leaf			link_##_ealgo=none		vpn_ipsec_??-Pre20_select_1_allow-esp=off
	copy_leaf			link_##_ealgo=none		vpn_ipsec_??-Pre20_select_1_cipher=
	copy_leaf			link_##_ealgo=none		vpn_ipsec_??-Pre20_select_1_allow-ah=on
	copy_leaf			link_##_aalgo=**		vpn_ipsec_??-Pre20_select_1_ah=**
	delete_leaf			link_##_ealgo=none
end_if

# ...and do something else if ealgo is set to anything else
if_leaf				link_##_ealgo=**
	copy_leaf			link_##_ealgo=**		vpn_ipsec_??-Pre20_select_1_allow-esp=on
	copy_leaf			link_##_ealgo=**		vpn_ipsec_??-Pre20_select_1_cipher=**
	copy_leaf			link_##_ealgo=none		vpn_ipsec_??-Pre20_select_1_allow-ah=off
	copy_leaf			link_##_aalgo=**		vpn_ipsec_??-Pre20_select_1_ah=None
end_if

# Do one thing if pfs is set to "off"...
copy_leaf			link_##_pfs=Off			vpn_ipsec_??-Pre20_select_1_allow-pfs=Off
copy_leaf			link_##_pfs=Off			vpn_ipsec_??-Pre20_select_1_pfs=
delete_leaf			link_##_pfs=Off
# ...and do something else if it is set to anything else
copy_leaf			link_##_pfs=**			vpn_ipsec_??-Pre20_select_1_allow-pfs=On
copy_leaf			link_##_pfs=**			vpn_ipsec_??-Pre20_select_1_pfs=**

########## Conditional settings

if_leaf		link_##_ipcomp=off
	copy_leaf			link_##_ipcomp=off		vpn_ipsec_??-Pre20_select_1_allow-ippcp=off
	copy_leaf			link_##_ipcomp=off		vpn_ipsec_??-Pre20_select_1_ippcp=None
end_if

# have to deal with ipcomp on as a doble-if with a dummy variable to get around limitations
# of wildcards in if_leaf
if_leaf		link_##_ipcomp=on
	copy_leaf			link_##_ipcomp=on		vpn_ipsec_??-Pre20_select_1_UPGRADE=IPCOMP-ON
end_if

if_leaf					vpn_ipsec_**_select_1_UPGRADE=IPCOMP-ON

# Get rid of this fake entry before I forget (again!!)
	delete_leaf			vpn_ipsec_**_select_1_UPGRADE=IPCOMP-ON

	add_to_branch		vpn_ipsec_**			select_1_allow-ippcp=off
												select_1_ippcp=None
												select_2_allow-ippcp=on
												select_2_ippcp=LZS
												select_3_allow-ippcp=on
												select_3_ippcp=Deflate


############ select_2 - This is proposal 2
	copy_leaf		vpn_ipsec_**_select_1_hash=**			vpn_ipsec_**_select_2_hash=**
	copy_leaf		vpn_ipsec_**_select_1_lifetime=**		vpn_ipsec_**_select_2_lifetime=**
	copy_leaf		vpn_ipsec_**_select_1_allow-mb=**		vpn_ipsec_**_select_2_allow-mb=**
	copy_leaf		vpn_ipsec_**_select_1_transfer-limit=**	vpn_ipsec_**_select_2_transfer-limit=**
	copy_leaf		vpn_ipsec_**_select_1_allow-esp=**		vpn_ipsec_**_select_2_allow-esp=**
	copy_leaf		vpn_ipsec_**_select_1_cipher=**			vpn_ipsec_**_select_2_cipher=**
	copy_leaf		vpn_ipsec_**_select_1_allow-pfs=**		vpn_ipsec_**_select_2_allow-pfs=**
	copy_leaf		vpn_ipsec_**_select_1_pfs=**			vpn_ipsec_**_select_2_pfs=**
	copy_leaf		vpn_ipsec_**_select_1_allow-ah=**		vpn_ipsec_**_select_2_allow-ah=**
	copy_leaf		vpn_ipsec_**_select_1_ah=**				vpn_ipsec_**_select_2_ah=**

############ select_3 - This is proposal 3
	copy_leaf		vpn_ipsec_**_select_1_hash=**			vpn_ipsec_**_select_3_hash=**
	copy_leaf		vpn_ipsec_**_select_1_lifetime=**		vpn_ipsec_**_select_3_lifetime=**
	copy_leaf		vpn_ipsec_**_select_1_allow-mb=**		vpn_ipsec_**_select_3_allow-mb=**
	copy_leaf		vpn_ipsec_**_select_1_transfer-limit=**	vpn_ipsec_**_select_3_transfer-limit=**
	copy_leaf		vpn_ipsec_**_select_1_allow-esp=**		vpn_ipsec_**_select_3_allow-esp=**
	copy_leaf		vpn_ipsec_**_select_1_cipher=**			vpn_ipsec_**_select_3_cipher=**
	copy_leaf		vpn_ipsec_**_select_1_allow-pfs=**		vpn_ipsec_**_select_3_allow-pfs=**
	copy_leaf		vpn_ipsec_**_select_1_pfs=**			vpn_ipsec_**_select_3_pfs=**
	copy_leaf		vpn_ipsec_**_select_1_allow-ah=**		vpn_ipsec_**_select_3_allow-ah=**
	copy_leaf		vpn_ipsec_**_select_1_ah=**				vpn_ipsec_**_select_3_ah=**

end_if

# if blank, stays blank.
# If number and target is number, limited by target.
# If number and target is text, change to target
edit_leaf			vpn_ipsec_**_select_**_transfer-limit=**	max			4000000
edit_leaf			vpn_ipsec_**_select_**_transfer-limit=**	min			10
edit_leaf			vpn_ipsec_**_select_**_allow-mb=**			notnull		on

# synthesize a name for this one
copy_leaf					link_##_aalgo=**					vpn_ipsec_??-Pre20_moocow_name=**

# this will be the real name
replace_value_with_name		vpn_ipsec_**_moocow_name=**
promote_leaf				vpn_ipsec_**_moocow_name=**

##################
# Local Objects
##################

# this routine will read the ip address, ip network, or iprange from object 1, create a 
# net_ip* object, and if there is an object2, put the name of the object in object2
# If this results in an object identical to an existing object, use the existing object
address_convert			net_**_laddress=**				upgradetemp_##_laddress=**


#################################
# VPN Links/Packet Filter Rules
#################################

# ALL LINKS

# we do these in a higher level "temp" branch so we can come back and make sure we do not
# overwrite the existing NUMBERED packet filter rule

## PRIVATE LINKS

if_leaf						link_##_type=private
	copy_leaf				link_##_lname=**			rule_pffwd_temp_##_label=**

	copy_leaf				link_##_debug=None			rule_pffwd_temp_##_loglevel_number=0
	copy_leaf				link_##_debug=Critical		rule_pffwd_temp_##_loglevel_number=1
	copy_leaf				link_##_debug=Normal		rule_pffwd_temp_##_loglevel_number=2
	copy_leaf				link_##_debug=Medium		rule_pffwd_temp_##_loglevel_number=3
	copy_leaf				link_##_debug=High			rule_pffwd_temp_##_loglevel_number=4

	# if this is a client link, hook it to a net_vpnclient object
	# if it is anything else, hook it to a net_vpnnetwork object

	copy_leaf				link_##_lname=**			rule_pffwd_temp_##_src=**
	edit_leaf				rule_pffwd_temp_##_src=**	insert	net_vpnnetwork_

	# now if it is a client, just overwrite what we just did...
	if_leaf					link_##_mode=client
		copy_leaf			link_##_lname=**			rule_pffwd_temp_##_src=**
		edit_leaf			rule_pffwd_temp_##_src=**	insert	net_vpnclient_
	end_if

	address_convert			link_##_laddress=**			rule_pffwd_temp_##_dst=**

	add_to_branch			rule_pffwd_temp_##			service=fpf-serv_TrustedVPN(allservices)
														type=Absorb

 synthesize a temporary leaf that will tell us the original sequence number of this rule
	copy_leaf				link_##_raddress=**			rule_pffwd_temp_##_PREUPGRADE-SEQ=
	replace_value_with_name	rule_pffwd_temp_##_PREUPGRADE-SEQ=**

end_if
# this will take the temp_## branches and merge them into a unique numbered 
# branch within pffwd
merge_unique_num_branch		rule_pffwd_temp


## TRUSTED LINKS

if_leaf						link_##_type=Trusted
	copy_leaf				link_##_lname=**			rule_pffwd_temp_##_label=**

	copy_leaf				link_##_debug=None			rule_pffwd_temp_##_loglevel_number=0
	copy_leaf				link_##_debug=Critical		rule_pffwd_temp_##_loglevel_number=1
	copy_leaf				link_##_debug=Normal		rule_pffwd_temp_##_loglevel_number=2
	copy_leaf				link_##_debug=Medium		rule_pffwd_temp_##_loglevel_number=3
	copy_leaf				link_##_debug=High			rule_pffwd_temp_##_loglevel_number=4

	# if this is a client link, hook it to a net_vpnclient object
	# if it is anything else, hook it to a net_vpnnetwork object

	copy_leaf				link_##_lname=**			rule_pffwd_temp_##_src=**
	edit_leaf				rule_pffwd_temp_##_src=**	insert	net_vpnnetwork_

	# now if it is a client, just overwrite what we just did...
	if_leaf					link_##_mode=client
		copy_leaf			link_##_lname=**			rule_pffwd_temp_##_src=**
		edit_leaf			rule_pffwd_temp_##_src=**	insert	net_vpnclient_
	end_if

	address_convert			link_##_laddress=**			rule_pffwd_temp_##_dst=**
	add_to_branch			rule_pffwd_temp_##			service=fpf-serv_TrustedVPN(allservices)
														type=Bi-dir

# synthesize a temporary leaf that will tell us the original sequence number of this rule
	copy_leaf				link_##_raddress=**			rule_pffwd_temp_##_PREUPGRADE-SEQ=
	replace_value_with_name	rule_pffwd_temp_##_PREUPGRADE-SEQ=**

end_if
merge_unique_num_branch		rule_pffwd_temp



# ALL LINKS AGAIN

replace_name_with_value		net_vpnnetwork_**_name=**

delete_branch				upgradetemp

##################
# Remote Objects
##################

# if it is blank, delete it so it does not mess up our conditionals below
delete_leaf		link_##_mode=

# is this source object a VPN Client?
if_leaf						link_##_mode=client

#######################
# Client IKE Policies
#######################

# Command decision: Upgraded IKE policies will go under a "Pre20-Client" name
	copy_leaf				link_##_hash=**			vpn_ike_Pre20-Client_select_##_hash=**
	copy_leaf				link_##_encr=**			vpn_ike_Pre20-Client_select_##_cipher=**
	copy_leaf				link_##_ltimeImax=**	vpn_ike_Pre20-Client_select_##_lifetime=**
	copy_leaf				link_##_group=**		vpn_ike_Pre20-Client_select_##_dh=**

# synthesize some new entrees
	copy_leaf				link_##_hash=**			vpn_ike_Pre20-Client_select_##_keys=0
	copy_leaf				link_##_hash=**			vpn_ike_Pre20-Client_select_##_data=
	copy_leaf				link_##_hash=**			vpn_ike_Pre20-Client_select_##_data_hidden=

# if we actually found and converted an ike policy, then make it the default
	if_leaf					vpn_ike_Pre20-Client_select_##_hash=**
		add_leaf			vpn_ike_Pre20-Client_name=Pre20-Client
		copy_leaf			version_old_vpn=**								vpn_ike_Pre20-Client_description=**
		edit_leaf			vpn_ike_Pre20-Client_description=**				insert	' ' 
		edit_leaf			vpn_ike_Pre20-Client_description=**				insert	Client IKE Policy imported from 
		add_leaf			vpn_settings_ike=vpn_ike_Pre20-Client
	end_if

###########################
# Client Remote Objects
###########################

	copy_leaf				link_##_lname=**			net_vpnclient_##_name=**

	copy_leaf				link_##_scn=**				net_vpnclient_##_scn=**
	copy_leaf				link_##_so=**				net_vpnclient_##_son=**
	copy_leaf				link_##_sou=**				net_vpnclient_##_sou=**
	copy_leaf				link_##_sc=**				net_vpnclient_##_sc=**
	copy_leaf				link_##_sst=**				net_vpnclient_##_sst=**
	copy_leaf				link_##_sl=**				net_vpnclient_##_sl=**
	copy_leaf				link_##_ssa=**				net_vpnclient_##_ssa=**
	copy_leaf				link_##_san_type=**			net_vpnclient_##_san-type=**
	copy_leaf				link_##_san_content=**		net_vpnclient_##_san-content=**
	copy_leaf				link_##_icn=**				net_vpnclient_##_icn=**
	copy_leaf				link_##_io=**				net_vpnclient_##_ion=**
	copy_leaf				link_##_iou=**				net_vpnclient_##_iou=**
	copy_leaf				link_##_ic=**				net_vpnclient_##_ic=**
	copy_leaf				link_##_ist=**				net_vpnclient_##_ist=**
	copy_leaf				link_##_il=**				net_vpnclient_##_il=**
	copy_leaf				link_##_isa=**				net_vpnclient_##_isa=**

	copy_leaf				link_##__modecfg=**			net_vpnclient_##_vip=**
	edit_leaf		net_vpnclient_##_vip=**		insert		vpn_mcpool_
	copy_leaf				link_##_xgwenforced=**			net_vpnclient_##_enforce-xgw=**
	if_leaf			link_##_xgwenforced=On
		edit_leaf		net_vpnclient_##_enforce-xgw=**		nuke_from	On
		edit_leaf		net_vpnclient_##_enforce-xgw=**		insert	Mandatory
	end_if
	if_leaf			link_##_xgwenforced=Off
		edit_leaf		net_vpnclient_##_enforce-xgw=**		nuke_from	Off
		edit_leaf		net_vpnclient_##_enforce-xgw=**		insert	Optional
	end_if
	add_to_branch			net_vpnclient_##			df=Copy
														include-sgo=off
														use-xgw=off

	if_leaf					link_##_laddress=0.0.0.0:0.0.0.0
		edit_leaf		net_vpnclient_##_use-xgw=**		insert		on
		edit_leaf		net_vpnclient_##_use-xgw=**		nuke_after	on
	end_if
	if_leaf					link_##_hash=**
		copy_leaf			link_##_lname=**			net_vpnclient_##_ike=**
	end_if

	if_leaf					link_##_aalgo=**
		copy_leaf			link_##_lname=**			net_vpnclient_##_ipsec=**
	end_if

# get rid of this client link so it does not bite us in the butt later
	delete_branch			link_##

end_if

###################################
# ISAKMP (non-client) IKE Policies
###################################

# the ones that are left SHOULD be ISAKMP links

# Command decision: Upgraded IKE and IPSec policies will go under a "##-Pre20" name

if_leaf					link_##_hash=**
	copy_leaf				link_##_hash=**				vpn_ike_??-Pre20_select_1_hash=**
	copy_leaf				link_##_encr=**				vpn_ike_??-Pre20_select_1_cipher=**
	copy_leaf				link_##_ltimeImax=**		vpn_ike_??-Pre20_select_1_lifetime=**
	copy_leaf				link_##_group=**			vpn_ike_??-Pre20_select_1_dh=**

# synthesize some new entrees
	copy_leaf				link_##_hash=**				vpn_ike_??-Pre20_select_1_keys=0
	copy_leaf				link_##_hash=**				vpn_ike_??-Pre20_select_1_data=
	copy_leaf				link_##_hash=**				vpn_ike_??-Pre20_select_1_data_hidden=
	copy_leaf				link_##_hash=**				vpn_ike_??-Pre20_description=IKE Policy imported from upgraded Firewall
	copy_leaf				link_##_hash=**				vpn_ike_??-Pre20_moocow_name=**
#	copy_leaf				link_##_hash=**				vpn_ike_??-Pre20_moocow_number_name=**

end_if

# this will be the real name
replace_value_with_name		vpn_ike_**_moocow_name=**
promote_leaf				vpn_ike_**_moocow_name=**

renumber_branches			vpn_ike_**_select

#############################
# Non-Client Remote Objects
#############################

# note that the vpnclient is still actually a ##, but we use the ** for convenience
replace_value_with_name		net_vpnclient_**_ipsec=**
edit_leaf					net_vpnclient_**_ipsec=**	insert	vpn_ipsec_
edit_leaf					net_vpnclient_**_ipsec=**	append	-Pre20
replace_value_with_name		net_vpnclient_**_ike=**
edit_leaf					net_vpnclient_**_ike=**		insert	vpn_ike_
edit_leaf					net_vpnclient_**_ike=**		append	-Pre20

# if it was not a client, then it could be either a isakmp or swipe
if_leaf			link_##_mode=**
	copy_leaf				link_##_lname=**			net_vpnnetwork_##_name=**

# this routine will read the ip address, ip network, or iprange from object 1, create a 
# net_ip* object, and then put the name of the object in object2
	address_convert			link_##_raddress=**			net_vpnnetwork_##_network=**

	address_convert			link_##_gateway=**			net_vpnnetwork_##_ip-address=**

	copy_leaf				link_##_auth=pre			net_vpnnetwork_##_auth=Pre-shared secret
	copy_leaf				link_##_auth=rsa			net_vpnnetwork_##_auth=Certificate based
# swipe has no auth entry
	copy_leaf				link_##_mode=swIPe			net_vpnnetwork_##_auth=Certificate based
	copy_leaf				link_##_preshrd=**			net_vpnnetwork_##_secret=**

# this set depends on whatever we got out of the three auth calls
	if_leaf					net_vpnnetwork_##_auth=Certificate based
		copy_leaf			link_##_scn=**				net_vpnnetwork_##_scn=**
		copy_leaf			link_##_so=**				net_vpnnetwork_##_son=**
		copy_leaf			link_##_sou=**				net_vpnnetwork_##_sou=**
		copy_leaf			link_##_sc=**				net_vpnnetwork_##_sc=**
		copy_leaf			link_##_sst=**				net_vpnnetwork_##_sst=**
		copy_leaf			link_##_sl=**				net_vpnnetwork_##_sl=**
		copy_leaf			link_##_ssa=**				net_vpnnetwork_##_ssa=**
		copy_leaf			link_##_san_type=**			net_vpnnetwork_##_san-type=**
		copy_leaf			link_##_san_content=**		net_vpnnetwork_##_san-content=**
		copy_leaf			link_##_icn=**				net_vpnnetwork_##_icn=**
		copy_leaf			link_##_io=**				net_vpnnetwork_##_ion=**
		copy_leaf			link_##_iou=**				net_vpnnetwork_##_iou=**
		copy_leaf			link_##_ic=**				net_vpnnetwork_##_ic=**
		copy_leaf			link_##_ist=**				net_vpnnetwork_##_ist=**
		copy_leaf			link_##_il=**				net_vpnnetwork_##_il=**
		copy_leaf			link_##_isa=**				net_vpnnetwork_##_isa=**
	end_if

	if_leaf					link_##_mode=swIPe
		add_to_branch		vpn_vpnnetwork_##			scn=
														son=
														sou=
														sc=
														sst=
														sl=
														ssa=
														san-type=
														san-content=
														icn=
														ion=
														iou=
														ic=
														ist=
														il=
														isa=

	end_if

	add_to_branch			net_vpnnetwork_##			df=Copy
														include-sgo=off

# Put in the IKE policy
	copy_leaf				link_##_hash=**						net_vpnnetwork_##_moocow_ike=**
	replace_value_with_name	net_vpnnetwork_##_moocow_ike=**
	edit_leaf				net_vpnnetwork_##_moocow_ike=**		append	-Pre20
	edit_leaf				net_vpnnetwork_##_moocow_ike=**		insert	vpn_ike_
	promote_leaf			net_vpnnetwork_##_moocow_ike=**

# put in the IPSEC policy
	copy_leaf				link_##_aalgo=**					net_vpnnetwork_##_moocow_ipsec=**
	replace_value_with_name	net_vpnnetwork_##_moocow_ipsec=**
	edit_leaf				net_vpnnetwork_##_moocow_ipsec=**	append	-Pre20
	edit_leaf				net_vpnnetwork_##_moocow_ipsec=**	insert	vpn_ipsec_
	promote_leaf			net_vpnnetwork_##_moocow_ipsec=**

end_if

#replace_name_with_value		vpn_vpnnetwork_**_name=**
#rename_leaf				vpn_vpnnetwork_**_name=**	upgraded-from-link-lname
#delete_leaf					vpn_vpnnetwork_**_name=**

replace_name_with_value		net_vpnnetwork_##_name=**	##
replace_name_with_value		net_vpnclient_##_name=**	##

delete_branch				link
#delete_branch				pki

replace_name_with_value						mcpool_**_name=**
demote_leaf		mcpool_**_addr_##=**			start
copy_leaf		mcpool_**_addr2_##=**			mcpool_**_addr_##_end=**
merge_addr		mcpool_**_addr_##			vpn_mcpool_**_addr_##			iprange
address_convert		vpn_mcpool_**_addr_##_network=**	vpn_mcpool_**_addr_##_network=**

merge_addr		mcpool_**_net_##			vpn_mcpool_**_net_##			ipnet
address_convert		vpn_mcpool_**_net_##_network=**		vpn_mcpool_**_net_##_network=**

edit_leaf		mcpool_**_mask=**		insert		0.0.0.0:
address_convert		mcpool_**_mask=**			netx_**_foo=**
copy_leaf		netx_**_foo=**				vpn_mcpool_**_mask=**
edit_leaf		vpn_mcpool_**_mask=**		nuke_thru	ipmask-
edit_leaf		vpn_mcpool_**_mask=**		insert		net_ipmask_

copy_leaf		mcpool_**_dns_##=**			vpn_mcpool_**_dns_##_network=**
address_convert		vpn_mcpool_**_dns_##_network=**		vpn_mcpool_**_dns_##_network=**

copy_leaf		mcpool_**_nbns_##=**			vpn_mcpool_**_nbns_##_network=**
address_convert		vpn_mcpool_**_nbns_##_network=**	vpn_mcpool_**_nbns_##_network=**

copy_leaf		mcpool_**_stale_limit=**		vpn_mcpool_**_stale-limit=**
copy_leaf		mcpool_**_expiry=**			vpn_mcpool_**_expiry=**
copy_leaf		mcpool_**_ifname=**			vpn_mcpool_**_ifname=**
copy_leaf		mcpool_**_name=**			vpn_mcpool_**_description=**
edit_leaf		vpn_mcpool_**_description=**		insert				Pre20 virtual identity pool-

delete_branch		mcpool


# Tree preparation complete - we will now gather information from the tree for rules, net objs, etc.

[MERGE_TREE1]

# We have gotten what we need, now nuke the stuff that will collide when we merge the trees - we will put it back later

## Reenter interfaces
#delete_branch				ip
#delete_branch				net_group
delete_branch				rule_proxy
delete_branch				rule_natrule
delete_branch				pfedit
delete_branch				rule_pffwd
delete_branch				rule_pflcl
delete_branch				lpf-serv
delete_branch				fpf-serv
delete_branch				destination

# Bad juju - this causes authentication info to also get deleted. We only want to delete the service group elements
# to prevent duplicate services from showing up during postprocessing.
#delete_branch				service_group_**_elem_##
# Changed my mind - this is actually good juju - auth info is now in proxy rule
delete_branch				service_group

# do this after all of the service group stuff - these may be the only entries
# for these config-sets
# get rid of old default config set names and descriptions - the new ones are better (mostly)
delete_leaf					def_proxy_**_config-sets_**_description=
delete_leaf					def_proxy_AOL_config-sets_AOL_description=**
delete_leaf					def_proxy_authsrv_config-sets_AuthServer_description=**
delete_leaf					def_proxy_ck-gw_config-sets_Circuit_description=**
delete_leaf					def_proxy_CompuServe_config-sets_CompuServe_description=**
delete_leaf					def_proxy_csmap_config-sets_SMTP_description=**
delete_leaf					def_proxy_espmd_config-sets_ESPMD_description=**
delete_leaf					def_proxy_ftp-gw_config-sets_FTP_description=**
delete_leaf					def_proxy_gopher-gw_config-sets_Gopher_description=**
delete_leaf					def_proxy_http-gw_config-sets_HTTP_description=**
delete_leaf					def_proxy_iiop-pdk_config-sets_IIOP_description=**
delete_leaf					def_proxy_info-gw_config-sets_Info_description=**
delete_leaf					def_proxy_LDAP_config-sets_LDAP_description=**
delete_leaf					def_proxy_LotusNotes_config-sets_LotusNotes_description=**
delete_leaf					def_proxy_lp-gw_config-sets_LP_description=**
delete_leaf					def_proxy_NNTP_config-sets_NewsFeed_description=**
delete_leaf					def_proxy_NNTP_config-sets_NNTP_description=**
delete_leaf					def_proxy_mssql-gw_config-sets_SQLServer_description=**
delete_leaf					def_proxy_fingerd_config-sets_Finger-Out_description=**
delete_leaf					def_proxy_fingerd_config-sets_Finger-Block_description=**
delete_leaf					def_proxy_pop3-gw_config-sets_POP3_description=**
delete_leaf					def_proxy_RealAudio_config-sets_RealAudio_description=**
delete_leaf					def_proxy_rlogin-gw_config-sets_Rlogin_description=**
delete_leaf					def_proxy_rsh-gw_config-sets_Rsh_description=**
delete_leaf					def_proxy_snmp-gw_config-sets_SNMP_description=**
delete_leaf					def_proxy_snmpd_config-sets_SNMP-Agent_description=**
delete_leaf					def_proxy_SSL_config-sets_SSL_description=**
delete_leaf					def_proxy_strmwrks-gw_config-sets_StreamWorks_description=**
delete_leaf					def_proxy_tn-gw_config-sets_Telnet_description=**
delete_leaf					def_proxy_x-gw_config-sets_X-Server_description=**

delete_leaf					def_proxy_**_config-sets_**_name=**
#delete_leaf					def_proxy_AOL_config-sets_AOL_name=**
#delete_leaf					def_proxy_authsrv_config-sets_AuthServer_name=**
#delete_leaf					def_proxy_ck-gw_config-sets_Circuit_name=**
#delete_leaf					def_proxy_CompuServe_config-sets_CompuServe_name=**
#delete_leaf					def_proxy_csmap_config-sets_SMTP_name=**
#delete_leaf					def_proxy_espmd_config-sets_ESPMD_name=**
#delete_leaf					def_proxy_ftp-gw_config-sets_FTP_name=**
#delete_leaf					def_proxy_gopher-gw_config-sets_Gopher_name=**
#delete_leaf					def_proxy_http-gw_config-sets_HTTP_name=**
#delete_leaf					def_proxy_iiop-pdk_config-sets_IIOP_name=**
#delete_leaf					def_proxy_info-gw_config-sets_Info_name=**
#delete_leaf					def_proxy_LDAP_config-sets_LDAP_name=**
#delete_leaf					def_proxy_LotusNotes_config-sets_LotusNotes_name=**
#delete_leaf					def_proxy_lp-gw_config-sets_LP_name=**
#delete_leaf					def_proxy_NNTP_config-sets_NewsFeed_name=**
#delete_leaf					def_proxy_NNTP_config-sets_NNTP_name=**
#delete_leaf					def_proxy_mssql-gw_config-sets_SQLServer_name=**
#delete_leaf					def_proxy_fingerd_config-sets_Finger-Out_name=**
#delete_leaf					def_proxy_fingerd_config-sets_Finger-Block_name=**
#delete_leaf					def_proxy_pop3-gw_config-sets_POP3_name=**
#delete_leaf					def_proxy_RealAudio_config-sets_RealAudio_name=**
#delete_leaf					def_proxy_rlogin-gw_config-sets_Rlogin_name=**
#delete_leaf					def_proxy_rsh-gw_config-sets_Rsh_name=**
#delete_leaf					def_proxy_snmp-gw_config-sets_SNMP_name=**
#delete_leaf					def_proxy_snmpd_config-sets_SNMP-Agent_name=**
#delete_leaf					def_proxy_SSL_config-sets_SSL_name=**
#delete_leaf					def_proxy_strmwrks-gw_config-sets_StreamWorks_name=**
#delete_leaf					def_proxy_tn-gw_config-sets_Telnet_name=**
#delete_leaf					def_proxy_x-gw_config-sets_X-Server_name=**

delete_branch				def_proxy_Local-FTP_config-sets_Local-FTP
delete_branch				def_proxy_Local-Rlogin_config-sets_Local-Rlogin
delete_branch				def_proxy_Local-Telnet_config-sets_Local-Telnet

[MERGE_TREE2]

if_leaf						version_old_**=**
	user_error				This firewall has already been upgraded!  Cannot continue!
end_if

# the following verbs apply to the second tree, and are applied before the actual merge
delete_branch				net_group_Authsrv_elem
delete_branch				net_group_Netacl_elem
delete_branch				net_group_Trusted_elem
delete_branch				net_group_Untrusted_elem
delete_branch				net_group_Mail_elem
delete_branch				rule_proxy
delete_branch				rule_pffwd
delete_branch				rule_pflcl
delete_branch				lpf-serv
delete_branch				fpf-serv
delete_branch				destination
delete_branch				kernel_alerts_log
delete_leaf					def_proxy_http-gw_pdkbackend-port=**
delete_branch				netobj_list_Outside
delete_leaf					def_proxy_socks5-gw_config-sets_**_protocol-support=**
delete_branch				service_group

#delete_branch				keys_proxy
# should really be removed from initial_env...
delete_branch				radius_client

# Note that the merge from the old gauntlet.conf to the new gauntlet.conf 
# should be a destructive merge - that is, anything in the old g.c should overwrite any existing
# items from new g.c

[POSTPROCESS]

# the following verbs are applied to the final, fully merged tree
# this is your last chance to muck with it.

#delete_branch	**

# these items were just created for debugging purposes to ensure that links/rules stayed in the
# correct sequence
delete_leaf					rule_pffwd_**_PREUPGRADE-SEQ=**
delete_leaf					rule_pffwd_**_oldRuleNumber=**
delete_leaf					rule_pflcl_**_oldRuleNumber=**

# these are probably harmless, but let's leave 'em out
delete_leaf					rule_pffwd_**_label=
delete_leaf					rule_pflcl_**_label=

# the saved rules, etc. will be restored after this final word from our sponsor...
# Time to move authorization-filter and timeout from def_proxy_authsrv_config-sets_AuthServer_ to auth_obj_
# Ok, we can't copy one to many. We know the name of each, so copy one to one for auth_obj_change_ and auth_obj_normal_
if_leaf			auth_obj_normal_name=**
	copy_leaf		def_proxy_authsrv_config-sets_AuthServer_authorization-filter=**	auth_obj_normal_authorization_filter=**
	copy_leaf		def_proxy_authsrv_config-sets_AuthServer_timeout=**			auth_obj_normal_timeout=**
end_if
if_leaf			auth_obj_change_name=**
	copy_leaf		def_proxy_authsrv_config-sets_AuthServer_authorization-filter=**	auth_obj_change_authorization_filter=**
	copy_leaf		def_proxy_authsrv_config-sets_AuthServer_timeout=**			auth_obj_change_timeout=**
end_if
delete_leaf		def_proxy_authsrv_config-sets_AuthServer_authorization-filter=**
delete_leaf		def_proxy_authsrv_config-sets_AuthServer_timeout=**
