#! /sbin/sh
# PGP E-ppliance 2.0 Upgrade
#
# BackupEPL1.XConfig.sh backup_path
#
# PGP Security, A Network Associates Business
# Copyright (c) 1993 - 2001, Network Associates Technology, Inc.

BACKUPPATH=""

#######################################################################
# functions
#######################################################################
BackupConfig ()
{
	 CONFIGFILE=$1
	 if [ -f "${CONFIGFILE}" ] || [ -d "${CONFIGFILE}" ]; then
		  Log "# Backup ${CONFIGFILE}"
		  CONFIGFILEPATH=`dirname ${CONFIGFILE}`
		  DEST=${BACKUPPATH}${CONFIGFILEPATH}
		  if [ ! -d "${DEST}" ]; then
				mkdir -p ${DEST} > /dev/null 2>&1
				if [ $? -ne 0 ]; then
					 Log "UPGRADE::ERR Failed to make directory ${DEST}"
					 exit 3
				fi  
		  fi
		  cp -r ${CONFIGFILE} ${DEST} > /dev/null 2>&1
		  if [ $? -ne 0 ]; then
				Log "UPGRADE::ERR Failed to backup ${CONFIGFILE}"
				exit 3
		  fi  
	 fi
}

#######################################################################
# change dir to the root of upgrade source
#######################################################################
UPGRADEROOT=`dirname $0`
BASENAME=`basename $0`
cd ${UPGRADEROOT} > /dev/null 2>&1
if [ $? -ne 0 ]; then
	 echo "UPGRADE::ERR Failed to change directory ${UPGRADEROOT}"
	 exit 3
fi

. ./Utils.sh

#######################################################################
# verify the user's input
#######################################################################
if [ $# -eq 1 ]; then
	 BACKUPPATH=$1
else
	 Log "UPGRADE::ERR Wrong argument in BackupEPL1.XConfig.sh"
	 exit 1
fi

if [ ! -d ${BACKUPPATH} ]; then
	 mkdir -p ${BACKUPPATH}
	 if [ $? -ne 0 ]; then
		  Log "UPGRADE::ERR Failed to make directory ${BACKUPPATH}"
		  exit 3
	 fi
fi

#######################################################################
# backup system configuration for restore
#######################################################################
BackupConfig "/etc/vfstab"
BackupConfig "/etc/passwd"
BackupConfig "/etc/shadow"

#######################################################################
# backup FW configuration for upgrade/restore
#######################################################################
# perform backup for restore/upgrade purpose
BackupConfig "/usr/local/etc/mgmt/gauntlet.conf"
BackupConfig "/usr/local/etc/mgmt/keys.conf"
BackupConfig "/usr/local/etc/mgmt/cyber"
BackupConfig "/usr/local/etc/dat"
BackupConfig "/usr/local/etc/frequentcheck.ignore"
BackupConfig "/usr/local/etc/securityalerts.ignore"
BackupConfig "/usr/local/etc/finger.txt"

# use vpn_packcerts.sh to backup certs and authentication databases
# meanwhile, create gvpn_cert_status.conf for upgrade
# the output directory of gvpn_packcerts.sh is 
# /usr/local/etc/mgmt/upgrade
UPGRADEDIR="/usr/local/etc/mgmt/upgrade"
if [ ! -d "${UPGRADEDIR}" ]; then
	 mkdir -p ${UPGRADEDIR} > /dev/null 2>&1
	 if [ $? -ne 0 ]; then
		  Log "UPGRADE::ERR Failed to make directory ${UPGRADEDIR}"
		  exit 3
	 fi
fi

./vpn_packcerts.sh > /dev/null 2>&1
if [ $? -ne 0 ]; then
	 Log "UPGRADE::ERR Failed to back up firewall certificates"
	 exit 1
fi

BackupConfig "${UPGRADEDIR}"

EXTRAFILES="${UPGRADEDIR}/extrafiles.txt"
if [ ! -f "${EXTRAFILES}" ]; then
	 Log "UPGRADE::ERR Failed to find ${EXTRAFILES}"
	 exit 3
fi
SAVEDAUTHDBS=`cat "${UPGRADEDIR}/extrafiles.txt"`
for AUTHDB in $SAVEDAUTHDBS; do 
	 BackupConfig "$AUTHDB"
done

# perform a regular backup for the user future reference
/usr/local/etc/mgmt/save-config-files ${BACKUPPATH}/fwconfig.tar \
	 > /dev/null 2>/dev/null

#######################################################################
# finish
#######################################################################
exit 0

