#! /sbin/sh
# PGP e-ppliance 2.0 Upgrade
#  
# EMailReport.sh
#
# PGP Security, A Network Associates Business
# Copyright (c) 1993 - 2001, Network Associates Technology, Inc.

UPGRADEPREFFILE="./.preference"

if [ -f /etc/rc3.d/S90report ]; then
	 rm -f /etc/rc3.d/S90report > /dev/null 2>&1
fi

#######################################################################
# change dir to the root of upgrade source
#######################################################################
UPGRADEROOT=`dirname $0`
BASENAME=`basename $0`
cd ${UPGRADEROOT} > /dev/null 2>&1
if [ $? -ne 0 ]; then
	 echo "UPGRADE::ERR Failed to change directory ${UPGRADEROOT}"
	 exit 3
fi

. ./Utils.sh

################################################################################
# load up upgrade preference and state
################################################################################
if [ -f ${UPGRADEPREFFILE} ]; then
	 . ${UPGRADEPREFFILE}
else
	 Log "UPGRADE::ERR Failed to find ${UPGRADEPREFFILE}"
	 exit 3
fi

################################################################################
# get the recipient address
################################################################################
if [ -z "${EMAILADDR}" ]; then
	 Log "UPGRADE::ERR Failed to retrieve recipient address"
	 exit 2
fi

if [ "${UPGRADESTATE}" = "PGP_UPGRADE_VALIDATION" ]; then
	# report restore succeeded
/usr/lib/sendmail -f "PGPEPL_UPGRADE" -F "e-ppliance upgrade" ${EMAILADDR}<<EOF
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
PGP e-ppliance 2.0 Upgrade Status Message from `hostname`
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
UPGRADE::MSG The PGP e-ppliance has been restored successfully.
UPGRADE::MSG The following attachment  is  the  upgrade log  that  records  all critial
UPGRADE::MSG information during the upgrade. 
UPGRADE::MSG
UPGRADE::MSG PGP e-ppliance upgrade team
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
`cat ${UPGRADELOGFILE}`
EOF
else
	 # report error
/usr/lib/sendmail -f "PGPEPL_UPGRADE" -F "e-ppliance upgrade" ${EMAILADDR}<<EOF
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
PGP e-ppliance 2.0 Upgrade Status Message from `hostname`
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
UPGRADE::WRN The state of upgrade : ${UPGRADESTATE}
UPGRADE::WRN The PGP e-ppliance upgrade has encountered some difficulties to accomplish
UPGRADE::WRN the  upgrade  process.  The following  attachment  is the upgrade log that 
UPGRADE::WRN records all critial information during the upgrade. 
UPGRADE::WRN Your e-ppliance has been restored with your original configurations.
UPGRADE::WRN
UPGRADE::WRN PGP e-ppliance upgrade team
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
`cat ${UPGRADELOGFILE}`
EOF
fi

################################################################################
# finish                                                         
################################################################################
exit 0
