#! /sbin/sh
# PGP E-ppliance 2.0 Upgrade
#
# Finish.sh 
#
# PGP Security, A Network Associates Business
# Copyright (c) 1993 - 2001, Network Associates Technology, Inc.

UPGRADEPREFFILE="./.preference"
CONFBACKUPDIR="./Backup/Config"

# clean up the /etc/rc3.d/S19upgrade
if [ -f /etc/rc3.d/S19upgrade ]; then
	 rm -f /etc/rc3.d/S19upgrade > /dev/null 2>&1
fi

################################################################################
# functions
################################################################################
Exit ()
{
/usr/lib/sendmail -f "PGPEPL_UPGRADE" -F "e-ppliance upgrade" ${EMAILADDR}<<EOF
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
PGP e-ppliance 2.0 Upgrade Status Message from `hostname`
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
`cat ${UPGRADELOGFILE}`
EOF
	 exit $1
}

#######################################################################
# change dir to the root of upgrade source
#######################################################################
UPGRADEROOT=`dirname $0`
BASENAME=`basename $0`
cd ${UPGRADEROOT} > /dev/null 2>&1
if [ $? -ne 0 ]; then
	 echo "UPGRADE::ERR Failed to change directory ${UPGRADEROOT}"
	 exit 3
fi

. ./Utils.sh

Log ""
Log "##########################################################################"
Log "# Finish "
Log "##########################################################################"
Log ""

#######################################################################
# load up upgrade preference and state
#######################################################################
Log "# Load Upgrade Preference"
if [ -f ${UPGRADEPREFFILE} ]; then
	 . ${UPGRADEPREFFILE}
else
	 Log "UPGRADE::ERR Failed to find ${UPGRADEPREFFILE}"
	 exit 3
fi

#######################################################################
# verify the user's input
#######################################################################
# the user must give the MSGFILE filename
if [ $# -ne 1 ]; then
	 Log "UPGRADE::ERR Message filename not specified"
	 Exit 1
fi
MSGFILE=$1

#######################################################################
# restore original authentication databases / certificates
#######################################################################
Log "# Restore the original firewall authentication databases"
Log "# Restore firewall certificates"

if [ -f /usr/local/etc/mgmt/upgrade/gvpn_certs.tar ]; then
	 mv -f /usr/local/etc/mgmt/upgrade/gvpn_certs.tar \
		  /usr/local/etc/mgmt/upgrade/gvpn_certs.tar.PRE60UPGRADE \
		  > /dev/null 2>&1
else
	 Log "UPGRADE::ERR Failed to find original certificates files"
	 Exit 3
fi

if [ ! -f /usr/local/etc/mgmt/upgrade/vpn_unpackcerts.sh ]; then
	 Log "UPGRADE::ERR Failed to find vpn_unpackcerts.sh"
	 Exit 3
fi
if [ ! -f /usr/local/etc/mgmt/upgrade/authlist.txt ]; then
	 Log "UPGRADE::ERR Failed to find authlist.txt"
	 Exit 3
fi

sh /usr/local/etc/mgmt/upgrade/vpn_unpackcerts.sh > /dev/null 2>&1
if [ $? -ne 0 ]; then
	 Log "UPGRADE::ERR Failed to restore firewall certificates"
	 Exit 1
fi

#######################################################################
# update firewall configuration
#######################################################################
Log "# Update firewall configuration"
# since gversion is invoked in /usr/local/etc/mgmt/update without
# absolute path, we need specify the PATH env variable here
if [ -z "${PATH}" ]; then
	 PATH="/usr/local/etc"
else
	 PATH="${PATH}:/usr/local/etc"
fi
export PATH
/usr/local/etc/mgmt/update

#######################################################################
# start the network
#######################################################################
Log "# Start network"
/etc/netstart

#######################################################################
# change the state to FIN
#######################################################################
if [ ${UPGRADESTATE} = "PGP_UPGRADE_FINALBOOT" ]; then
	 UPGRADESTATE="PGP_UPGRADE_FIN"
	 Export "UPGRADESTATE" ${UPGRADESTATE}
else
	 Log "UPGRADE::ERR Wrong state found in ${UPGRADEPREFFILE}"
	 Exit 1
fi

Log "\n\nCongratulations! the upgrade was successful.      "  >  ${MSGFILE}
Log "Please perform a complete system configuration  check."  >> ${MSGFILE}
Log "Once you are satisfied with the current configuration,"  >> ${MSGFILE}
Log "issue the command:                                    "  >> ${MSGFILE}
Log "${UPGRADEROOT}/clean                                  "  >> ${MSGFILE}
Log "to remove the internal backup  files  created  by  the"  >> ${MSGFILE}
Log "upgrade. The clean  also  restores  queued  e-mail  in"  >> ${MSGFILE}
Log "${MQUEUEDIR}                                          "  >> ${MSGFILE}
Log "NOTE: Once the internal backup files have been removed," >> ${MSGFILE}
Log "you will not be able to restore your e-ppliance to its"  >> ${MSGFILE}
Log "previous, pre-upgrade state using this upgrade utility." >> ${MSGFILE}
Log ""                                                        >> ${MSGFILE}
Log "PGP e-ppliance upgrade team"                             >> ${MSGFILE}
Log ""                                                        >> ${MSGFILE}

/usr/lib/sendmail -f "PGPEPL_UPGRADE" -F "e-ppliance upgrade" ${EMAILADDR}<<EOF
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
PGP e-ppliance 2.0 Upgrade Status Message from `hostname`
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
`cat ${MSGFILE}`
EOF

#######################################################################
# install Luna driver if necessary
#######################################################################
Log "Install Luna Driver"
if [ -x /usr/local/etc/mgmt/fwluna ]; then
	 /usr/local/etc/mgmt/fwluna install > /dev/null 2>&1
	 reboot -- "-r"
fi

#######################################################################
# finish
#######################################################################
exit 0
