#!/bin/sh
# PGP E-ppliance 2.0 Upgrade 
#
# InitBootShuOS5.8.sh 
#
# PGP Security, A Network Associates Business
# Copyright (c) 1993 - 2001, Network Associates Technology, Inc.

INITBOOTROOT="/var/virtmp"

################################################################################
# change dir to the root of upgrade source
################################################################################
UPGRADEROOT=`dirname $0`
BASENAME=`basename $0`
cd ${UPGRADEROOT} > /dev/null 2>&1
if [ $? -ne 0 ]; then
	 echo "UPGRADE::ERR Failed to change directory ${UPGRADEROOT}"
	 exit 3
fi

ABSROOT=`pwd`

. ./Utils.sh

#######################################################################
# keep the /var/virtmp as a safe upgrade source repository
#######################################################################
Log "# Disable /var/virtmp Clean Routine"
if [ -f /usr/local/etc/mgmt/cleanse_vtmp.sh ]; then
	mv /usr/local/etc/mgmt/cleanse_vtmp.sh \
	 /usr/local/etc/mgmt/disabled.cleanse_vtmp.sh
fi

#######################################################################
# test if ./gzip is executable
#######################################################################
if [ ! -x ./gzip ]; then
	 Log "UPGRADE::ERR ./gzip not found or not executable"
	 exit 3
fi

#######################################################################
# extract SunOS5.8 + EPL2.0
#######################################################################
# enable interrupt handling 
trap 'kill $! > /dev/null 2>&1; Log "\n# User Interrupt! Upgrade aborted"; exit 2' 2 15
sh ./Indicator.sh &
Log "# Extract root Partition to /var/virtmp"
## ./gzip -cd ../pgp${PRODUCT_MODEL}.root.gz | (cd ${INITBOOTROOT};     ufsrestore rf -) > /dev/null 2>&1
./gzip -cd ../pgp${PRODUCT_MODEL}.root.gz | ( cd ${INITBOOTROOT}; tar -xfX - ${ABSROOT}/initroot.exc ) > /dev/null 2>&1

Log "# Extract var Partition to /var/virtmp"
## ./gzip -cd ../pgp${PRODUCT_MODEL}.var.gz  | (cd ${INITBOOTROOT}/var; ufsrestore rf -) > /dev/null 2>&1
## mkdir -p ${INITBOOTROOT}/var > /dev/null 2>&1
## ./gzip -cd ../pgp${PRODUCT_MODEL}.var.gz  | ( cd ${INITBOOTROOT}/var; tar -xf - ) > /dev/null 2>&1

Log "# Extract usr Partition to /var/virtmp"
## ./gzip -cd ../pgp${PRODUCT_MODEL}.usr.gz  | (cd ${INITBOOTROOT}/usr; ufsrestore rf -) > /dev/null 2>&1
mkdir -p ${INITBOOTROOT}/usr > /dev/null 2>&1
./gzip -cd ../pgp${PRODUCT_MODEL}.usr.gz | ( cd ${INITBOOTROOT}/usr; tar -xfX - ${ABSROOT}/initusr.exc ) > /dev/null 2>&1

kill $! > /dev/null 2>&1

# enable interrupts
trap 2 15

#######################################################################
# ufs filesystems
#######################################################################
Log "# Make ufs Mount Points in /var/virtmp"
# make preserved directories for 
# /, /usr, /var and /var/quarantine partitions
mkdir -p ${INITBOOTROOT}/root.preserved
mkdir -p ${INITBOOTROOT}/usr.preserved
mkdir -p ${INITBOOTROOT}/var.preserved
mkdir -p ${INITBOOTROOT}/var/quarantine.preserved  

# make some system mount points
mkdir -p ${INITBOOTROOT}/var/run
mkdir -p ${INITBOOTROOT}/var/adm
mkdir -p ${INITBOOTROOT}/var/tmp
mkdir -p ${INITBOOTROOT}/var/spool/mqueue
mkdir -p ${INITBOOTROOT}/dev/fd
mkdir -p ${INITBOOTROOT}/proc
mkdir -p ${INITBOOTROOT}/tmp

# update the /var/virtmp/etc/vfstab
if [ -f ${INITBOOTROOT}/etc/vfstab ]; then
	mv ${INITBOOTROOT}/etc/vfstab ${INITBOOTROOT}/etc/vfstab.PRE2.0
fi
if [ ! -f ./etc/vfstab ]; then
	 Log "UPGRADE::ERR Failed to find ./etc/vfstab"
	 exit 3
fi
cp ./etc/vfstab ${INITBOOTROOT}/etc/vfstab

#######################################################################
# restore original system user profiles
#######################################################################
# update the /etc/passwd with the original setting
if [ -f ${INITBOOTROOT}/etc/passwd ]; then
	 mv ${INITBOOTROOT}/etc/passwd \
	 ${INITBOOTROOT}/etc/passwd.PRE2.0
fi
cp ${CONFBACKUPDIR}/etc/passwd ${INITBOOTROOT}/etc > /dev/null 2>&1
if [ $? -ne 0 ]; then
	 Log "UPGRADE::ERR Failed to restore /etc/passwd"
	 Exit 3
fi

# update the /etc/shadow with the original setting
if [ -f ${INITBOOTROOT}/etc/shadow ]; then
	 mv ${INITBOOTROOT}/etc/shadow \
	 ${INITBOOTROOT}/etc/shadow.PRE2.0
fi
cp ${CONFBACKUPDIR}/etc/shadow ${INITBOOTROOT}/etc > /dev/null 2>&1
if [ $? -ne 0 ]; then
	 Log "UPGRADE::ERR Failed to restore /etc/shadow"
	 Exit 3
fi

#######################################################################
# confirm with the user
#######################################################################
Log ""
Log "The upgrade will reboot your system to SunOS-5.8 temporarily."
Log "Your current connection will be shut down during this period."
Log "The  upgrade  will  then  install  PGP ${PRODUCT_MODEL} e-ppliance on your"
Log "system. You will be notified via  e-mail when the upgrade  is"
Log "finished. The entire upgrade should take about 30 minutes."
Log ""
if [ -z "${SKIPINITQUEST}" ] || [ "${SKIPINITQUEST}" = "FALSE" ]; then
	 echo "Would you like to continue? [y/n] : \c"
	 read foo
	 if [ "${foo}" != "y" -a "${foo}" != "Y" ]; then
		  exit 0
	 fi
fi

#######################################################################
# prepare the final boot
#######################################################################
FINALPATH=`pwd`
TMP_INITBOOTROOT="\\${INITBOOTROOT}"
FINALPATH=`echo ${FINALPATH} | sed s%$TMP_INITBOOTROOT%%1`

if [ -f ${INITBOOTROOT}/etc/rcS.d/S99upgrade ]; then
	 rm -f ${INITBOOTROOT}/etc/rcS.d/S99upgrade
fi
echo "sh ${FINALPATH}/FinalBootSunOS5.8.sh" \
	 > ${INITBOOTROOT}/etc/rcS.d/S99upgrade
echo "rm -f /etc/rcS.d/S99upgrade" \
	 >> ${INITBOOTROOT}/etc/rcS.d/S99upgrade

# we need add email report routine in /etc/rc3.d if the INITBOOT fails
# if INITBOOT fails to boot the system to SunOS5.8 on /var/virtmp partition
# the system will boot from disk:a by default
FINALPATH=`pwd`
echo "sh ${FINALPATH}/EMailReport.sh" \
	 > /etc/rc3.d/S90report
echo "rm -f /etc/rc3.d/S90report" \
	 >> /etc/rc3.d/S90report

#######################################################################
# install the SunOS5.8 boot block into the /var/virtmp partition
#######################################################################
Log "# Install SunOS5.8 Boot Block"
mount -a > /dev/null 2>&1
installboot ${INITBOOTROOT}/usr/platform/`uname -i`/lib/fs/ufs/bootblk \
 /dev/rdsk/c0t0d0s5

#######################################################################
# init boot from /var/virtmp partition in single user mode
#######################################################################
Log "# Initial Reboot from disk:f in Single User Mode"
sync; reboot -- "disk:f -s"

