#! /sbin/sh
# PGP E-ppliance 2.0 Upgrade 
#
# Restore.sh
#
# PGP Security, A Network Associates Business
# Copyright (c) 1993 - 2001, Network Associates Technology, Inc.

BACKUPPATH="./Backup"
UPGRADEPREFFILE="./.preference"
RESTORESYMFILE="restoresymtable"

if [ -f /etc/rcS.d/S98restore ]; then
	 rm -f /etc/rcS.d/S98restore > /dev/null 2>&1
fi

################################################################################
# functions
################################################################################

################################################################################
# change dir to the root of upgrade source
################################################################################
UPGRADEROOT=`dirname $0`
BASENAME=`basename $0`
cd ${UPGRADEROOT} > /dev/null 2>&1
if [ $? -ne 0 ]; then
	 echo "UPGRADE::ERR Failed to change directory ${UPGRADEROOT}"
	 exit 3
fi

. ./Utils.sh

Log "##########################################################################"
Log "# Restore"
Log "##########################################################################"

################################################################################
# load up upgrade preference and state
################################################################################
Log "# Load Upgrade Preference"
if [ -f ${UPGRADEPREFFILE} ]; then
	 . ${UPGRADEPREFFILE}
else
	 Log "UPGRADE::ERR Failed to find ${UPGRADEPREFFILE}"
	 exit 3
fi

if [ ${UPGRADESTATE} = "PGP_UPGRADE_VALIDATION" ] || \
	 [ ${UPGRADESTATE} = "PGP_UPGRADE_BACKUP" ] || \
	 [ ${UPGRADESTATE} = "PGP_UPGRADE_INITBOOT" ]; then
	 Log "UPGRADE::WRN the upgrade has not changed the system yet"
	 Log "UPGRADE::WRN there is nothing to restore"
	 exit 0
fi

# for state PGP_UPGRADE_FINAL and PGP_UPGRADE_FIN
################################################################################
# check the backup source
################################################################################
Log "# Check Backup Source"
if [ ! -d ${BACKUPPATH} ]; then
	 Log "UPGRADE::ERR Failed to find PGP ${PRODUCTMODEL} e-ppliance backup \
		  directory ${BACKUPPATH}"
	 exit 3
fi

ROOTBACKUP=${BACKUPPATH}/pgp${PRODUCT_MODEL}.root.PRE_EPL2.0.gz
VARBACKUP=${BACKUPPATH}/pgp${PRODUCT_MODEL}.var.PRE_EPL2.0.gz
USRBACKUP=${BACKUPPATH}/pgp${PRODUCT_MODEL}.usr.PRE_EPL2.0.gz
MAILBACKUP=${BACKUPPATH}/pgp${PRODUCT_MODEL}.mail.PRE_EPL2.0.gz

# find backups of root, var and usr partitions
if [ ! -f ${ROOTBACKUP} ] || [ ! -f ${VARBACKUP} ] || [ ! -f ${USRBACKUP} ]; then
	 Log "UPGRADE::ERR Failed to find PGP ${PRODUCT_MODEL} e-ppliance backup \
		  in ${BACKUPPATH}"
	 exit 3
fi

################################################################################
# test if ./gzip is executable
################################################################################
if [ ! -x ./gzip ]; then
	 Log "UPGRADE::ERR ./gzip not found or not executable"
	 exit 3
fi

################################################################################
# restore from backup
################################################################################
# consider the current STATE is PGP_UPGRADE_FINALBOOT
Log "# Check Current Boot Partition"
ROOTDEV=c0t0d0s0
USRDEV=c0t0d0s3
VARDEV=c0t0d0s6
VIRDEV=c0t0d0s5

mount -a > /dev/null 2>&1
TMP_ROOTMNT=`df -k | grep ${VIRDEV}`
if [ -z "${TMP_ROOTMNT}" ]; then
	 Log "UPGRADE::FATALERR Failed to find the ${VIRDEV} partition"
	 exit 1
fi

# if /dev/dsk/c0t0d0s5 is mounted on "/var/virtmp", must reboot
# the system to disk:f which is the /var/virtmp partition
TMP_ROOTMNT=`echo ${TMP_ROOTMNT} | awk '{ print $6 }'`
if [ ${TMP_ROOTMNT} = "/var/virtmp" ]; then
	 # boot from /var/virtmp
	 # make a RC file in /etc/rcS.d/S98restore
	 INITBOOTROOT="/var/virtmp"
	 FINALPATH=`pwd`
	 TMP_INITBOOTROOT="\\${INITBOOTROOT}"
	 FINALPATH=`echo ${FINALPATH} | sed s%$TMP_INITBOOTROOT%%1`

	 Log "# Reboot from disk:f in Single User Mode"
	 echo "sh ${FINALPATH}/Restore.sh" \
		  > ${INITBOOTROOT}/etc/rcS.d/S98restore
	 echo "rm -f /etc/rcS.d/S98restore" \
		  >> ${INITBOOTROOT}/etc/rcS.d/S98restore
	 sync; reboot -- "disk:f -s"
else
	 RESTOREBOOTROOT="/root.preserved"
	 RESTOREBOOTVAR="/var.preserved"
	 RESTOREBOOTUSR="/usr.preserved"
fi

################################################################################
# construct new filesystems /, /var and /usr
################################################################################
# disable interrupt
trap "" 2 15

# the root partition
Log "# Construct root Partition"
umount -f ${RESTOREBOOTROOT} > /dev/null 2>&1
newfs /dev/rdsk/${ROOTDEV} 2>/dev/null <<EOF
y
EOF
if [ $? -ne 0 ]; then
	 Log "UPGRADE::ERR Failed to construct root partition."
	 exit 1
fi
fsck -y -of /dev/rdsk/${ROOTDEV} > /dev/null 2>&1
mount /dev/dsk/${ROOTDEV} ${RESTOREBOOTROOT}

# the /usr partition
Log "# Construct usr Partition"
umount -f ${RESTOREBOOTUSR} > /dev/null 2>&1
newfs /dev/rdsk/${USRDEV} 2>/dev/null <<EOF
y
EOF
if [ $? -ne 0 ]; then
	 Log "UPGRADE::ERR Failed to construct usr partition."
	 Exit 1
fi
fsck -y -of /dev/rdsk/${USRDEV} > /dev/null 2>&1
mount /dev/dsk/${USRDEV} ${RESTOREBOOTUSR}

# the /var partition
Log "# Construct var Partition"
umount -f ${RESTOREBOOTVAR} > /dev/null 2>&1
newfs /dev/rdsk/${VARDEV} 2>/dev/null <<EOF
y
EOF
if [ $? -ne 0 ]; then
	 Log "UPGRADE::ERR Failed to construct var partition."
	 Exit 1
fi
fsck -y -of /dev/rdsk/${VARDEV} > /dev/null 2>&1
mount /dev/dsk/${VARDEV} ${RESTOREBOOTVAR}

################################################################################
# extract SunOS5.6 + EPL1.X
################################################################################
# enable interrupt handling
trap 'kill $! > /dev/null 2>&1; Log "\n# User Interrupt! Upgrade aborted"; exit 2' 2 15
sh ./Indicator.sh &
Log "# Restore root Partition"
## ./gzip -cd ${ROOTBACKUP} | (cd ${RESTOREBOOTROOT}; ufsrestore rf -) > /dev/null 2>&1
./gzip -cd ${ROOTBACKUP} | ( cd ${RESTOREBOOTROOT}; tar -xf - ) > /dev/null 2>&1
if [ -f ${RESTOREBOOTROOT}/${RESTORESYMFILE} ]; then
	 rm -f ${RESTOREBOOTROOT}/${RESTORESYMFILE}
fi

Log "# Restore var Partition"
## ./gzip -cd ${VARBACKUP}  | (cd ${RESTOREBOOTVAR};  ufsrestore rf -) > /dev/null 2>&1
./gzip -cd ${VARBACKUP}  | ( cd ${RESTOREBOOTVAR};  tar -xf - ) > /dev/null 2>&1
if [ -f ${RESTOREBOOTVAR}/${RESTORESYMFILE} ]; then
	 rm -f ${RESTOREBOOTVAR}/${RESTORESYMFILE}
fi

Log "# Restore usr Partition"
## ./gzip -cd ${USRBACKUP}  | (cd ${RESTOREBOOTUSR};  ufsrestore rf -) > /dev/null 2>&1
./gzip -cd ${USRBACKUP}  | ( cd ${RESTOREBOOTUSR};  tar -xf - ) > /dev/null 2>&1
if [ -f ${RESTOREBOOTUSR}/${RESTORESYMFILE} ]; then
	 rm -f ${RESTOREBOOTUSR}/${RESTORESYMFILE}
fi

if [ -f ${MAILBACKUP} ]; then
	 Log "# Restore Queued E-Mails"
	 ## ./gzip -cd ${MAILBACKUP} | (cd ${RESTOREBOOTVAR}; ufsrestore rf -) > /dev/null 2>&1
	 ./gzip -cd ${MAILBACKUP} | ( cd ${RESTOREBOOTVAR}; tar -xf - ) > /dev/null 2>&1
	 if [ -f ${RESTOREBOOTVAR}/${RESTORESYMFILE} ]; then
		  rm -f ${RESTOREBOOTVAR}/${RESTORESYMFILE}
	 fi
fi

kill $! > /dev/null 2>&1

#######################################################################
# ufs filesystems
#######################################################################
Log "# Make ufs Mount Points"
# make /var, /usr, /var/virtmp, and /var/quarantine mount points
mkdir -p ${RESTOREBOOTROOT}/var
mkdir -p ${RESTOREBOOTROOT}/usr
mkdir -p ${RESTOREBOOTROOT}/tmp
mkdir -p ${RESTOREBOOTVAR}/virtmp
mkdir -p ${RESTOREBOOTVAR}/quarantine

# make some system mount points
mkdir -p ${RESTOREBOOTVAR}/run
mkdir -p ${RESTOREBOOTROOT}/dev/fd
mkdir -p ${RESTOREBOOTROOT}/proc

#######################################################################
# restore /var/spool/mqueue ownership to uucp
#######################################################################
# this is required only for PGP1000 since /var/spool/mqueue is a
# partition rather than a directory of /var partition on PGP300.
SENDMAILQUEUE="/var/spool/mqueue"
if [ "${PRODUCT_MODEL}" = "1000" ]; then
	 if [ -d "${SENDMAILQUEUE}" ]; then
		  chown uucp ${SENDMAILQUEUE} > /dev/null 2>&1
		  if [ $? -ne 0 ]; then
				Log "UPGRADE::ERR Failed to restore ownership of ${SENDMAILQUEUE}"
				exit 3
		  fi
	 fi
fi

################################################################################
# install the SunOS5.6 boot block into the root partition
################################################################################
# critical phase, disable interrupts
trap "" 2 15

mount -a > /dev/null 2>&1

# NOTE: At this point, the root must be on /var/virtmp partition
# we need add email report routine in /etc/rc3.d based on the 
# current state
# if state is PGP_UPGRADE_FINAL, report upgrade failed
# if state is PGP_UPGRADE_FIN,   report restore accomplished

Log "# Install SunOS5.6 Boot Block"
installboot ${RESTOREBOOTUSR}/platform/`uname -i`/lib/fs/ufs/bootblk \
	 /dev/rdsk/c0t0d0s0

ROOTPATH="/var/virtmp"
ROOTPATH=${ROOTPATH}`pwd`
echo "sh ${ROOTPATH}/EMailReport.sh" \
	 > ${RESTOREBOOTROOT}/etc/rc3.d/S90report
echo "rm -f /etc/rc3.d/S90report" \
	 >> ${RESTOREBOOTROOT}/etc/rc3.d/S90report

Log "# Reset Upgrade State"
if [ "${UPGRADESTATE}" = "PGP_UPGRADE_FIN" ]; then
	 # reset the state of the upgrade
	 UPGRADESTATE="PGP_UPGRADE_VALIDATION"
	 Export "UPGRADESTATE" ${UPGRADESTATE}
fi

# enable interrupts
trap 2 15

################################################################################
# boot the system into previous e-ppliance state
################################################################################
Log "# Reboot from disk:a"
sync; reboot -- "disk:a"
