#! /sbin/sh
# PGP e-ppliance 2.0 Upgrade
#  
# ShutdownFWServices.sh 
#
# Usage: 
# % sh ShutdownFWServices.sh
#
# PGP Security, A Network Associates Business
# Copyright (c) 1993 - 2001, Network Associates Technology, Inc.
# 
# NOTE: the telnet service still is enabled as well as netacl Local-Telnet
# NOTE: the smapd will not be shut down if there are some queued messages
#       in /var/spool/smap
# ./netacl -as netacl-telnetd -service SV23:127.0.0.1X -daemon 23
# ./tn-gw -as tn-gw -service SV23X -daemon 23

################################################################################
# imported variables
################################################################################
# SMAPQUEUEDIR
# MQUEUEDIR

SERVICELIST=""
NETPERM_TABLE="/usr/local/etc/netperm-table"
WAIT_TIME=120

################################################################################
# change dir to the root of upgrade source
################################################################################
UPGRADEROOT=`dirname $0`
BASENAME=`basename $0`
cd ${UPGRADEROOT} > /dev/null 2>&1
if [ $? -ne 0 ]; then
	 echo "UPGRADE::ERR Failed to change directory ${UPGRADEROOT}"
	 exit 3
fi

. ./Utils.sh

#######################################################################
# get the list of running services first
#######################################################################
if [ -f $NETPERM_TABLE ]; then
	 SERVICELIST=`grep ": state on" $NETPERM_TABLE | cut -d':' -f1`
else
	 Log "UPGRADE::ERR Failed to locate firewall configuration file $NETPERM_TABLE"
	 exit 1
fi

#######################################################################
# shutdown the firewall services, except tn-gw and smapd if exists
#######################################################################
if [ -n "${SERVICELIST}" ]; then
	 for process in ${SERVICELIST}; do
		  if [ "$process" != "tn-gw" ] && [ "$process" != "smapd" ] && \
				[ "$process" != "smap" ] && [ "$process" != "netacl-telnetd" ]; then
				PID=`ps -ef | grep "\-as $process" | grep -v "grep" | awk '{ print $2 }'`
				kill -9 $PID > /dev/null 2>&1
		  elif [ "$process" = "smap" ]; then
				PID=`ps -ef | grep "\-as $process" | grep -v "grep" | grep "\-daemon 25" | awk '{ print $2 }'`
				kill -9 $PID > /dev/null 2>&1
		  fi
	 done
fi

# process the sendmail queue once
# Log "# Process sendmail Queue"
# /usr/lib/sendmail -q
# check smap queue before kill the smapd
# get the total usage of the queued e-mails
SMAPQUEUE_USAGE=`du -dks $SMAPQUEUEDIR | awk '{ print $1 }'`
if [ $SMAPQUEUE_USAGE -gt 100000 ]; then
	 Log "UPGRADE::WRN Queued messages found in $SMAPQUEUEDIR and the size"
	 Log "UPGRADE::WRN exceeded the limit of the backup.  Allow smap $WAIT_TIME"
	 Log "UPGRADE::WRN seconds process the queued messages"
	 sleep $WAIT_TIME
fi

# check whether any remaining emails in both queues
SMAPQUEUE_CONT=`ls $SMAPQUEUEDIR`
MQUEUE_CONT=`ls $MQUEUEDIR`
if [ -n "${SMAPQUEUE_CONT}" ] || [ -n "${MQUEUE_CONT}" ]; then
	 Log "UPGRADE::WRN Please be advised that there are some queued emails in"
	 Log "UPGRADE::WRN either $SMAPQUEUEDIR or $MQUEUEDIR."
	 Log "UPGRADE::WRN The queued emails in $SMAPQUEUEDIR will no longer be"
	 Log "UPGRADE::WRN compatible with PGP e-ppliance 2.0."
 	 Log "UPGRADE::WRN If there are huge amount of queued emails, the user"
 	 Log "UPGRADE::WRN would be asked to transfer the queued emails to a "
 	 Log "UPGRADE::WRN remote FTP server, however the user should restore"
 	 Log "UPGRADE::WRN those queued emails into the PGP e-ppliance when the"
	 Log "UPGRADE::WRN upgrade is done. There exists potenial risks to loss"
	 Log "UPGRADE::WRN those invaluable emails during the upgrade."
	 Log ""
	 Log "UPGRADE::WRN It is strongly recommended that the user should shut down"
	 Log "UPGRADE::WRN the email service, and wait the both $SMAPQUEUEDIR "
	 Log "UPGRADE::WRN and $MQUEUEDIR clean before starting the upgrade."
	 Log ""
	 echo "Would you like to continue? [y/n]"
	 echo "[y] - continue the upgrade [n] - quit the upgrade : \c"
	 read foo
	 if [ "${foo}" != "y" -a "${foo}" != "Y" ]; then
		  exit 1
	 fi
fi

# kill the smapd process if exists
# if the size of queued messages still exceeds the limit, the VALIDATION will 
# remove the entire queued messages.
PID=`ps -ef | grep "\-as smapd" | grep -v "grep" | awk '{ print $2 }'`
kill -9 $PID > /dev/null 2>&1

# process the sendmail queue once
Log "# Process sendmail Queue"
/usr/lib/sendmail -q

#######################################################################
# finish
#######################################################################
exit 0

