#! /sbin/sh
# PGP E-ppliance 2.0 Upgrade 
#
# UpgradeLegatoOnly.sh
#
# PGP Security, A Network Associates Business
# Copyright (c) 1993 - 2001, Network Associates Technology, Inc.

FINALBOOTVAR="/var"

#######################################################################
# define interrupt handling 
# NOTE: upon an interrupt, the upgrade at this stage must bring the
# system back to pre-upgrade state by either reboot disk:a or restore
#######################################################################
trap 'kill $! > /dev/null 2>&1; Log "\n# User Interrupt! Upgrade aborted"; Exit 2' 2 15

#######################################################################
# change dir to the root of upgrade source
#######################################################################
UPGRADEROOT=`dirname $0`
BASENAME=`basename $0`
cd ${UPGRADEROOT} > /dev/null 2>&1
if [ $? -ne 0 ]; then
	 echo "UPGRADE::ERR Failed to change directory ${UPGRADEROOT}"
	 Exit 3
fi

. ./Utils.sh

Log ""
Log "##########################################################################"
Log "# Upgrade Legato FTC with EPL 2.0 "
Log "##########################################################################"
Log ""

#######################################################################
# test if ./gzip is executable
#######################################################################
if [ ! -x ./gzip ]; then
	 Log "UPGRADE::ERR ./gzip not found or not executable"
	 Exit 3
fi

#######################################################################
# test the current version of e-ppliance, must be 2.0
#######################################################################
GVERSION=`/usr/local/etc/gversion`
if [ "${GVERSION}" != "2.0" ]; then
	 Log "UPGRADE::ERR This option is for e-ppliance 2.0 Legato Software upgrade only"
	 exit 1
fi

pkginfo | grep LGTOlca > /dev/null 2>&1
if [ $? -eq 0 ]; then
	 Log "UPGRADE::ERR Legato FTC Software installed already"
	 Log "UPGRADE::ERR This option is for e-ppliance 2.0 Legato Software upgrade only"
	 exit 1
fi

PRODUCT_MODEL=300
export PRODUCT_MODEL

#######################################################################
# extract Legato Software
#######################################################################
sh ./Indicator.sh &

Log "# Extract Legato Software"
./gzip -cd ../pgp${PRODUCT_MODEL}.var.gz  | (cd ${FINALBOOTVAR};  tar -xf - ./ftc ) > /dev/null 2>&1
if [ $? -ne 0 ]; then
	 Log "UPGRADE::ERR Failed to extract /var/ftc partition."
	 Exit 1
fi

kill $! > /dev/null 2>&1

#######################################################################
# install Legato Software
#######################################################################
Log "# Install Legato Software"
if [ ! -d /var/PGP-epl-log ]; then
	 mkdir -p /var/PGP-epl-log
fi
(sh ./apply-Legato) > /var/PGP-epl-log/stage4 2>&1

#######################################################################
# finish 
#######################################################################

pkginfo | grep LGTOlca > /dev/null 2>&1
if [ $? -ne 0 ]; then
	 Log "UPGRADE::ERR Failed to upgrade Legato FTC Software."
	 exit 1
else
	 Log "# Legato Software Upgraded Successfully"
fi

exit 0
