#!/bin/sh
#

###
#
# This script will tar the directories where certificates are stored
# and create a file with the appropriate gauntlet.conf key/values
# for displaying certificate state on a Gauntlet 6.0 system
#
###

TARGETPATH="/usr/local/etc/mgmt/upgrade"
FWCERTPATH="/usr/local/etc/gvpn/active/fwcert"
KEYFILEPATH="/usr/local/etc/gvpn/active/keys"
GAUNTLETCONF="/usr/local/etc/mgmt/gauntlet.conf"

################
# IF we are on a Gauntlet 5.0 system, we need to copy the firewall cert and key file
#	(if they exist at all) to names that Gauntlet 6.0 will recognize
################
VER=`/usr/local/etc/gversion`

if [ "$VER" = "V5.0" ]; then
	# Get the primary PKI component number out of gauntlet.conf
	PRINUM=`grep "pki_...._primary=True" $GAUNTLETCONF | cut -d_ -f2`

	# Get the name of the component
	PKINAME=`grep "pki_"$PRINUM"_name=" $GAUNTLETCONF | cut -d= -f2`

	# Get the type of the component
	UPKITYPE=`grep "pki_"$PRINUM"_CA=" $GAUNTLETCONF | cut -d= -f2`

	# Convert the name to lowercase (is there a tolower() function we could use?)
	if [ "$UPKITYPE" = "XCERT" ]; then
		PKITYPE="xcert"
	fi
	if [ "$UPKITYPE" = "ENTRUST" ]; then
		PKITYPE="entrust"
	fi
	if [ "$UPKITYPE" = "OTHER" ]; then
		PKITYPE="other"
	fi

	HOSTNAME=`hostname`

	# Compute the names of the current active fwcert and key files
	TARGETFWCERT="$FWCERTPATH"/fwcert_"$PKINAME"_"$PKITYPE".crt
	TARGETKEYFILE="$KEYFILEPATH"/"$PKINAME"_"$PKITYPE".key

	# Copy the firewall certificate (if one exists) to the 6.0 name
	if [ -f $FWCERTPATH/$HOSTNAME.crt ]; then
		cp $FWCERTPATH/$HOSTNAME.crt $TARGETFWCERT
	fi

	# Copy the keyfile (if one exists) to the 6.0 name
	if [ -f $KEYFILEPATH/$HOSTNAME.key ]; then
		cp $KEYFILEPATH/$HOSTNAME.key $TARGETKEYFILE
	fi
fi

# Create tar file of all certs
tar cvf $TARGETPATH/gvpn_certs.tar /usr/local/etc/gvpn /usr/local/cacerts >/dev/null

# Get the "Obtained" CA cert list
CAROOTS=`ls /usr/local/etc/gvpn/active/caroots | cut -d_ -f2`

# Get the active fwcert list
FWCERT=`ls /usr/local/etc/gvpn/active/fwcert | grep "^fwcert" | cut -d_ -f2`

# Get the requested fwcert list
REQUEST=`ls /usr/local/etc/gvpn/pending/keys | cut -d_ -f1`

# Clear out the gvpn_cert_status.conf file
echo "" >$TARGETPATH/gvpn_cert_status.conf

# Create the config file entries for the cert status
for CA in $CAROOTS; do
	echo "sys_pki_"$CA"_ca-received=Obtained" >>$TARGETPATH/gvpn_cert_status.conf
done

for REQ in $REQUEST; do
	echo "sys_pki_"$REQ"_fw-cert=Requested" >>$TARGETPATH/gvpn_cert_status.conf
done

for FW in $FWCERT; do
	echo "sys_pki_"$FW"_fw-cert=Activated" >>$TARGETPATH/gvpn_cert_status.conf
done

##################
# Save AUTH db's
##################

AUTHDUMP=/usr/local/etc/authdump
NETPERM=/usr/local/etc/netperm-table
AUTHLIST=/usr/local/etc/mgmt/upgrade/authlist.txt
EXTRAFILES=/usr/local/etc/mgmt/upgrade/extrafiles.txt

if [ ! -f "$CONFIGFILES" ]; then
	CONFIGFILES=/usr/local/etc/mgmt/config_files_list
fi

# Find all the auth databases that need to be dumped.
# and authdump them.
STATUS='$?'
rm -f $AUTHLIST
rm -f $EXTRAFILES

grep database $NETPERM | grep -v "^#" >$AUTHLIST
sed -e "s@\([^:][^:]*\):[   ]*database[     ]*\(..*\)@$AUTHDUMP -as \1 >\2.save ; echo \2.save >>$EXTRAFILES ;@"  < $AUTHLIST | /bin/sh


