<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema"   
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan"
    >
    
    <!--
        
        For which definition is this XSLT appilcable ?
        
        This is a modified version of  winSystemConfigurationCheck02_SCAP.xsl.
        
        This works for the logic  below:
        
        <criteria operator="AND">
            <criteria operator="OR">
                <criteria operator="AND">
                    <criterion comment="Benchmark Variable = Not Configured" negate="false" test_ref="oval:com.mcafee.oval.windows:tst:66061"/>
                    <criterion comment="HKLM\Software\Policies\Microsoft\Windows\WindowsUpdate\AU!RescheduleWaitTimeEnabled does not exist" negate="true" test_ref="oval:com.mcafee.oval.windows:tst:66066"/>
                </criteria>
                <criteria operator="AND">
                    <criterion comment="HKLM\Software\Policies\Microsoft\Windows\WindowsUpdate\AU!RescheduleWaitTimeEnabled = 1" negate="false" test_ref="oval:com.mcafee.oval.windows:tst:66064"/>
                    <criterion comment="HKLM\Software\Policies\Microsoft\Windows\WindowsUpdate\AU!RescheduleWaitTime = variable" negate="false" test_ref="oval:com.mcafee.oval:tst:243766"/>
                </criteria>
                <criteria operator="AND">
                    <criterion comment="Benchmark Variable = Disabled" negate="false" test_ref="oval:com.mcafee.oval.windows:tst:66063"/>
                    <criterion comment="HKLM\Software\Policies\Microsoft\Windows\WindowsUpdate\AU!RescheduleWaitTimeEnabled = 0" negate="false" test_ref="oval:com.mcafee.oval.windows:tst:66065"/>
                </criteria>
            </criteria>
        </criteria>
        
        Corresponding txt is winSystemConfigurationCheck02_1_SCAP_xsl.txt
        
        One  of the supported def id's is :
        oval:com.mcafee.oval.windows:def:6606
        
        Library has simple logic of getting title, expected value and system value from the check.
     
    -->
    
  
    
    <xsl:variable name="SystemData"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data"/>
    
    <xsl:variable name="Variables"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables"/>
    
    <xsl:template name="getExternalVariablePrintableValue">
        <xsl:param name="id"/>
        <xsl:param name="numaricValue"/>
        
        <xsl:variable name="value">
            <xsl:value-of select="normalize-space($numaricValue)"/>    
        </xsl:variable>
        
        <xsl:variable name="printableValue">
            <xsl:for-each
                select="$Variables/oval-def:external_variable[@id = $id]/descendant::oval-def:possible_value">
                <xsl:if test="text() = $numaricValue">
                    <xsl:value-of select="@hint"/>
                </xsl:if>
            </xsl:for-each>
        </xsl:variable>
        
        <xsl:variable name="printableValueRange">
            <xsl:for-each
                select="$Variables/oval-def:external_variable[@id = $id]/descendant::oval-def:possible_restriction">
                <xsl:value-of select=" substring-before(@hint,'. Range')"/>
            </xsl:for-each>
        </xsl:variable>
        
        <xsl:variable name="formattedNumaricValue">
            <xsl:choose> 
                <xsl:when test="$value = ''  or $value='99999'">
                    <xsl:text>Not Configured</xsl:text>                    
                </xsl:when>
                <xsl:when test="$value = '0'">
                    <xsl:text>Disabled (0)</xsl:text>                    
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="concat('Enabled', ' (' , $value , ')' )"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable> 
        
        <xsl:value-of select="$formattedNumaricValue"/>
        
    </xsl:template>
  
    
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        
        <xsl:variable name="result"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <xsl:variable name="title">
             <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>            
        </xsl:variable>
       
        <xsl:variable name="isViolationValue">
            <xsl:choose>
                <xsl:when test="$result = 'false' ">
                    <xsl:text>true</xsl:text>                                              
                </xsl:when>
                <xsl:when test="$result = 'true' ">
                    <xsl:text>false</xsl:text>                                              
                </xsl:when>
            </xsl:choose>               
        </xsl:variable>
        
        <xsl:variable name="message_id">
               <xsl:text>com.mcafee.pa.msg.winconfig_SCAP</xsl:text>
        </xsl:variable>
        
                 <xsl:variable name="expectedValue">
                    <xsl:call-template name="getExternalVariablePrintableValue">
                         <xsl:with-param name="id" select="$SystemData/ind-sc:variable_item/ind-sc:var_ref/text()"  />
                         <xsl:with-param name="numaricValue" select="$SystemData/ind-sc:variable_item/ind-sc:value"/>
                     </xsl:call-template>
                </xsl:variable>
            
                <xsl:variable name="actualValue">
                    <xsl:variable name="result3"
                        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[3]/@result"/>
                        
                    
                    <xsl:choose>
                        <xsl:when test="$result3='true'">
                            <xsl:variable name="RegItemId" select="$SystemData/win-sc:registry_item[2]/@id"/>
                            <xsl:choose>
                                <xsl:when test="$SystemData/win-sc:registry_item[@id=$RegItemId]/win-sc:value != ''">
                                    <xsl:call-template name="getExternalVariablePrintableValue">
                                        <xsl:with-param name="id" select="$SystemData/ind-sc:variable_item/ind-sc:var_ref/text()"  />
                                        <xsl:with-param name="numaricValue" select="$SystemData/win-sc:registry_item[@id=$RegItemId]/win-sc:value"/>
                                    </xsl:call-template>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:text>Not Configured</xsl:text>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:variable name="RegItemId" select="$SystemData/win-sc:registry_item/@id"/>
                            <xsl:choose>
                                <xsl:when test="$SystemData/win-sc:registry_item[@id=$RegItemId]/win-sc:value != ''">
                                    <xsl:call-template name="getExternalVariablePrintableValue">
                                        <xsl:with-param name="id" select="$SystemData/ind-sc:variable_item/ind-sc:var_ref/text()"  />
                                        <xsl:with-param name="numaricValue" select="$SystemData/win-sc:registry_item[@id=$RegItemId]/win-sc:value"/>
                                    </xsl:call-template>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:text>Not Configured</xsl:text>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:otherwise>
                    </xsl:choose>
               </xsl:variable>

            <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="id">
                    <xsl:value-of select="$definitionId"/>
                </xsl:attribute>
                <xsl:element name="inputValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">expectedValue</xsl:attribute>
                    <xsl:value-of select="$expectedValue"/>
                </xsl:element>                
                <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="messageId">
                        <xsl:value-of select="$message_id"/>
                    </xsl:attribute>
                    <xsl:attribute name="isViolation">
                        <xsl:value-of select="$isViolationValue"/>
                    </xsl:attribute>
                    <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                        <xsl:attribute name="key">config</xsl:attribute>
                        <xsl:value-of select="$title"/>
                    </xsl:element>
                    <xsl:element name="actualValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                        <xsl:attribute name="key">actualValue</xsl:attribute>
                        <xsl:value-of select="$actualValue"/>
                    </xsl:element>
                </xsl:element>
            </xsl:element>
        
</xsl:template>
</xsl:stylesheet>