<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema"   
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan">
    
    <!--
       
       This XSLT is used to check User Right Permissions for a given user/users.
       
       Schema is below 
       
       Criteria (and)
          criterion family test         
          criterion  access allow     (accesstoken test) 
          .....            access allow    (accesstoken test)
          
          criterion access not allow (accesstoken test)
    -->
       
    <xsl:variable name="Definitions"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
    <xsl:variable name="Tests"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests"/>
    <xsl:variable name="TestedItems"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests"/>
    <xsl:variable name="CollectedObjects"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:collected_objects"/>
    <xsl:variable name="SystemData"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data"/>
    <xsl:variable name="States"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states"/>
    <xsl:variable name="Objects"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects"/>
    <xsl:variable name="Variables"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables"/>
    <xsl:variable name="OvalResult"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions"/>
   
   
    <xsl:template name="toggleBoolean">
        <xsl:param name="value"/>
        <xsl:choose>
            <xsl:when test="$value = 'true'">
                <xsl:value-of select="false()"/>
            </xsl:when>
            <xsl:when test="$value = 'false'">
                <xsl:value-of select="true()"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="true()"/>
            </xsl:otherwise>
        </xsl:choose>
        
        
    </xsl:template>
    
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        
        <xsl:variable name="result"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>

        <xsl:variable name="title">
            <xsl:value-of select="$Definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>            
        </xsl:variable>
        
        <xsl:variable name="tests">
            <xsl:for-each select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:criterion">
                                    
                <xsl:variable name="test">
                    <xsl:value-of select="@test_ref"/>
                  </xsl:variable>
                
                <xsl:if test="$Tests/win-def:accesstoken_test[@id=$test]">
                    <xsl:variable name="state">
                        <xsl:value-of select="$Tests/win-def:accesstoken_test[@id=$test]/win-def:state/@state_ref"/>
                    </xsl:variable>
                    
                    <xsl:variable name="localVariable" select="$States/win-def:registry_state[@id=$state]/win-def:value/@var_ref"/>
                    <xsl:variable name="externalVar" select="$Variables/oval-def:local_variable/oval-def:split/oval-def:variable_component/@var_ref"/>
                    
                    <xsl:variable name="privilegeName">
                        <xsl:value-of  select="name($States/win-def:accesstoken_state[@id=$state ]/*)"/>
                    </xsl:variable>
                    
                    <xsl:element name="test">
                        <xsl:attribute name="id">
                            <xsl:value-of select="$test"/>
                        </xsl:attribute>   
                        
                        <xsl:attribute name="privilegeName">
                            <xsl:value-of select="$privilegeName"/>
                            </xsl:attribute>
                        
                        <xsl:attribute name="externalVar">
                            <xsl:value-of select="$externalVar"/>
                        </xsl:attribute>
                        
                        <xsl:attribute name="state">
                            <xsl:value-of select="$state"/>
                        </xsl:attribute>
                        <xsl:attribute name="type">
                            <xsl:text>accesstoken</xsl:text>
                        </xsl:attribute>            
                    </xsl:element>        
                </xsl:if>
                
                <xsl:if test="$Tests/oval-ind:family_test[@id=$test]">
                    <xsl:element name="test">
                        <xsl:attribute name="id">
                            <xsl:value-of select="$test"/>
                        </xsl:attribute>
                        <xsl:attribute name="type">
                            <xsl:text>family</xsl:text>
                        </xsl:attribute>
                    </xsl:element>
                </xsl:if>
                
            </xsl:for-each>
        </xsl:variable>
        
        <!-- When final result is true-->
        <xsl:if test=" $result = 'true' ">
            <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">
               <xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @type ='accesstoken' ]">
                   <xsl:variable name="test" select="@id"/>
                   <xsl:variable name="state" select="@state"/>
                   <xsl:variable name="privName" select="@privilegeName"/>
                    
                    <xsl:variable name="externalVarId" select="@externalVar"/>
                   
                    <xsl:if test="$externalVarId != '' ">
                        
                        <xsl:variable name="externalVarValue"
                            select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable[@variable_id = $externalVarId]"/>
                        
                        <xsl:choose>
                            <xsl:when test="$externalVarValue = '|'">
                                <finding messageId="com.mcafee.pa.msg.UserRightPermission_NoUser" isViolation="false">
                                    <instanceValue key="expectedValue">
                                        <xsl:text>None</xsl:text>
                                    </instanceValue>
                                    <instanceValue key="title">
                                        <xsl:value-of select="$title"/>
                                    </instanceValue>
                                    <instanceValue key="privilegeName">
                                        <xsl:text> ( </xsl:text>
                                        <xsl:value-of select="$privName"/>
                                        <xsl:text> ) </xsl:text>
                                    </instanceValue>
                                </finding>
                            </xsl:when>
                            <xsl:when test="$externalVarValue != '' ">
                                <finding messageId="com.mcafee.pa.msg.UserRightPermission" isViolation="false">
                                    <instanceValue key="expectedValue">
                                        <xsl:value-of select="$externalVarValue"/>
                                    </instanceValue>
                                    <instanceValue key="title">
                                        <xsl:value-of select="$title"/>
                                    </instanceValue>
                                    <instanceValue key="privilegeName">
                                        <xsl:text> ( </xsl:text>
                                        <xsl:value-of select="$privName"/>
                                        <xsl:text> ) </xsl:text>
                                    </instanceValue>
                                </finding>
                            </xsl:when>
                        </xsl:choose>
                    </xsl:if>
                    
                    
                </xsl:for-each>
            </findings>
        </xsl:if>
        
        <!-- When final result is false-->
        <xsl:if test=" $result = 'false' ">
            <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">
                <xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @type ='accesstoken' ]">
                    <xsl:variable name="test" select="@id"/>
                    <xsl:variable name="state" select="@state"/>
                    <xsl:variable name="privName" select="@privilegeName"/>
                    
                    <xsl:variable name="externalVarId" select="@externalVar"/>
                    
                    <xsl:if test="$externalVarId != '' ">
                        
                        <xsl:variable name="externalVarValue"
                            select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable[@variable_id = $externalVarId]"/>
                        
                        <xsl:choose>
                            <xsl:when test="$externalVarValue = '|'">
                                <finding messageId="com.mcafee.pa.msg.UserRightPermission_NoUser" isViolation="true">
                                    <instanceValue key="expectedValue">
                                        <xsl:text>None</xsl:text>
                                    </instanceValue>
                                    <instanceValue key="title">
                                        <xsl:value-of select="$title"/>
                                    </instanceValue>
                                    <instanceValue key="privilegeName">
                                        <xsl:text> ( </xsl:text>
                                        <xsl:value-of select="$privName"/>
                                        <xsl:text> ) </xsl:text>
                                    </instanceValue>
                                </finding>
                            </xsl:when>
                            <xsl:when test="$externalVarValue != '' ">
                                <finding messageId="com.mcafee.pa.msg.UserRightPermission" isViolation="true">
                                    <instanceValue key="expectedValue">
                                        <xsl:value-of select="$externalVarValue"/>
                                    </instanceValue>
                                    <instanceValue key="title">
                                        <xsl:value-of select="$title"/>
                                    </instanceValue>
                                    <instanceValue key="privilegeName">
                                        <xsl:text> ( </xsl:text>
                                        <xsl:value-of select="$privName"/>
                                        <xsl:text> ) </xsl:text>
                                    </instanceValue>
                                </finding>
                            </xsl:when>
                        </xsl:choose>
                    </xsl:if>
                </xsl:for-each>
            </findings>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>