<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
  xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
  xmlns:aix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#aix"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
  xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
  xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
  xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
  xmlns:aix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#aix"
  xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
  xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
  xmlns:xalan="http://xml.apache.org/xalan"
  exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def ind-sc ind-def aix-def aix-sc">
  <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>
  
  <!--          
    Logic :-
    <criteria operator="OR">
    <criterion negate="true"  test_ref='oval:com.mcafee.oval:tst:224445' comment='Test for the existence of the file - /etc/exports' />
    <criterion negate="true"  test_ref="oval:com.mcafee.oval:tst:1413477" comment='Verify that there are no references to localhost in /etc/exports file.' />
    </criteria>
          
          without external variable or state.
          
          Ex OVAL ID - oval:com.mcafee.oval:def:1412428
  -->

  <xsl:param name="defid" />
  <xsl:template match="/">
    <xsl:call-template name="getFindings">
      <xsl:with-param name="definitionId" select="$defid"/>
    </xsl:call-template>
  </xsl:template>
  
  <xsl:template name="getFindings">
    <xsl:param name="definitionId"/>
    <xsl:variable name="result" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
    
    
    <xsl:variable name="fileTest_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test/@id"/>
    <xsl:variable name="fileContentTest_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test/@id"/>
    <xsl:variable name="result1" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$fileTest_id]/@result"/>
    <xsl:variable name="result2" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$fileContentTest_id]/@result"/>
    
    <xsl:variable name="definitionFileTest" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test[@id=$fileTest_id]"/>
    <xsl:variable name="filePath" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:file_object[@id=$definitionFileTest/unix-def:object/@object_ref]/unix-def:path/text()" />
    <xsl:variable name="fileName" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:file_object[@id=$definitionFileTest/unix-def:object/@object_ref]/unix-def:filename/text()" />
    
    <xsl:variable name="definitionTextFileTest" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTest_id]"/>
    <xsl:variable name="textfile53Path" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest/ind-def:object/@object_ref]/ind-def:path/text()" />
    <xsl:variable name="textfile53Name" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest/ind-def:object/@object_ref]/ind-def:filename/text()" />
    
    <xsl:variable name="textfilePattern" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest/ind-def:object/@object_ref]/ind-def:pattern/text()" />
  
  <xsl:variable name="file_info">
  
    <xsl:variable name="fileInfo">
      <xsl:choose>
        <xsl:when test="definitionFileTest != ' ' ">
          <xsl:value-of select="concat($filePath,'/', $fileName)"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="concat($textfile53Path,'/', $textfile53Name)"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    
    <xsl:variable name="filesMissingPat">

      <xsl:variable name="OvalResult"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions"/>
      <xsl:variable name="Tests"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests"/>
      
      <xsl:variable name="tests">
        <xsl:for-each
          select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:criterion">
          <xsl:variable name="test" select="@test_ref"/>
          <xsl:if test="$Tests/ind-def:textfilecontent54_test[@id=$test]">
            <xsl:element name="test">
              <xsl:attribute name="id">
                <xsl:value-of select="$test"/>
              </xsl:attribute>
              <xsl:attribute name="type">
                <xsl:text>textfileTest</xsl:text>
              </xsl:attribute>
            </xsl:element>
          </xsl:if>
        </xsl:for-each>
      </xsl:variable>
           
      <xsl:variable name="TestedItems"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests"/>
      
      <xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @type ='textfileTest' ]">
        <xsl:variable name="test" select="@id"/>
        <xsl:variable name="type" select="@type"/>
        
        <xsl:for-each select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[@result = 'false' or @result = 'not evaluated']">
          <xsl:variable name="itemRef" select="@item_id"/>
          <xsl:variable name="fixTestItem" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/ind-sc:textfilecontent54_item[@id=$itemRef]"/>
          <xsl:variable name="fixTestItem_1" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/ind-sc:textfilecontent_item[@id=$itemRef]"/>
            <xsl:choose>
              <xsl:when test="not($fixTestItem)">
                <xsl:value-of select="concat($fixTestItem_1/ind-sc:filepath/text(),' ')"/>
              </xsl:when>
              <xsl:when test="not($fixTestItem_1)">
                <xsl:value-of select="concat($fixTestItem/ind-sc:filepath/text(),' ')"/>
              </xsl:when>
            </xsl:choose>
        </xsl:for-each>
      </xsl:for-each>
    </xsl:variable>
   
    <xsl:choose>
      <xsl:when test="contains($fileInfo,'.*')">
        <xsl:value-of select="$filesMissingPat"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$fileInfo"/>
      </xsl:otherwise>
    </xsl:choose>
    
    
  </xsl:variable> 
    <xsl:variable name="title" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>
    
    <xsl:variable name="isViolationValue">
      <xsl:choose>
        <xsl:when test="$result = 'false' ">
          <xsl:text>true</xsl:text>
        </xsl:when>
        <xsl:when test="$result = 'true' ">
          <xsl:text>false</xsl:text>
        </xsl:when>
      </xsl:choose>
    </xsl:variable>
    
    <xsl:variable name="message_id">
      <!-- Check if result is false ......................................... -->
      <xsl:if test="$result='false'">
        <xsl:text>com.mcafee.pa.msg.PatternMatchNegSCAP</xsl:text>
      </xsl:if>            
      
      <xsl:if test="$result='true' ">                
        <xsl:choose>
          <xsl:when test="$result1='true'">
            <xsl:text>com.mcafee.pa.msg.configfileDoesNotExists</xsl:text>
          </xsl:when>
          <xsl:when test="$result1='false' and $result2 = 'true'">
            <xsl:text>com.mcafee.pa.msg.PatternMatchNegSCAP</xsl:text>
          </xsl:when>
        </xsl:choose>
      </xsl:if>
    </xsl:variable>
    
    <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
      <xsl:attribute name="id">
        <xsl:value-of select="$definitionId"/>
      </xsl:attribute>
      <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
        <xsl:attribute name="messageId">
          <xsl:value-of select="$message_id"/>
        </xsl:attribute>
        <xsl:attribute name="isViolation">
          <xsl:value-of select="$isViolationValue"/>
        </xsl:attribute>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">config_name</xsl:attribute>
          <xsl:value-of select="$title"/>
        </xsl:element>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">pattern</xsl:attribute>
          <xsl:value-of select="$textfilePattern"/>
        </xsl:element>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">file_info</xsl:attribute>
          <xsl:value-of select="$file_info"/>
        </xsl:element>
      </xsl:element>
    </xsl:element>
</xsl:template>
</xsl:stylesheet>

