﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema"   
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan"    >
    
    <!--  FILENAME: winForceLogoffPolicy_SCAP.xsl         DATE: 29th Sep, 2011     AUTHOR: Nandini NR   -->
    <!--  MAPPINGFILE: winForceLogoffPolicy_SCAP_xsl.txt    -->
    
    <!-- THIS LIBRARY IS DEVELOPED FOR WINDOWS COMPLIANCE CHECKS TO VERIFY Network security: Force logoff when logon hours expire Settings -->
    
<!-- FOLLOWING ARE SOME OF THE ASSUMPTIONS TAKEN IN THE LOGIC FOR THE LIBRARY  -->
   <!--   1. Following are the test cases which are taken into consideration for the logic:-
    ______________________________________________________________________________________________________________________________________________________________________
       Test Case	External Variable    System Setting	                                                                                Check result      Message String                                          	                         Is Violation        Message ID
    ______________________________________________________________________________________________________________________________________________________________________
       
       Result1    Disabled                Disabled  (Val=-1)                                                                                                Pass               Configuration is set as expected	                               FALSE   com.mcafee.pa.msg.forcelogoff
       Result2    Enabled                 Enabled	                                                                                                                 Pass               Configuration is set as expected	                               FALSE   com.mcafee.pa.msg.forcelogoff
       Result3    Disabled                Disabled (Val=4294967295)                                                                             Pass               Configuration is set as expected	                               FALSE   com.mcafee.pa.msg.forcelogoff
       Result4    Disabled                Enabled	                                                                                                   Fail                  Configuration setings are not as expected	                TRUE     com.mcafee.pa.msg.forcelogoff
       Result5    Enabled                 Disabled  (Val=-1)	                                                                                    Fail                  Configuration setings are not as expected	                TRUE    com.mcafee.pa.msg.forcelogoff
       Result6    Enabled                 Disabled (Val=4294967295)                                                                             Fail                   Configuration is set as expected	                               TRUE    com.mcafee.pa.msg.forcelogoff
       ______________________________________________________________________________________________________________________________________________________________________    
   -->

    
    <!-- Entry Function for the library  -->
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        
        <!-- Final result -->
        <xsl:variable name="result"  select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <xsl:variable name="Definitions"
            select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
        
        <!-- Extract configuration/policy name from the check title -->
        <xsl:variable name="title">
            <xsl:value-of select="$Definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>            
        </xsl:variable>
        
        <xsl:variable name="result1"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[1]/@result"/>
        <xsl:variable name="result2"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[2]/@result"/>
        <xsl:variable name="result3"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[3]/@result"/>
        <xsl:variable name="result4"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[4]/@result"/>
        <xsl:variable name="result5"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[5]/@result"/>
        <xsl:variable name="result6"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[6]/@result"/>
        
        <!-- Decide about the message id depending upon  the combination of results for various criterions ........................................................................................... -->

            <xsl:variable name="message_id">
                
                <!-- Check if result is true ........................................................................................... -->
                <xsl:if test="$result='true'">
                    <xsl:choose>
                        <xsl:when test="$result1 = 'true' and $result2 = 'true'">
                            <xsl:text>com.mcafee.pa.msg.forcelogoff</xsl:text>
                        </xsl:when>
                        <xsl:when test="$result3 = 'true' and $result4 = 'true'">
                            <xsl:text>com.mcafee.pa.msg.forcelogoff</xsl:text>
                        </xsl:when>
                        <xsl:when test="$result5 = 'true' and $result6 = 'true'">
                            <xsl:text>com.mcafee.pa.msg.forcelogoff</xsl:text>
                        </xsl:when>
                    </xsl:choose>
                </xsl:if>
                
                <!-- Check if result is false ........................................................................................... -->
                <xsl:if test="$result='false'">
                    <xsl:choose>
                        <xsl:when test="$result1 = 'true' and $result4 = 'true'">
                            <xsl:text>com.mcafee.pa.msg.forcelogoff</xsl:text>
                        </xsl:when>
                        <xsl:when test="$result1 = 'true' and $result6 = 'true'">
                            <xsl:text>com.mcafee.pa.msg.forcelogoff</xsl:text>
                        </xsl:when>
                        
                        <xsl:when test="$result3 = 'true' and $result2 = 'true'">
                            <xsl:text>com.mcafee.pa.msg.forcelogoff</xsl:text>
                        </xsl:when>
                        <xsl:when test="$result3 = 'true' and $result6 = 'true'">
                            <xsl:text>com.mcafee.pa.msg.forcelogoff</xsl:text>
                        </xsl:when>
                        
                        <xsl:when test="$result5 = 'true' and $result2 = 'true'">
                            <xsl:text>com.mcafee.pa.msg.forcelogoff</xsl:text>
                        </xsl:when>
                        <xsl:when test="$result5 = 'true' and $result4 = 'true'">
                            <xsl:text>com.mcafee.pa.msg.forcelogoff</xsl:text>
                        </xsl:when>
                    </xsl:choose>
                </xsl:if>
  
            </xsl:variable>
            
        <xsl:variable name="expectedValue">
            <xsl:choose>
                <xsl:when test="$result1 = 'true' ">
                    <xsl:text>Enabled</xsl:text>                                              
                </xsl:when>
                <xsl:when test="$result3 = 'true' or $result5 = 'true' ">
                    <xsl:text>Disabled</xsl:text>                                              
                </xsl:when>
            </xsl:choose>               
        </xsl:variable>
        
        <xsl:variable name="actualValue">
            <xsl:choose>
                <xsl:when test="$result2 = 'true' ">
                    <xsl:text>Enabled (0)</xsl:text>                                              
                </xsl:when>
                <xsl:when test="$result4 = 'true' ">
                    <xsl:text>Disabled (-1)</xsl:text>                                              
                </xsl:when>
                <xsl:when test="$result6 = 'true' ">
                    <xsl:text>Disabled (4294967295)</xsl:text>                                              
                </xsl:when>
            </xsl:choose>               
        </xsl:variable>
        
        <!-- Decide about the isViolation value depending upon  the result of the check ........................................................................................... -->
            <xsl:variable name="isViolationValue">
                <xsl:choose>
                    <xsl:when test="$result = 'false' ">
                        <xsl:text>true</xsl:text>                                              
                    </xsl:when>
                    <xsl:when test="$result = 'true' ">
                        <xsl:text>false</xsl:text>                                              
                    </xsl:when>
                    </xsl:choose>               
            </xsl:variable>
        
        <!--Now Create Finding xml with all the values extracted ........................................................................................... -->
        <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">
            <inputValue key="inputValue_forcelogoff">
                <xsl:value-of select="$expectedValue"/>
            </inputValue>
            <finding messageId="{$message_id}" isViolation="{$isViolationValue}">
                <actualValue key="actualValue">
                    <xsl:value-of select="$actualValue"/>                                                    
                </actualValue>     
            </finding>
        </findings>
      
    </xsl:template>
</xsl:stylesheet>
