<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan">

    <!--
                   This XSLT is used to verify the registry setting against user input as a Variable.
                   
                   criteria ( or )
                       criteria ( and )
                            criterion or extend_definition : Family testor extend definition
                             Variable test : Take user input from the benchmark 
                              Registry test 
                                 one or more..
                         criteria ( and )
                                criterion or extend_definition : Family testor extend definition
                                Variable test : Take user input from the benchmark 
                                Registry test 
                                one or more..      
                          ......
                       criteria ( or )
                   
                   
                   Example : 
                   
                   <criteria operator=""OR"">
                       <criteria operator=""AND"">
                           <criterion comment=""Benchmark Variable = Not Configured"" negate=""false"" test_ref=""oval:com.mcafee.oval.windows:tst:65791""/>
                           <criterion comment=""HKLM\Software\Microsoft\Windows\CurrentVersion\Policies\Explorer\\NoMSAppLogo5ChannelNotify does not exist"" negate=""true"" test_ref=""oval:com.mcafee.oval.windows:tst:65795""/>
                           <criterion comment=""The installed operating system is part of the Microsoft Windows family"" test_ref=""oval:com.mcafee.oval.windows:tst:160262""/>
                       </criteria>
                       <criteria operator=""AND"">
                           <criterion comment=""Benchmark Variable = Enabled"" negate=""false"" test_ref=""oval:com.mcafee.oval.windows:tst:65792""/>
                           <criterion comment=""HKLM\Software\Microsoft\Windows\CurrentVersion\Policies\Explorer\\NoMSAppLogo5ChannelNotify = 1"" negate=""false"" test_ref=""oval:com.mcafee.oval.windows:tst:65794""/>
                           <criterion comment=""The installed operating system is part of the Microsoft Windows family"" test_ref=""oval:com.mcafee.oval.windows:tst:160262""/>
                   </criteria>
                   <criteria operator=""AND"">
                           <criterion comment=""Benchmark Variable = Disabled"" negate=""false"" test_ref=""oval:com.mcafee.oval.windows:tst:65793""/>
                           <criterion comment=""HKLM\Software\Microsoft\Windows\CurrentVersion\Policies\Explorer\\NoMSAppLogo5ChannelNotify does not exist"" negate=""true"" test_ref=""oval:com.mcafee.oval.windows:tst:65795""/>
                           <criterion comment=""The installed operating system is part of the Microsoft Windows family"" test_ref=""oval:com.mcafee.oval.windows:tst:160262""/>
                       </criteria>
                   </criteria>
                   
    -->

    <xsl:variable name="Definitions"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
    <xsl:variable name="Tests"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests"/>
    <xsl:variable name="TestedItems"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests"/>
    <xsl:variable name="CollectedObjects"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:collected_objects"/>
    <xsl:variable name="SystemData"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data"/>
    <xsl:variable name="States"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states"/>
    <xsl:variable name="Objects"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects"/>
    <xsl:variable name="Variables"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables"/>
    <xsl:variable name="OvalResult"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions"/>
  
  
    <xsl:template name="toggleBoolean">
        <xsl:param name="value"/>
        <xsl:choose>
            <xsl:when test="$value = 'true'">
                <xsl:value-of select="false()"/>
            </xsl:when>
            <xsl:when test="$value = 'false'">
                <xsl:value-of select="true()"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="true()"/>
            </xsl:otherwise>
        </xsl:choose>
        
        
    </xsl:template>
        
  <xsl:template name="removeColon">
      <xsl:param name="string"/>
      <xsl:param name="count"/>
      <xsl:param name="length"/>
    
      <xsl:if test="$count  &lt;= $length">
          
          <xsl:variable name="char">
              <xsl:value-of select="substring($string,$count,1)"/>
          </xsl:variable>
          
          <xsl:choose>
              <xsl:when test="$char != ':' and $char != '.' ">
                   <xsl:value-of select="$char"/>
                     <xsl:call-template name="removeColon">
                          <xsl:with-param name="string" select="$string"/>
                           <xsl:with-param name="count" select="$count + 1"/>
                          <xsl:with-param name="length" select="$length"/>
                     </xsl:call-template>
              </xsl:when>
              <xsl:otherwise>                  
                  <xsl:call-template name="removeColon">
                      <xsl:with-param name="string" select="$string"/>
                      <xsl:with-param name="count" select="$count + 1"/>
                      <xsl:with-param name="length" select="$length"/>
                  </xsl:call-template>
              </xsl:otherwise>
          </xsl:choose>          
          </xsl:if>
      
  </xsl:template>
    
  <xsl:template name="getSuffixForMessageId">
      <xsl:param name="id"/>      
       
       <xsl:variable name="suffix">           
           <xsl:value-of select="substring-after($id,'oval:com.mcafee.oval')"/>
       </xsl:variable>
                   
         <xsl:variable name="suffix1">
             <xsl:call-template name="removeColon">
                  <xsl:with-param name="string" select="$suffix"/>
                   <xsl:with-param name="length" select="string-length($suffix)"/>
                   <xsl:with-param name="count" select="1 + 0"/>
             </xsl:call-template>
         </xsl:variable>
          <xsl:value-of select="$suffix1"/>
  </xsl:template>
    
  <xsl:template name="getMessageId">
       <xsl:param name="id"/>
      
        <xsl:variable name="suffiex">
            <xsl:call-template name="getSuffixForMessageId">
                  <xsl:with-param name="id" select="$id"/>                
             </xsl:call-template>
        </xsl:variable>
        
        <xsl:if test="$suffiex != '' ">
            <xsl:value-of select="concat('com.mcafee.pa.msg.winconfiguration',$suffiex)"/>       
        </xsl:if>
  </xsl:template>
    
    <xsl:template name="configurationStatusString">
            <xsl:param name="value"/>
        <!--<possible_value hint="Enabled">Enabled</possible_value>
        <possible_value hint="Disabled">Disabled</possible_value>
        <possible_value hint="Not Configured">Not Configured</possible_value>-->
        
         <xsl:choose>
             <!-- <xsl:when test="$value = '' ">
                 <xsl:text>Unknown</xsl:text>
                 </xsl:when> -->
             <xsl:when test="contains($value,'Not Configured')">
                 <xsl:text>Not Configured</xsl:text>
             </xsl:when>
             <xsl:when test="contains($value,'Disabled')">
                 <xsl:text>Disabled</xsl:text>
             </xsl:when>
             <xsl:when test="contains($value,'Enabled')">
                 <xsl:text>Enabled</xsl:text>
             </xsl:when>
             <xsl:otherwise>
                 <xsl:value-of select="$value"/>
             </xsl:otherwise>
         </xsl:choose>        
    </xsl:template>
    
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>

        <xsl:variable name="result"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
  
            <xsl:call-template name="winConfigurationCheck">
                <xsl:with-param name="definitionId" select="$definitionId"/>
                <xsl:with-param name="def_result" select="$result"/>
            </xsl:call-template>

    </xsl:template>

    <xsl:template name="winConfigurationCheck">
        <xsl:param name="definitionId"/>
        <xsl:param name="def_result"/>

    
        <xsl:variable name="tests">
            <xsl:for-each
                select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:criteria">
   
               <xsl:element name="criteria">
                    <xsl:for-each select="./oval-res:criterion">
                        <xsl:variable name="test" select="@test_ref"/>
                        <xsl:variable name="result" select="@result"/>
                        
                        
                        <xsl:if test="$Tests/win-def:registry_test[@id=$test]">
                            
                            <xsl:element name="test">
                                <xsl:attribute name="id">
                                    <xsl:value-of select="$test"/>
                                </xsl:attribute>                      
                                <xsl:attribute name="result">
                                    <xsl:value-of select="$result"/>
                                </xsl:attribute>
                                <xsl:attribute name="testtype">
                                    <xsl:text>registry</xsl:text>
                                </xsl:attribute>

                            </xsl:element>
                        </xsl:if>

                        <xsl:if test="$Tests/oval-ind:variable_test[@id=$test]">
                            <xsl:variable name="state"
                                select="$Tests/oval-ind:variable_test[@id=$test]/oval-ind:state/@state_ref"/>                            
                            <xsl:variable name="expectedValue"
                                select="$States/oval-ind:variable_state[@id=$state]/oval-ind:value"/>

                            <xsl:element name="test">
                                <xsl:attribute name="id">
                                    <xsl:value-of select="$test"/>
                                </xsl:attribute>                                
                                <xsl:attribute name="expectedValue">
                                    <xsl:value-of select="$expectedValue"/>
                                </xsl:attribute>
                                <xsl:attribute name="result">
                                    <xsl:value-of select="$result"/>
                                </xsl:attribute>
                                <xsl:attribute name="testtype">
                                    <xsl:text>variable</xsl:text>
                                </xsl:attribute>
                            </xsl:element>
                        </xsl:if>

                        <xsl:if test="$Tests/oval-ind:family_test[@id=$test]">
                            <xsl:element name="test">
                                <xsl:attribute name="id">
                                    <xsl:value-of select="$test"/>
                                </xsl:attribute>
                                <xsl:attribute name="testtype">
                                    <xsl:text>family</xsl:text>
                                </xsl:attribute>
                            </xsl:element>
                        </xsl:if>
                    </xsl:for-each>
                </xsl:element>
            </xsl:for-each>

            <xsl:element name="criteria">
                <xsl:for-each
                    select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/oval-res:criterion">

                    <xsl:variable name="test" select="@test_ref"/>
                    <xsl:variable name="result" select="@result"/>

                    <xsl:if test="$Tests/win-def:registry_test[@id=$test]">
                       <xsl:element name="test">
                            <xsl:attribute name="id">
                                <xsl:value-of select="$test"/>
                            </xsl:attribute>
                            <xsl:attribute name="result">
                                <xsl:value-of select="$result"/>
                            </xsl:attribute>
                            <xsl:attribute name="testtype">
                                <xsl:text>registry</xsl:text>
                            </xsl:attribute>

                        </xsl:element>
                    </xsl:if>

                    <xsl:if test="$Tests/oval-ind:variable_test[@id=$test]">
                        <xsl:variable name="state"
                            select="$Tests/oval-ind:variable_test[@id=$test]/oval-ind:state/@state_ref"/>
                        <xsl:variable name="expectedValue"
                            select="$States/oval-ind:variable_state[@id=$state]/oval-ind:value"/>

                        <xsl:element name="test">
                            <xsl:attribute name="id">
                                <xsl:value-of select="$test"/>
                            </xsl:attribute>
                            <xsl:attribute name="expectedValue">
                                <xsl:value-of select="$expectedValue"/>
                            </xsl:attribute>
                            <xsl:attribute name="result">
                                <xsl:value-of select="$result"/>
                            </xsl:attribute>
                            <xsl:attribute name="testtype">
                                <xsl:text>variable</xsl:text>
                            </xsl:attribute>
                        </xsl:element>
                    </xsl:if>

                    <xsl:if test="$Tests/oval-ind:family_test[@id=$test]">
                        <xsl:element name="test">
                            <xsl:attribute name="id">
                                <xsl:value-of select="$test"/>
                            </xsl:attribute>
                            <xsl:attribute name="testtype">
                                <xsl:text>family</xsl:text>
                            </xsl:attribute>
                        </xsl:element>
                    </xsl:if>

                </xsl:for-each>
            </xsl:element>

        </xsl:variable>


        <xsl:variable name="exDefinitionId">
            <xsl:for-each
                select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:extend_definition[@result = 'false'] ">
                <xsl:if test="./parent::node()/@result = 'false' ">
                    <xsl:element name="extend_definition">
                        <xsl:attribute name="id">
                            <xsl:value-of select="@definition_ref"/>
                        </xsl:attribute>
                        <xsl:attribute name="result">
                            <xsl:value-of select="@result"/>
                        </xsl:attribute>
                    </xsl:element>
                </xsl:if>
            </xsl:for-each>
        </xsl:variable>
        
        <xsl:variable name="rs_exDefinition">
            <xsl:value-of
                select="xalan:nodeset($exDefinitionId)/descendant::extend_definition/@result"/>
        </xsl:variable>
                
        <xsl:variable name="preCoditionStatus">
            <xsl:choose>
                <xsl:when test="$rs_exDefinition != '' ">
                    <xsl:value-of select="$rs_exDefinition"/>
                </xsl:when>
                <xsl:when
                    test="xalan:nodeset($tests)/descendant::test[ @testtype ='family' ]/@id != '' ">
                    <xsl:variable name="test"
                        select="xalan:nodeset($tests)/descendant::test[ @testtype ='family' ]/@id"/>
                    <xsl:value-of select="$TestedItems/oval-res:test[@test_id=$test ]/@result"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text>true</xsl:text>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>


        <xsl:variable name="message_id">
            <xsl:call-template name="getMessageId">
                <xsl:with-param name="id" select="$definitionId"/>
            </xsl:call-template>
        </xsl:variable>
        

            <xsl:if test=" $preCoditionStatus = 'true'  and $def_result = 'false' ">               
                
                <!--   Get the expected Value from the variable test   -->
                <xsl:variable name="expectedValue">
                <xsl:for-each select="xalan:nodeset($tests)/descendant::criteria">
                    <xsl:if  test="./test[ @testtype = 'variable' ] and ./test[ @testtype = 'variable' ]/@result = 'true'  ">                        
                        <xsl:value-of select="./test[ @testtype = 'variable' ]/@expectedValue"/>
                    </xsl:if>
                </xsl:for-each>
                </xsl:variable>
             
                
                <!--  Now get the actual value from the registry test which passed -->

                <xsl:variable name="actualValue">
                <xsl:for-each select="xalan:nodeset($tests)/descendant::criteria">

                    <!--  Get the expected value for this criteria that would be actual value if all the registry tests passed                     -->
                    <xsl:variable name="variableTestExpectedValue">
                        <xsl:for-each select="./child::test[ @testtype = 'variable' ]">
                            <xsl:value-of select="@expectedValue"/>
                        </xsl:for-each>
                    </xsl:variable>
                    
                        <!--  Check all registry test passed                     -->
                          <xsl:variable name="registryTestResult">
                            <xsl:for-each select="./child::test[ @testtype = 'registry' ]">
                                <xsl:variable name="reg_test_result" select="@result"/>
                                 <xsl:if test="$reg_test_result != 'true' ">
                                      <xsl:text>1</xsl:text>
                                 </xsl:if>
                             </xsl:for-each>
                          </xsl:variable>
                    
                        <!--     If all registry tests pass then variable test value is the actual value in the system -->
                            <xsl:if test="not(contains($registryTestResult,'1'))">
                                <xsl:value-of select="$variableTestExpectedValue"/>
                            </xsl:if>
                        </xsl:for-each>
                </xsl:variable>
                
                               <xsl:if test="$message_id != '' ">
                                   <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">
                                       
                                       <inputValue key="expectedValue">
                                           <xsl:call-template name="configurationStatusString">
                                               <xsl:with-param name="value" select="$expectedValue"/>
                                           </xsl:call-template>
                                       </inputValue>
                                       
                                    <finding messageId="{$message_id}" isViolation="true">                                      
                                         <actualValue key="actualValue">
                                            <xsl:call-template name="configurationStatusString">
                                                <xsl:with-param name="value" select="$actualValue"/>
                                            </xsl:call-template>                                            
                                        </actualValue>
                                    </finding>
                                   </findings>
                               </xsl:if>
                
            </xsl:if>
        
            <xsl:if test="$def_result = 'true' ">               
            
            <!--   Get the expected Value from the variable test   -->
            <xsl:variable name="expectedValue">
                <xsl:for-each select="xalan:nodeset($tests)/descendant::criteria">
                    <xsl:if  test="./test[ @testtype = 'variable' ] and ./test[ @testtype = 'variable' ]/@result = 'true'  ">                        
                        <xsl:value-of select="./test[ @testtype = 'variable' ]/@expectedValue"/>
                    </xsl:if>
                </xsl:for-each>
            </xsl:variable>
            
            <xsl:if test="$message_id != '' ">
                <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">
                    
                    <finding messageId="{$message_id}" isViolation="false">                                      
                        <actualValue key="actualValue">
                            <xsl:call-template name="configurationStatusString">
                                <xsl:with-param name="value" select="$expectedValue"/>
                            </xsl:call-template>                                            
                        </actualValue>
                    </finding>
                </findings>
            </xsl:if>
            
        </xsl:if>
        
    </xsl:template>

</xsl:stylesheet>
