<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
    xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def ind-sc ind-def">
    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>
    
    <xsl:param name="defid" />
    <xsl:template match="/">
        <xsl:call-template name="getFindings">
            <xsl:with-param name="definitionId" select="$defid"/>
        </xsl:call-template>
    </xsl:template>
    
    <!-- This library is for HPUX, Solaris checks related to Login shell for user account should be set appropriately -->
    <xsl:template name="getConfigNameFromTitle">
        <xsl:param name="title"/>
        <xsl:variable name="configName">
            <!-- For HPUX checks -->
            <xsl:if test="contains($title, 'Shell for the')">
                <xsl:value-of select="substring-before($title, ' should be')"/>
            </xsl:if>
            <!-- For Solaris checks -->
            <xsl:if test="contains($title, 'The shell for the')">
                <xsl:value-of select="substring-before($title, ' should be')"/>
            </xsl:if>
        </xsl:variable>
        <xsl:choose>
            <xsl:when test="$configName != '' ">
                <xsl:if test="starts-with($configName, 'The ')">
                    <xsl:value-of select="substring-after($configName, 'The ')"/>
                </xsl:if>
                <xsl:if test="starts-with($configName, 'Shell ')">
                    <xsl:value-of select="$configName"/>
                </xsl:if>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$title"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        <!-- Collect the final result of the OVAL check -->
        <xsl:variable name="result" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <!-- Collect configuration name from the title --> 
        <xsl:variable name="Definitions" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
        <xsl:variable name="title" select="$Definitions/oval-def:definition[@id=$definitionId ]/oval-def:metadata/oval-def:title"/>
        
        <!-- Collect all test references, test results and other misc data  required --> 
        
        <!-- It is assumed that password_test[1] is a account existence test and password_test[2] is shell verification test in the OVAL checks -->
        <xsl:variable name="passwdTest1_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:password_test[1]/@id"/>
        <xsl:variable name="passwdTest2_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:password_test[2]/@id"/>
        
        <xsl:variable name="result1" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$passwdTest1_id]/@result"/>
        <xsl:variable name="result2" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$passwdTest2_id]/@result"/>
        
        <xsl:variable name="definitionPasswdTest" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:password_test[@id=$passwdTest2_id]"/>
        <xsl:variable name="userName" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:password_object[@id=$definitionPasswdTest/unix-def:object/@object_ref]/unix-def:username/text()" />
        <xsl:variable name="expectedConfig" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states/unix-def:password_state[@id=$definitionPasswdTest/unix-def:state/@state_ref]/unix-def:login_shell/text()" />
        
        <xsl:variable name="passwdObj_ref" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:password_test[@id=$passwdTest2_id]/unix-def:object/@object_ref" />
        <xsl:variable name="passwdObj_flag" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:collected_objects/oval-sc:object[@id=$passwdObj_ref]/@flag"/>
        
        <xsl:variable name="passwditem_id" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$passwdTest2_id]/oval-res:tested_item/@item_id"/>        
        <xsl:variable name="passwditem" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/unix-sc:password_item[@id=$passwditem_id]" />        
        <xsl:variable name="actualConfig" select="$passwditem/unix-sc:login_shell/text()"/>
        
        <!-- Decide about the message id depending upon  the combination of results for various criterions/tests -->
        <xsl:variable name="message_id">
            <!-- Check if result is true -->
            <xsl:if test="$result='true'">
                <xsl:choose>
                    <xsl:when test="$result1 = 'false' and $result2 = 'true' " >
                        <!-- The configuration $$config_name$$ is set to '%%actual_config%%'. -->
                        <xsl:text>com.mcafee.pa.msg.configStatus</xsl:text>
                    </xsl:when>
                    <xsl:when test="$result1 = 'true' and $result2 = 'false' and $passwdObj_flag= 'does not exist' " >
                        <!-- The user $$user_name$$ does not exists on the system. -->
                        <xsl:text>com.mcafee.pa.msg.UserDoesNotExists</xsl:text>
                    </xsl:when>
                </xsl:choose>
            </xsl:if>            
            <!-- Check if result is false -->
            <xsl:if test="$result='false' ">
                <xsl:choose>
                    <xsl:when test="$result1 = 'false' and $result2 = 'false' and $passwdObj_flag= 'complete' and $actualConfig !='' ">
                            <!-- The configuration $$config_name$$ is not set to '%%actual_config%%', expected to be configured with '##expected_config##'. -->
                            <xsl:text>com.mcafee.pa.msg.configStatus</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                        <!-- The configuration $$config_name$$ is not configured. -->
                        <xsl:text>com.mcafee.pa.msg.configNotSet</xsl:text>                        
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:if>  
        </xsl:variable>
        
        <xsl:variable name="isViolationValue">
            <xsl:choose>
                <xsl:when test="$result = 'false' ">
                    <xsl:text>true</xsl:text>
                </xsl:when>
                <xsl:when test="$result = 'true' ">
                    <xsl:text>false</xsl:text>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="configName">
            <xsl:call-template name="getConfigNameFromTitle">
                <xsl:with-param name="title" select="$title"/>
            </xsl:call-template>
        </xsl:variable>
        <!-- The following section should be compliant to PA findings schema -->
        <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
            <xsl:attribute name="id">
                <xsl:value-of select="$definitionId"/>
            </xsl:attribute>
            <xsl:element name="inputValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="key">expected_config</xsl:attribute>
                <xsl:value-of select="$expectedConfig" />
            </xsl:element>
            <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="messageId">
                    <xsl:value-of select="$message_id"/>
                </xsl:attribute>
                <xsl:attribute name="isViolation">
                    <xsl:value-of select="$isViolationValue"/>
                </xsl:attribute>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">user_name</xsl:attribute>
                    <xsl:value-of select="$userName"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">config_name</xsl:attribute>
                    <xsl:value-of select="$configName"/>
                </xsl:element>
                <xsl:element name="actualValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">actual_config</xsl:attribute>
                    <xsl:value-of select="$actualConfig"/>
                </xsl:element>
            </xsl:element>
        </xsl:element>
        
    </xsl:template>
</xsl:stylesheet>