<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
  xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
  xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
  xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
  xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
  xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
  xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
  exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def ind-sc ind-def">
  <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>

  <!-- This library is to handle the OVAL checks with the text file test and file existence test.
         Text file test verifies if a specific pattern of text is not present in the configuration file in test.
          
          Logic :-
          <criteria operator="AND">
            <criterion comment="Test for the existence of the files" test_ref="oval:com.mcafee.oval:tst:242441"/>
            <criterion comment="Verift if the required pawword pattern is found" test_ref="oval:com.mcafee.oval:tst:242442"/>
          </criteria>
          
          without external variable & OVAL State.
          
          Ex. OVAL ID - oval:com.mcafee.oval:def:242440
  -->

  <xsl:variable name="SystemData"
  select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data"/>
  
  <xsl:param name="defid" />
  <xsl:template match="/">
    <xsl:call-template name="getFindings">
      <xsl:with-param name="definitionId" select="$defid"/>
    </xsl:call-template>
  </xsl:template>
  
  <xsl:template name="concatWithDelimiter">
    <xsl:param name="currIndex"/>
    <xsl:param name="paramValue"/>
    <xsl:param name="lastIndex"/>
    
    <xsl:choose>
      <xsl:when test="$currIndex &lt;=$lastIndex">
        
        <xsl:variable name="currValue" select="$SystemData/unix-sc:file_item[$currIndex]/unix-sc:filepath/text()"/>
        
        <xsl:call-template name="concatWithDelimiter">
          <xsl:with-param name="currIndex" select="$currIndex + 1"/>
          <xsl:with-param name="paramValue" select="concat($paramValue, ' | ', $currValue)"/>
          <xsl:with-param name="lastIndex" select="$lastIndex"/>
        </xsl:call-template>
        
      </xsl:when>
      <xsl:otherwise>
        <xsl:if test="$paramValue != ''">
          <xsl:value-of select="substring($paramValue,2)"/>
        </xsl:if>                
      </xsl:otherwise>
    </xsl:choose>        
  </xsl:template>
  
  
  <xsl:template name="getFindings">
    <xsl:param name="definitionId"/>
    
    <xsl:variable name="result" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
    
    <xsl:variable name="fileTest_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test/@id"/>
    <xsl:variable name="fileContentTest_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test/@id"/>
    <xsl:variable name="result1" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$fileTest_id]/@result"/>
    <xsl:variable name="result2" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$fileContentTest_id]/@result"/>
   
    <xsl:variable name="fileList">
      <xsl:call-template name="concatWithDelimiter">
        <xsl:with-param name="currIndex" select="1"/>
        <xsl:with-param name="paramValue"/>
        <xsl:with-param name="lastIndex" select="count($SystemData/unix-sc:file_item/unix-sc:filepath/text())"/>
      </xsl:call-template>
    </xsl:variable>
   
    <xsl:variable name="fileName">
      <xsl:choose>
        <xsl:when test="$fileList!=''">
            <xsl:value-of select="$fileList"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text>/boot/grub/grub.cfg and /boot/grub/menu.lst</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
      
    </xsl:variable>
    
    <xsl:variable name="pattern">
      <xsl:choose>
        <xsl:when test="(contains($fileList,'/boot/grub/grub.cfg') and contains($fileList,'/boot/grub/menu.lst'))">
          <xsl:text>^(?!#).*password(_pbkdf2)?\s+(.+)$ and ^(?!#).*password\s+[-][-]md5\s+(.+)$</xsl:text>
        </xsl:when>
        <xsl:when test="contains($fileList,'/boot/grub/grub.cfg')">
          <xsl:text>^(?!#).*password(_pbkdf2)?\s+(.+)$</xsl:text>
        </xsl:when>
        <xsl:when test="contains($fileList,'/boot/grub/menu.lst')">
          <xsl:text>^(?!#).*password\s+[-][-]md5\s+(.+)$</xsl:text>
        </xsl:when>
      </xsl:choose>
    </xsl:variable>
    
    <xsl:variable name="title" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>
    
    <xsl:variable name="isViolationValue">
      <xsl:choose>
        <xsl:when test="$result = 'false' ">
          <xsl:text>true</xsl:text>
        </xsl:when>
        <xsl:when test="$result = 'true' ">
          <xsl:text>false</xsl:text>
        </xsl:when>
      </xsl:choose>
    </xsl:variable>
    
    <xsl:variable name="message_id">

      <!-- Check if result is true ......................................... -->
          <xsl:if test="$result='true'">
            <xsl:text>com.mcafee.pa.msg.PatternMatchSCAP</xsl:text>
          </xsl:if>            
          <!-- Check if result is false .......................................-->
          <xsl:if test="$result='false' ">                
            <xsl:choose>
              <xsl:when test="$result1='false'">
                <xsl:text>com.mcafee.pa.msg.configfilesDoesNotExists</xsl:text>
              </xsl:when>
              <xsl:when test="$result1='true' and $result2='false'">
                <xsl:text>com.mcafee.pa.msg.PatternMatchMultFilesSCAP</xsl:text>
              </xsl:when>
            </xsl:choose>
          </xsl:if>    
    </xsl:variable>
    
    <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
      <xsl:attribute name="id">
        <xsl:value-of select="$definitionId"/>
      </xsl:attribute>
      <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
        <xsl:attribute name="messageId">
          <xsl:value-of select="$message_id"/>
        </xsl:attribute>
        <xsl:attribute name="isViolation">
          <xsl:value-of select="$isViolationValue"/>
        </xsl:attribute>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">config_name</xsl:attribute>
          <xsl:value-of select="$title"/>
        </xsl:element>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">pattern</xsl:attribute>
          <xsl:value-of select="$pattern"/>
        </xsl:element>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">file_info</xsl:attribute>
          <xsl:value-of select="$fileName"/>
        </xsl:element>
      </xsl:element>
    </xsl:element>
</xsl:template>
</xsl:stylesheet>