﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema"   
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan"    >
    
    <!-- Library Logic
        This library will work in case where there are only 2 criterion's
        1) If Setting is Disabled or Not Configured then Result is Pass with message saying Configuration "$$config$$" is Not Configured or Disabled.
        2) In any other pass case we return Pass wtih message as Configuration $$config$$ is set to ##expectedValue## as expected.
        3) In case where result is False then we return Fail with message as Configuration $$config$$ is set to %%actualValue%%. It should be set to ##expectedValue##.
    -->  
    
    <!-- Entry Function for the library  -->
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        <xsl:variable name="result"  select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <xsl:variable name="Definitions"
            select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
        <xsl:variable name="title">
            <xsl:value-of select="$Definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>            
        </xsl:variable>
        
        <xsl:variable name="result1"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[1]/@result"/>
        <xsl:variable name="result2"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[2]/@result"/>
        
        
        <xsl:variable name="system_config_1" 
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/win-sc:registry_item/win-sc:value/text()"/>
        
        <xsl:variable name="stateID"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states/oval-ind:xmlfilecontent_state/oval-ind:value_of/@var_ref"/>
        
        <xsl:variable name="UserExpectedValue" 
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[2]/oval-res:tested_variable/text()"/>
            
        <!-- Decide about the message id depending upon  the combination of results for various criterions ........................................................................................... -->

            <xsl:variable name="message_id">
                
                <!-- Check if result is true ........................................................................................... -->
                <xsl:if test="$result='true'">
                    <xsl:choose>
                        <xsl:when test="$result1 = 'true' ">
                            <xsl:text>com.mcafee.pa.msg.DisabledOrNotConfigured</xsl:text>                                    
                        </xsl:when>
                        <xsl:when test="$result2 = 'true' ">
                            <xsl:text>com.mcafee.pa.msg.Setting</xsl:text>                   
                        </xsl:when>
                    </xsl:choose>
                </xsl:if>
                
                <!-- Check if result is false ........................................................................................... -->
                <xsl:if test="$result='false'">
                    <xsl:choose>
                        <xsl:when test="$result2 = 'false'">
                            <xsl:text>com.mcafee.pa.msg.Setting</xsl:text>    
                        </xsl:when>
                    </xsl:choose>
                </xsl:if>
  
            </xsl:variable>
            
        <!-- Decide about the isViolation value depending upon  the result of the check ........................................................................................... -->
            <xsl:variable name="isViolationValue">
                <xsl:choose>
                    <xsl:when test="$result = 'false' ">
                        <xsl:text>true</xsl:text>                                              
                    </xsl:when>
                    <xsl:when test="$result = 'true' ">
                        <xsl:text>false</xsl:text>                                              
                    </xsl:when>
                    </xsl:choose>               
            </xsl:variable>
        
        <!--Now Create Finding xml with all the values extracted ........................................................................................... -->
        <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">
            <inputValue key="expectedValue">
                <xsl:value-of select="$UserExpectedValue"/>                                                    
            </inputValue>
            <finding messageId="{$message_id}" isViolation="{$isViolationValue}">
                <instanceValue key="config">
                    <xsl:value-of select="$title"/>                                                    
                </instanceValue>
                <actualValue key="actualValue">
                    <xsl:value-of select="$system_config_1"/>                                                    
                </actualValue>
            </finding>
        </findings>
    </xsl:template>
</xsl:stylesheet>
