<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
    xmlns:aix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#aix"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
    xmlns:aix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#aix"
    xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:xalan="http://xml.apache.org/xalan"
    exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def ind-sc ind-def aix-def aix-sc">
    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>
    
    <!--
        
        This XSL is specific to AIX Patch Checks of SCAP Content.
        
        Patch details will be piacked up based on the result of the applicability. 
        
        Usual title pattern would be Patch for AIX <cause of the vulnerability> vulnerability.
        
        Example:Patch for AIX named DNS BIND dynamic update denial of service vulnerability
        
        This library is in specific for any AIX application related version verification. - Example Java version
        Affected fileset is verified for a version >= fixed version.
        
        <criteria negate="true" operator="AND">
            <criteria operator="OR">
                <criterion comment="Java5.sdk or Java5_64.sdk fileset existence test" negate="true" test_ref="oval:com.mcafee.oval:tst:1234"/>
                <criterion comment="Check if Java5.sdk or Java5_64.sdk fileset version is greater than or equal 5.0.0.560" test_ref="oval:com.mcafee.oval:tst:1111"/>
            </criteria>
            <criteria operator="OR">
                <criterion comment="Java6.sdk or Java6_64.sdk fileset existence test" negate="true" test_ref="oval:com.mcafee.oval:tst:5678"/>
                <criterion comment="Check if Java6.sdk or Java6_64.sdk fileset version is greater than or equal 6.0.0.435" test_ref="oval:com.mcafee.oval:tst:2222"/>
        </criteria>
        <criteria operator="OR">
            <criterion comment="Java7.sdk or Java7_64.sdk fileset existence test" negate="true" test_ref="oval:com.mcafee.oval:tst:9101"/>
            <criterion comment="Check if Java7.sdk or Java7_64.sdk fileset version is greater than or equal 7.0.0.110" test_ref="oval:com.mcafee.oval:tst:3333"/>
        </criteria>
     </criteria>
        
	Test Cases:
	1. Pass - Not Applicable - When Java 5, 6, 7 are not installed (required fileset is not present) on the system.
	2. Pass - Fixed filesets of Java 5/6/7 are installed on the system (Differenrt version range for Java 5, 6 and 7).
	3. Fail - Vulnerable filesets of Java 5/6/7 are installed on the system (Differenrt version range for Java 5, 6 and 7).
	
	Example - oval:com.mcafee.oval:def:403766
    -->
    
    <xsl:param name="defid" />
    <xsl:template match="/">
        <xsl:call-template name="getFindings">
            <xsl:with-param name="definitionId" select="$defid"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        
        <xsl:variable name="result"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <xsl:variable name="defVar" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]"/>
        <xsl:variable name="java5AppTestRes" select="$defVar/oval-res:criteria/descendant::oval-res:criterion[1]/@result"/>
        <xsl:variable name="java5PatchTestRes" select="$defVar/oval-res:criteria/descendant::oval-res:criterion[2]/@result"/>
        <xsl:variable name="java6AppTestRes" select="$defVar/oval-res:criteria/descendant::oval-res:criterion[3]/@result"/>
        <xsl:variable name="java6PatchTestRes" select="$defVar/oval-res:criteria/descendant::oval-res:criterion[4]/@result"/>
        <xsl:variable name="java7AppTestRes" select="$defVar/oval-res:criteria/descendant::oval-res:criterion[5]/@result"/>
        <xsl:variable name="java7PatchTestRes" select="$defVar/oval-res:criteria/descendant::oval-res:criterion[6]/@result"/>
        
        <xsl:variable name="expectedJava5Ver">
              <xsl:variable name="testID" select="$defVar/oval-res:criteria/descendant::oval-res:criterion[2]/@test_ref"/>
              <xsl:variable name="steID"  select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/aix-def:fileset_test[@id=$testID]/aix-def:state/@state_ref"/>
              <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states/aix-def:fileset_state[@id=$steID]/aix-def:level/text()"/>
        </xsl:variable>
        
        <xsl:variable name="expectedJava6Ver">
            <xsl:variable name="testID" select="$defVar/oval-res:criteria/descendant::oval-res:criterion[4]/@test_ref"/>
            <xsl:variable name="steID"  select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/aix-def:fileset_test[@id=$testID]/aix-def:state/@state_ref"/>
            <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states/aix-def:fileset_state[@id=$steID]/aix-def:level/text()"/>
        </xsl:variable>
        
        <xsl:variable name="expectedJava7Ver">
            <xsl:variable name="testID" select="$defVar/oval-res:criteria/descendant::oval-res:criterion[6]/@test_ref"/>
            <xsl:variable name="steID"  select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/aix-def:fileset_test[@id=$testID]/aix-def:state/@state_ref"/>
            <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states/aix-def:fileset_state[@id=$steID]/aix-def:level/text()"/>
        </xsl:variable>
        
      
        <xsl:variable name="java5Fileset">
            <xsl:text>Java5.sdk/Java5_64.sdk</xsl:text>
        </xsl:variable>
        
        <xsl:variable name="java6Fileset">
            <xsl:text>Java6.sdk/Java6_64.sdk</xsl:text>
        </xsl:variable>
        
        <xsl:variable name="java7Fileset">
            <xsl:text>Java7.sdk/Java7_64.sdk</xsl:text>
        </xsl:variable>
        
        <xsl:variable name="fileset" select="concat($java5Fileset, ', ', $java6Fileset,', ',$java7Fileset)"/>
        
        <xsl:variable name="title">
            <xsl:value-of select="substring-after(/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title,'Patch for ')"/>            
        </xsl:variable>
        <xsl:variable name="product">
            <xsl:text>IBM SDK, Java Technology Edition</xsl:text>
        </xsl:variable>
        
        <xsl:variable name="isViolationValue">
            <xsl:choose>
                <xsl:when test="$result = 'false' ">
                    <xsl:text>false</xsl:text>
                </xsl:when>
                <xsl:when test="$result = 'true' ">
                    <xsl:text>true</xsl:text>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="message_id">
            <xsl:if test="$result='true'">
                <xsl:choose>
                    <xsl:when test="($java5AppTestRes = 'false' and $java5PatchTestRes='false') and ($java6AppTestRes = 'false' and $java6PatchTestRes='false') and ($java7AppTestRes = 'false' and $java7PatchTestRes='false')">
                        <xsl:text>com.mcafee.pa.msg.aixJavaPatch567NotInstalled</xsl:text>
                    </xsl:when>
                    <xsl:when test="($java5AppTestRes = 'false' and $java5PatchTestRes='false') and ($java6AppTestRes = 'false' and $java6PatchTestRes='false')">
                        <xsl:text>com.mcafee.pa.msg.aixJavaPatch56NotInstalled</xsl:text>
                    </xsl:when>
                    <xsl:when test="($java5AppTestRes = 'false' and $java5PatchTestRes='false') and ($java7AppTestRes = 'false' and $java7PatchTestRes='false')">
                        <xsl:text>com.mcafee.pa.msg.aixJavaPatch57NotInstalled</xsl:text>
                    </xsl:when>
                    <xsl:when test="($java6AppTestRes = 'false' and $java6PatchTestRes='false') and ($java7AppTestRes = 'false' and $java7PatchTestRes='false')">
                        <xsl:text>com.mcafee.pa.msg.aixJavaPatch67NotInstalled</xsl:text>
                    </xsl:when>
                    <xsl:when test="($java5AppTestRes = 'false' and $java5PatchTestRes='false')">
                        <xsl:text>com.mcafee.pa.msg.aixJavaPatch5NotInstalled</xsl:text>
                    </xsl:when>
                    <xsl:when test="($java6AppTestRes = 'false' and $java6PatchTestRes='false')">
                        <xsl:text>com.mcafee.pa.msg.aixJavaPatch6NotInstalled</xsl:text>
                    </xsl:when>
                    <xsl:when test="($java7AppTestRes = 'false' and $java7PatchTestRes='false')">
                        <xsl:text>com.mcafee.pa.msg.aixJavaPatch7NotInstalled</xsl:text>
                    </xsl:when>
                </xsl:choose>
            </xsl:if>
            <xsl:if test="$result='false'">
                <xsl:choose>
                    <xsl:when test="$java5AppTestRes = 'false' and $java6AppTestRes='false' and $java7AppTestRes = 'false'">
                        <xsl:text>com.mcafee.pa.msg.aixAppVerNotApplicable</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>com.mcafee.pa.msg.aixAppAptchInstalled</xsl:text>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:if>
        </xsl:variable>
        
        <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
            <xsl:attribute name="id">
                <xsl:value-of select="$definitionId"/>
            </xsl:attribute>
            <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="messageId">
                    <xsl:value-of select="$message_id"/>
                </xsl:attribute>
                <xsl:attribute name="isViolation">
                    <xsl:value-of select="$isViolationValue"/>
                </xsl:attribute>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">vulnerability</xsl:attribute>
                    <xsl:value-of select="$title"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">product</xsl:attribute>
                    <xsl:value-of select="$product"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">java5Fileset</xsl:attribute>
                    <xsl:value-of select="$java5Fileset"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">java6Fileset</xsl:attribute>
                    <xsl:value-of select="$java6Fileset"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">java7Fileset</xsl:attribute>
                    <xsl:value-of select="$java7Fileset"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">expectedJava5Ver</xsl:attribute>
                    <xsl:value-of select="$expectedJava5Ver" />
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">expectedJava6Ver</xsl:attribute>
                    <xsl:value-of select="$expectedJava6Ver" />
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">expectedJava7Ver</xsl:attribute>
                    <xsl:value-of select="$expectedJava7Ver" />
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">fileset</xsl:attribute>
                    <xsl:value-of select="$fileset" />
                </xsl:element>
            </xsl:element>
        </xsl:element>
    </xsl:template>
</xsl:stylesheet>