<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
    xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def ind-sc ind-def">
    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>
    
    <!-- This library is the modified version of the existing library linuxConfigTextFileContent54ExtVarChecks.xsl.
           Messages are modified as required.
           
           Logic :-
           <criteria operator="OR">
               <criteria operator="AND">
                   <criterion comment="Test for the existence of the file" negate="true" test_ref="oval:com.mcafee.oval:tst:236996"/>
                   <criterion comment="External variable set to disable" test_ref="oval:com.mcafee.oval:tst:239661"/>
                </criteria>
               <criterion comment="Verify the enable / disable status for - Additional Logging of vsftpd daemon for the parameter xferlog_std_format as per the user input" test_ref="oval:com.mcafee.oval:tst:236995"/>       
           </criteria>
           
           with External variables.
           
           Ex. OVAL ID - oval:com.mcafee.oval:def:236999
    -->
    <xsl:param name="defid" />
    <xsl:template match="/">
        <xsl:call-template name="getFindings">
            <xsl:with-param name="definitionId" select="$defid"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
         <xsl:variable name="result" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <!-- Collect configuration name from the title ......................................... --> 
        <xsl:variable name="Definitions" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
        <xsl:variable name="title" select="$Definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>
        
       <!-- Collect all the required data from the checks like test ref, obj ref, ste ref and their data and results ......................................... --> 
        
        <xsl:variable name="fileContentTest_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test/@id"/>
        <xsl:variable name="extVar_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables/oval-def:external_variable/@id"/>
        
        <xsl:variable name="result1" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[1]/@result"/>
               
        <xsl:variable name="definitionTextFileTest" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTest_id]"/>
        <xsl:variable name="textfile53Path" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest/ind-def:object/@object_ref]/ind-def:path/text()" />
        <xsl:variable name="textfile53Name" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest/ind-def:object/@object_ref]/ind-def:filename/text()" />
        
        <xsl:variable name="fileInfo">
             <xsl:value-of select="concat($textfile53Path,'/', $textfile53Name)"/>
        </xsl:variable>
        
        <xsl:variable name="filecontentObj_ref" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTest_id]/ind-def:object/@object_ref" />
        <xsl:variable name="filecontentObj_flag" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:collected_objects/oval-sc:object[@id=$filecontentObj_ref]/@flag"/>
        
        <xsl:variable name="filecontentitem_id" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$fileContentTest_id]/oval-res:tested_item/@item_id"/>        
        <xsl:variable name="filecontentitem54" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/ind-sc:textfilecontent54_item[@id=$filecontentitem_id]" />
        <xsl:variable name="filecontentitem" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/ind-sc:textfilecontent_item[@id=$filecontentitem_id]" />
        
        <xsl:variable name="actualConfig">
            <xsl:choose>
                <xsl:when test="not($filecontentitem54)">
                    <xsl:value-of select="$filecontentitem/ind-sc:subexpression/text()"/>
                </xsl:when>
                <xsl:when test="not($filecontentitem)">
                    <xsl:value-of select="$filecontentitem54/ind-sc:subexpression/text()"/>
                </xsl:when>
            </xsl:choose>   
        </xsl:variable>
        
        <xsl:variable name="expectedConfig" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$fileContentTest_id]/oval-res:tested_variable[@variable_id=$extVar_id]/text()"/>       
                
        <!-- Decide about the message id depending upon  the combination of results for various criterions ........................................................................................... -->
        <xsl:variable name="message_id">
            <!-- Check if result is true ........................................................................................... -->
            <xsl:if test="$result='true'">
                <xsl:choose>
                    <xsl:when test="$actualConfig!=''" >
                        <xsl:text>com.mcafee.pa.msg.configStatusSCAP</xsl:text>
                    </xsl:when>                    
                    <xsl:otherwise>
                        <xsl:text>com.mcafee.pa.msg.PatternMatchSCAP</xsl:text>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:if>            
            <!-- Check if result is false ........................................................................................... -->
            <xsl:if test="$result='false' ">                
                <xsl:choose>
                    <xsl:when test="$actualConfig != '' and $expectedConfig!='' ">
                        <xsl:text>com.mcafee.pa.msg.configStatusSCAP</xsl:text>
                    </xsl:when>
                    <xsl:when test="$result1 = 'true'">
                        <xsl:text>com.mcafee.pa.msg.configNotSet</xsl:text>
                    </xsl:when>
                </xsl:choose>
            </xsl:if>  
        </xsl:variable>
        
        <xsl:variable name="isViolationValue">
            <xsl:choose>
                <xsl:when test="$result = 'false' ">
                    <xsl:text>true</xsl:text>
                </xsl:when>
                <xsl:when test="$result = 'true' ">
                    <xsl:text>false</xsl:text>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
            <xsl:attribute name="id">
                <xsl:value-of select="$definitionId"/>
            </xsl:attribute>
            <xsl:element name="inputValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="key">expected_config</xsl:attribute>
                <xsl:value-of select="$expectedConfig" />
            </xsl:element>
            <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="messageId">
                    <xsl:value-of select="$message_id"/>
                </xsl:attribute>
                <xsl:attribute name="isViolation">
                    <xsl:value-of select="$isViolationValue"/>
                </xsl:attribute>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">file_info</xsl:attribute>
                    <xsl:value-of select="$fileInfo"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">config_name</xsl:attribute>
                    <xsl:value-of select="$title"/>
                </xsl:element>
                <xsl:element name="actualValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">actual_config</xsl:attribute>
                    <xsl:value-of select="$actualConfig"/>
                </xsl:element>
            </xsl:element>
        </xsl:element>
        
    </xsl:template>
</xsl:stylesheet>