<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
    xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def ind-sc ind-def">
    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>
    
    <!-- This library is to handle the OVAL checks with the only two text file tests.
        Text file test verifies if a specific patterns of text is present in the configuration file in test.
        
        Logic :-
        <criteria operator="AND">
        <criterion comment="Verify no legacy '+' entries exist in passwd" test_ref="oval:com.mcafee.oval:tst:50153" />
        <criterion comment="Verify no legacy '+' entries exist in shadow" test_ref="oval:com.mcafee.oval:tst:50154" />
        <criterion comment="Verify no legacy '+' entries exist in group" test_ref="oval:com.mcafee.oval:tst:50155" />
        </criteria>
        
        Ex. OVAL ID - oval:com.mcafee.oval:def:50153
    -->
    
    <xsl:param name="defid" />
    <xsl:template match="/">
        <xsl:call-template name="getFindings">
            <xsl:with-param name="definitionId" select="$defid"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        <xsl:variable name="result" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <xsl:variable name="fileContentTest_id1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent_test[1]/@id"/>
        <xsl:variable name="result1" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$fileContentTest_id1]/@result"/>
        
        <xsl:variable name="definitionTextFileTest1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent_test[@id=$fileContentTest_id1]"/>
        <xsl:variable name="textfilePath1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent_object[@id=$definitionTextFileTest1/ind-def:object/@object_ref]/ind-def:path/text()" />
        <xsl:variable name="textfileName1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent_object[@id=$definitionTextFileTest1/ind-def:object/@object_ref]/ind-def:filename/text()" />
        <xsl:variable name="textfilePattern1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent_object[@id=$definitionTextFileTest1/ind-def:object/@object_ref]/ind-def:line/text()" />
        <xsl:variable name="fileInfo1">
             <xsl:value-of select="concat($textfilePath1,'/', $textfileName1)"/>
        </xsl:variable>
        
        <xsl:variable name="fileContentTest_id2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent_test[2]/@id"/>
        <xsl:variable name="result2" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$fileContentTest_id2]/@result"/>
        
        <xsl:variable name="definitionTextFileTest2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent_test[@id=$fileContentTest_id2]"/>
        <xsl:variable name="textfilePath2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent_object[@id=$definitionTextFileTest2/ind-def:object/@object_ref]/ind-def:path/text()" />
        <xsl:variable name="textfileName2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent_object[@id=$definitionTextFileTest2/ind-def:object/@object_ref]/ind-def:filename/text()" />
        <xsl:variable name="textfilePattern2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent_object[@id=$definitionTextFileTest2/ind-def:object/@object_ref]/ind-def:line/text()" />
        <xsl:variable name="fileInfo2">
            <xsl:value-of select="concat($textfilePath2,'/', $textfileName2)"/>
        </xsl:variable>
        
        <xsl:variable name="fileContentTest_id3" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent_test[3]/@id"/>
        <xsl:variable name="result3" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$fileContentTest_id3]/@result"/>
        
        <xsl:variable name="definitionTextFileTest3" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent_test[@id=$fileContentTest_id3]"/>
        <xsl:variable name="textfilePath3" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent_object[@id=$definitionTextFileTest3/ind-def:object/@object_ref]/ind-def:path/text()" />
        <xsl:variable name="textfileName3" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent_object[@id=$definitionTextFileTest3/ind-def:object/@object_ref]/ind-def:filename/text()" />
        <xsl:variable name="textfilePattern3" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent_object[@id=$definitionTextFileTest3/ind-def:object/@object_ref]/ind-def:line/text()" />
        <xsl:variable name="fileInfo3">
            <xsl:value-of select="concat($textfilePath3,'/', $textfileName3)"/>
        </xsl:variable>
        
        <xsl:variable name="title" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>
        
        <xsl:variable name="fileInfo">
            <xsl:choose>
                <xsl:when test="$fileInfo1=$fileInfo2=$fileInfo3">
                    <xsl:value-of select="$fileInfo1"/>
                </xsl:when>
                <xsl:otherwise>
                        <xsl:value-of select="concat($fileInfo1,', ', $fileInfo2, ', ','and ', $fileInfo3)"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="isViolationValue">
            <xsl:choose>
                <xsl:when test="$result = 'false' ">
                    <xsl:text>true</xsl:text>
                </xsl:when>
                <xsl:when test="$result = 'true' ">
                    <xsl:text>false</xsl:text>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="message_id">
            <!-- Check if result is true ......................................... -->
            <xsl:if test="$result='true'">
                <xsl:text>com.mcafee.pa.msg.PatternMatchSCAP</xsl:text>
            </xsl:if>           
            
            <!-- Check if result is false .......................................-->
            <xsl:if test="$result='false' ">
                <xsl:choose>
                    <xsl:when test="$result1='false' and $result2='false' and $result3='false'">
                        <xsl:text>com.mcafee.pa.msg.Pattern234MissingSCAP</xsl:text>
                    </xsl:when>
                    <xsl:when test="$result1='false' and $result2='true' and $result3='true'">
                        <xsl:text>com.mcafee.pa.msg.MissingPat1SCAP</xsl:text>
                    </xsl:when>
                     <xsl:when test="$result1='true' and $result2='false' and $result3='true'">
                           <xsl:text>com.mcafee.pa.msg.MissingPat2SCAP</xsl:text>
                    </xsl:when>
                    <xsl:when test="$result1='true' and $result2='true' and $result3='false'">
                        <xsl:text>com.mcafee.pa.msg.MissingPat3SCAP</xsl:text>
                    </xsl:when>
                    
                    <xsl:when test="$result1='false' and $result2='false' and $result3='true'">
                        <xsl:text>com.mcafee.pa.msg.MissingPatSCAP</xsl:text>
                    </xsl:when>
                    <xsl:when test="$result1='false' and $result2='true' and $result3='false'">
                        <xsl:text>com.mcafee.pa.msg.Missing13PatSCAP</xsl:text>
                    </xsl:when>
                    <xsl:when test="$result1='true' and $result2='false' and $result3='false'">
                        <xsl:text>com.mcafee.pa.msg.Missing23PatSCAP</xsl:text>
                    </xsl:when>
                </xsl:choose>
                </xsl:if>
        </xsl:variable>
        
        <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
            <xsl:attribute name="id">
                <xsl:value-of select="$definitionId"/>
            </xsl:attribute>
            <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="messageId">
                    <xsl:value-of select="$message_id"/>
                </xsl:attribute>
                <xsl:attribute name="isViolation">
                    <xsl:value-of select="$isViolationValue"/>
                </xsl:attribute>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">config_name</xsl:attribute>
                    <xsl:value-of select="$title"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">textfilePattern1</xsl:attribute>
                    <xsl:value-of select="$textfilePattern1"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">textfilePattern2</xsl:attribute>
                    <xsl:value-of select="$textfilePattern2"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">textfilePattern3</xsl:attribute>
                    <xsl:value-of select="$textfilePattern3"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">file_info</xsl:attribute>
                    <xsl:value-of select="$fileInfo"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">file_info1</xsl:attribute>
                    <xsl:value-of select="$fileInfo1"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">file_info2</xsl:attribute>
                    <xsl:value-of select="$fileInfo2"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">file_info3</xsl:attribute>
                    <xsl:value-of select="$fileInfo3"/>
                </xsl:element>
            </xsl:element>
        </xsl:element>
    </xsl:template>
</xsl:stylesheet>

