<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
  xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
  xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
  xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
  xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
  xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
  xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
  exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def ind-sc ind-def">
  <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>

  <!-- This library is to handle the OVAL checks with the text file test, file existence test and inetd test.
         Text file test verifies if a specific pattern of text is not present in the configuration file in test.
         Inetd test verified if a server argument parameter is set appropriately for wuftpd. If a specific
         file for wu-ftpd does not exist on a system then result is a pass.
         
          Logic :-
          <criteria operator='OR'>
            <criterion negate='true' comment='Test for the existence of the file' test_ref='oval:com.mcafee.oval:tst:237170' /> - file existence test
            <criteria operator="AND">
              <criterion test_ref='oval:com.mcafee.oval:tst:237171' comment="Verify the  Additional Logging of wu-ftpd Daemon configuration for the parameter WU_OPTIONS in /etc/default/wuftpd file"/> - textfile content test
              <criterion test_ref='oval:com.mcafee.oval:tst:237172' comment="Verify the  Additional Logging of wu-ftpd Daemon configuration in /etc/inetd.conf file"/> - inetd test
            </criteria>
          </criteria>
          
          without external variable & OVAL State.
          
          Ex. OVAL ID - oval:com.mcafee.oval:def:237169
  -->

  <xsl:param name="defid" />
  <xsl:template match="/">
    <xsl:call-template name="getFindings">
      <xsl:with-param name="definitionId" select="$defid"/>
    </xsl:call-template>
  </xsl:template>
  
  <xsl:template name="getFindings">
    <xsl:param name="definitionId"/>
    <xsl:variable name="result" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
    
    <xsl:variable name="fileTest_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test[1]/@id"/>
    <xsl:variable name="FileTestresult" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$fileTest_id]/@result"/>
    
    <xsl:variable name="definitionFileTest" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test[@id=$fileTest_id]"/>
    <xsl:variable name="filePath" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:file_object[@id=$definitionFileTest/unix-def:object/@object_ref]/unix-def:path/text()" />
    <xsl:variable name="fileName" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:file_object[@id=$definitionFileTest/unix-def:object/@object_ref]/unix-def:filename/text()" />
    
    <xsl:variable name="fileInfo">
      <xsl:value-of select="concat($filePath, '/', $fileName)"/>
    </xsl:variable>
    
    <xsl:variable name="fileContentTest_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test/@id"/>
    <xsl:variable name="definitionTextFileTest" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTest_id]"/>
    
    <xsl:variable name="FileContRes" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$fileContentTest_id]/@result"/>
    <xsl:variable name="textfile53Path" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest/ind-def:object/@object_ref]/ind-def:path/text()" />
    <xsl:variable name="textfile53Name" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest/ind-def:object/@object_ref]/ind-def:filename/text()" />
    <xsl:variable name="textfilePattern" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest/ind-def:object/@object_ref]/ind-def:pattern/text()" />
    
    <xsl:variable name="inetdPattern" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states/unix-def:inetd_state/unix-def:server_arguments/text()" />
  
    <xsl:variable name="wuftpdFileInfo">
      <xsl:value-of select="concat($textfile53Path,'/', $textfile53Name)"/>
    </xsl:variable>
    
    <xsl:variable name="inetdFileTest_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test[2]/@id"/>
    <xsl:variable name="inetdFileTestresult" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$inetdFileTest_id]/@result"/>
    
    <xsl:variable name="inetdFileTest" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test[@id=$inetdFileTest_id]"/>
    <xsl:variable name="inetdFilePath" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:file_object[@id=$inetdFileTest/unix-def:object/@object_ref]/unix-def:path/text()" />
    <xsl:variable name="inetdFileName" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:file_object[@id=$inetdFileTest/unix-def:object/@object_ref]/unix-def:filename/text()" />
    <xsl:variable name="inetdFileInfo" select="concat($inetdFilePath, $inetdFileName)"/>

    
    <xsl:variable name="inetdTest_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:inetd_test/@id"/>
    <xsl:variable name="inetdTestresult" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$inetdTest_id]/@result"/>
    
    <xsl:variable name="title" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>
    
    <xsl:variable name="isViolationValue">
      <xsl:choose>
        <xsl:when test="$result = 'false' ">
          <xsl:text>true</xsl:text>
        </xsl:when>
        <xsl:when test="$result = 'true' ">
          <xsl:text>false</xsl:text>
        </xsl:when>
      </xsl:choose>
    </xsl:variable>
    
    <xsl:variable name="message_id">
      <!-- Check if result is true ......................................... -->
      <xsl:if test="$result='true'">
        <xsl:choose>
          <xsl:when test="$FileTestresult='true'">
            <xsl:text>com.mcafee.pa.msg.configfileDoesNotExists</xsl:text>    
          </xsl:when>
            <xsl:otherwise>
              <xsl:text>com.mcafee.pa.msg.PatternMatchSCAP</xsl:text>
            </xsl:otherwise>
        </xsl:choose>
      </xsl:if>            
      <!-- Check if result is false .......................................-->
      <xsl:if test="$result='false' ">                
        <xsl:choose>
          <xsl:when test="$FileTestresult='false' and $FileContRes='false' and $inetdFileTestresult='true' and $inetdTestresult='false'">
            <xsl:text>com.mcafee.pa.msg.configWuftpdInetdLogSCAP</xsl:text>
          </xsl:when>
          <xsl:when test="$FileTestresult='false' and $FileContRes='true' and $inetdFileTestresult='true' and $inetdTestresult='false'">
            <xsl:text>com.mcafee.pa.msg.configInetdLogSCAP</xsl:text>
          </xsl:when>
          <xsl:when test="$FileTestresult='false' and $FileContRes='false' and $inetdFileTestresult='true' and $inetdTestresult='true'">
            <xsl:text>com.mcafee.pa.msg.configWuftpdLogSCAP</xsl:text>
          </xsl:when>
          <xsl:when test="$FileTestresult='false' and $FileContRes='true' and $inetdFileTestresult='false'">
            <xsl:text>com.mcafee.pa.msg.InetdWuftpdStatusSCAP</xsl:text>
          </xsl:when>
          <xsl:when test="$FileTestresult='false' and $FileContRes='false' and $inetdFileTestresult='false'">
            <xsl:text>com.mcafee.pa.msg.configWuftpdInetdStatusSCAP</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>com.mcafee.pa.msg.configGenericSCAP</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:if>  
    </xsl:variable>
    
    <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
      <xsl:attribute name="id">
        <xsl:value-of select="$definitionId"/>
      </xsl:attribute>
      <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
        <xsl:attribute name="messageId">
          <xsl:value-of select="$message_id"/>
        </xsl:attribute>
        <xsl:attribute name="isViolation">
          <xsl:value-of select="$isViolationValue"/>
        </xsl:attribute>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">file_info</xsl:attribute>
          <xsl:value-of select="$fileInfo"/>
        </xsl:element>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">config_name</xsl:attribute>
          <xsl:value-of select="$title"/>
        </xsl:element>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">wuftpdFileInfo</xsl:attribute>
          <xsl:value-of select="$wuftpdFileInfo"/>
        </xsl:element>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">inetdFileInfo</xsl:attribute>
          <xsl:value-of select="$inetdFileInfo"/>
        </xsl:element>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">wuftpdPattern</xsl:attribute>
          <xsl:value-of select="$textfilePattern"/>
        </xsl:element>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">inetdPattern</xsl:attribute>
          <xsl:value-of select="$inetdPattern"/>
        </xsl:element>
      </xsl:element>
    </xsl:element>
</xsl:template>
</xsl:stylesheet>