<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
    xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def ind-sc ind-def">
    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>

    <!-- 
      
     This library works fine for the below check logic:          
          
          <criteria operator="AND">
              <criterion comment="Test for the existence of the file - /etc/audit/audit.rules" test_ref="oval:com.mcafee.oval:tst:98687" />
                  <criteria operator="OR">
                      <criteria operator="AND" comment="For 64-bit arch">
                          <criterion negate='false' comment='ix64 architecture' test_ref='oval:com.mcafee.oval:tst:6784' />
                          <criterion comment='Verify if the /etc/audit/audit.rules file is set with appropriate -S adjtimex -S settimeofday parameter for 64-bit architecture.' test_ref='oval:com.mcafee.oval:tst:402479' />
                          <criterion comment='Verify if the /etc/audit/audit.rules file is set with appropriate -S clock_settime -k time-change parameter for 64-bit architecture.' test_ref='oval:com.mcafee.oval:tst:402480' />
                          <criterion comment='Verify if the /etc/audit/audit.rules file is set with appropriate -S adjtimex -S settimeofday -S stime -k time-change parameter for 32-bit architecture.' test_ref='oval:com.mcafee.oval:tst:402481' />
                          <criterion comment='Verify if the /etc/audit/audit.rules file is set with appropriate -S clock_settime -k time-change parameter for 32-bit architecture.' test_ref='oval:com.mcafee.oval:tst:402482' />
                      </criteria>
                      <criteria operator="AND" comment="For 32-bit arch">
                          <criterion negate='false' comment='ix86 architecture' test_ref='oval:org.mitre.oval:tst:3912' />
                          <criterion comment='Verify if the /etc/audit/audit.rules file is set with appropriate -S adjtimex -S settimeofday -S stime -k time-change parameter for 32-bit architecture.' test_ref='oval:com.mcafee.oval:tst:402481' />
                          <criterion comment='Verify if the /etc/audit/audit.rules file is set with appropriate -S clock_settime -k time-change parameter for 32-bit architecture.' test_ref='oval:com.mcafee.oval:tst:402482' />
                      </criteria>
                  </criteria> 
          <criterion comment='Verify if the /etc/audit/audit.rules file is set with appropriate -w /etc/localtime -p wa -k time-change parameter.' test_ref='oval:com.mcafee.oval:tst:402483' />
          </criteria>
     
     Example def if : oval:com.mcafee.oval:def:402478
    -->
    <xsl:param name="defid" />
    <xsl:template match="/">
        <xsl:call-template name="getFindings">
            <xsl:with-param name="definitionId" select="$defid" />
        </xsl:call-template>
    </xsl:template>

    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
         <xsl:variable name="result" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <!-- Collect service name from the title ......................................... --> 
        <xsl:variable name="Definitions" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
        <xsl:variable name="title" select="$Definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>
        
       <!-- Collect all results for the criterias in the variables ......................................... --> 
        
        <xsl:variable name="result1" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[1]/@result"/>
        
        <xsl:variable name="result2_64bit" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[2]/@result"/>        
        <xsl:variable name="result3" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[3]/@result"/>
        <xsl:variable name="result4" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[4]/@result"/>
        <xsl:variable name="result5" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[5]/@result"/>
        <xsl:variable name="result6" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[6]/@result"/>
        
        <xsl:variable name="result7_32bit" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[7]/@result"/>
        <xsl:variable name="result8" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[8]/@result"/>          
        <xsl:variable name="result9" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[9]/@result"/>
        
        <xsl:variable name="result10" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[10]/@result"/>
        
        <xsl:variable name="fileTest_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test/@id"/>
        <xsl:variable name="definitionFileTest" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test[@id=$fileTest_id]"/>        
        <xsl:variable name="filePath" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:file_object[@id=$definitionFileTest/unix-def:object/@object_ref]/unix-def:path/text()" />
        <xsl:variable name="fileName" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:file_object[@id=$definitionFileTest/unix-def:object/@object_ref]/unix-def:filename/text()" />
        
        
        <xsl:variable name="fileContentTest_id1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[1]/@id"/>
        <xsl:variable name="definitionTextFileTest1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTest_id1]"/>
        <xsl:variable name="textfile53Path1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest1/ind-def:object/@object_ref]/ind-def:path/text()"/>
        <xsl:variable name="textfile53Name1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest1/ind-def:object/@object_ref]/ind-def:filename/text()"/>
        <xsl:variable name="textfilePat1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest1/ind-def:object/@object_ref]/ind-def:pattern/text()"/>
        
        <xsl:variable name="fileContentTest_id2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[2]/@id"/>
        <xsl:variable name="definitionTextFileTest2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTest_id2]"/>
        <xsl:variable name="textfile53Path2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest2/ind-def:object/@object_ref]/ind-def:path/text()"/>
        <xsl:variable name="textfile53Name2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest2/ind-def:object/@object_ref]/ind-def:filename/text()"/>
        <xsl:variable name="textfilePat2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest2/ind-def:object/@object_ref]/ind-def:pattern/text()"/>
        
        <xsl:variable name="fileContentTest_id3" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[3]/@id"/>
        <xsl:variable name="definitionTextFileTest3" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTest_id3]"/>
        <xsl:variable name="textfile53Path3" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest3/ind-def:object/@object_ref]/ind-def:path/text()"/>
        <xsl:variable name="textfile53Name3" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest3/ind-def:object/@object_ref]/ind-def:filename/text()"/>
        <xsl:variable name="textfilePat3" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest3/ind-def:object/@object_ref]/ind-def:pattern/text()"/>
        
        <xsl:variable name="fileContentTest_id4" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[4]/@id"/>
        <xsl:variable name="definitionTextFileTest4" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTest_id4]"/>
        <xsl:variable name="textfile53Path4" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest4/ind-def:object/@object_ref]/ind-def:path/text()"/>
        <xsl:variable name="textfile53Name4" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest4/ind-def:object/@object_ref]/ind-def:filename/text()"/>
        <xsl:variable name="textfilePat4" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest4/ind-def:object/@object_ref]/ind-def:pattern/text()"/>
        
        <xsl:variable name="fileContentTest_id5" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[5]/@id"/>
        <xsl:variable name="definitionTextFileTest5" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTest_id5]"/>
        <xsl:variable name="textfile53Path5" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest5/ind-def:object/@object_ref]/ind-def:path/text()"/>
        <xsl:variable name="textfile53Name5" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest5/ind-def:object/@object_ref]/ind-def:filename/text()"/>
        <xsl:variable name="textfilePat5" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest5/ind-def:object/@object_ref]/ind-def:pattern/text()"/>
        
        
        <xsl:variable name="fileInfo">
            <xsl:value-of select="concat($filePath,'/', $fileName,' ')"/>
        </xsl:variable>
        
        <xsl:variable name="textfilePat">
            <xsl:value-of select="concat($textfilePat1,', ',$textfilePat2,', ',$textfilePat3,', ',$textfilePat4,' and ',$textfilePat5,' ')"/>
        </xsl:variable>
        
        <!-- Decide about the message id depending upon  the combination of results for various criterions ........................................................................................... -->
        <xsl:variable name="message_id">
            <!-- Check if result is true ........................................................................................... -->
            <xsl:if test="$result='true'">
                <xsl:text>com.mcafee.pa.msg.PatternMatchSCAP</xsl:text>
            </xsl:if>            
            <!-- Check if result is false ........................................................................................... -->
            <xsl:if test="$result='false'">
                <xsl:choose>
                    <xsl:when test="$result1 = 'false'">
                        <xsl:text>com.mcafee.pa.msg.configfilesDoesNotExists</xsl:text>
                    </xsl:when>
                    <xsl:when test="($result1 = 'true' and $result10 = 'false') and ($result3='true' and $result4='true' and $result5='true' and $result6='true')">
                        <xsl:text>com.mcafee.pa.msg.Patterns5MissingSCAP</xsl:text>
                    </xsl:when>
                    <xsl:when test="($result1 = 'true' and $result2_64bit = 'true') and ($result3='false' and $result4='false' and $result5='false' and $result6='false')">
                        <xsl:text>com.mcafee.pa.msg.Patterns1234MissingSCAP</xsl:text>
                    </xsl:when>
                    <xsl:when test="($result1 = 'true' and $result2_64bit = 'true') and ($result3='false' and $result4='false' and $result5='false' and $result6='true')">
                        <xsl:text>com.mcafee.pa.msg.Patterns123MissingSCAP</xsl:text>
                    </xsl:when>
                    <xsl:when test="($result1 = 'true' and $result2_64bit = 'true') and ($result3='false' and $result4='false' and $result5='true' and $result6='false')">
                        <xsl:text>com.mcafee.pa.msg.Patterns124MissingSCAP</xsl:text>
                    </xsl:when>
                    <xsl:when test="($result1 = 'true' and $result2_64bit = 'true') and ($result3='false' and $result4='true' and $result5='false' and $result6='false')">
                        <xsl:text>com.mcafee.pa.msg.Patterns134MissingSCAP</xsl:text>
                    </xsl:when>
                    <xsl:when test="($result1 = 'true' and $result2_64bit = 'true') and ($result3='false' and $result4='false' and $result5='true' and $result6='true')">
                        <xsl:text>com.mcafee.pa.msg.Patterns12MissingSCAP</xsl:text>
                    </xsl:when>
                    <xsl:when test="($result1 = 'true' and $result2_64bit = 'true') and ($result3='true' and $result4='false' and $result5='false' and $result6='true')">
                        <xsl:text>com.mcafee.pa.msg.Patterns23MissingSCAP</xsl:text>
                    </xsl:when>
                    <xsl:when test="($result1 = 'true' and $result2_64bit = 'true') and ($result3='true' and $result4='true' and $result5='false' and $result6='false')">
                        <xsl:text>com.mcafee.pa.msg.Patterns34MissingSCAP</xsl:text>
                    </xsl:when>
                    <xsl:when test="($result1 = 'true' and $result2_64bit = 'true') and ($result3='false' and $result4='true' and $result5='true' and $result6='false')">
                        <xsl:text>com.mcafee.pa.msg.Patterns14MissingSCAP</xsl:text>
                    </xsl:when>
                    <xsl:when test="($result1 = 'true' and $result2_64bit = 'true') and ($result3='false' and $result4='true' and $result5='false' and $result6='true')">
                        <xsl:text>com.mcafee.pa.msg.Patterns13MissingSCAP</xsl:text>
                    </xsl:when>
                    <xsl:when test="($result1 = 'true' and $result2_64bit = 'true') and ($result3='true' and $result4='false' and $result5='true' and $result6='false')">
                        <xsl:text>com.mcafee.pa.msg.Patterns24MissingSCAP</xsl:text>
                    </xsl:when>
                    <xsl:when test="($result1 = 'true' and $result2_64bit = 'true') and ($result3='false' and $result4='true' and $result5='true' and $result6='true')">
                        <xsl:text>com.mcafee.pa.msg.Patterns1MissingSCAP</xsl:text>
                    </xsl:when>
                    <xsl:when test="($result1 = 'true' and $result2_64bit = 'true') and ($result3='true' and $result4='false' and $result5='true' and $result6='true')">
                        <xsl:text>com.mcafee.pa.msg.Patterns2MissingSCAP</xsl:text>
                    </xsl:when>
                    <xsl:when test="($result1 = 'true' and $result2_64bit = 'true') and ($result3='true' and $result4='true' and $result5='false' and $result6='true')">
                        <xsl:text>com.mcafee.pa.msg.Patterns3MissingSCAP</xsl:text>
                    </xsl:when>
                    <xsl:when test="($result1 = 'true' and $result2_64bit = 'true') and ($result3='true' and $result4='true' and $result5='true' and $result6='false')">
                        <xsl:text>com.mcafee.pa.msg.Patterns4MissingSCAP</xsl:text>
                    </xsl:when>
                    
                    
                    <xsl:when test="($result1 = 'true' and $result7_32bit = 'true') and ($result8='false' and $result9='false')">
                        <xsl:text>com.mcafee.pa.msg.Patterns24MissingSCAP</xsl:text>
                    </xsl:when>
                    <xsl:when test="($result1 = 'true' and $result7_32bit = 'true') and ($result8='false' and $result9='true')">
                        <xsl:text>com.mcafee.pa.msg.Patterns2MissingSCAP</xsl:text>
                    </xsl:when>
                    <xsl:when test="($result1 = 'true' and $result7_32bit = 'true') and ($result8='true' and $result9='false')">
                        <xsl:text>com.mcafee.pa.msg.Patterns4MissingSCAP</xsl:text>
                    </xsl:when>
                </xsl:choose>
            </xsl:if>  
        </xsl:variable>
        
        <xsl:variable name="isViolationValue">
            <xsl:choose>
                <xsl:when test="$result = 'false' ">
                    <xsl:text>true</xsl:text>
                </xsl:when>
                <xsl:when test="$result = 'true' ">
                    <xsl:text>false</xsl:text>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
                
        <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
            <xsl:attribute name="id">
                <xsl:value-of select="$definitionId"/>
            </xsl:attribute>        
            <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="messageId">
                    <xsl:value-of select="$message_id"/>
                </xsl:attribute>
                <xsl:attribute name="isViolation">
                    <xsl:value-of select="$isViolationValue"/>
                </xsl:attribute>                
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">config_name</xsl:attribute>
                    <xsl:value-of select="$title"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">file_info</xsl:attribute>
                    <xsl:value-of select="$fileInfo"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">pattern</xsl:attribute>
                    <xsl:value-of select="$textfilePat"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">textfilePattern1</xsl:attribute>
                    <xsl:value-of select="$textfilePat1"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">textfilePattern2</xsl:attribute>
                    <xsl:value-of select="$textfilePat2"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">textfilePattern3</xsl:attribute>
                    <xsl:value-of select="$textfilePat3"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">textfilePattern4</xsl:attribute>
                    <xsl:value-of select="$textfilePat4"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">textfilePattern5</xsl:attribute>
                    <xsl:value-of select="$textfilePat5"/>
                </xsl:element>
            </xsl:element>
        </xsl:element>
    </xsl:template>
</xsl:stylesheet>