<xsl:stylesheet version="1.1" 
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema"   
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows">
    <xsl:output indent="yes"/>
    <!-- This template expects the definition to have 
                    criteria (AND)
                        criteria (OR)
                            criterion1 -  regkey does not exist 
                            criterion2 -  reg key value is 4 (disabled )
                        Criterion windows platform  
    It also expects the title to begin with hte service followed by 'Service' - which is how these are built as of June 11, 2009
    
    Nothing is output if any of the three criterion do not exist in the hierarchy as described above.
    
    -->
    <xsl:template name="winServiceStartupDisabled">
        <xsl:param name="definitionId"></xsl:param>
        <xsl:param name="hasPlatformCriterion">true</xsl:param>
        <xsl:variable name="serviceName1" select="substring-before(/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions/oval-def:definition[@id=$definitionId]/oval-def:metadata/oval-def:title,' Service')"></xsl:variable>
        <xsl:variable name="serviceName" select="concat($serviceName1,' Service')"/>

        <xsl:choose>
            <xsl:when test="$hasPlatformCriterion = 'true'">
                <xsl:variable name="existenceTestId" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/oval-res:criteria[1]/oval-res:criteria/oval-res:criterion[1]/@test_ref"/>
                <xsl:variable name="disabledTestId" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/oval-res:criteria[1]/oval-res:criteria/oval-res:criterion[2]/@test_ref"/>
                <xsl:variable name="platformTestId" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/oval-res:criteria[1]/oval-res:criterion[1]/@test_ref"/>
                <xsl:if test="$existenceTestId and $disabledTestId and $platformTestId " >
                    <xsl:call-template name="winServiceStartupDisabled2">
                        <xsl:with-param name="definitionId" select="$definitionId"></xsl:with-param>
                        <xsl:with-param name="existenceTestId" select="$existenceTestId"></xsl:with-param>
                        <xsl:with-param name="disabledTestId" select="$disabledTestId"></xsl:with-param>
                        <xsl:with-param name="platformTestId" select="$platformTestId"></xsl:with-param>
                        <xsl:with-param name="serviceName"  select="$serviceName"></xsl:with-param>
                    </xsl:call-template>
                </xsl:if>
            </xsl:when>
            <xsl:otherwise>
                <xsl:variable name="existenceTestId" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/oval-res:criteria[1]/oval-res:criterion[1]/@test_ref"/>
                <xsl:variable name="disabledTestId" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/oval-res:criteria[1]/oval-res:criterion[2]/@test_ref"/>
                <xsl:if test="$existenceTestId and $disabledTestId  " >
                    <xsl:call-template name="winServiceStartupDisabled2">
                        <xsl:with-param name="definitionId" select="$definitionId"></xsl:with-param>
                        <xsl:with-param name="existenceTestId" select="$existenceTestId"></xsl:with-param>
                        <xsl:with-param name="disabledTestId" select="$disabledTestId"></xsl:with-param>
                        <xsl:with-param name="serviceName"  select="$serviceName"></xsl:with-param>
                    </xsl:call-template>
                </xsl:if>
           </xsl:otherwise>
        </xsl:choose>
    </xsl:template>    
    
    <xsl:template name="winServiceStartupDisabled2">
        <xsl:param name="definitionId"></xsl:param>
        <xsl:param name="existenceTestId"></xsl:param>
        <xsl:param name="disabledTestId"></xsl:param>
        <xsl:param name="platformTestId"></xsl:param>
        <xsl:param name="serviceName"></xsl:param>
        <xsl:variable name="result" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>

        <xsl:variable name="existenceTestResult" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$existenceTestId]/@result"></xsl:variable>
        <xsl:variable name="existenceCriterionResult" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/oval-res:criteria/oval-res:criteria/oval-res:criterion[1]/@result"></xsl:variable>
        <xsl:variable name="disabledTestResult" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$disabledTestId]/@result"></xsl:variable>
        <xsl:variable name="platformTestResult" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$platformTestId]/@result"></xsl:variable>
        
        <xsl:variable name="itemRef" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$disabledTestId]/oval-res:tested_item/@item_id"/>
        <xsl:variable name="actual" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/win-sc:registry_item[@id=$itemRef]/win-sc:value"></xsl:variable>
        <xsl:variable name="expected" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$disabledTestId]/oval-res:tested_variable"></xsl:variable>
        
                 <findings  xmlns="http://results.pa.mcafee.com/findings/5.2" >
                    <xsl:attribute name="id"><xsl:value-of select="$definitionId"/></xsl:attribute>

                     <inputValue xmlns="http://results.pa.mcafee.com/findings/5.2" key="serviceName"><xsl:value-of select="$serviceName"/></inputValue>
                     
                            <xsl:variable name="messageId">
                                <xsl:call-template name="getMessageId">
                                    <xsl:with-param name="platformTestResult" select="$platformTestResult"></xsl:with-param>
                                    <xsl:with-param name="existenceCriterionResult" select="$existenceCriterionResult"></xsl:with-param>
                                    <xsl:with-param name="definitionId" select="$definitionId"></xsl:with-param>
                                    <xsl:with-param name="result" select="$result"></xsl:with-param>
                                </xsl:call-template>
                            </xsl:variable>
                        
                     <finding xmlns="http://results.pa.mcafee.com/findings/5.2" messageId="{$messageId}" isViolation="{$result = 'false'}">
                            <xsl:call-template name="winStartupActual">
                                <xsl:with-param name="actual" select="$actual"></xsl:with-param>
                            </xsl:call-template>
                         <actualValue xmlns="http://results.pa.mcafee.com/findings/5.2" key="desiredState"><xsl:call-template name="startupString"><xsl:with-param name="id" select="$expected"></xsl:with-param></xsl:call-template> </actualValue>
                     </finding>
                        
                </findings>
                
           
    </xsl:template>
    
    <xsl:template name="getMessageId">
        <xsl:param name="platformTestResult"></xsl:param>
        <xsl:param name="existenceCriterionResult"></xsl:param>
        <xsl:param name="definitionId"></xsl:param>
        <xsl:param name="result"></xsl:param>
        
        <xsl:choose>
            <xsl:when test="$existenceCriterionResult = 'true' ">
                <xsl:text>com.mcafee.pa.msgs.serviceNotExist</xsl:text>
            </xsl:when>
            <xsl:when test="$result = 'true'">
                <xsl:value-of select="$definitionId"/>
            </xsl:when>
            <xsl:when test="$platformTestResult = 'false'">
                <xsl:text>com.mcafee.pa.msgs.notWindowsPlatform</xsl:text>
            </xsl:when>
           <xsl:otherwise>
               <xsl:text>com.mcafee.pa.msgs.serviceNotDisabled</xsl:text>
           </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="winStartupActual">
        <xsl:param name="actual"></xsl:param>
        <actualValue xmlns="http://results.pa.mcafee.com/findings/5.2" key="actualState"><xsl:call-template name="startupString"><xsl:with-param name="id" select="$actual"></xsl:with-param></xsl:call-template> </actualValue>
    </xsl:template>
    
     <xsl:template name="startupString">
         <xsl:param name="id">0</xsl:param>
         <xsl:choose>
             <xsl:when test="$id=2">Automatic(2)</xsl:when>
             <xsl:when test="$id=3">Manual(3)</xsl:when>
             <xsl:when test="$id=4">Disabled(4)</xsl:when>
             <xsl:otherwise>Unknown</xsl:otherwise>
         </xsl:choose>
         
     </xsl:template>   
</xsl:stylesheet>
