<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:oval-win="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-sc-win="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
    exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc oval-win">

    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>
    <xsl:template name="fipsDefinition">
        <xsl:param name="definition_id"/>

        <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
            <xsl:attribute name="id" ><xsl:value-of select="$definition_id"/></xsl:attribute>
            <xsl:variable name="result"
                select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definition_id]/@result"/>
            <xsl:variable name="test_ids"
                select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/oval-win:registry_test/@id"/>
            <xsl:choose>
                <xsl:when test="$result='false'">
                    <xsl:call-template name="fipsTestFail" >
                        <xsl:with-param name="inputValue" select="$test_ids"/>
                    </xsl:call-template>
                </xsl:when>
                <xsl:when test="$result='true'">
                    <xsl:call-template name="fipsTestPass">
                        <xsl:with-param name="test_ids" select="$test_ids"/>
                    </xsl:call-template>
                </xsl:when>
            </xsl:choose>
        </xsl:element>
    </xsl:template>
    <xsl:template name="fipsTestFail">
        <xsl:choose>
            <xsl:when test="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/oval-sc-win:registry_item[@status]">
                <xsl:variable name="inputVal" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests//oval-res:tested_variable[1]/text()"/>
                <xsl:element name="inputValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">enabledDisabled</xsl:attribute>
                    <xsl:call-template name="mapEnabledDisabled">
                        <xsl:with-param name="value" select="$inputVal"/>
                    </xsl:call-template>
                </xsl:element>
                <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="messageId">com.mcafee.pa.msg.winconfigurationovalwindowsdef6102</xsl:attribute>
                    <xsl:attribute name="isViolation">true</xsl:attribute>
                    <xsl:element namespace="http://results.pa.mcafee.com/findings/5.2" name="actualValue">
                        <xsl:attribute name="key">currentEnabledDisabled</xsl:attribute>
                        <xsl:call-template name="reverseInputValue"><xsl:with-param name="value" select="$inputVal"></xsl:with-param></xsl:call-template>
                    </xsl:element>
                </xsl:element>
            </xsl:when>
            <xsl:otherwise>
                <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="messageId">com.mcafee.pa.msg.winnoconfigurationovalwindowsdef6102</xsl:attribute>
                    <xsl:attribute name="isViolation">true</xsl:attribute>
                </xsl:element>
            </xsl:otherwise>
        </xsl:choose>
        
    </xsl:template>
    <xsl:template name="fipsTestPass">
        <xsl:param name="test_ids" />
        <xsl:for-each select="$test_ids">
            <xsl:variable name="test" 
                select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=current()]"/>
            <xsl:if test="$test/@result='true'">
                <xsl:element name="inputValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">enabledDisabled</xsl:attribute>
                    <xsl:call-template name="mapEnabledDisabled">
                        <xsl:with-param name="value" select="$test/tested_variable[1]/text()"/>
                    </xsl:call-template>
                </xsl:element>
                <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="messageId">com.mcafee.pa.msg.winconfigurationovalwindowsdef6102</xsl:attribute>
                    <xsl:attribute name="isViolation">false</xsl:attribute>
                </xsl:element>
            </xsl:if>
        </xsl:for-each>
    </xsl:template>
    <xsl:template name="reverseInputValue">
        <xsl:param name="value" />
        <xsl:choose>
            <xsl:when test="$value=1"><xsl:call-template name="mapEnabledDisabled"><xsl:with-param name="value">0</xsl:with-param></xsl:call-template></xsl:when>
            <xsl:otherwise><xsl:call-template name="mapEnabledDisabled"><xsl:with-param name="value">1</xsl:with-param></xsl:call-template></xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="mapEnabledDisabled">
        <xsl:param name="value"/>
        <xsl:choose>
            <xsl:when test="$value=1">enabled (1)</xsl:when>
            <xsl:otherwise>disabled (0)</xsl:otherwise>
        </xsl:choose>
        
    </xsl:template>
</xsl:stylesheet>