<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
  xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
  xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
  xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
  xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
  xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
  xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
  xmlns:aix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#aix"
  xmlns:aix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#aix"
  exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def ind-sc ind-def aix-def aix-sc">
  <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>

  <!-- This library is to handle the OVAL checks with the text file test and file existence test.
         Text file test verifies if a specific pattern of text is not present in the configuration file in test.
         This is the modified version of LinuxConfigTextFileCont54PatMatchChecks.xsl
          
          Logic :-
          <criteria operator="OR">
          <criterion test_ref='oval:com.mcafee.oval:tst:247097' negate="true" comment="Test for the existence of  the X11.Dt* filesets" />
          <criterion comment='Ensure XDMCP port is disabled (/etc/dt/config/Xconfig)' test_ref='oval:com.mcafee.oval:tst:50063' />
          </criteria>
          
          without external variable & OVAL State.
          
          Ex. OVAL ID - oval:com.mcafee.oval:def:247096
  -->

  <xsl:param name="defid" />
  <xsl:template match="/">
    <xsl:call-template name="getFindings">
      <xsl:with-param name="definitionId" select="$defid"/>
    </xsl:call-template>
  </xsl:template>
  
  <xsl:template name="getFindings">
    <xsl:param name="definitionId"/>
    <xsl:variable name="result" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
    
    
    <xsl:variable name="filesetTest_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/aix-def:fileset_test/@id"/>
    <xsl:variable name="fileContentTest_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent_test/@id"/>
    <xsl:variable name="result1" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$filesetTest_id]/@result"/>
    <xsl:variable name="result2" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$fileContentTest_id]/@result"/>
    
    <xsl:variable name="filesetTest" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/aix-def:fileset_test[@id=$filesetTest_id]"/>
    <xsl:variable name="filesetName" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/aix-def:fileset_object[@id=$filesetTest/aix-def:object/@object_ref]/aix-def:flstinst/text()" />
    
    <xsl:variable name="definitionTextFileTest" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent_test[@id=$fileContentTest_id]"/>
    <xsl:variable name="textfile53Path" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent_object[@id=$definitionTextFileTest/ind-def:object/@object_ref]/ind-def:path/text()" />
    <xsl:variable name="textfile53Name" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent_object[@id=$definitionTextFileTest/ind-def:object/@object_ref]/ind-def:filename/text()" />
    
    <xsl:variable name="filecontentObj_ref" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent_test[@id=$fileContentTest_id]/ind-def:object/@object_ref" />
    <xsl:variable name="filecontentObj_flag" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:collected_objects/oval-sc:object[@id=$filecontentObj_ref]/@flag"/>
    
    <xsl:variable name="subexPattern" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states/ind-def:textfilecontent_state[@id=$definitionTextFileTest/ind-def:state/@state_ref]/ind-def:subexpression/text()" />
    <xsl:variable name="linePattern" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent_object[@id=$definitionTextFileTest/ind-def:object/@object_ref]/ind-def:line/text()" />
    
    
    <xsl:variable name="textfilePattern">
      <xsl:choose>
        <xsl:when test="$subexPattern != ' ' ">
          <xsl:value-of select="$subexPattern"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$linePattern"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
  
    <xsl:variable name="fileInfo">
          <xsl:value-of select="concat($textfile53Path,'/', $textfile53Name)"/>
    </xsl:variable>
    
    <xsl:variable name="title" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>
    
    <xsl:variable name="isViolationValue">
      <xsl:choose>
        <xsl:when test="$result = 'false' ">
          <xsl:text>true</xsl:text>
        </xsl:when>
        <xsl:when test="$result = 'true' ">
          <xsl:text>false</xsl:text>
        </xsl:when>
      </xsl:choose>
    </xsl:variable>
    
    <xsl:variable name="message_id">
      <!-- Check if result is true ......................................... -->
      <xsl:if test="$result='true'">
        <xsl:choose>
          <xsl:when test="$result1='true'">
            <xsl:text>com.mcafee.pa.msg.filesetDoesNotExists</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>com.mcafee.pa.msg.PatternMatchSCAP</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:if>            
      <!-- Check if result is false .......................................-->
      <xsl:if test="$result='false' ">                
        <xsl:choose>
          <xsl:when test="$filecontentObj_flag='does not exist' and $result2='false'">
            <xsl:text>com.mcafee.pa.msg.configfileDoesNotExists</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>com.mcafee.pa.msg.FileNegatePatternMatchNegChecks</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:if>  
    </xsl:variable>
    
    <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
      <xsl:attribute name="id">
        <xsl:value-of select="$definitionId"/>
      </xsl:attribute>
      <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
        <xsl:attribute name="messageId">
          <xsl:value-of select="$message_id"/>
        </xsl:attribute>
        <xsl:attribute name="isViolation">
          <xsl:value-of select="$isViolationValue"/>
        </xsl:attribute>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">config_name</xsl:attribute>
          <xsl:value-of select="$title"/>
        </xsl:element>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">pattern</xsl:attribute>
          <xsl:value-of select="$textfilePattern"/>
        </xsl:element>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">file_info</xsl:attribute>
          <xsl:value-of select="$fileInfo"/>
        </xsl:element>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">filesetName</xsl:attribute>
          <xsl:value-of select="$filesetName"/>
        </xsl:element>
      </xsl:element>
    </xsl:element>
</xsl:template>
</xsl:stylesheet>
