<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
    xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def ind-sc ind-def">
    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>
   
    <!-- This library is to handle the OVAL checks with the OR logic of file existence test (negate)  and 2 text file content tests
            with 2 external variable. Specific patterns are extrcted from the config file in test and are compared with the external
             variable values.
             
             Logic :-
             <criteria operator='OR'>
                 <criterion test_ref='oval:com.mcafee.oval:tst:231165' negate="true" comment='Test for the existence of the file /etc/X11/gdm/gdm.conf or /etc/gdm/gdm.conf' />
                     <criteria operator="AND">
                         <criterion test_ref='oval:com.mcafee.oval:tst:239073' comment='Test if the Greeter variable is set appropriately in /etc/X11/gdm/gdm.conf or /etc/gdm/gdm.conf'/>
                         <criterion test_ref='oval:com.mcafee.oval:tst:231166' comment='Test if the GNOME Users login banner text is set correctly in /etc/X11/gdm/gdm.conf or /etc/gdm/gdm.conf' />                    
                     </criteria>
                 </criteria>
                        
             with 2 External variables.
             
             Ex. OVAL ID - oval:com.mcafee.oval:def:239072
    --> 
    
    <xsl:param name="defid" />
    <xsl:template match="/">
        <xsl:call-template name="getFindings">
            <xsl:with-param name="definitionId" select="$defid"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
         <xsl:variable name="result" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <!-- Collect configuration name from the title ......................................... --> 
        <xsl:variable name="Definitions" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
        <xsl:variable name="title" select="$Definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>
        
       <!-- Collect all the required data from the checks like test ref, obj ref, ste ref and their data and results ......................................... --> 
        <xsl:variable name="fileTest_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test/@id"/>
        <xsl:variable name="fileContentTest_id1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[1]/@id"/>
        <xsl:variable name="fileContentTest_id2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[2]/@id"/>
        <xsl:variable name="extVar_id1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables/oval-def:external_variable[1]/@id"/>
        <xsl:variable name="extVar_id2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables/oval-def:external_variable[2]/@id"/>
        
        <xsl:variable name="fileTestResult" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$fileTest_id]/@result"/>
        
        <xsl:variable name="result1" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$fileContentTest_id1]/@result"/>
        <xsl:variable name="result2" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$fileContentTest_id2]/@result"/>
 
        <xsl:variable name="fileInfo">
            <xsl:text>/etc/gdm/gdm.conf or /etc/X11/gdm/gdm.conf</xsl:text>
        </xsl:variable>
        
        <xsl:variable name="filecontentObj_ref1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTest_id1]/ind-def:object/@object_ref" />
        <xsl:variable name="filecontentObj_flag1" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:collected_objects/oval-sc:object[@id=$filecontentObj_ref1]/@flag"/>
        
        <xsl:variable name="filecontentitem_id1" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$fileContentTest_id1]/oval-res:tested_item/@item_id"/>        
        <xsl:variable name="filecontentitem1" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/ind-sc:textfilecontent54_item[@id=$filecontentitem_id1]"/>
        <xsl:variable name="filecontentitem11" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/ind-sc:textfilecontent_item[@id=$filecontentitem_id1]"/>
        <xsl:variable name="actualConfig1">
            <xsl:choose>
                <xsl:when test="not($filecontentitem1)">
                    <xsl:value-of select="$filecontentitem11/ind-sc:subexpression/text()"/>
                </xsl:when>
                <xsl:when test="not($filecontentitem11)">
                    <xsl:value-of select="$filecontentitem1/ind-sc:subexpression/text()"/>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="filecontentObj_ref2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTest_id2]/ind-def:object/@object_ref" />
        <xsl:variable name="filecontentObj_flag2" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:collected_objects/oval-sc:object[@id=$filecontentObj_ref2]/@flag"/>
        
        <xsl:variable name="filecontentitem_id2" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$fileContentTest_id2]/oval-res:tested_item/@item_id"/>        
        <xsl:variable name="filecontentitem2" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/ind-sc:textfilecontent54_item[@id=$filecontentitem_id2]"/>
        <xsl:variable name="filecontentitem22" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/ind-sc:textfilecontent_item[@id=$filecontentitem_id2]"/>
        <xsl:variable name="actualConfig2">
            <xsl:choose>
                <xsl:when test="not($filecontentitem2)">
                    <xsl:value-of select="$filecontentitem22/ind-sc:subexpression/text()"/>
                </xsl:when>
                <xsl:when test="not($filecontentitem22)">
                    <xsl:value-of select="$filecontentitem2/ind-sc:subexpression/text()"/>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="expectedConfig1" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$fileContentTest_id1]/oval-res:tested_variable[@variable_id=$extVar_id1]/text()"/> 
        <xsl:variable name="expectedConfig2" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$fileContentTest_id2]/oval-res:tested_variable[@variable_id=$extVar_id2]/text()"/> 
                
        <!-- Decide about the message id depending upon  the combination of results for various criterions ........................................................................................... -->
        <xsl:variable name="message_id">
            <!-- Check if result is true ........................................................................................... -->
            <xsl:if test="$result='true'">
                <xsl:choose>
                    <xsl:when test="$fileTestResult = 'false' and ($result1 = 'true' and $result2='true')" >
                        <xsl:text>com.mcafee.pa.msg.PatternMatchSCAP</xsl:text>
                    </xsl:when>                    
                    <xsl:when test="$fileTestResult= 'true'" >
                        <xsl:text>com.mcafee.pa.msg.configfileDoesNotExists</xsl:text>
                    </xsl:when>
                </xsl:choose>
            </xsl:if>            
            <!-- Check if result is false ........................................................................................... -->
            <xsl:if test="$result='false' ">                
                <xsl:choose>
                    <xsl:when test="$fileTestResult='false' and $result1 = 'false' and $result2 = 'false' and (not($actualConfig1) or not($actualConfig2) or $actualConfig1='' or $actualConfig2='')">
                        <xsl:text>com.mcafee.pa.msg.configNotSet</xsl:text>
                    </xsl:when>
                    <xsl:when test="$fileTestResult='false' and $result1 = 'false' and $result2 = 'false' and $actualConfig1!='' and $actualConfig2!=''">
                        <xsl:text>com.mcafee.pa.msg.configValuesStatusSCAP</xsl:text>
                    </xsl:when>
                    <xsl:when test="$fileTestResult='false' and $result1 = 'false' and $result2 = 'true' and $actualConfig1!=''">
                        <xsl:text>com.mcafee.pa.msg.configValue1StatusSCAP</xsl:text>
                    </xsl:when>
                    <xsl:when test="$fileTestResult='false' and $result1 = 'true' and $result2 = 'false' and $actualConfig2!=''">
                        <xsl:text>com.mcafee.pa.msg.configValue2StatusSCAP</xsl:text>
                    </xsl:when>
                </xsl:choose>
            </xsl:if>  
        </xsl:variable>
        
        <xsl:variable name="isViolationValue">
            <xsl:choose>
                <xsl:when test="$result = 'false' ">
                    <xsl:text>true</xsl:text>
                </xsl:when>
                <xsl:when test="$result = 'true' ">
                    <xsl:text>false</xsl:text>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
            <xsl:attribute name="id">
                <xsl:value-of select="$definitionId"/>
            </xsl:attribute>
            <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="messageId">
                    <xsl:value-of select="$message_id"/>
                </xsl:attribute>
                <xsl:attribute name="isViolation">
                    <xsl:value-of select="$isViolationValue"/>
                </xsl:attribute>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">file_info</xsl:attribute>
                    <xsl:value-of select="$fileInfo"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">config_name</xsl:attribute>
                    <xsl:value-of select="$title"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">actual_config1</xsl:attribute>
                    <xsl:value-of select="$actualConfig1"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">actual_config2</xsl:attribute>
                    <xsl:value-of select="$actualConfig2"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">expected_config1</xsl:attribute>
                    <xsl:value-of select="$expectedConfig1"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">expected_config2</xsl:attribute>
                    <xsl:value-of select="$expectedConfig2"/>
                </xsl:element>
            </xsl:element>
        </xsl:element>
    </xsl:template>
</xsl:stylesheet>