<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan">

    <!--
                   This XSLT is used to verify the registry setting against user input as a Variable.
                   
                   criteria ( or )
                       criteria ( and )
                            criterion or extend_definition : Family testor extend definition
                             Variable test : Take user input from the benchmark 
                              Registry test 
                                 one or more..
                         criteria ( and )
                                criterion or extend_definition : Family testor extend definition
                                Variable test : Take user input from the benchmark 
                                Registry test 
                                one or more..      
                          ......
                       criteria ( or )
                   
                   
                   Example : 
                   
                   <criteria operator=""OR"">
                       <criteria operator=""AND"">
                           <criterion comment=""Benchmark Variable = Not Configured"" negate=""false"" test_ref=""oval:com.mcafee.oval.windows:tst:65791""/>
                           <criterion comment=""HKLM\Software\Microsoft\Windows\CurrentVersion\Policies\Explorer\\NoMSAppLogo5ChannelNotify does not exist"" negate=""true"" test_ref=""oval:com.mcafee.oval.windows:tst:65795""/>
                           <criterion comment=""The installed operating system is part of the Microsoft Windows family"" test_ref=""oval:com.mcafee.oval.windows:tst:160262""/>
                       </criteria>
                       <criteria operator=""AND"">
                           <criterion comment=""Benchmark Variable = Enabled"" negate=""false"" test_ref=""oval:com.mcafee.oval.windows:tst:65792""/>
                           <criterion comment=""HKLM\Software\Microsoft\Windows\CurrentVersion\Policies\Explorer\\NoMSAppLogo5ChannelNotify = 1"" negate=""false"" test_ref=""oval:com.mcafee.oval.windows:tst:65794""/>
                           <criterion comment=""The installed operating system is part of the Microsoft Windows family"" test_ref=""oval:com.mcafee.oval.windows:tst:160262""/>
                   </criteria>
                   <criteria operator=""AND"">
                           <criterion comment=""Benchmark Variable = Disabled"" negate=""false"" test_ref=""oval:com.mcafee.oval.windows:tst:65793""/>
                           <criterion comment=""HKLM\Software\Microsoft\Windows\CurrentVersion\Policies\Explorer\\NoMSAppLogo5ChannelNotify does not exist"" negate=""true"" test_ref=""oval:com.mcafee.oval.windows:tst:65795""/>
                           <criterion comment=""The installed operating system is part of the Microsoft Windows family"" test_ref=""oval:com.mcafee.oval.windows:tst:160262""/>
                       </criteria>
                   </criteria>
				   Modified the style sheet to display the hint value while generating the findings message.
            
            Ex: oval:com.mcafee.oval:def:71758
    -->

    <xsl:variable name="Definitions"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
    <xsl:variable name="Tests"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests"/>
    <xsl:variable name="States"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states"/>
    <xsl:variable name="Objects"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects"/>
    <xsl:variable name="Variables"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables"/>
        

    <xsl:template name="configurationStatusString">
            <xsl:param name="value"/>
            <xsl:param name="printableValue"/>
                     <xsl:choose>
                         <xsl:when test="contains($printableValue,'Not Configured') and contains($printableValue,'Disabled')">
                             <xsl:text>Not Configured/Disabled</xsl:text>
                         </xsl:when>
                         <xsl:when test="contains($printableValue,'Not Configured')">
                             <xsl:text>Not Configured</xsl:text>
                         </xsl:when>
                         <xsl:when test="$printableValue = $value">
                             <xsl:value-of select="$printableValue"/>
                         </xsl:when>
                         <xsl:when test="$printableValue != '' ">
                             <xsl:value-of select="concat($printableValue, ' ', '(' , ' ', $value , ' ',  ')' )"/>
                         </xsl:when>
                         <xsl:when test="$value = '' ">
                             <xsl:text>Not Configured/Disabled</xsl:text>
                             </xsl:when>
                         <xsl:otherwise>
                             <xsl:value-of select="$value"/>
                             </xsl:otherwise>
                     </xsl:choose>
    </xsl:template>
    
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>

        <xsl:variable name="result"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
  
            <xsl:call-template name="winConfigurationCheck">
                <xsl:with-param name="definitionId" select="$definitionId"/>
                <xsl:with-param name="def_result" select="$result"/>
            </xsl:call-template>

    </xsl:template>

    <xsl:template name="winConfigurationCheck">
        <xsl:param name="definitionId"/>
        <xsl:param name="def_result"/>

    
        <xsl:variable name="tests">
            <xsl:for-each
                select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:criteria">
   
               <xsl:element name="criteria">
                    <xsl:for-each select="./oval-res:criterion">
                        <xsl:variable name="test" select="@test_ref"/>
                        <xsl:variable name="result" select="@result"/>
                        
                        
                        <xsl:if test="$Tests/win-def:registry_test[@id=$test]">
                            
                            <xsl:element name="test">
                                <xsl:attribute name="id">
                                    <xsl:value-of select="$test"/>
                                </xsl:attribute>                      
                                <xsl:attribute name="result">
                                    <xsl:value-of select="$result"/>
                                </xsl:attribute>
                                <xsl:attribute name="testtype">
                                    <xsl:text>registry</xsl:text>
                                </xsl:attribute>

                            </xsl:element>
                        </xsl:if>

                        <xsl:if test="$Tests/oval-ind:variable_test[@id=$test]">
                            <xsl:variable name="state"
                                select="$Tests/oval-ind:variable_test[@id=$test]/oval-ind:state/@state_ref"/>                            
                            <xsl:variable name="expectedValue"
                            select="$States/oval-ind:variable_state[@id=$state]/oval-ind:value"/>
                            
                            <xsl:variable name="ObjRef"
                            select="$Tests/oval-ind:variable_test[@id=$test]/oval-ind:object/@object_ref"/>
                            <xsl:variable name="VarRef"
                            select="$Objects/oval-ind:variable_object[@id=$ObjRef]/oval-ind:var_ref"/>
                            <xsl:variable name="printableValue">
                                <xsl:for-each
                                    select="$Variables/oval-def:external_variable[@id = $VarRef]/descendant::oval-def:possible_value">
                                    <xsl:if test="text() = $expectedValue">
                                        <xsl:value-of select="@hint"/>
                                    </xsl:if>
                                </xsl:for-each>
                            </xsl:variable>

                            <xsl:element name="test">
                                <xsl:attribute name="id">
                                    <xsl:value-of select="$test"/>
                                </xsl:attribute>                                
                                <xsl:attribute name="expectedValue">
                                    <xsl:value-of select="$expectedValue"/>
                                </xsl:attribute>
                                <xsl:attribute name="printableValue">
                                    <xsl:value-of select="$printableValue"/>
                                </xsl:attribute>
                                <xsl:attribute name="result">
                                    <xsl:value-of select="$result"/>
                                </xsl:attribute>
                                <xsl:attribute name="testtype">
                                    <xsl:text>variable</xsl:text>
                                </xsl:attribute>
                            </xsl:element>
                        </xsl:if>
                    </xsl:for-each>
                </xsl:element>
            </xsl:for-each>

            <xsl:element name="criteria">
                <xsl:for-each
                    select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/oval-res:criterion">

                    <xsl:variable name="test" select="@test_ref"/>
                    <xsl:variable name="result" select="@result"/>

                    <xsl:if test="$Tests/win-def:registry_test[@id=$test]">
                       <xsl:element name="test">
                            <xsl:attribute name="id">
                                <xsl:value-of select="$test"/>
                            </xsl:attribute>
                            <xsl:attribute name="result">
                                <xsl:value-of select="$result"/>
                            </xsl:attribute>
                            <xsl:attribute name="testtype">
                                <xsl:text>registry</xsl:text>
                            </xsl:attribute>

                        </xsl:element>
                    </xsl:if>

                    <xsl:if test="$Tests/oval-ind:variable_test[@id=$test]">
                        <xsl:variable name="state"
                            select="$Tests/oval-ind:variable_test[@id=$test]/oval-ind:state/@state_ref"/>
                        <xsl:variable name="expectedValue"
                        select="$States/oval-ind:variable_state[@id=$state]/oval-ind:value"/>
                        <xsl:variable name="ObjRef"
                            select="$Tests/oval-ind:variable_test[@id=$test]/oval-ind:object/@object_ref"/>
                        <xsl:variable name="VarRef"
                            select="$Objects/oval-ind:variable_object[@id=$ObjRef]/oval-ind:var_ref"/>
                        <xsl:variable name="printableValue">
                            <xsl:for-each
                                select="$Variables/oval-def:external_variable[@id = $VarRef]/descendant::oval-def:possible_value">
                                <xsl:if test="text() = $expectedValue">
                                    <xsl:value-of select="@hint"/>
                                </xsl:if>
                            </xsl:for-each>
                        </xsl:variable>

                        <xsl:element name="test">
                            <xsl:attribute name="id">
                                <xsl:value-of select="$test"/>
                            </xsl:attribute>
                            <xsl:attribute name="expectedValue">
                                <xsl:value-of select="$expectedValue"/>
                            </xsl:attribute>
                            <xsl:attribute name="printableValue">
                                <xsl:value-of select="$printableValue"/>
                            </xsl:attribute>
                            <xsl:attribute name="result">
                                <xsl:value-of select="$result"/>
                            </xsl:attribute>
                            <xsl:attribute name="testtype">
                                <xsl:text>variable</xsl:text>
                            </xsl:attribute>
                        </xsl:element>
                    </xsl:if>
                </xsl:for-each>
            </xsl:element>
        </xsl:variable>

       <xsl:variable name="message_id">
           <xsl:text>com.mcafee.pa.msg.winconfig_SCAP</xsl:text>
        </xsl:variable>
        
        <xsl:variable name="configName">
            <xsl:value-of select="$Definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>            
        </xsl:variable>
        
           <xsl:if test="$def_result = 'false' ">               
                
                <!--   Get the expected Value from the variable test   -->
                <xsl:variable name="expectedValue">
                <xsl:for-each select="xalan:nodeset($tests)/descendant::criteria">
                    <xsl:if  test="./test[ @testtype = 'variable' ] and ./test[ @testtype = 'variable' ]/@result = 'true'  ">                        
                        <xsl:value-of select="./test[ @testtype = 'variable' ]/@expectedValue"/>
                    </xsl:if>
                </xsl:for-each>
                </xsl:variable>
                
                <!--   Get the expected Printable Value from the variable test   -->
                <xsl:variable name="expectedPrintableValue">
                    <xsl:for-each select="xalan:nodeset($tests)/descendant::criteria">
                        <xsl:if  test="./test[ @testtype = 'variable' ] and ./test[ @testtype = 'variable' ]/@result = 'true'  ">                        
                            <xsl:value-of select="./test[ @testtype = 'variable' ]/@printableValue"/>
                        </xsl:if>
                    </xsl:for-each>
                </xsl:variable>
             
                
                <!--  Now get the actual value from the registry test which passed -->

                <xsl:variable name="actualValue">
                <xsl:for-each select="xalan:nodeset($tests)/descendant::criteria">

                    <!--  Get the expected value for this criteria that would be actual value if all the registry tests passed                     -->
                    <xsl:variable name="variableTestExpectedValue">
                        <xsl:for-each select="./child::test[ @testtype = 'variable' ]">
                            <xsl:value-of select="@expectedValue"/>
                        </xsl:for-each>
                    </xsl:variable>
                    
                        <!--  Check all registry test passed                     -->
                          <xsl:variable name="registryTestResult">
                            <xsl:for-each select="./child::test[ @testtype = 'registry' ]">
                                <xsl:variable name="reg_test_result" select="@result"/>
                                 <xsl:if test="$reg_test_result != 'true' ">
                                      <xsl:text>1</xsl:text>
                                 </xsl:if>
                             </xsl:for-each>
                          </xsl:variable>
                    
                        <!--     If all registry tests pass then variable test value is the actual value in the system -->
                            <xsl:if test="not(contains($registryTestResult,'1'))">
                                <xsl:value-of select="$variableTestExpectedValue"/>
                            </xsl:if>
                        </xsl:for-each>
                </xsl:variable>
               
                <!-- Now get the actual printable (hint) value -->
                <xsl:variable name="actualPrintableValue">
                    <xsl:for-each select="xalan:nodeset($tests)/descendant::criteria">
                        
                        <!--  Get the expected Printable value for this criteria that would be actual printable value if all the registry tests passed                     -->
                        <xsl:variable name="variableTestPrintableExpectedValue">
                            <xsl:for-each select="./child::test[ @testtype = 'variable' ]">
                                <xsl:value-of select="@printableValue"/>
                            </xsl:for-each>
                        </xsl:variable>
                        
                        <!--  Check all registry test passed                     -->
                        <xsl:variable name="registryTestResult">
                            <xsl:for-each select="./child::test[ @testtype = 'registry' ]">
                                <xsl:variable name="reg_test_result" select="@result"/>
                                <xsl:if test="$reg_test_result != 'true' ">
                                    <xsl:text>1</xsl:text>
                                </xsl:if>
                            </xsl:for-each>
                        </xsl:variable>
                        
                        <!--     If all registry tests pass then variable test printable  value is the actual printable value in the system -->
                        <xsl:if test="not(contains($registryTestResult,'1'))">
                            <xsl:value-of select="$variableTestPrintableExpectedValue"/>
                        </xsl:if>
                    </xsl:for-each>
                </xsl:variable>
                      
                                   <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">
                                       
                                       <inputValue key="expectedValue">
                                           <xsl:call-template name="configurationStatusString">
                                               <xsl:with-param name="value" select="$expectedValue"/>
                                               <xsl:with-param name="printableValue" select="$expectedPrintableValue"/>
                                           </xsl:call-template>
                                       </inputValue>
                                       
                                    <finding messageId="{$message_id}" isViolation="true">
                                        <instanceValue key="config">
                                            <xsl:value-of select="$configName"/>
                                        </instanceValue>
                                         <actualValue key="actualValue">
                                            <xsl:call-template name="configurationStatusString">
                                                <xsl:with-param name="value" select="$actualValue"/>
                                                <xsl:with-param name="printableValue" select="$actualPrintableValue"/>
                                            </xsl:call-template>                                            
                                        </actualValue>
                                    </finding>
                                   </findings>
                               </xsl:if>
        
            <xsl:if test="$def_result = 'true' ">               
            
            <!--   Get the expected Value from the variable test   -->
            <xsl:variable name="expectedValue">
                <xsl:for-each select="xalan:nodeset($tests)/descendant::criteria">
                    <xsl:if  test="./test[ @testtype = 'variable' ] and ./test[ @testtype = 'variable' ]/@result = 'true'  ">                        
                        <xsl:value-of select="./test[ @testtype = 'variable' ]/@expectedValue"/>
                    </xsl:if>
                </xsl:for-each>
            </xsl:variable>
                
            <!--   Get the expected printable Value (hint)  from the variable test   -->
            <xsl:variable name="expectedPrintableValue">
                <xsl:for-each select="xalan:nodeset($tests)/descendant::criteria">
                    <xsl:if  test="./test[ @testtype = 'variable' ] and ./test[ @testtype = 'variable' ]/@result = 'true'  ">                        
                        <xsl:value-of select="./test[ @testtype = 'variable' ]/@printableValue"/>
                    </xsl:if>
                </xsl:for-each>
            </xsl:variable>
            
            <xsl:if test="$message_id != '' ">
                <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">
                    
                    <finding messageId="{$message_id}" isViolation="false">
                        <instanceValue key="config">
                            <xsl:value-of select="$configName"/>
                        </instanceValue>
                        <actualValue key="actualValue">
                            <xsl:call-template name="configurationStatusString">
                                <xsl:with-param name="value" select="$expectedValue"/>
                                <xsl:with-param name="printableValue" select="$expectedPrintableValue"/>
                            </xsl:call-template>                                            
                        </actualValue>
                    </finding>
                </findings>
            </xsl:if>
            
        </xsl:if>
        
    </xsl:template>

</xsl:stylesheet>
