
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema"   
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan"
    >
     
    <xsl:include  href="common.xsl" />
    
   <xsl:template name="getPrivilege">
       <xsl:param name="privilegeName"/>
       
       <xsl:choose>
           <xsl:when test="$privilegeName = 'seauditprivilege' ">
               <xsl:text>generate security audits</xsl:text>
           </xsl:when>
         
           <xsl:when test="$privilegeName = 'sebackupprivilege' ">
               <xsl:text>back up files and directories</xsl:text>
           </xsl:when>
  
           <xsl:when test="$privilegeName = 'secreateglobalprivilege' ">
               <xsl:text>create global privilage</xsl:text>
           </xsl:when>
           
           <xsl:when test="$privilegeName = 'secreateglobalprivilege' ">
               <xsl:text>create  pagefile</xsl:text>
           </xsl:when>
           
           <xsl:when test="$privilegeName = 'secreatepermanentprivilege' ">
               <xsl:text>create permanent shared objects</xsl:text>
           </xsl:when>
           
           <xsl:when test="$privilegeName = 'secreatesymboliclinkprivilege' ">
               <xsl:text>create a symbolic link</xsl:text>
           </xsl:when>
      
           <xsl:when test="$privilegeName = 'secreatetokenprivilege' ">
               <xsl:text>create a token object</xsl:text>
           </xsl:when>
      
           <xsl:when test="$privilegeName = 'sedebugprivilege' ">
               <xsl:text>debug programs</xsl:text>
           </xsl:when>
           
           <xsl:when test="$privilegeName = 'seloaddriverprivilege' ">
               <xsl:text> load and unload driver</xsl:text>
           </xsl:when>
  
           <xsl:when test="$privilegeName = 'selockmemoryprivilege' ">
               <xsl:text> lock pages in memory</xsl:text>
           </xsl:when>
           
           <xsl:when test="$privilegeName = 'semachineaccountprivilege' ">
               <xsl:text> add a computer account to a specific domain</xsl:text>
           </xsl:when>
           
           <xsl:when test="$privilegeName = 'semanagevolumeprivilege' ">
               <xsl:text> manage the files on a volume (volumes or disks)</xsl:text>
           </xsl:when>
           
           <xsl:when test="$privilegeName = 'seprofilesingleprocessprivilege' ">
               <xsl:text>sample the performance of an application process (application profiling rights)</xsl:text>
           </xsl:when>
           
           
           <xsl:when test="$privilegeName = 'seremoteshutdownprivilege' ">
               <xsl:text>shut down a computer from a remote location on the network</xsl:text>
           </xsl:when>
   
           <xsl:when test="$privilegeName = 'serestoreprivilege' ">
               <xsl:text>circumvent file and directory permissions when restoring backed-up files and directories and to set any valid security principal as the owner of an object</xsl:text>
           </xsl:when>
    
   
           <xsl:when test="$privilegeName = 'sesecurityprivilege' ">
               <xsl:text>specify object access auditing options for individual resources such as files, Active Directory objects, and registry keys</xsl:text>
           </xsl:when>
                 
           <xsl:when test="$privilegeName = 'seshutdownprivilege' ">
               <xsl:text>shut down the local computer</xsl:text>
           </xsl:when>
    
           <xsl:when test="$privilegeName = 'sesyncagentprivilege' ">
               <xsl:text>synchronize directory service data (read all objects and properties in the directory, regardless of the protection on the objects and properties) </xsl:text>
           </xsl:when>
   
           <xsl:when test="$privilegeName = 'sesystemenvironmentprivilege' ">
               <xsl:text>modify firmware environment values (modify system environment variables either by a process through an API or by a user through System Properties)</xsl:text>
           </xsl:when>
        
           <xsl:when test="$privilegeName = 'sesystemprofileprivilege' ">
               <xsl:text>sample the performance of system processes (System Profiling  Rights)</xsl:text>
           </xsl:when>
   
           <xsl:when test="$privilegeName = 'sesystemtimeprivilege' ">
               <xsl:text>change the system time</xsl:text>
           </xsl:when>

           <xsl:when test="$privilegeName = 'setakeownershipprivilege' ">
               <xsl:text>take ownership of an object without being granted discretionary access, including Active Directory objects, NTFS files and folders, printers, registry keys, services, processes, and threads</xsl:text>
           </xsl:when>
   
           <xsl:when test="$privilegeName = 'setcbprivilege' ">
               <xsl:text>act as part of the operating system (only some trusted protected subsystems are granted this privilege)</xsl:text>
           </xsl:when>
   
           <xsl:when test="$privilegeName = 'setimezoneprivilege' ">
               <xsl:text>change the time zone</xsl:text>
           </xsl:when>

           <xsl:when test="$privilegeName = 'seundockprivilege' ">
               <xsl:text>remove computer from docking station</xsl:text>
           </xsl:when>
   
           <xsl:when test="$privilegeName = 'seunsolicitedinputprivilege' ">
               <xsl:text>read unsolicited data from a terminal device (SeUnsolicitedInputPrivilege)</xsl:text>
           </xsl:when>
   
           <xsl:when test="$privilegeName = 'sebatchlogonright' ">
               <xsl:text>log on as a batch job</xsl:text>
           </xsl:when>

           <xsl:when test="$privilegeName = 'seinteractivelogonright' ">
               <xsl:text>log on locally</xsl:text>
           </xsl:when>
    
           <xsl:when test="$privilegeName = 'senetworklogonright' ">
               <xsl:text>access this computer from the network</xsl:text>
           </xsl:when>
                      
           <xsl:when test="$privilegeName = 'seremoteinteractivelogonright' ">
               <xsl:text>log on through Terminal Services (Remote Desktop Connection)</xsl:text>
           </xsl:when>
   
           <xsl:when test="$privilegeName = 'seservicelogonright' ">
               <xsl:text>log on as a service</xsl:text>
           </xsl:when>

           <xsl:when test="$privilegeName = 'sedenybatchLogonright' ">
               <xsl:text>log on as a batch job</xsl:text>
           </xsl:when>
   
           <xsl:when test="$privilegeName = 'sedenyinteractivelogonright' ">
               <xsl:text>log on locally</xsl:text>
           </xsl:when>

           <xsl:when test="$privilegeName = 'sedenynetworklogonright' ">
               <xsl:text>access this computer from the network</xsl:text>
           </xsl:when>
   
           <xsl:when test="$privilegeName = 'sedenyremoteInteractivelogonright' ">
               <xsl:text>log on through Terminal Services (Remote Desktop Connection)</xsl:text>
           </xsl:when>
   
           <xsl:when test="$privilegeName = 'sedenyservicelogonright' ">
               <xsl:text>log on as a service</xsl:text>
           </xsl:when>

           <xsl:when test="$privilegeName = 'serelabelprivilege' ">
               <xsl:text>relabel</xsl:text>
           </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$privilegeName"/>
            </xsl:otherwise>
       </xsl:choose>
       
   </xsl:template>
</xsl:stylesheet>
