<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
  xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
  xmlns:aix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#aix"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
  xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
  xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
  xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
  xmlns:aix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#aix"
  xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
  xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
  xmlns:xalan="http://xml.apache.org/xalan"
  exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def ind-sc ind-def aix-def aix-sc">
  <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>

  <!-- This library is to handle the OVAL checks with the 2 file existence tests and 3 text file tests with 1 text file test negated.
         2 of the text file tests verifies if a specific pattern of text is present in the config files and 1 text file test ensures that a specific pattern of text is not present in the config file.
          
          <criteria operator='AND' comment='Operating system version is Redhat Enterprise 5 on x86 or x64'>
            <criterion comment='Test for the existence of the file - /etc/security/console.perms.d/50-default.perms' test_ref='oval:com.mcafee.oval:tst:92676' /> - File Test
            <criterion comment='Test for the existence of the file' test_ref='oval:com.mcafee.oval:tst:79602' /> - File Test
            <criterion comment='Check if the console device ownership is restricted to root-only in /etc/security/console.perms.d/0-default.perms file' test_ref='oval:com.mcafee.oval:tst:200803070555' negate="true"/> - TextFile Test
            <criterion comment='Check if the console device ownership is restricted to root-only in /etc/security/console.perms file for console tty' test_ref='oval:com.mcafee.oval:tst:455442'/> - TextFile Test
            <criterion comment='Check if the console device ownership is restricted to root-only in /etc/security/console.perms file for xconsole' test_ref='oval:com.mcafee.oval:tst:455443'/> - TextFile Test
          </criteria>
          
          without external variable & OVAL State.
          
          Ex. OVAL ID's: oval:com.mcafee.oval:def:200803070553
  -->

  <xsl:param name="defid" />
  <xsl:template match="/">
    <xsl:call-template name="getFindings">
      <xsl:with-param name="definitionId" select="$defid" />
    </xsl:call-template>
  </xsl:template>
  
  <xsl:template name="getFindings">
    <xsl:param name="definitionId"/>
    <xsl:variable name="result" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
    
    <xsl:variable name="fileContentTestID1" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[3]/@test_ref"/>
    <xsl:variable name="fileContentTestID2" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[4]/@test_ref"/>
    <xsl:variable name="fileContentTestID3" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[5]/@test_ref"/>
  
    
    <xsl:variable name="fileTest_id1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test[1]/@id"/>
    
    <xsl:variable name="result1" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$fileTest_id1]/@result"/>
    
    <xsl:variable name="result3">
      <xsl:value-of select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$fileContentTestID1]/@result"/>
    </xsl:variable>
    
    <xsl:variable name="definitionFileTest1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test[@id=$fileTest_id1]"/>
    
   <xsl:variable name="filePath1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:file_object[@id=$definitionFileTest1/unix-def:object/@object_ref]/unix-def:path/text()" />
    <xsl:variable name="fileName1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:file_object[@id=$definitionFileTest1/unix-def:object/@object_ref]/unix-def:filename/text()" />
    
    <xsl:variable name="textFilePath1">
      <xsl:choose>
        <xsl:when test="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTestID1]!=''">
          <xsl:variable name="definitionTextFile54Test1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTestID1]"/>
          <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFile54Test1/ind-def:object/@object_ref]/ind-def:path/text()"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:variable name="definitionTextFileTest1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent_test[@id=$fileContentTestID1]"/>
          <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent_object[@id=$definitionTextFileTest1/ind-def:object/@object_ref]/ind-def:path/text()"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    
    <xsl:variable name="textFileName1">
      <xsl:choose>
        <xsl:when test="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTestID1]!=''">
          <xsl:variable name="definitionTextFile54Test1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTestID1]"/>
          <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFile54Test1/ind-def:object/@object_ref]/ind-def:name/text()"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:variable name="definitionTextFileTest1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent_test[@id=$fileContentTestID1]"/>
          <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent_object[@id=$definitionTextFileTest1/ind-def:object/@object_ref]/ind-def:filename/text()"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    
    <xsl:variable name="textfilePattern1">
      <xsl:choose>
        <xsl:when test="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTestID1]!=''">
          <xsl:variable name="definitionTextFile54Test1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTestID1]"/>
          <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFile54Test1/ind-def:object/@object_ref]/ind-def:pattern/text()"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:variable name="definitionTextFileTest1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent_test[@id=$fileContentTestID1]"/>
          <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent_object[@id=$definitionTextFileTest1/ind-def:object/@object_ref]/ind-def:line/text()"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    
    <xsl:variable name="fileInfo1">
      <xsl:choose>
        <xsl:when test="$fileTest_id1 != ' ' ">
          <xsl:value-of select="concat($filePath1,'/', $fileName1)"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="concat($textFilePath1,'/', $textFileName1)"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    
    <xsl:variable name="fileTest_id2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test[2]/@id"/>
    
    <xsl:variable name="result2" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$fileTest_id2]/@result"/>
    
    <xsl:variable name="result4">
      <xsl:value-of select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$fileContentTestID2]/@result"/>
    </xsl:variable>
    
    <xsl:variable name="definitionFileTest2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test[@id=$fileTest_id2]"/>
    
    <xsl:variable name="filePath2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:file_object[@id=$definitionFileTest2/unix-def:object/@object_ref]/unix-def:path/text()" />
    <xsl:variable name="fileName2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:file_object[@id=$definitionFileTest2/unix-def:object/@object_ref]/unix-def:filename/text()" />
    
    <xsl:variable name="textFilePath2">
      <xsl:choose>
        <xsl:when test="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTestID2]!=''">
          <xsl:variable name="definitionTextFile54Test2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTestID2]"/>
          <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFile54Test2/ind-def:object/@object_ref]/ind-def:path/text()"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:variable name="definitionTextFileTest2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent_test[@id=$fileContentTestID2]"/>
          <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent_object[@id=$definitionTextFileTest2/ind-def:object/@object_ref]/ind-def:path/text()"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    
    <xsl:variable name="textFileName2">
      <xsl:choose>
        <xsl:when test="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTestID2]!=''">
          <xsl:variable name="definitionTextFile54Test2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTestID2]"/>
          <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFile54Test2/ind-def:object/@object_ref]/ind-def:filename/text()"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:variable name="definitionTextFileTest2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent_test[@id=$fileContentTestID2]"/>
          <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent_object[@id=$definitionTextFileTest2/ind-def:object/@object_ref]/ind-def:filename/text()"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    
    <xsl:variable name="textfilePattern2">
      <xsl:choose>
        <xsl:when test="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTestID2]!=''">
          <xsl:variable name="definitionTextFile54Test2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTestID2]"/>
          <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFile54Test2/ind-def:object/@object_ref]/ind-def:pattern/text()"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:variable name="definitionTextFileTest2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent_test[@id=$fileContentTestID2]"/>
          <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent_object[@id=$definitionTextFileTest2/ind-def:object/@object_ref]/ind-def:line/text()"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    
    <xsl:variable name="fileInfo2">
      <xsl:choose>
        <xsl:when test="$fileTest_id2 != ' ' ">
          <xsl:value-of select="concat($filePath2,'/', $fileName2)"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="concat($textFilePath2,'/', $textFileName2)"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    
    <xsl:variable name="result5">
      <xsl:value-of select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$fileContentTestID3]/@result"/>
    </xsl:variable>
    
    <xsl:variable name="textFilePath3">
      <xsl:choose>
        <xsl:when test="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTestID3]!=''">
          <xsl:variable name="definitionTextFile54Test3" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTestID3]"/>
          <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFile54Test3/ind-def:object/@object_ref]/ind-def:path/text()"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:variable name="definitionTextFileTest3" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent_test[@id=$fileContentTestID3]"/>
          <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent_object[@id=$definitionTextFileTest3/ind-def:object/@object_ref]/ind-def:path/text()"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    
    <xsl:variable name="textFileName3">
      <xsl:choose>
        <xsl:when test="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTestID3]!=''">
          <xsl:variable name="definitionTextFile54Test3" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTestID3]"/>
          <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFile54Test3/ind-def:object/@object_ref]/ind-def:filename/text()"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:variable name="definitionTextFileTest3" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent_test[@id=$fileContentTestID3]"/>
          <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent_object[@id=$definitionTextFileTest3/ind-def:object/@object_ref]/ind-def:filename/text()"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    
    <xsl:variable name="textfilePattern3">
      <xsl:choose>
        <xsl:when test="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTestID3]!=''">
          <xsl:variable name="definitionTextFile54Test3" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTestID3]"/>
          <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFile54Test3/ind-def:object/@object_ref]/ind-def:pattern/text()"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:variable name="definitionTextFileTest3" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent_test[@id=$fileContentTestID3]"/>
          <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent_object[@id=$definitionTextFileTest3/ind-def:object/@object_ref]/ind-def:line/text()"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    
    
    <xsl:variable name="fileInfo">
      <xsl:choose>
        <xsl:when test="concat($textFilePath3,'/', $textFileName3)=$fileInfo2">
          <xsl:value-of select="concat($fileInfo1,', ', $fileInfo2)"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="concat($fileInfo1,', ', $fileInfo2,', ',concat($textFilePath3,'/', $textFileName3))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    
    <xsl:variable name="title" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>
    
    <xsl:variable name="isViolationValue">
      <xsl:choose>
        <xsl:when test="$result = 'false' ">
          <xsl:text>true</xsl:text>
        </xsl:when>
        <xsl:when test="$result = 'true' ">
          <xsl:text>false</xsl:text>
        </xsl:when>
      </xsl:choose>
    </xsl:variable>
    
    <xsl:variable name="message_id">
      <xsl:choose>
        <xsl:when test="$result='true'">
          <xsl:text>com.mcafee.pa.msg.PatternMatchSCAP</xsl:text>
        </xsl:when>
        <xsl:when test="$result='false'">
          <xsl:choose>
            <xsl:when test="$result1='false' and $result2='false'">
              <xsl:text>com.mcafee.pa.msg.ConfigFilesMissingConfigNotPat1AndPat2Pat3</xsl:text>
            </xsl:when>
            <xsl:when test="$result1='true' and $result3='false' and $result2='false'">
              <xsl:text>com.mcafee.pa.msg.NotPat1ConfigFile2NotExists</xsl:text>
            </xsl:when>
            <xsl:when test="$result1='true' and $result3='true' and $result2='false'">
              <xsl:text>com.mcafee.pa.msg.ConfigFile2NotExists</xsl:text>
            </xsl:when>
            <xsl:when test="$result1='false' and $result2='true'">
              <xsl:choose>
                <xsl:when test="$result4='false' and $result5='false'">
                  <xsl:text>com.mcafee.pa.msg.ConfigFile1NotExistPat2Pat3Missing</xsl:text>
                </xsl:when>
                <xsl:when test="$result4='false' and $result5='true'">
                  <xsl:text>com.mcafee.pa.msg.ConfigFile1NotExistPat2Missing</xsl:text>
                </xsl:when>
                <xsl:when test="$result4='true' and $result5='false'">
                  <xsl:text>com.mcafee.pa.msg.ConfigFile1NotExistPat3Missing</xsl:text>
                </xsl:when>
                <xsl:when test="$result4='true' and $result5='true'">
                  <xsl:text>com.mcafee.pa.msg.ConfigFile1NotExist</xsl:text>
                </xsl:when>
              </xsl:choose>
            </xsl:when>
            <xsl:when test="$result1='true' and $result2='true'">
              <xsl:choose>
                <xsl:when test="$result3='false' and $result4='false' and $result5='false'">
                  <xsl:text>com.mcafee.pa.msg.NotPat1AndPat2Pat3Missing</xsl:text>
                </xsl:when>
                <xsl:when test="$result3='true' and $result4='false' and $result5='false'">
                  <xsl:text>com.mcafee.pa.msg.Pat2Pat3Missing</xsl:text>
                </xsl:when>
                <xsl:when test="$result3='true' and $result4='false' and $result5='true'">
                  <xsl:text>com.mcafee.pa.msg.Patn2Missing</xsl:text>
                </xsl:when>
                <xsl:when test="$result3='true' and $result4='true' and $result5='false'">
                  <xsl:text>com.mcafee.pa.msg.Patn3Missing</xsl:text>
                </xsl:when>
                <xsl:when test="$result3='false' and $result4='true' and $result5='true'">
                  <xsl:text>com.mcafee.pa.msg.NotPat1</xsl:text>
                </xsl:when>
                <xsl:when test="$result3='false' and $result4='true' and $result5='false'">
                  <xsl:text>com.mcafee.pa.msg.NotPat1AndPat3Missing</xsl:text>
                </xsl:when>
                <xsl:when test="$result3='false' and $result4='false' and $result5='true'">
                  <xsl:text>com.mcafee.pa.msg.NotPat1AndPat2Missing</xsl:text>
                </xsl:when>
              </xsl:choose>
            </xsl:when>
          </xsl:choose>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text>com.mcafee.pa.msg.configGenericSCAP</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
   </xsl:variable>
    
    <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
      <xsl:attribute name="id">
        <xsl:value-of select="$definitionId"/>
      </xsl:attribute>
      <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
        <xsl:attribute name="messageId">
          <xsl:value-of select="$message_id"/>
        </xsl:attribute>
        <xsl:attribute name="isViolation">
          <xsl:value-of select="$isViolationValue"/>
        </xsl:attribute>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">config_name</xsl:attribute>
          <xsl:value-of select="$title"/>
        </xsl:element>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">pattern1</xsl:attribute>
          <xsl:value-of select="$textfilePattern1"/>
        </xsl:element>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">file_info1</xsl:attribute>
          <xsl:value-of select="$fileInfo1"/>
        </xsl:element>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">pattern2</xsl:attribute>
          <xsl:value-of select="$textfilePattern2"/>
        </xsl:element>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">file_info2</xsl:attribute>
          <xsl:value-of select="$fileInfo2"/>
        </xsl:element>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">pattern3</xsl:attribute>
          <xsl:value-of select="$textfilePattern3"/>
        </xsl:element>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">file_info</xsl:attribute>
          <xsl:value-of select="$fileInfo"/>
        </xsl:element>
      </xsl:element>
    </xsl:element>
</xsl:template>
</xsl:stylesheet>