<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
    exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def">
    
    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>

    <xsl:template name="windowsPatchDefinition">
        <xsl:param name="definition_id"/>
        <xsl:variable name="result"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definition_id]/@result"/>
        <xsl:variable name="definitionTitle" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions/oval-def:definition/oval-def:metadata/oval-def:title"></xsl:variable>
        <findings xmlns="http://results.pa.mcafee.com/findings/5.2" id="{$definition_id}">
            <xsl:element name="inputValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="key">title</xsl:attribute>
                <xsl:value-of select="$definitionTitle"/>
            </xsl:element>
            <xsl:choose>
                <xsl:when test="$result='false'">
                    <xsl:call-template name="windowsPatchPrereq" >
                        <xsl:with-param name="definition_id" select="$definition_id" />
                    </xsl:call-template>
                </xsl:when>
                <xsl:otherwise>
                    <!-- Message 'The patch (##title##) is not installed on this system.' -->
                    <finding xmlns="http://results.pa.mcafee.com/findings/5.2" messageId="com.mcafee.pa.msg.patchNotInstalled" isViolation="true">
                    </finding>
                </xsl:otherwise>
            </xsl:choose>
        </findings>
    </xsl:template>
    
    <xsl:template name="windowsPatchPrereq">
        <xsl:param name="definition_id"/>
        <xsl:variable name="prereqCriteraResult" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definition_id]/oval-res:criteria/oval-res:criteria[1]/@result"/>
        <xsl:choose>
            <xsl:when test="$prereqCriteraResult='false'">
            <!-- Message 'The patch (##title##) is not applicable to this system.' -->
            <finding xmlns="http://results.pa.mcafee.com/findings/5.2" messageId="com.mcafee.pa.msg.patchNotApplicable" isViolation="false">
            </finding>
            </xsl:when>
            <xsl:otherwise>
                <!-- Message 'The patch (##title##) has been applied to this system.' -->
                <finding xmlns="http://results.pa.mcafee.com/findings/5.2" messageId="com.mcafee.pa.msg.patchInstalled" isViolation="false">
                </finding>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:stylesheet>
