﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema"   
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan"    >
    
    <!--  FILENAME: winCompEventLogServSettings_2_SCAP.xsl         DATE: 16th Jan, 2013     AUTHOR: Nandini NR   -->
    <!--  MAPPINGFILE: winCompEventLogServSettings_2_SCAP_xsl.txt    -->
    
    <!-- THIS LIBRARY IS DEVELOPED FOR WINDOWS COMPLIANCE CHECKS TO VERIFY IE Settings -->
    
<!-- FOLLOWING ARE SOME OF THE ASSUMPTIONS TAKEN IN THE LOGIC FOR THE LIBRARY  -->
   <!--   1. Configuration/Policy name is extracted from the title of the check.
            2. Following are the nine test cases which are taken into consideration for the logic:-
    
    Check Logic :-
            <criteria operator='AND'>
                <criteria operator='OR'>
                    <criterion comment='Internet Explorer 6 is installed' test_ref='oval:com.mcafee.oval:tst:75515' />
                            <criteria operator='AND'>
                                    <criterion negate='false' comment='External Variable = Not Configured' test_ref='oval:com.mcafee.oval:tst:240939' />
                                    <criterion negate='false' comment='Registry key HKLM\Software\Policies\Microsoft\Internet Explorer\SQM\DisableCustomerImprovementProgram does not exist' test_ref='oval:com.mcafee.oval:tst:240940' />
                            </criteria>
                            <criteria operator='AND'>
                                <criterion negate='false' comment='External Variable = Enabled' test_ref='oval:com.mcafee.oval:tst:240941' />
                                <criterion negate='false' comment='Registry key HKLM\Software\Policies\Microsoft\Internet Explorer\SQM\DisableCustomerImprovementProgram = 0' test_ref='oval:com.mcafee.oval:tst:240942' />
                           </criteria>
                           <criteria operator='AND'>
                                <criterion negate='false' comment='External Variable = Disabled' test_ref='oval:com.mcafee.oval:tst:240943' />
                                <criterion negate='false' comment='Registry key HKLM\Software\Policies\Microsoft\Internet Explorer\SQM\DisableCustomerImprovementProgram = 1' test_ref='oval:com.mcafee.oval:tst:240944' />
                           </criteria>
                </criteria>
      </criteria>
   
   <external_variable id='oval:com.mcafee.oval.ie7:var:821' version='5' datatype='string' comment='Prevent participation in the Customer Experience Improvement Program'>
       <possible_value hint='Enabled'>Enabled</possible_value>
       <possible_value hint='Disabled'>Disabled</possible_value>
       <possible_value hint='Not Configured'>Not Configured</possible_value>
   </external_variable>
   
   Ex:- oval:com.mcafee.oval.ie7:def:1171
   -->

    
    <!-- Entry Function for the library  -->
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        
        <!-- Final result -->
        <xsl:variable name="result"  select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <xsl:variable name="Definitions"
            select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
        
        <!-- Extract configuration/policy name from the check title -->
        <xsl:variable name="title">
            <xsl:value-of select="$Definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>            
        </xsl:variable>
        
        <xsl:variable name="result1"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[1]/@result"/>
        <xsl:variable name="result2"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[2]/@result"/>
        <xsl:variable name="result3"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[3]/@result"/>
        <xsl:variable name="result4"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[4]/@result"/>
        <xsl:variable name="result5"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[5]/@result"/>
        <xsl:variable name="result6"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[6]/@result"/>
        <xsl:variable name="result7"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[7]/@result"/>
        
        
        <!-- Decide about the message id depending upon  the combination of results for various criterions ........................................................................................... -->

            <xsl:variable name="message_id">
                    <xsl:choose>
                        <xsl:when test="$result1 = 'true'">
                            <xsl:text>com.mcafee.pa.msg.ConfigNotApplicable_SCAP</xsl:text>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:text>com.mcafee.pa.msg.winConf_SCAP</xsl:text>
                        </xsl:otherwise>
                    </xsl:choose>
            </xsl:variable>
            
        <xsl:variable name="expectedValue">
            <xsl:choose>
                <xsl:when test="$result2 = 'true' ">
                    <xsl:text>Not Configured</xsl:text>                                              
                </xsl:when>
                <xsl:when test="$result4 = 'true' ">
                    <xsl:text>Enabled (1)</xsl:text>                                              
                </xsl:when>
                <xsl:when test="$result6 = 'true' ">
                    <xsl:text>Disabled (0)</xsl:text>                                              
                </xsl:when>
            </xsl:choose>               
        </xsl:variable>
        
        <xsl:variable name="actualValue">
            <xsl:choose>
                <xsl:when test="$result3 = 'true' ">
                    <xsl:text>Not Configured</xsl:text>                                              
                </xsl:when>
                <xsl:when test="$result5 = 'true' ">
                    <xsl:text>Enabled (1)</xsl:text>                                              
                </xsl:when>
                <xsl:when test="$result7 = 'true' ">
                    <xsl:text>Disabled (0)</xsl:text>                                              
                </xsl:when>
            </xsl:choose>               
        </xsl:variable>
        
        <!-- Decide about the isViolation value depending upon  the result of the check ........................................................................................... -->
            <xsl:variable name="isViolationValue">
                <xsl:choose>
                    <xsl:when test="$result = 'false' ">
                        <xsl:text>true</xsl:text>                                              
                    </xsl:when>
                    <xsl:when test="$result = 'true' ">
                        <xsl:text>false</xsl:text>                                              
                    </xsl:when>
                    </xsl:choose>               
            </xsl:variable>
        
        <!--Now Create Finding xml with all the values extracted ........................................................................................... -->
        <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">

            <finding messageId="{$message_id}" isViolation="{$isViolationValue}">
                <instanceValue key="title">
                    <xsl:value-of select="$title"/>                                                    
                </instanceValue>
                <instanceValue key="expectedValue">
                    <xsl:value-of select="$expectedValue"/>                                                    
                </instanceValue>
                <actualValue key="actualValue">
                    <xsl:value-of select="$actualValue"/>                                                    
                </actualValue>
            </finding>
        </findings>
      
    </xsl:template>
</xsl:stylesheet>
