<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
    exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def">
    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>

    <xsl:template name="xinetdDisabled">
        <xsl:param name="definition_id"/>
        <xsl:variable name="result"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definition_id]/@result"/>
        <xsl:if test="$result='false'">
            <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="id">
                    <xsl:value-of select="$definition_id"/>
                </xsl:attribute>
                <xsl:variable name="test_id"
                    select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definition_id]/descendant::oval-res:criterion[1]/@test_ref"/>
                <xsl:call-template name="xinetdTestDisabled">
                    <xsl:with-param name="test_Id" select="$test_id"/>
                </xsl:call-template>
            </xsl:element>
        </xsl:if>
    </xsl:template>
    <xsl:template name="xinetdTestDisabled">
        <xsl:param name="test_Id"/>
        <xsl:variable name="definitionTest"
            select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:xinetd_test[@id=$test_Id]"/>
        <xsl:variable name="state_id"
            select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:xinetd_test[@id=$test_Id]/unix-def:state/@state_ref"/>
        <xsl:variable name="state"
            select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states/unix-def:xinetd_state[@id=$state_id]"/>
        <xsl:element name="inputValue" namespace="http://results.pa.mcafee.com/findings/5.2">
            <xsl:attribute name="key">service_name</xsl:attribute>
            <xsl:value-of
                select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:xinetd_object[@id=$definitionTest/unix-def:object/@object_ref]/unix-def:service_name/text()"
            />
        </xsl:element>
        <xsl:element name="inputValue" namespace="http://results.pa.mcafee.com/findings/5.2">
            <xsl:attribute name="key">protocol</xsl:attribute>
            <xsl:value-of
                select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:xinetd_object[@id=$definitionTest/unix-def:object/@object_ref]/unix-def:protocol/text()"
            />
        </xsl:element>
        <xsl:for-each
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$test_Id]/oval-res:tested_item[@result='false']">
            <xsl:variable name="item_id" select="@item_id"/>
            <xsl:variable name="item"
                select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/unix-sc:xinetd_item[@id=$item_id]"/>
            <xsl:element namespace="http://results.pa.mcafee.com/findings/5.2" name="finding">
                <!-- The xinetd service ##service_name## using protocol ##protocol## is not disabled. !-->
                <xsl:attribute name="messageId">com.mcafee.pa.msg.unixXinetdDisabled0</xsl:attribute>
                <xsl:attribute name="isViolation">true</xsl:attribute>
            </xsl:element>
        </xsl:for-each>
        <xsl:for-each
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$test_Id]/oval-res:tested_item[@result='not evaluated']">
            <xsl:variable name="item_id" select="@item_id"/>
            <xsl:variable name="item"
                select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/unix-sc:xinetd_item[@id=$item_id]"/>
            <xsl:element namespace="http://results.pa.mcafee.com/findings/5.2" name="finding">
                <!-- The xinetd service ##service_name## using protocol ##protocol## does not exist. !-->
                <xsl:attribute name="messageId">com.mcafee.pa.msg.unixXinetdDisabled1</xsl:attribute>
                <xsl:attribute name="isViolation">true</xsl:attribute>
            </xsl:element>
        </xsl:for-each>
        
    </xsl:template>
</xsl:stylesheet>
