﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema"   
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan"    >
    
    <!-- Library Logic
        This library will work in case where there are 4 criterion's
        1) If IIS is not installed then Result is Pass with message saying IIS is not installed
        2) In any other pass case we return Pass wtih message as Configuration $$config$$ is set to ##expectedValue## as expected.
        3) In case where Configuration is set at user level but not set to user expected value then we return Fail with message as Configuration $$config$$ is set to %%actualValue_userlevel%%. It should be set to ##expectedValue##.
        4) In case where Configuration file is not present at user specified file but configuration is present at root level but not to user expected value then ue then we return Fail with message as Configuration $$config$$ is set to %%actualValue_userlevel%%. It should be set to ##expectedValue##.
        5) In case where Configuration file is not present at both root and user paths i.e. default installation but value different from user expected value then we return Fail with message as Configuration $$config$$ is set to $$defaultValue$$ but it should be set to ##expectedValue##.
    -->     
    
    <!-- Entry Function for the library  -->
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        <xsl:variable name="result"  select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <xsl:variable name="Definitions"
            select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
        <xsl:variable name="title">
            <xsl:value-of select="$Definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>            
        </xsl:variable>
        
        <xsl:variable name="result1"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[1]/@result"/>
        <xsl:variable name="result2"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[2]/@result"/>
        <xsl:variable name="result3"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[3]/@result"/>
        <xsl:variable name="result4"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[4]/@result"/>
        <xsl:variable name="result5"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[5]/@result"/>
        <xsl:variable name="result6"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[6]/@result"/>
        <xsl:variable name="result7"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[7]/@result"/>
        <xsl:variable name="result8"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[8]/@result"/>
        
        <!-- Actual Value at root level -->
        <!--xsl:variable name="system_config_1" 
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/ind-sc:xmlfilecontent_item[@id=4]/ind-sc:value_of"/-->
        <xsl:variable name="system_config_1"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/ind-sc:xmlfilecontent_item/ind-sc:value_of/text()"/>
        <!-- Actual Value at user level -->
        <!--xsl:variable name="system_config_2" 
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/ind-sc:xmlfilecontent_item[@id=5]/ind-sc:value_of"/-->
        <xsl:variable name="system_config_2"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/ind-sc:xmlfilecontent_item/ind-sc:value_of/text()"/>
        <xsl:variable name="stateID"
            select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states/oval-ind:xmlfilecontent_state/oval-ind:value_of/@var_ref"/>
        <!--xsl:variable name="externalVarID" 
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables/oval-def:external_variable/@id"/-->
        <xsl:variable name="defaultValue" 
            select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states/oval-ind:variable_state/oval-ind:value"/>
        <xsl:variable name="UserExpectedValue" 
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test/oval-res:tested_variable[@variable_id=$stateID]"/>
        
        <!-- Decide about the message id depending upon  the combination of results for various criterions ........................................................................................... -->

            <xsl:variable name="message_id">
                
                <!-- Check if result is true ........................................................................................... -->
                <xsl:if test="$result='true'">
                    <xsl:choose>
                        <xsl:when test="$result1 = 'true' ">
                            <xsl:text>com.mcafee.pa.msg.IISNotInstalled</xsl:text>                                    
                        </xsl:when>
                        <xsl:when test="$result = 'true' ">
                            <xsl:text>com.mcafee.pa.msg.winconfig_SCAP_IIS_1</xsl:text>                   
                        </xsl:when>
                    </xsl:choose>
                </xsl:if>
                
                <!-- Check if result is false ........................................................................................... -->
                <xsl:if test="$result='false'">
                    <xsl:choose>
                        <xsl:when test="$result7 = 'true' and  $result6 = 'false'  and $result5 = 'true'">
                            <xsl:text>com.mcafee.pa.msg.winconfig_SCAP_IIS_7</xsl:text>    
                        </xsl:when>
                        <xsl:when test="$result7 = 'true' and  $result6 = 'false'  and $result5 = 'false'">
                            <xsl:text>com.mcafee.pa.msg.winconfig_SCAP_IIS_4</xsl:text>    
                        </xsl:when>
                        <xsl:when test="$result8 = 'false' and  $result7 = 'false'">
                            <xsl:text>com.mcafee.pa.msg.winconfig_SCAP_IIS_5</xsl:text>    
                        </xsl:when>
                    </xsl:choose>
                </xsl:if>
  
            </xsl:variable>
            
        <!-- Decide about the isViolation value depending upon  the result of the check ........................................................................................... -->
            <xsl:variable name="isViolationValue">
                <xsl:choose>
                    <xsl:when test="$result = 'false' ">
                        <xsl:text>true</xsl:text>                                              
                    </xsl:when>
                    <xsl:when test="$result = 'true' ">
                        <xsl:text>false</xsl:text>                                              
                    </xsl:when>
                    </xsl:choose>               
            </xsl:variable>
        
        <!--Now Create Finding xml with all the values extracted ........................................................................................... -->
        <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">
            <inputValue key="expectedValue">
                <xsl:value-of select="$UserExpectedValue"/>                                                    
            </inputValue>
            <finding messageId="{$message_id}" isViolation="{$isViolationValue}">
                <instanceValue key="config">
                    <xsl:value-of select="$title"/>                                                    
                </instanceValue>
                <instanceValue key="defaultValue">
                    <xsl:value-of select="$defaultValue"/>                                                    
                </instanceValue>
                <actualValue key="actualValue_rootlevel">
                    <xsl:value-of select="$system_config_1"/>                                                    
                </actualValue>
                <actualValue key="actualValue_userlevel">
                    <xsl:value-of select="$system_config_2"/>                                                    
                </actualValue>
            </finding>
        </findings>
    </xsl:template>
</xsl:stylesheet>
