<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema"   
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan"
    >
    
    <!--
        
        This XSLT is used for the definition which want to verify whther some registry parameter 
        are set as expected or not. ( cover = != < > <= etc...).
        
        Criterio ( and )
            criterion : family test 
            criterion              Registry test  with input value
            one or more test  .. 
         or 
        
        Criterio ( and )
            criterion : family test 
            Criterio ( and )
                criterion              Registry test  with input value 
                one or more test ...
      
    -->
    
    <xsl:variable name="Definitions"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
    <xsl:variable name="Tests"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests"/>
    <xsl:variable name="TestedItems"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests"/>
    <xsl:variable name="CollectedObjects"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:collected_objects"/>
    <xsl:variable name="SystemData"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data"/>
    <xsl:variable name="States"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states"/>
    <xsl:variable name="Objects"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects"/>
    <xsl:variable name="Variables"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables"/>
    <xsl:variable name="OvalResult"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions"/>
    
    <xsl:variable name="smallcase" select="'abcdefghijklmnopqrstuvwxyz'" />
    <xsl:variable name="uppercase" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'" />
    
    <xsl:template name="formatDisplayOpration">
        <xsl:param name="operation"/>
        <xsl:param name="datatype"/>
        
        <xsl:choose>
            <xsl:when test="$datatype = 'int' ">
                
                <xsl:choose>                    
                    <xsl:when test=" $operation = 'not equal' ">
                        <xsl:text>should not be equal to</xsl:text>
                    </xsl:when>
                    <xsl:when test=" $operation = 'greater than' ">
                        <xsl:text>should be greater than</xsl:text>
                    </xsl:when>
                    <xsl:when test=" $operation = 'less than' ">
                        <xsl:text>should be less than</xsl:text>
                    </xsl:when>
                    <xsl:when test=" $operation = 'greater than or equal' ">
                        <xsl:text>should be greater than or equal to</xsl:text>
                    </xsl:when>
                    
                    <xsl:when test=" $operation = 'less than or equal' ">
                        <xsl:text>should be less than or equal to</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>                        
                            <xsl:text>should be equal to</xsl:text>                        
                    </xsl:otherwise>                    
                </xsl:choose>
            </xsl:when>
            
            <xsl:when test="$datatype = 'boolean' ">
                
                <xsl:choose>                    
                    <xsl:when test=" $operation = 'not equal' ">
                        <xsl:text>should not be</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>                        
                        <xsl:text>should be</xsl:text>                        
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            
            <xsl:when test="$datatype = 'string' ">
                
                <xsl:choose>
                    <xsl:when test=" $operation = 'pattern match' ">
                        <xsl:text>should be like</xsl:text>
                    </xsl:when>
                    <xsl:when test=" $operation = 'not equal' ">
                        <xsl:text>should not be</xsl:text>
                    </xsl:when>                    
                    <xsl:otherwise>                        
                        <xsl:text>should be</xsl:text>                        
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            
        </xsl:choose>
    </xsl:template>
  
    <xsl:template name="getDisplayOperation">
        <xsl:param name="id"/>
        <xsl:param name="operation"/>
        
        <xsl:variable name="datatype">
            <xsl:call-template name="getExternalVariableDataType">
                <xsl:with-param name="id" select="$id"/>
            </xsl:call-template>
        </xsl:variable>
        
        <xsl:variable name="display_operation">
            <xsl:call-template name="formatDisplayOpration">
                <xsl:with-param name="operation" select="$operation"/>
                <xsl:with-param name="datatype" select="$datatype"/>
             </xsl:call-template>               
        </xsl:variable>
        
        <xsl:value-of select="$display_operation"/>
     </xsl:template>
    
    <xsl:template name="getQuntitativeValue">
        <xsl:param name="id"/>
        <xsl:param name="numaricValue"/>
        
        <xsl:variable name="comment">
            <xsl:value-of select="translate($Variables/oval-def:external_variable[@id = $id]/@comment,$uppercase,$smallcase)"/>
        </xsl:variable>
        
        <xsl:variable name="time">
            <xsl:choose>
                
                <xsl:when test="contains($comment, ' milliseconds' )">                    
                    <xsl:value-of select="$numaricValue"/><xsl:text> MilliSeconds</xsl:text>                              
                </xsl:when>
                
                <xsl:when test="contains($comment, ' seconds' )">
                    <xsl:choose>
                        <xsl:when test="number(number($numaricValue) div  number( 60 * 60 * 24 )) &gt;= 1">
                            <xsl:value-of select="number($numaricValue) div  number( 60 * 60 * 24 )"/><xsl:text> Days</xsl:text>                                
                        </xsl:when>
                        <xsl:when test="number(number($numaricValue) div  number( 60 * 60 )) &gt;= 1">
                            <xsl:value-of select="number($numaricValue) div  number( 60 * 60 )"/><xsl:text> Hours</xsl:text>                                
                        </xsl:when>
                        <xsl:when test="number(number($numaricValue) div  60) &gt;= 1">
                            <xsl:value-of select="number($numaricValue) div  60"/><xsl:text> Minutes</xsl:text>                                
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="$numaricValue"/><xsl:text> Seconds</xsl:text>                                
                        </xsl:otherwise>
                    </xsl:choose>
                    
                    
                </xsl:when>
                <xsl:when test="contains($comment, 'minutes' )">
                    <xsl:choose>
                        <xsl:when test="number(number($numaricValue) div  number( 60 * 24 )) &gt;= 1">
                            <xsl:value-of select="number($numaricValue) div  number( 60 * 24 )"/><xsl:text> Days</xsl:text>                                
                        </xsl:when>
                        <xsl:when test="number(number($numaricValue) div  60) &gt;= 1">
                            <xsl:value-of select="number($numaricValue) div  60"/><xsl:text> Hours</xsl:text>                                
                        </xsl:when>                        
                        <xsl:otherwise>
                            <xsl:value-of select="$numaricValue"/><xsl:text> Minutes</xsl:text>                                
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <xsl:when test="contains($comment, 'hours' )">
                    <xsl:choose>
                        <xsl:when test="number(number($numaricValue) div  24) &gt;= 1">
                            <xsl:value-of select="number($numaricValue) div  24"/><xsl:text> Days</xsl:text>                                
                        </xsl:when>                                                
                        <xsl:otherwise>
                            <xsl:value-of select="$numaricValue"/><xsl:text> Hours</xsl:text>                                
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <xsl:when test="contains($comment, 'days' )">
                    <xsl:value-of select="$numaricValue"/> <xsl:text> Days</xsl:text>     
                </xsl:when>
            </xsl:choose>
            
        </xsl:variable>
        
        <xsl:variable name="size">
            <xsl:choose>                
                <xsl:when test="contains($comment, 'kilobytes' )">
                    <xsl:choose>
                        <xsl:when test="number(number($numaricValue) div  1024) &gt;= 1">
                            <xsl:value-of select="number($numaricValue) div  1024"/><xsl:text> MB</xsl:text>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="$numaricValue"/><xsl:text> KB</xsl:text>                                
                        </xsl:otherwise>
                    </xsl:choose>                    
                </xsl:when>
                
                <xsl:when test="contains($comment, 'bytes' )">
                    <xsl:choose>
                        <xsl:when test="number(number($numaricValue) div  number( 1024 *1024 ) ) &gt;= 1">
                            <xsl:value-of select="number($numaricValue) div  number( 1024 * 1024 )"/><xsl:text> MB</xsl:text>
                        </xsl:when>
                        <xsl:when test="number(number($numaricValue) div  1024) &gt;= 1">
                            <xsl:value-of select="number($numaricValue) div  1024"/><xsl:text> KB</xsl:text>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="$numaricValue"/><xsl:text> Bytes</xsl:text>                                
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:when>                
            </xsl:choose>            
        </xsl:variable>
        
        <xsl:choose>
            <xsl:when test="$time != '' ">
                <xsl:value-of select="$time"/>
            </xsl:when>
            <xsl:when test="$size != '' ">
                <xsl:value-of select="$size"/>
            </xsl:when>
        </xsl:choose>
        
        
    </xsl:template>
     
    <xsl:template name="getExternalVariablePrintableValue">
        <xsl:param name="id"/>
        <xsl:param name="numaricValue"/>
        
        
        <xsl:variable name="printableValue">
            <xsl:for-each select="$Variables/oval-def:external_variable[@id = $id]/descendant::oval-def:possible_value">
                <xsl:if test="text() = $numaricValue">
                    <xsl:value-of select="@hint"/>
                </xsl:if>
            </xsl:for-each>
        </xsl:variable>
        
        <xsl:variable name="datatype">
            <xsl:call-template name="getExternalVariableDataType">
                <xsl:with-param name="id" select="$id"/>       
            </xsl:call-template>
        </xsl:variable>
        
        <xsl:variable name="time_or_size_value">
            <xsl:if test="$datatype = 'int' ">
                <xsl:call-template name="getQuntitativeValue">
                    <xsl:with-param name="id" select="$id"/>
                    <xsl:with-param name="numaricValue" select="$numaricValue"/>
                </xsl:call-template>
            </xsl:if>
        </xsl:variable>
        
        <xsl:variable name="formattedNumaricValue">
            <xsl:choose>
                <xsl:when test="$time_or_size_value != '' ">
                    <xsl:value-of select="$time_or_size_value"/>
                </xsl:when>
                <xsl:when test="$printableValue != '' ">
                    <xsl:value-of select="$numaricValue"/><xsl:text>  ( </xsl:text><xsl:value-of select="$printableValue"/><xsl:text> )</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$numaricValue"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable> 
        
       <xsl:value-of select="$formattedNumaricValue"/>
        
    </xsl:template>
    
    <xsl:template name="getExternalVariableDataType">
        <xsl:param name="id"/>
        
        <xsl:variable name="datatype">
            <xsl:value-of select="$Variables/oval-def:external_variable[@id = $id]/@datatype"/>
        </xsl:variable>
        
        <xsl:variable name="values">
            <xsl:for-each select="$Variables/oval-def:external_variable[@id = $id]/*">
                <xsl:value-of select="text()"/>
            </xsl:for-each>
        </xsl:variable>
        
        <xsl:choose>
            <xsl:when test="$values= '01' or $values = '10'  ">
                <xsl:text>boolean</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$datatype"/>
            </xsl:otherwise>
        </xsl:choose>
        
    </xsl:template>
             
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        
        <xsl:variable name="result"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <xsl:if test="$result='false' ">
            <xsl:call-template name="winRegistryParameterValueCheck">
                <xsl:with-param name="definitionId" select="$definitionId"/>
            </xsl:call-template>
        </xsl:if>
        
    </xsl:template>
    
    <xsl:template name="winRegistryParameterValueCheck">
        <xsl:param name="definitionId"/>       
        
        <xsl:variable name="tests">        
            <xsl:for-each select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:criterion">
                
                <xsl:variable name="test" select="@test_ref"/>
                <xsl:if test="$Tests/win-def:registry_test[@id=$test]">
                    <xsl:variable name="object" select="$Tests/win-def:registry_test[@id=$test]/win-def:object/@object_ref"/>
                    <xsl:variable name="state"  select="$Tests/win-def:registry_test[@id=$test]/win-def:state/@state_ref"/>
                    
                    <xsl:variable name="key" select="$Objects/win-def:registry_object[@id=$object]/win-def:key"/>
                    <xsl:variable name="name" select="$Objects/win-def:registry_object[@id=$object]/win-def:name"/>
                    
                    <xsl:variable name="externalVar" select="$States/win-def:registry_state[@id=$state]/win-def:value/@var_ref"/>
                    <xsl:variable name="operation" select="$States/win-def:registry_state[@id=$state]/win-def:value/@operation"/>
                    
                    <xsl:element name="test">
                        <xsl:attribute name="id">
                            <xsl:value-of select="$test"/>
                        </xsl:attribute>
                        
                        <xsl:attribute name="key">
                            <xsl:value-of select="$key"/>
                        </xsl:attribute>
                        
                        <xsl:attribute name="state">
                            <xsl:value-of select="$state"/>
                        </xsl:attribute>
                        
                        <xsl:attribute name="name">
                            <xsl:value-of select="$name"/>
                        </xsl:attribute>
                        <xsl:attribute name="externalVar">
                            <xsl:value-of select="$externalVar"/>
                        </xsl:attribute>
                        <xsl:attribute name="operation">
                            <xsl:value-of select="$operation"/>
                        </xsl:attribute>
                        
                        <xsl:if test="$States/win-def:registry_state[@id=$state]/win-def:value or $state = '' ">
                            <xsl:attribute name="type">
                                <xsl:text>primarytest</xsl:text>
                            </xsl:attribute>
                        </xsl:if>
                        
                        <xsl:if test="$States/win-def:registry_state[@id=$state]/win-def:type and not($States/win-def:registry_state[@id=$state]/win-def:value)">
                            <xsl:attribute name="type">
                                <xsl:text>typecheckingtest</xsl:text>
                            </xsl:attribute>
                            <xsl:attribute name="typeName">
                                <xsl:value-of select="$States/win-def:registry_state[@id=$state]/win-def:type"/>
                            </xsl:attribute>
                        </xsl:if>                        
                    </xsl:element>
                </xsl:if>
                
                <xsl:if test="$Tests/oval-ind:family_test[@id=$test]">
                    <xsl:element name="test">
                        <xsl:attribute name="id">
                            <xsl:value-of select="$test"/>
                        </xsl:attribute>
                        <xsl:attribute name="type">
                            <xsl:text>family</xsl:text>
                        </xsl:attribute>                        
                    </xsl:element>
                </xsl:if>
            </xsl:for-each>            
            
        </xsl:variable>
        
     
        <xsl:variable name="pre_test">
            <xsl:value-of select="xalan:nodeset($tests)/test[@type='family']/@id"/>              
        </xsl:variable>
        
        <xsl:variable name="pre_test_result">
            <xsl:value-of select="$TestedItems/oval-res:test[@test_id=$pre_test ]/@result"/> 
        </xsl:variable>
        
        
        <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">       
            
            <xsl:if test=" $pre_test_result = 'true' ">
                
                <xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @type ='typecheckingtest' ]">
                    <xsl:variable name="test" select="@id"/>
                    <xsl:variable name="key" select="@key"/>
                    <xsl:variable name="name" select="@name"/>                    
                    <xsl:variable name="typeName" select="@typeName"/>
                    
                    <xsl:for-each  select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[ @result = 'false' ] ">
                        
                        <xsl:variable name="itemRef" select="@item_id"/>
                        <xsl:variable name="result" select="@result"/>
                        
                        <xsl:variable name="actualParameterType" select="$SystemData/win-sc:registry_item[@id=$itemRef]/win-sc:type"/>
                        
                        <xsl:if test="$actualParameterType != '' ">
                            <finding messageId="com.mcafee.pa.msg.winregistryvaluetypeisinvalid" isViolation="true">                                
                                <instanceValue key="registry">
                                    <xsl:value-of select="$key"/><xsl:text>\</xsl:text><xsl:value-of select="$name"/>                                                    
                                </instanceValue>                                
                                <instanceValue key="expectedType">
                                    <xsl:value-of select="$typeName"/>                                                    
                                </instanceValue>
                                <actualValue key="actualType">
                                    <xsl:value-of select="$actualParameterType"/>                                                    
                                </actualValue>
                            </finding>
                        </xsl:if>
                    </xsl:for-each>
                </xsl:for-each>
                
                <xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @type ='primarytest' ]">
                    <xsl:variable name="test" select="@id"/>
                    <xsl:variable name="state" select="@state"/>
                    <xsl:variable name="key" select="@key"/>
                    <xsl:variable name="name" select="@name"/>
                    
                    <xsl:variable name="externalVarId" select="@externalVar"/>
                    <xsl:variable name="operation" select="@operation"/>
                    
                    <xsl:variable name="display_operation">
                        <xsl:call-template name="getDisplayOperation">
                            <xsl:with-param name="id"  select="$externalVarId"/>
                            <xsl:with-param name="operation" select="$operation"/>
                        </xsl:call-template>
                    </xsl:variable>
                    
                    <xsl:variable name="externalVarValue" 
                        select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable[@variable_id = $externalVarId]"/>
                    
                    <xsl:variable name="inputRegistryParameterValue">
                        <xsl:call-template name="getExternalVariablePrintableValue">
                            <xsl:with-param name="id" select="$externalVarId"  />
                            <xsl:with-param name="numaricValue" select="$externalVarValue"/>
                        </xsl:call-template>
                    </xsl:variable> 
                    
                    <xsl:if test="$state != '' ">                      
                        <xsl:for-each  select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[ @result = 'false'  or @result = 'error'  or  @result='not evaluated' ] ">
                            
                            <xsl:variable name="itemRef" select="@item_id"/>
                            <xsl:variable name="result" select="@result"/>
                            
                            <xsl:variable name="actualParameterValue" select="$SystemData/win-sc:registry_item[@id=$itemRef]/win-sc:value"/>
                            <xsl:variable name="actualParameterStatus" select="$SystemData/win-sc:registry_item[@id=$itemRef]/win-sc:name/@status"/>
                            
                            <xsl:variable name="actualParameterPrintableValue">
                                <xsl:call-template name="getExternalVariablePrintableValue">
                                    <xsl:with-param name="id" select="$externalVarId"  />
                                    <xsl:with-param name="numaricValue" select="$actualParameterValue"/>
                                </xsl:call-template>
                            </xsl:variable> 
                            
                            <xsl:variable name="message_id">
                                <xsl:choose>
                                    <xsl:when test="$actualParameterStatus = 'does not exist' ">
                                        <xsl:text>com.mcafee.pa.msg.winregistryparameternotset</xsl:text>                                    
                                    </xsl:when>
                                    <xsl:when test="$result = 'error' or  $result='not evaluated' ">
                                        <xsl:text>com.mcafee.pa.msg.winregistryparametererror</xsl:text>                                    
                                    </xsl:when>                                
                                    <xsl:otherwise>                                
                                        <xsl:text>com.mcafee.pa.msg.winregistryparametersettingmessage</xsl:text>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:variable>
                            
                            
                            <finding messageId="{$message_id}" isViolation="true">
                                <instanceValue key="parameter">
                                    <xsl:value-of select="$key"/><xsl:text>\</xsl:text><xsl:value-of select="$name"/>                                                                                    
                                </instanceValue>
                                <instanceValue key="shouldbe">
                                    <xsl:value-of select="$display_operation"/>                                                    
                                </instanceValue>
                                <instanceValue key="inputStatus">
                                    <xsl:value-of select="$inputRegistryParameterValue"/>                                                    
                                </instanceValue>
                                <actualValue key="status">
                                    <xsl:value-of select="$actualParameterPrintableValue"/>                                                    
                                </actualValue>
                            </finding>
                        </xsl:for-each>
                    </xsl:if>
                    
                    <xsl:if test=" $state = '' ">
                        <xsl:for-each
                            select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[ @result = 'false'  or @result = 'error'  or  @result='not evaluated' ] ">
                            
                            <xsl:variable name="itemRef" select="@item_id"/>
                            <xsl:variable name="result" select="@result"/>
                            
                            <xsl:variable name="actualParameterValue"
                                select="$SystemData/win-sc:registry_item[@id=$itemRef]/win-sc:value"/>
                            <xsl:variable name="actualParameterStatus"
                                select="$SystemData/win-sc:registry_item[@id=$itemRef]/win-sc:name/@status"/>
                            
                            <xsl:variable name="message_id">
                                <xsl:choose>
                                    <xsl:when
                                        test="$actualParameterStatus = 'does not exist' ">
                                        <xsl:text>com.mcafee.pa.msg.winregistryisnotexist</xsl:text>
                                    </xsl:when>
                                    <xsl:when
                                        test="$result = 'error' or  $result='not evaluated' ">
                                        <xsl:text>com.mcafee.pa.msg.winregistryreaderror</xsl:text>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:text>com.mcafee.pa.msg.winregistryisexist</xsl:text>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:variable>
                            
                            <finding messageId="{$message_id}" isViolation="true">                                        
                                <instanceValue key="registry">
                                    <xsl:value-of select="$key"/><xsl:text>\</xsl:text><xsl:value-of select="$name"/>
                                </instanceValue>                                      
                            </finding>
                        </xsl:for-each>
                    </xsl:if>
                    
                </xsl:for-each>
            </xsl:if>
        </findings>
    </xsl:template>
    
</xsl:stylesheet>