<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema"   
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan"
    >
    
    <!--
        
        For which definition is this XSLT appilcable ?
        
        This library is a new library for the logic as below:
        
        <criteria operator="OR">
        <criteria operator="AND">
        <criterion comment="External Variable = Disabled/Not Configured" negate="false" test_ref="oval:com.mcafee.oval:tst:231892"/>
        <criteria operator="OR">
        <criterion comment="Registry key HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Tpm\StandardUserAuthorizationFailureTotalThreshold does not exist" negate="true" test_ref="oval:com.mcafee.oval:tst:231893"/>
        <criterion comment="Registry key HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Tpm\StandardUserAuthorizationFailureTotalThreshold = 0" negate="false" test_ref="oval:com.mcafee.oval:tst:231894"/>
        </criteria>
        </criteria>
        <criteria operator="AND">
        <criterion comment="External Variable = Enabled" negate="true" test_ref="oval:com.mcafee.oval:tst:231892"/>
        <criterion comment="Registry key HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Tpm\StandardUserAuthorizationFailureTotalThreshold = VAR" negate="false" test_ref="oval:com.mcafee.oval:tst:231895"/>
        </criteria>
        </criteria>
        
        Corresponding txt is winSystemConfigurationCheck03_SCAP_xsl.txt
        
        One  of the supported def id's is :
        oval:com.mcafee.oval:def:230030
        
        Library has simple logic of getting title, expected value and system value from the check.
     
    -->
    <xsl:variable name="SystemData"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data"/>
    
    <xsl:variable name="Variables"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables"/>
    
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        
        <xsl:variable name="result"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <xsl:variable name="title">
             <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>            
        </xsl:variable>
       
        <xsl:variable name="isViolationValue">
            <xsl:choose>
                <xsl:when test="$result = 'false' ">
                    <xsl:text>true</xsl:text>                                              
                </xsl:when>
                <xsl:when test="$result = 'true' ">
                    <xsl:text>false</xsl:text>                                              
                </xsl:when>
            </xsl:choose>               
        </xsl:variable>
        
        <xsl:variable name="message_id">
               <xsl:text>com.mcafee.pa.msg.winconfiguration_SCAP</xsl:text>
        </xsl:variable>
        
        <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">
                 <xsl:variable name="expectedValue">
                 <xsl:variable name="ExtVarItemId" select="$SystemData/ind-sc:variable_item/@id"/>
                      <xsl:choose>
                           <xsl:when test="$SystemData/ind-sc:variable_item[@id=$ExtVarItemId]/ind-sc:value='99999'">
                                <xsl:text>Not Configured/Disabled(99999)</xsl:text>
                           </xsl:when>
                           <xsl:when test="$SystemData/ind-sc:variable_item[@id=$ExtVarItemId]/ind-sc:value='0'">
                                 <xsl:text>Enabled - Threshold Value set to 0</xsl:text>
                           </xsl:when>
                           <xsl:otherwise>
                               <xsl:text>Enabled (</xsl:text><xsl:value-of select="$SystemData/ind-sc:variable_item[@id=$ExtVarItemId]/ind-sc:value"/><xsl:text>)</xsl:text>
                           </xsl:otherwise>
                     </xsl:choose>
                </xsl:variable>
                        
                <inputValue key="expectedValue">
                      <xsl:value-of select="$expectedValue"/>
                </inputValue>
                <xsl:variable name="actualValue">
                      <xsl:variable name="RegItemId" select="$SystemData/win-sc:registry_item/@id"/>
                      <xsl:choose>
                           <xsl:when test="$SystemData/win-sc:registry_item[@id=$RegItemId]/win-sc:value ='0'">
                               <xsl:text>Enabled - Threshold Value set to 0</xsl:text>
                           </xsl:when>
                           <xsl:when test="$SystemData/win-sc:registry_item[@id=$RegItemId]/win-sc:value != ''">
                               <xsl:text>Enabled (</xsl:text><xsl:value-of select="$SystemData/win-sc:registry_item[@id=$RegItemId]/win-sc:value"/><xsl:text>)</xsl:text>
                           </xsl:when>
                          <xsl:otherwise>
                              <xsl:text>Not Configured/Disabled</xsl:text>
                          </xsl:otherwise>
                          </xsl:choose>
               </xsl:variable>

            <finding messageId="{$message_id}" isViolation="{$isViolationValue}">                                                            
                   <instanceValue key="config">
                         <xsl:value-of select="$title"/>
                   </instanceValue>                                      
                <actualValue key="actualValue">
                          <xsl:value-of select="$actualValue"/>
                 </actualValue>
           </finding>
        </findings>
</xsl:template>
</xsl:stylesheet>