<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
    xmlns:aix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#aix"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
    xmlns:aix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#aix"
    xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:xalan="http://xml.apache.org/xalan"
    exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def ind-sc ind-def aix-def aix-sc">
    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>
    
    <!--
        
        This XSL is to verify if the user home directories are set with the desired directory permission.
        This library lists the home directories on a system which are not set with the directoy permissions.
        
        <criteria operator="OR">
            <criterion comment="Test the existence of defined account home directories" negate="true" test_ref="oval:com.mcafee.oval:tst:232447"/> - Home directory existence test.
            <criterion comment="Test the Permissions of defined account home directories" test_ref="oval:com.mcafee.oval:tst:232448"/> - Home directory directory permission verification test
        </criteria>
        
       Test Cases:
            1. Final Result is Pass - No desired home directories found.
            2. Final Result is Pass - All the home directories are set with required directory permissions.
            3. Final Result is Fail - One or more home directories are not set with desired directory permissions.
            
            Ex. - OVAL ID - oval:com.mcafee.oval:def:232427
    -->
    
    <xsl:param name="defid" />
    <xsl:template match="/">
        <xsl:call-template name="getFindings">
            <xsl:with-param name="definitionId" select="$defid"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="convertBinaryToOctal">
        <xsl:param name="value"/>        
        <xsl:variable name="octalVal">
            <xsl:choose>            
                <xsl:when test="contains($value, '000' )">
                    <xsl:text>0</xsl:text>                    
                </xsl:when>
                <xsl:when test="contains($value, '001' )">
                    <xsl:text>1</xsl:text>                    
                </xsl:when>
                <xsl:when test="contains($value, '010' )">
                    <xsl:text>2</xsl:text>                    
                </xsl:when>
                <xsl:when test="contains($value, '011' )">
                    <xsl:text>3</xsl:text>                    
                </xsl:when>
                <xsl:when test="contains($value, '100' )">
                    <xsl:text>4</xsl:text>                    
                </xsl:when>
                <xsl:when test="contains($value, '101' )">
                    <xsl:text>5</xsl:text>                    
                </xsl:when>
                <xsl:when test="contains($value, '110' )">
                    <xsl:text>6</xsl:text>                    
                </xsl:when>
                <xsl:when test="contains($value, '111' )">
                    <xsl:text>7</xsl:text>                    
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text>0</xsl:text>
                </xsl:otherwise>
            </xsl:choose>            
        </xsl:variable>        
        <xsl:choose>            
            <xsl:when test="$octalVal != '' ">
                <xsl:value-of select="$octalVal"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$value"/>
            </xsl:otherwise>
        </xsl:choose>        
    </xsl:template>
    
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
         
        <xsl:variable name="result"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <xsl:variable name="result1" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[1]/@result"/>
        
        <xsl:variable name="extVar_id1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables/oval-def:external_variable[1]/@id"/>
        <xsl:variable name="extVar_id2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables/oval-def:external_variable[2]/@id"/>
        <xsl:variable name="extVar_id3" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables/oval-def:external_variable[3]/@id"/>
        <xsl:variable name="extVar_id4" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables/oval-def:external_variable[4]/@id"/>
        <xsl:variable name="extVar_id5" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables/oval-def:external_variable[5]/@id"/>
        <xsl:variable name="extVar_id6" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables/oval-def:external_variable[6]/@id"/>
        <xsl:variable name="extVar_id7" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables/oval-def:external_variable[7]/@id"/>
        <xsl:variable name="extVar_id8" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables/oval-def:external_variable[8]/@id"/>
        <xsl:variable name="extVar_id9" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables/oval-def:external_variable[9]/@id"/>
        
        <xsl:variable name="testId" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[2]/@test_ref"/>
        <xsl:variable name="testedVar" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$testId]"/>
        
        <xsl:variable name="octalVal1">
            <xsl:call-template name="convertBinaryToOctal">
                <xsl:with-param name="value" select="  concat($testedVar/oval-res:tested_variable[@variable_id=$extVar_id1]/text(), $testedVar/oval-res:tested_variable[@variable_id=$extVar_id2]/text(), $testedVar/oval-res:tested_variable[@variable_id=$extVar_id3]/text())"/>
            </xsl:call-template>            
        </xsl:variable>
        
        <xsl:variable name="octalVal2">
            <xsl:call-template name="convertBinaryToOctal">
                <xsl:with-param name="value" select="  concat($testedVar/oval-res:tested_variable[@variable_id=$extVar_id4]/text(), $testedVar/oval-res:tested_variable[@variable_id=$extVar_id5]/text(), $testedVar/oval-res:tested_variable[@variable_id=$extVar_id6]/text())"/>
            </xsl:call-template>            
        </xsl:variable>
        
        <xsl:variable name="octalVal3">
            <xsl:call-template name="convertBinaryToOctal">
                <xsl:with-param name="value" select="  concat($testedVar/oval-res:tested_variable[@variable_id=$extVar_id7]/text(), $testedVar/oval-res:tested_variable[@variable_id=$extVar_id8]/text(), $testedVar/oval-res:tested_variable[@variable_id=$extVar_id9]/text())"/>
            </xsl:call-template>            
        </xsl:variable>
        
        <xsl:variable name="binaryValue">
            <xsl:value-of select="concat($testedVar/oval-res:tested_variable[@variable_id=$extVar_id1]/text(),
                $testedVar/oval-res:tested_variable[@variable_id=$extVar_id2]/text(), 
                $testedVar/oval-res:tested_variable[@variable_id=$extVar_id3]/text(), ',' ,
                $testedVar/oval-res:tested_variable[@variable_id=$extVar_id4]/text(), 
                $testedVar/oval-res:tested_variable[@variable_id=$extVar_id5]/text(),
                $testedVar/oval-res:tested_variable[@variable_id=$extVar_id6]/text(), ',' ,
                $testedVar/oval-res:tested_variable[@variable_id=$extVar_id7]/text(), 
                $testedVar/oval-res:tested_variable[@variable_id=$extVar_id8]/text(), 
                $testedVar/oval-res:tested_variable[@variable_id=$extVar_id9]/text())"/>
        </xsl:variable>
        
        <xsl:variable name="externalVarValue">
                <xsl:variable name="octalVal" select="concat($octalVal1, $octalVal2, $octalVal3) ">                     
                  </xsl:variable>                    
                <xsl:value-of select="concat($octalVal, ' (', $binaryValue, ')' )"/>                    
        </xsl:variable>
        
        <xsl:variable name="HomeDirList">
            <xsl:variable name="OvalResult"
                select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions"/>
            <xsl:variable name="Tests"
                select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests"/>
            
            <xsl:variable name="tests">
                <xsl:for-each
                    select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:criterion[2]">
                    <xsl:variable name="test" select="@test_ref"/>
                    <xsl:if test="$Tests/unix-def:file_test[@id=$test]">
                        <xsl:element name="test">
                            <xsl:attribute name="id">
                                <xsl:value-of select="$test"/>
                            </xsl:attribute>
                            <xsl:attribute name="type">
                                <xsl:text>fileTest</xsl:text>
                            </xsl:attribute>
                        </xsl:element>
                    </xsl:if>
                </xsl:for-each>
            </xsl:variable>
            
            <xsl:variable name="TestedItems"
                select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests"/>
            
            <xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @type ='fileTest' ]">
                <xsl:variable name="test" select="@id"/>
                <xsl:variable name="type" select="@type"/>
                
                <xsl:for-each select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[@result = 'false']">
                    <xsl:variable name="itemRef" select="@item_id"/>
                    <xsl:variable name="DirTestItem" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/unix-sc:file_item[@id=$itemRef]" />
                    <xsl:value-of select="concat($DirTestItem/unix-sc:path/text(),'  ')"/>
                </xsl:for-each>
            </xsl:for-each>
        </xsl:variable>
        
        <xsl:variable name="title">
            <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>            
        </xsl:variable>

        <xsl:variable name="isViolationValue">
            <xsl:choose>
                <xsl:when test="$result = 'false' ">
                    <xsl:text>true</xsl:text>
                </xsl:when>
                <xsl:when test="$result = 'true' ">
                    <xsl:text>false</xsl:text>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="message_id">
            <xsl:if test="$result='true'">
                <xsl:choose>
                    <xsl:when test="$result1='true'">
                        <xsl:text>com.mcafee.pa.msg.NoHomeDirSCAP</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>com.mcafee.pa.msg.PatternMatchSCAP</xsl:text>                        
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:if>
            <xsl:if test="$result='false'">
                <xsl:text>com.mcafee.pa.msg.HomeDirListSCAP</xsl:text>
            </xsl:if>
        </xsl:variable>
        
        <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
            <xsl:attribute name="id">
                <xsl:value-of select="$definitionId"/>
            </xsl:attribute>
            <xsl:element name="inputValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="key">expected_value</xsl:attribute>
                <xsl:value-of select="$externalVarValue"/>
            </xsl:element>
            <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="messageId">
                    <xsl:value-of select="$message_id"/>
                </xsl:attribute>
                <xsl:attribute name="isViolation">
                    <xsl:value-of select="$isViolationValue"/>
                </xsl:attribute>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">config_name</xsl:attribute>
                    <xsl:value-of select="$title"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">home_dir_list</xsl:attribute>
                    <xsl:value-of select="$HomeDirList"/>
                </xsl:element>
            </xsl:element>
        </xsl:element>
    </xsl:template>
</xsl:stylesheet>