<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
    xmlns:linux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#linux"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
    xmlns:linux-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#linux"
    xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def ind-sc ind-def">
    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>
   
    <!-- This library is to handle the OVAL checks with the Partition test with external variable. 
        Specific pattern is extrcted from the config file in test and is compared with the external variable value.
             
             Logic :-
             <criteria operator="AND">
             <criterion comment="Test if separate partitions are created" test_ref="oval:com.mcafee.oval:tst:2487861" />
             </criteria>
                        
             with External variable.
             
             Ex. OVAL ID - oval:com.mcafee.oval:def:2487644
    --> 
    
    <xsl:param name="defid" />
    <xsl:template match="/">
        <xsl:call-template name="getFindings">
            <xsl:with-param name="definitionId" select="$defid"/>
        </xsl:call-template>
    </xsl:template>
    
<!-- This library is for partition options checks in RHEL -->
    
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
         <xsl:variable name="result" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <!-- Collect configuration name from the title ......................................... --> 
        <xsl:variable name="Definitions" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
        <xsl:variable name="title" select="$Definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>
        
       <!-- Collect all the required data from the checks like test ref, obj ref, ste ref and their data and results ......................................... --> 
        <xsl:variable name="PartitionTest_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/linux-def:partition_test/@id"/>
        <xsl:variable name="extVar_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables/oval-def:external_variable/@id"/>
        
        <xsl:variable name="definitionPartitionTest" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests//linux-def:partition_test[@id=$PartitionTest_id]"/>
        <xsl:variable name="MountPoint" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/linux-def:partition_object[@id=$definitionPartitionTest/linux-def:object/@object_ref]/linux-def:mount_point/text()"/>
        
        <xsl:variable name="PartitionName" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$PartitionTest_id]/oval-res:tested_variable[@variable_id=$extVar_id]/text()"/>       
                
        <!-- Decide about the message id depending upon  the combination of results for various criterions ........................................................................................... -->
        <xsl:variable name="message_id">
            <!-- Check if result is true ........................................................................................... -->
            <xsl:if test="$result='true'">
                <!-- The partition ##partition_name## is present on the system as expected. --> 
                <xsl:text>com.mcafee.pa.msg.PartitionPresentSCAP</xsl:text>
            </xsl:if>            
            <!-- Check if result is false ........................................................................................... -->
            <xsl:if test="$result='false' ">   
                <!-- The partition ##partition_name## is not present on the system. --> 
                <xsl:text>com.mcafee.pa.msg.PartitionNotPresentSCAP</xsl:text>
            </xsl:if>  
        </xsl:variable>
        
        <xsl:variable name="isViolationValue">
            <xsl:choose>
                <xsl:when test="$result = 'false' ">
                    <xsl:text>true</xsl:text>
                </xsl:when>
                <xsl:when test="$result = 'true' ">
                    <xsl:text>false</xsl:text>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
            <xsl:attribute name="id">
                <xsl:value-of select="$definitionId"/>
            </xsl:attribute>
            <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="messageId">
                    <xsl:value-of select="$message_id"/>
                </xsl:attribute>
                <xsl:attribute name="isViolation">
                    <xsl:value-of select="$isViolationValue"/>
                </xsl:attribute>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">config_name</xsl:attribute>
                    <xsl:value-of select="$title" />
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">partition_name</xsl:attribute>
                    <xsl:value-of select="$PartitionName" />
                </xsl:element>
            </xsl:element>
        </xsl:element>
        
    </xsl:template>
</xsl:stylesheet>