<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
    exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def">
    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>
    
    
    <!--
        
        This XSL Library is to verify if user defined directories and files are set with required file permissions.
        
        <criteria operator="OR">
        <criterion comment="Test the existence of su command /usr/bin/su" negate="true" test_ref="oval:com.mcafee.oval:tst:1126578"/>
        <criterion comment="Test if su command /usr/bin/su has the suid bit set." test_ref="oval:com.mcafee.oval:tst:1126579"/>
        </criteria>
        
        <external_variable datatype="boolean" id="oval:com.mcafee.oval:var:234337" version="1" comment="Should SUID be enabled or disabled">
        <possible_value hint="enabled">true</possible_value>
        <possible_value hint="disabled">false</possible_value>
        </external_variable>
        
        Ex. OVAL ID - oval:com.mcafee.oval:def:1126576
    -->
    
    <xsl:param name="defid" />
    <xsl:template match="/">
        <xsl:call-template name="getFindings">
            <xsl:with-param name="definitionId" select="$defid"/>
        </xsl:call-template>
    </xsl:template>
    
    
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        <xsl:variable name="result" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        <xsl:variable name="Definitions" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
        
    <xsl:variable name="title" select="$Definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>
        
        <!-- Collect all results for the criterias in the variables ......................................... --> 
        <xsl:variable name="result1" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[1]/@result"/>
        <xsl:variable name="result2" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[2]/@result"/>        
        <xsl:variable name="testId" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[2]/@test_ref"/>
        
        <xsl:variable name="fileTest_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test/@id"/>
        <xsl:variable name="definitionFileTest" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test[@id=$fileTest_id]"/>
        <xsl:variable name="filePath" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:file_object[@id=$definitionFileTest/unix-def:object/@object_ref]/unix-def:path/text()" />
        <xsl:variable name="fileName" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:file_object[@id=$definitionFileTest/unix-def:object/@object_ref]/unix-def:filename/text()" />
        
        
        <!--  Extract input value -->
        <xsl:variable name="externalVarValue">
                    <xsl:value-of select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$testId]/oval-res:tested_variable[1]"/>  
        </xsl:variable>  
        
        <xsl:variable name="testedVarCount">
            <xsl:value-of select="count(/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$testId]/oval-res:tested_variable)"/>
        </xsl:variable>        
        <!--   <xsl:variable name="fileItemCount">
            <xsl:value-of select="count(/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/unix-sc:file_item)"/>
            </xsl:variable>         -->
        
               
        <!-- Verify the actual permissions value existing on the system........................................................................................... -->
        <xsl:variable name="fileTestItem_id" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$testId]/oval-res:tested_item/@item_id"/>
        <xsl:variable name="item" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/unix-sc:file_item[@id=$fileTestItem_id]"/>        
        
        <!-- Extract actual value -->
        <xsl:variable name="systemValue">
                    <xsl:value-of select="$item/unix-sc:suid/text()"/>
        </xsl:variable>
        
        <xsl:variable name="message_id">
                <!-- if number of file item is one then display specific message with actual values 
                    <xsl:when test="$fileItemCount = 1"> -->
                    <!-- Check if result is false ........................................................................................... -->
                    <xsl:if test="$result='false'">
                        <xsl:choose>
                            <xsl:when test="$result1 = 'false' and $result2 = 'false' ">
                                        <xsl:text>com.mcafee.pa.msg.FileSUIDValidAnyDirExt</xsl:text>
                            </xsl:when>
                        </xsl:choose>
                    </xsl:if>
                    <!-- Check if result is true ........................................................................................... -->
                    <xsl:if test="$result='true'">
                        <xsl:choose>
                            <xsl:when test="$result1 = 'true' ">
                                <xsl:text>com.mcafee.pa.msg.FileDoesNotExistAnyDirExt</xsl:text>
                            </xsl:when>
                            <xsl:when test="$result1 = 'false' and $result2 = 'true' ">
                                        <xsl:text>com.mcafee.pa.msg.FileSUIDValidAnyDirExt</xsl:text>
                            </xsl:when>
                        </xsl:choose>
                    </xsl:if>
        </xsl:variable>
        
        <xsl:variable name="isViolationValue">
            <xsl:choose>
                <xsl:when test="$result = 'false' ">
                    <xsl:text>true</xsl:text>                                              
                </xsl:when>
                <xsl:when test="$result = 'true' ">
                    <xsl:text>false</xsl:text>                                              
                </xsl:when>
            </xsl:choose>               
        </xsl:variable>
                
        <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
            <xsl:attribute name="id">
                <xsl:value-of select="$definitionId"/>
            </xsl:attribute>
            <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2" >
                <xsl:attribute name="messageId">
                    <xsl:value-of select="$message_id"/>
                </xsl:attribute>
                <xsl:attribute name="isViolation">
                    <xsl:value-of select="$isViolationValue"/>
                </xsl:attribute>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">UserValue</xsl:attribute>
                    <xsl:value-of select="$externalVarValue"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">DirectoryPath</xsl:attribute>
                    <xsl:value-of select="$filePath"/>
                </xsl:element>  
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">SystemValue</xsl:attribute>
                    <xsl:value-of select="$systemValue"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">config_name</xsl:attribute>
                    <xsl:value-of select="$title"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">FileName</xsl:attribute>
                    <xsl:value-of select="$fileName"/>
                </xsl:element>         
            </xsl:element>
        </xsl:element>
        
    </xsl:template>
</xsl:stylesheet>