<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
  xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
  xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
  xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
  xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
  xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
  xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
  exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def ind-sc ind-def">
  <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>

  <!-- This library is to handle the OVAL checks with the multiple text file tests and file existence test.
         Text file test verifies if a specific patterns of text is present in the configuration file in test.
          
          Logic :-
          <criteria operator="AND">
          <criterion comment="Test if the file /etc/security/audit_event exists" test_ref="oval:com.mcafee.oval:tst:234490"/>
          <criterion comment="Test if the CIS audit class is added to audit event AUE_ACCEPT" test_ref="oval:com.mcafee.oval:tst:244289"/>
          <criterion comment="Test if the CIS audit class is added to audit event AUE_CONNECT" test_ref="oval:com.mcafee.oval:tst:249316"/>
          <criterion comment="Test if the CIS audit class is added to audit event AUE_SOCKACCEPT" test_ref="oval:com.mcafee.oval:tst:249317"/>
          <criterion comment="Test if the CIS audit class is added to audit event AUE_SOCKCONNECT" test_ref="oval:com.mcafee.oval:tst:249318"/>
          <criterion comment="Test if the CIS audit class is added to audit event AUE_inetd_connect" test_ref="oval:com.mcafee.oval:tst:249319"/>
          .
          .
          .
          
          </criteria>
          
          Ex. OVAL ID - oval:com.mcafee.oval:def:405793, oval:com.mcafee.oval:def:244286, oval:com.mcafee.oval:def:244285
  -->
  

  
  <xsl:param name="defid" />
  <xsl:template match="/">
    <xsl:call-template name="getFindings">
      <xsl:with-param name="definitionId" select="$defid" />
    </xsl:call-template>
  </xsl:template>
  
  <xsl:template name="getFindings">
    <xsl:param name="definitionId"/>
    <xsl:variable name="result" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
    <xsl:variable name="title" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>
    <xsl:variable name="description" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:description"/>
    
    <xsl:variable name="fileTest_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test/@id"/>
    <xsl:variable name="result1" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$fileTest_id]/@result"/>
    
    <xsl:variable name="definitionFileTest" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test[@id=$fileTest_id]"/>
    <xsl:variable name="filePath" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:file_object[@id=$definitionFileTest/unix-def:object/@object_ref]/unix-def:path/text()" />
    <xsl:variable name="fileName" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:file_object[@id=$definitionFileTest/unix-def:object/@object_ref]/unix-def:filename/text()" />
    
    <xsl:variable name="fileContentTest_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test/@id"/>
    <xsl:variable name="result2" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$fileContentTest_id]/@result"/>

    
    <xsl:variable name="config">
      <xsl:choose>       
        <xsl:when test="contains($description,'AUE')">
          <xsl:value-of select="concat('AUE',substring-before(substring-after($description,'AUE'),' in'))"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="concat('AUE',substring-after($description,'AUE'))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="fileInfo">
          <xsl:value-of select="concat($filePath,'/', $fileName)"/>
    </xsl:variable>
       
    
    <xsl:variable name="isViolationValue">
      <xsl:choose>
        <xsl:when test="$result = 'false' ">
          <xsl:text>true</xsl:text>
        </xsl:when>
        <xsl:when test="$result = 'true' ">
          <xsl:text>false</xsl:text>
        </xsl:when>
      </xsl:choose>
    </xsl:variable>
    
    <xsl:variable name="message_id">
          <!-- Check if result is true ......................................... -->
          <xsl:if test="$result='true'">
            <xsl:text>com.mcafee.pa.msg.solarisAuditFileContentPattern</xsl:text>
          </xsl:if>            
          <!-- Check if result is false .......................................-->
          <xsl:if test="$result='false' ">
            <xsl:choose>
              <xsl:when test="$result1='false'">
                <xsl:text>com.mcafee.pa.msg.configfileDoesNotExists</xsl:text>    
              </xsl:when>
              <xsl:otherwise>
                <xsl:text>com.mcafee.pa.msg.solarisAuditFileContentPattern</xsl:text> 
              </xsl:otherwise>
            </xsl:choose>
          </xsl:if>    
   </xsl:variable>
    
    <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
      <xsl:attribute name="id">
        <xsl:value-of select="$definitionId"/>
      </xsl:attribute>
      <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
        <xsl:attribute name="messageId">
          <xsl:value-of select="$message_id"/>
        </xsl:attribute>
        <xsl:attribute name="isViolation">
          <xsl:value-of select="$isViolationValue"/>
        </xsl:attribute>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">config_name</xsl:attribute>
          <xsl:value-of select="$title"/>
        </xsl:element>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">config</xsl:attribute>
          <xsl:value-of select="$config"/>
        </xsl:element>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">file_info</xsl:attribute>
          <xsl:value-of select="$fileInfo"/>
        </xsl:element>
      </xsl:element>
    </xsl:element>
</xsl:template>
</xsl:stylesheet>

