<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
    xmlns:linux-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#linux"
    exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def">
    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>
    
    <!-- This library is to verify if inetd service is installed on system and check for the status of a specific inetd service status.
        
        This library works fine for the below check logic:
        
        <criteria operator="OR">
            <criterion comment="Test if the file /etc/inet/inetd.conf exists" negate="true" test_ref="oval:com.mcafee.oval:tst:234095"/> - File existence test
            <criterion comment="The BSD line printer protocol should be enabled or disabled as appropriate." test_ref="oval:com.mcafee.oval:tst:8199"/> - inetd test
        </criteria>
        
        Test cases:
         1. Pass - Confuguration is set as required.
         2. Pass - Inetd service is not installed. 
         3. Fail -  The inetd service $$service_name$$ using protocol $$protocol$$ is enabled.
        
        Example def id: oval:com.mcafee.oval:def:8198
    -->
    
    <xsl:param name="defid" />
    <xsl:template match="/">
        <xsl:call-template name="getFindings">
            <xsl:with-param name="definitionId" select="$defid"/>
        </xsl:call-template>
    </xsl:template>
  
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
         <xsl:variable name="result" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <xsl:variable name="Definitions" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
        <xsl:variable name="title" select="$Definitions/oval-def:definition[@id=$definitionId ]/oval-def:metadata/oval-def:title"/>
        
        <xsl:variable name="inetdTest_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:inetd_test/@id"/>
        <xsl:variable name="inetdRes" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$inetdTest_id]/@result"/>
        
        <xsl:variable name="fileTest_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test/@id"/>
        <xsl:variable name="fileRes" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$fileTest_id]/@result"/>
        
        <xsl:variable name="definitioninetdTest" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:inetd_test[@id=$inetdTest_id]"/>
        <xsl:variable name="inetdSrvName" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:inetd_object[@id=$definitioninetdTest/unix-def:object/@object_ref]/unix-def:service_name/text()" />
        <xsl:variable name="inetdProtName" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:inetd_object[@id=$definitioninetdTest/unix-def:object/@object_ref]/unix-def:protocol/text()" />
        
              
        <!-- Decide about the message id depending upon  the combination of results for various criterions ........................................................................................... -->
        <xsl:variable name="message_id">
            <xsl:choose>
                <xsl:when test="$result='true'">
                    <xsl:choose>
                        <xsl:when test="$fileRes='true'">
                            <xsl:text>com.mcafee.pa.msg.InetdStatusSCAP</xsl:text>        
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:text>com.mcafee.pa.msg.PatternMatchSCAP</xsl:text>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <xsl:when test="$result='false'">
                    <xsl:text>com.mcafee.pa.msg.linuxInetdVarDisabled</xsl:text>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="isViolationValue">
            <xsl:choose>
                <xsl:when test="$result = 'false' ">
                    <xsl:text>true</xsl:text>
                </xsl:when>
                <xsl:when test="$result = 'true' ">
                    <xsl:text>false</xsl:text>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
                
        <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
            <xsl:attribute name="id">
                <xsl:value-of select="$definitionId"/>
            </xsl:attribute>
            <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="messageId">
                    <xsl:value-of select="$message_id"/>
                </xsl:attribute>
                <xsl:attribute name="isViolation">
                    <xsl:value-of select="$isViolationValue"/>
                </xsl:attribute>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">config_name</xsl:attribute>
                    <xsl:value-of select="$title"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">service_name</xsl:attribute>
                    <xsl:value-of select="$inetdSrvName"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">protocol</xsl:attribute>
                    <xsl:value-of select="$inetdProtName"/>
                </xsl:element>
            </xsl:element>
        </xsl:element>
    </xsl:template>
</xsl:stylesheet>