<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
    xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def ind-sc ind-def">
    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>
    
    <!-- This library is for Linux/Unix checks related to Login shell and shadow password for system user accounts.
        
        <criteria operator="OR">
        <criterion negate="true" test_ref='oval:com.mcafee.oval:tst:1174731' comment='Test if halt account exists on the halttem.' />
        <criteria operator="AND">
        <criterion test_ref='oval:com.mcafee.oval:tst:1174732' comment='Verify if the shell for the halt account is assigned appropriately.' />
        <criterion test_ref='oval:com.mcafee.oval:tst:1174733' comment='Verify if the halt account has an invalid shadow password.' />
        </criteria>
        </criteria>
        
        Ex. OVAL ID - oval:com.mcafee.oval:def:1174624
       
       Library written by :- Rakesh Jain
       
    -->
    
    <xsl:param name="defid" />
    <xsl:template match="/">
        <xsl:call-template name="getFindings">
            <xsl:with-param name="definitionId" select="$defid"/>
        </xsl:call-template>
    </xsl:template>
    
    <!-- This library is for Linux/Unix checks related to Login shell and shadow password for user account should be set appropriately -->
    
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        <!-- Collect the final result of the OVAL check -->
        <xsl:variable name="result" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <!-- Collect configuration name from the title --> 
        <xsl:variable name="Definitions" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
        <xsl:variable name="title" select="$Definitions/oval-def:definition[@id=$definitionId ]/oval-def:metadata/oval-def:title"/>
        
        <!-- Collect all test references, test results and other misc data  required --> 
        
        <!-- It is assumed that password_test[1] is a account existence test, password_test[2] is shell verification test and shadow_test[1] is shadowa password verification in the OVAL checks -->
        <xsl:variable name="passwdTest1_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:password_test[1]/@id"/>
        <xsl:variable name="passwdTest2_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:password_test[2]/@id"/>
        <xsl:variable name="shadowTest1_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:shadow_test[1]/@id"/>
        
        <xsl:variable name="result1" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$passwdTest1_id]/@result"/>
        <xsl:variable name="result2" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$passwdTest2_id]/@result"/>
        <xsl:variable name="result3" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$shadowTest1_id]/@result"/>
        
        <xsl:variable name="definitionPasswdTest" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:password_test[@id=$passwdTest2_id]"/>
        <xsl:variable name="definitionShadowTest" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:shadow_test[@id=$shadowTest1_id]"/>
        <xsl:variable name="userName" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:password_object[@id=$definitionPasswdTest/unix-def:object/@object_ref]/unix-def:username/text()" />
        <xsl:variable name="expectedConfig1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states/unix-def:password_state[@id=$definitionPasswdTest/unix-def:state/@state_ref]/unix-def:login_shell/text()" />
        <xsl:variable name="expectedConfig2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states/unix-def:shadow_state[@id=$definitionShadowTest/unix-def:state/@state_ref]/unix-def:password/text()" />
        
        <xsl:variable name="passwdObj_ref" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:password_test[@id=$passwdTest2_id]/unix-def:object/@object_ref" />
        <xsl:variable name="passwdObj_flag" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:collected_objects/oval-sc:object[@id=$passwdObj_ref]/@flag"/>
        
        <xsl:variable name="passwditem_id" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$passwdTest2_id]/oval-res:tested_item/@item_id"/>        
        <xsl:variable name="passwditem" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/unix-sc:password_item[@id=$passwditem_id]" />      
        
        
        <xsl:variable name="shadowitem_id" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$shadowTest1_id]/oval-res:tested_item/@item_id"/>        
        <xsl:variable name="shadowitem" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/unix-sc:shadow_item[@id=$shadowitem_id]" /> 
        
        <xsl:variable name="actualConfig1" select="$passwditem/unix-sc:login_shell/text()"/>
        <xsl:variable name="actualConfig2" select="$shadowitem/unix-sc:password/text()"/>
        
        <!-- Decide about the message id depending upon  the combination of results for various criterions/tests -->
        <xsl:variable name="message_id">
            <!-- Check if result is true -->
            <xsl:if test="$result='true'">
                <xsl:choose>
                    <xsl:when test="$result1 = 'false' and $result2 = 'true'  and $result3 = 'true' " >
                        <!-- The configuration $$config_name$$ is set to one of the required setting of '%%actual_config1%%' and %%actual_config2%%'. -->
                        <xsl:text>com.mcafee.pa.msg.ShellAndShadowConfigStatus</xsl:text>
                    </xsl:when>
                    <xsl:when test="$result1 = 'true' and $result2 = 'false' and $passwdObj_flag= 'does not exist' and $result3 = 'true'" >
                        <!-- The user $$user_name$$ does not exists on the system. -->
                        <xsl:text>com.mcafee.pa.msg.UserDoesNotExists</xsl:text>
                    </xsl:when>
                    <xsl:when test="$result1 = 'true' and $result2 = 'false' and $passwdObj_flag= 'does not exist' and $result3 = 'false'" >
                        <!-- The user $$user_name$$ does not exists on the system. -->
                        <xsl:text>com.mcafee.pa.msg.UserDoesNotExists</xsl:text>
                    </xsl:when>
                    <xsl:when test="$result1 = 'true' and $result2 = 'true' and $passwdObj_flag= 'complete' and $result3 = 'false'" >
                        <!-- The user $$user_name$$ does not exists on the system. -->
                        <xsl:text>com.mcafee.pa.msg.UserDoesNotExists</xsl:text>
                    </xsl:when>
                </xsl:choose>
            </xsl:if>            
            <!-- Check if result is false -->
            <xsl:if test="$result='false' ">
                <xsl:choose>
                    <xsl:when test="$result1 = 'false' and $result2 = 'false' and $passwdObj_flag= 'complete' and $actualConfig1 !='' and $result3 = 'true'">
                        <!-- The configuration $$config_name$$ is not set to '%%actual_config1%%', expected to be configured with '##expected_config1##'. -->
                        <xsl:text>com.mcafee.pa.msg.ShellConfigStatus</xsl:text>
                    </xsl:when>
                    <xsl:when test="$result1 = 'false' and $result2 = 'true' and $passwdObj_flag= 'complete' and $result3 = 'false'">
                        <!-- The configuration $$config_name$$ is not set to '%%actual_config2%%', expected to be configured with '##expected_config2##'. -->
                        <xsl:text>com.mcafee.pa.msg.ShadowConfigStatus</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                        <!-- The configuration $$config_name$$ is not configured. -->
                        <xsl:text>com.mcafee.pa.msg.configNotSet</xsl:text>                        
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:if>  
        </xsl:variable>
        
        <xsl:variable name="isViolationValue">
            <xsl:choose>
                <xsl:when test="$result = 'false' ">
                    <xsl:text>true</xsl:text>
                </xsl:when>
                <xsl:when test="$result = 'true' ">
                    <xsl:text>false</xsl:text>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
        
        <!-- <xsl:variable name="configName">
            <xsl:variable name="cName">
                <xsl:if test="contains($title, 'The shell and shadow password for the')">
                    <xsl:value-of select="substring-before($title, ' should be')"/>
                </xsl:if>
            </xsl:variable>
            <xsl:choose>
                <xsl:when test="$cName != '' ">
                    <xsl:if test="starts-with($cName, 'The ')">
                        <xsl:value-of select="substring-after($cName, 'The ')"/>
                    </xsl:if>
                    <xsl:if test="starts-with($cName, 'shell ')">
                        <xsl:value-of select="$cName"/>
                    </xsl:if>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$title"/>
                </xsl:otherwise>
            </xsl:choose>
            </xsl:variable> -->
        
        <xsl:variable name="configName" select="$title"/>
        
        <!-- The following section should be compliant to PA findings schema -->
        <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
            <xsl:attribute name="id">
                <xsl:value-of select="$definitionId"/>
            </xsl:attribute>
            <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="messageId">
                    <xsl:value-of select="$message_id"/>
                </xsl:attribute>
                <xsl:attribute name="isViolation">
                    <xsl:value-of select="$isViolationValue"/>
                </xsl:attribute>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">expected_config1</xsl:attribute>
                    <xsl:value-of select="$expectedConfig1" />
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">expected_config2</xsl:attribute>
                    <xsl:value-of select="$expectedConfig2" />
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">user_name</xsl:attribute>
                    <xsl:value-of select="$userName"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">config_name</xsl:attribute>
                    <xsl:value-of select="$configName"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">actual_config1</xsl:attribute>
                    <xsl:value-of select="$actualConfig1"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">actual_config2</xsl:attribute>
                    <xsl:value-of select="$actualConfig2"/>
                </xsl:element>
            </xsl:element>
        </xsl:element>
        
    </xsl:template>
</xsl:stylesheet>