<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema"   
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan"
    >
    
    <!--
        
        This XSL is apply to the definition which are made to check whether for an application the required security update is installed or not. 
        This is specific to Microsoft Office Patch Checks of SCAP Content.
        
        Patch details will be piacked from the title. 
        
        Usual title pattern would be <Microsoft Security bulletin name> - Security Update for application name with/without service pack (Main KB name, Sub KB Name)
        
        Example: MS10-063 - Security Update for Microsoft Office 2007 SP2 (KB2320113, KB2288621)
        
         Criteria (and)
                  Criterion :  Reg or file test ( Check for application)  
                      one or more...
                  Criterion :  File or reg test ( Check service pack if required)  (OPTIONAL)
                      one or more...
                  Criterion :  File or reg test with negation=true (Check patch is installed) 
    -->
    <xsl:variable name="Definitions"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
    <xsl:variable name="Tests"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests"/>
    <xsl:variable name="TestedItems"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests"/>
    <xsl:variable name="CollectedObjects"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:collected_objects"/>
    <xsl:variable name="SystemData"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data"/>
    <xsl:variable name="States"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states"/>
    <xsl:variable name="Objects"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects"/>
    <xsl:variable name="Variables"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables"/>
    <xsl:variable name="OvalResult"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions"/>
    
    <xsl:variable name="smallcase" select="'abcdefghijklmnopqrstuvwxyz'" />
    <xsl:variable name="uppercase" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'" />
    
    <xsl:template name="toggleBoolean">
        <xsl:param name="value"/>
        <xsl:choose>
            <xsl:when test="$value = 'true'">
                <xsl:value-of select="false()"/>
            </xsl:when>
            <xsl:when test="$value = 'false'">
                <xsl:value-of select="true()"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="true()"/>
            </xsl:otherwise>
        </xsl:choose>
        
        
    </xsl:template>
    
    <!-- definition for getFindings() function -->
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
         
        <xsl:variable name="result"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        <xsl:call-template name="winSoftwareVersionCheck">
            <xsl:with-param name="definitionId" select="$definitionId"/>
            <xsl:with-param name="def_result" select="$result"/>
        </xsl:call-template>
    </xsl:template>
    
    <!-- definition for winSoftwareVersionCheck() function -->
    <xsl:template name="winSoftwareVersionCheck">
        <xsl:param name="definitionId"/>       
        <xsl:param name="def_result"/>
        
         
         <xsl:variable name="title">
	<xsl:value-of select="$Definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>            
        </xsl:variable>
                
        <xsl:variable name="software">
            <xsl:value-of select="$title"/>
        </xsl:variable>
        
      
        <xsl:variable name="crt2Res">
            <xsl:value-of select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:criterion[2]/@result"/>            
        </xsl:variable>
        
		<xsl:variable name="crt3Res">
            <xsl:value-of select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:criterion[3]/@result"/>            
        </xsl:variable>
		
        <xsl:variable name="patRes">
            <xsl:value-of select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:criterion[4]/@result"/>            
        </xsl:variable>
		
      <xsl:variable name="tests">
              <xsl:choose>
                 <xsl:when test="$crt2Res='true' and $crt3Res='true'">
                    <xsl:variable name="crtFlag" select="0"/>
                        <xsl:element name="test">
                            <xsl:attribute name="crtFlag">
                                 <xsl:value-of select="$crtFlag"/>
                            </xsl:attribute>
                         </xsl:element>
                 </xsl:when>
                  <xsl:otherwise>
                      <xsl:variable name="crtFlag" select="1"/>
                          <xsl:element name="test">
                              <xsl:attribute name="crtFlag">
                                  <xsl:value-of select="$crtFlag"/>
                          </xsl:attribute>
                      </xsl:element>  
                  </xsl:otherwise>
              </xsl:choose>
      </xsl:variable>
        
        <xsl:for-each select="xalan:nodeset($tests)/descendant::test">
            <xsl:variable name="TestResult" select="$patRes"/>
            <xsl:variable name="crtFlag" select="@crtFlag"/>
            
            <xsl:if test="$def_result = 'true'  and $TestResult='true'">
                
                <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:variable name="message_id">
                        <xsl:text>com.mcafee.pa.msg.SecUpdInstalled_MNAC</xsl:text>          
                    </xsl:variable>
                        <finding messageId="{$message_id}" isViolation="true">
                            <instanceValue key="software">
                                <xsl:value-of select="$software"/>                                                    
                            </instanceValue> 
                        </finding>
                </findings>
                
            </xsl:if>
            
            <xsl:if test="$def_result = 'false'  and $TestResult='false' and $crtFlag='0'">
                
                <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:variable name="message_id">
                        <xsl:text>com.mcafee.pa.msg.SecUpdInstalled_MNAC</xsl:text>          
                    </xsl:variable>
                        <finding messageId="{$message_id}" isViolation="false">
                            <instanceValue key="software">
                                <xsl:value-of select="$software"/>                                                    
                            </instanceValue> 
                        </finding>
               </findings>
            </xsl:if>
            <xsl:if test="$def_result = 'false'  and $TestResult='true'">
                
                <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:variable name="message_id">
                        <xsl:text>com.mcafee.pa.msg.SecUpdNotApplicable_MNAC</xsl:text>          
                    </xsl:variable>
                    
                        <finding messageId="{$message_id}" isViolation="false">
                            <instanceValue key="software">
                                <xsl:value-of select="$software"/>                                                    
                            </instanceValue> 
                        </finding>
                    
                </findings>
                
            </xsl:if>
          
            <xsl:if test="$def_result = 'false'  and $TestResult='false' and $crtFlag='1'">
                
                <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:variable name="message_id">
                        <xsl:text>com.mcafee.pa.msg.SecUpdNotApplicable_MNAC</xsl:text>          
                    </xsl:variable>
                    
                        <finding messageId="{$message_id}" isViolation="false">
                            <instanceValue key="software">
                                <xsl:value-of select="$software"/>                                                    
                            </instanceValue> 
                        </finding>
                    
                </findings>
                
            </xsl:if>
            </xsl:for-each>
    </xsl:template>
</xsl:stylesheet>