<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan"
    xmlns:fnd="http://results.pa.mcafee.com/findings/5.2">

    <!--
        
        This XSLT is used for the definition which want to verify whether some system configuration is not set as 
        expected by the user in the user input. Choice of user input should be available in the external variable with all 
        the posssible value. 
        
        Message id :  Message id is generated by the template getMessageId. 
        
        Message id is generated by the id of the definition.          
        Message id is generated by the concatenation of  "com.mcafee.pa.msg.winconfiguration" 
        and the phrase of the definition id after "oval:com.mcafee." without  "." and ":" . 
        
        This messages are added in the Windows Messages file.
        
        Schema for the definition is : ( It should have only family and registry tests ) 
        
       Criterio ( and )
            criterion : family test 
            criterion              Registry test  with input value
            criterion              Registry test  to test the existance of the registry  ( optional )
            criterion              Registry test  to test the proper type of the registry value ( ( optional ))
         or 
        
        Criterio ( and )
            criterion : family test 
            Criterio ( and )
                criterion              Registry test  with input value
                criterion              Registry test  to test the existance of the registry  ( optional )
                criterion              Registry test  to test the proper type of the registry value ( ( optional ))
      
    -->
    <!--<xsl:template match="/">
        <xsl:call-template name="getFindings">
            <xsl:with-param name="definitionId">oval:com.mcafee.oval.windows:def:6019</xsl:with-param>
        </xsl:call-template>    
    </xsl:template>-->
	
	<!-- IsViolation value corrected to true -->
    
    <xsl:variable name="Definitions"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
    <xsl:variable name="Tests"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests"/>
    <xsl:variable name="TestedItems"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests"/>
    <xsl:variable name="CollectedObjects"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:collected_objects"/>
    <xsl:variable name="SystemData"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data"/>
    <xsl:variable name="States"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states"/>
    <xsl:variable name="Objects"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects"/>
    <xsl:variable name="Variables"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables"/>
    <xsl:variable name="OvalResult"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions"/>

    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>

        <xsl:variable name="result"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>

        <xsl:variable name="unorderedFindings">
            <xsl:call-template name="winConfigurationCheck">
            <xsl:with-param name="definitionId" select="$definitionId"/>
            <xsl:with-param name="def_result" select="$result"/>
        </xsl:call-template>
        </xsl:variable>
        
        <!-- Now arrange all the nodes to fit the schema. All <inputValue/> nodes must come first, followed by all <finding/> nodes-->
        
            <findings id="{xalan:nodeset($unorderedFindings)/descendant::fnd:findings/@id}"  xmlns="http://results.pa.mcafee.com/findings/5.2">
                <xsl:copy>
                    <xsl:copy-of select="xalan:nodeset($unorderedFindings)/descendant::fnd:inputValue"/>
                    <xsl:copy-of select="xalan:nodeset($unorderedFindings)/descendant::fnd:finding"/>
                </xsl:copy>
            </findings>
    </xsl:template>

    <xsl:template name="winConfigurationCheck">
        <xsl:param name="definitionId"/>
        <xsl:param name="def_result"/>

        <xsl:variable name="tests">
            <xsl:for-each select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:criterion">

                <xsl:variable name="test" select="@test_ref"/>
                <xsl:if test="$Tests/win-def:user_test[@id=$test]">
                    <xsl:variable name="object"
                        select="$Tests/win-def:user_test[@id=$test]/win-def:object/@object_ref"/>
                    <xsl:variable name="state"
                        select="$Tests/win-def:user_test[@id=$test]/win-def:state/@state_ref"/>

                    <xsl:variable name="user" select="$Objects/win-def:user_object[@id=$object]/win-def:user/text()"/>                    
                    <xsl:variable name="enabledVarId" select="$States/win-def:user_state[@id=$state]/win-def:enabled/@var_ref"/>
                                                            
                    <xsl:element name="test">
                        <xsl:attribute name="id">
                            <xsl:value-of select="$test"/>
                        </xsl:attribute>                     
                       <xsl:attribute name="state">
                            <xsl:value-of select="$state"/>
                       </xsl:attribute>
                        <xsl:attribute name="user">
                            <xsl:value-of select="$user"/>
                        </xsl:attribute>
                        <xsl:attribute name="enabledVarId">
                            <xsl:value-of select="$enabledVarId"/>
                        </xsl:attribute>                     
                        <xsl:attribute name="type">
                            <xsl:text>usertest</xsl:text>
                        </xsl:attribute>                        
                    </xsl:element>
                </xsl:if>

                <xsl:if test="$Tests/oval-ind:family_test[@id=$test]">
                    <xsl:element name="test">
                        <xsl:attribute name="id">
                            <xsl:value-of select="$test"/>
                        </xsl:attribute>
                        <xsl:attribute name="type">
                            <xsl:text>family</xsl:text>
                        </xsl:attribute>
                    </xsl:element>
                </xsl:if>
            </xsl:for-each>

        </xsl:variable>

        <xsl:variable name="exDefinitionId">
            <xsl:for-each
                select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:extend_definition[@result = 'false'] ">
                <xsl:if test="./parent::node()/@result = 'false' ">
                    <xsl:element name="extend_definition">
                        <xsl:attribute name="id">
                            <xsl:value-of select="@definition_ref"/>
                        </xsl:attribute>
                        <xsl:attribute name="result">
                            <xsl:value-of select="@result"/>
                        </xsl:attribute>
                    </xsl:element>
                </xsl:if>
            </xsl:for-each>
        </xsl:variable>

        <xsl:variable name="rs_exDefinition">
            <xsl:value-of
                select="xalan:nodeset($exDefinitionId)/descendant::extend_definition/@result"/>
        </xsl:variable>

        <xsl:variable name="pre_test_result">
            <xsl:choose>
                <xsl:when test="$rs_exDefinition != '' ">
                    <xsl:value-of select="$rs_exDefinition"/>
                </xsl:when>
                <xsl:when
                    test="xalan:nodeset($tests)/descendant::test[ @type ='family' ]/@id != '' ">
                    <xsl:variable name="test"
                        select="xalan:nodeset($tests)/descendant::test[ @type ='family' ]/@id"/>
                    <xsl:value-of select="$TestedItems/oval-res:test[@test_id=$test ]/@result"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text>true</xsl:text>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>


        <xsl:if test=" $pre_test_result = 'true' and $def_result = 'false' ">
            <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">
                
                <xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @type ='usertest' ]">
                    <xsl:variable name="test" select="@id"/>
                    <xsl:variable name="state" select="@state"/>
                    <xsl:variable name="user" select="@user"/>
                    <xsl:variable name="enabledVarId" select="@enabledVarId"/>
                    
                    <xsl:if test="$enabledVarId != '' ">
                        <xsl:variable name="enabledVarValue" select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable[@variable_id = $enabledVarId]"/>
                                                
                        <xsl:for-each select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[ @result = 'false'  or @result = 'error'  or  @result='not evaluated' ] ">

                            <xsl:variable name="itemRef" select="@item_id"/>
                            <xsl:variable name="result" select="@result"/>

                            <xsl:variable name="actualParameterValue" select="$SystemData/win-sc:user_item[@id=$itemRef]/win-sc:enabled"/>
                            <xsl:variable name="userExistanceStatus" select="$SystemData/win-sc:user_item[@id=$itemRef]/@status"/>
                                                                                    
                            <xsl:choose>
                                <xsl:when test="$state = ''">
                                    <xsl:variable name="message_id">
                                        <xsl:choose>
                                            <xsl:when test="$userExistanceStatus = 'does not exist'">
                                                <xsl:text>com.mcafee.pa.msg.winUserMustExist</xsl:text>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <xsl:text>com.mcafee.pa.msg.winUserMustNotExist</xsl:text>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </xsl:variable>
                                    <finding messageId="{$message_id}" isViolation="true">
                                        <instanceValue key="user">
                                            <xsl:value-of select="$user"/>
                                        </instanceValue>
                                    </finding>
                                </xsl:when>
                                <xsl:when test="$userExistanceStatus = 'does not exist'">
                                    <finding messageId="com.mcafee.pa.msg.winUserMustExist" isViolation="true">
										<instanceValue key="user">
                                            <xsl:value-of select="$user"/>
                                        </instanceValue>
                                        <actualValue key="actualValue">
                                            <xsl:value-of select="$actualParameterValue"/>
                                        </actualValue>
                                    </finding>
                                </xsl:when>
                                <!--<xsl:when test="$enabledVarValue != $actualParameterValue">
                                    <xsl:variable name="message_id"><xsl:text>com.mcafee.pa.msg.winUserEnabledStatus</xsl:text></xsl:variable>
                                    <inputValue key="expectedValue">
                                        <xsl:value-of select="$enabledVarValue"/>
                                    </inputValue>
                                    <finding messageId="{$message_id}" isViolation="true">
                                        <actualValue key="actualValue">
                                            <xsl:value-of select="$actualParameterValue"/>
                                        </actualValue>
                                    </finding>
                                </xsl:when>-->
									<xsl:when test="$enabledVarValue != $actualParameterValue">
                                    <xsl:variable name="message_id"><xsl:text>com.mcafee.pa.msg.winUserEnabledStatus</xsl:text></xsl:variable>
                                    <inputValue key="expectedValue">
                                        <xsl:value-of select="$enabledVarValue"/>
                                    </inputValue>
                                    <finding messageId="{$message_id}" isViolation="true">
										<instanceValue key="user">
                                            <xsl:value-of select="$user"/>
                                        </instanceValue>
                                        <actualValue key="actualValue">
                                            <xsl:value-of select="$actualParameterValue"/>
                                        </actualValue>
                                    </finding>
                                </xsl:when>
                            </xsl:choose>
                        </xsl:for-each>
                    </xsl:if>
                </xsl:for-each>
            </findings>
        </xsl:if>

        <xsl:if test=" $def_result = 'true' ">
            <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">
                
                <xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @type ='usertest' ]">
                    <xsl:variable name="test" select="@id"/>
                    <xsl:variable name="state" select="@state"/>
                    <xsl:variable name="user" select="@user"/>                    
                    <xsl:variable name="enabledVarId" select="@enabledVarId"/>
                    
                    <xsl:if test="$enabledVarId != '' ">
                        <xsl:variable name="enabledVarValue" select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable[@variable_id = $enabledVarId]"/>
                        
                        <xsl:for-each select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[@result = 'true'] ">
                            
                            <xsl:variable name="itemRef" select="@item_id"/>
                            <xsl:variable name="result" select="@result"/>
                            
                            <xsl:variable name="actualParameterValue" select="$SystemData/win-sc:user_item[@id=$itemRef]/win-sc:enabled"/>
                            <xsl:variable name="userExistanceStatus" select="$SystemData/win-sc:user_item[@id=$itemRef]/@status"/>
                            
                            <xsl:choose>
                                <xsl:when test="$state = ''">
                                    <xsl:variable name="message_id">
                                        <xsl:choose>
                                            <xsl:when test="$userExistanceStatus = 'does not exist'">
                                                <xsl:text>com.mcafee.pa.msg.winUserMustExist</xsl:text>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <xsl:text>com.mcafee.pa.msg.winUserMustNotExist</xsl:text>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </xsl:variable>
                                    <finding messageId="{$message_id}" isViolation="false">
                                        <instanceValue key="user">
                                            <xsl:value-of select="$user"/>
                                        </instanceValue>
                                    </finding>
                                </xsl:when>
                                <xsl:when test="$userExistanceStatus = 'does not exist'">
                                    <finding messageId="com.mcafee.pa.msg.winUserAbsenceFailure" isViolation="false">
                                        <actualValue key="actualValue">
                                            <xsl:value-of select="$actualParameterValue"/>
                                        </actualValue>
                                    </finding>
                                </xsl:when>
                                <xsl:when test="$enabledVarValue = $actualParameterValue">
                                    <xsl:variable name="message_id"><xsl:text>com.mcafee.pa.msg.winUserEnabledStatus</xsl:text></xsl:variable>
                                    <inputValue key="expectedValue">
                                        <xsl:value-of select="$enabledVarValue"/>
                                    </inputValue>
                                    <finding messageId="{$message_id}" isViolation="false">
										<instanceValue key="user">
                                            <xsl:value-of select="$user"/>
                                        </instanceValue>
                                        <actualValue key="actualValue">
                                            <xsl:value-of select="$actualParameterValue"/>
                                        </actualValue>
                                    </finding>
                                </xsl:when>
                            </xsl:choose>                                                                                        
                        </xsl:for-each>
                    </xsl:if>                    
                </xsl:for-each>
            </findings>
        </xsl:if>

        <xsl:if test="$pre_test_result = 'false'  and $def_result = 'false' ">
            <xsl:variable name="getIE7InstallationResult">
                <xsl:value-of select="xalan:nodeset($exDefinitionId)/descendant::extend_definition[@id = 'oval:com.mcafee.oval.ie7:def:627']/@result"/>
            </xsl:variable>
            <xsl:if test="$getIE7InstallationResult = 'false' ">
                <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">
                    <finding messageId="com.mcafee.pa.msg.ie7isnotinstalled" isViolation="true"/>
                </findings>
            </xsl:if>
            <xsl:variable name="getWindowsXPInstallationResult">
                <xsl:value-of select="xalan:nodeset($exDefinitionId)/descendant::extend_definition[@id = 'oval:com.mcafee.oval.1:def:2']/@result"/>
            </xsl:variable>
            <xsl:if test="$getWindowsXPInstallationResult = 'false' ">
                <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">
                    <finding messageId="com.mcafee.pa.msg.winxpisnotinstalled" isViolation="true"/>
                </findings>
            </xsl:if>
        </xsl:if>
    </xsl:template>

</xsl:stylesheet>
