
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan">
    
    
    <xsl:include  href="common.xsl" /> 
    
    <xsl:template name="getExternalVariableName">
        <xsl:param name="id"/>

        <xsl:variable name="variableComment">
            <xsl:value-of select="$Variables/oval-def:external_variable[@id = $id]/@comment"/>
        </xsl:variable>

    <xsl:variable name="formatted_comment">    
        <xsl:choose>
            <xsl:when test="$variableComment != '' ">

                <xsl:choose>                    
                    <xsl:when test="contains($variableComment, ':' )">
                        <xsl:value-of select="substring-after($variableComment , ':' )"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="$variableComment"/>
                    </xsl:otherwise>
                </xsl:choose>

            </xsl:when>
            <xsl:otherwise>
                <xsl:text/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    
    <xsl:variable name="removed_brakets_comment">
    <xsl:call-template name="removeBracketsFromComment">
        <xsl:with-param name="comment" select="$formatted_comment"/>
        <xsl:with-param name="length" select="string-length($formatted_comment)"/>
        <xsl:with-param name="index" select="number(1)"/>
        <xsl:with-param  name="in_bracket" select="false()"/>              
    </xsl:call-template>
    </xsl:variable>
     <xsl:value-of select="$removed_brakets_comment"/>
        
    </xsl:template>
    
    <xsl:template name="removeBracketsFromComment">
        <xsl:param name="comment"/>
        <xsl:param name="in_bracket"/>
        <xsl:param name="index"/>
        <xsl:param name="length"/>
        
        <xsl:choose>
            <xsl:when test=" $index &lt;= $length and $in_bracket = false() and substring($comment,$index,1) != '('  ">
                        <xsl:value-of select="substring($comment,$index,1)"/>
                    <xsl:call-template name="removeBracketsFromComment">
                        <xsl:with-param name="comment" select="$comment"/>
                        <xsl:with-param name="length" select="$length"/>
                        <xsl:with-param name="index" select="$index + 1"/>
                        <xsl:with-param  name="in_bracket" select="$in_bracket"/>
                    </xsl:call-template>
            </xsl:when>
            <xsl:when test=" $index &lt;= $length and $in_bracket = false() and substring($comment,$index,1) = '('  ">
                <xsl:call-template name="removeBracketsFromComment">
                    <xsl:with-param name="comment" select="$comment"/>
                    <xsl:with-param name="length" select="$length"/>
                    <xsl:with-param name="index" select="$index + 1"/>
                    <xsl:with-param  name="in_bracket" select="true()"/>
                </xsl:call-template>                                        
            </xsl:when>
            <xsl:when test=" $index &lt;= $length and $in_bracket = true() and substring($comment,$index,1) = ')'  ">
                <xsl:call-template name="removeBracketsFromComment">
                    <xsl:with-param name="comment" select="$comment"/>
                    <xsl:with-param name="length" select="$length"/>
                    <xsl:with-param name="index" select="$index + 1"/>
                    <xsl:with-param  name="in_bracket" select="false()"/>
                </xsl:call-template>                                        
            </xsl:when>
             <xsl:when test=" $index &lt;= $length ">       
                <xsl:call-template name="removeBracketsFromComment">
                    <xsl:with-param name="comment" select="$comment"/>
                    <xsl:with-param name="length" select="$length"/>
                    <xsl:with-param name="index" select="$index + 1"/>
                    <xsl:with-param  name="in_bracket" select="$in_bracket"/>
                </xsl:call-template>
            </xsl:when>
        </xsl:choose>
        
    </xsl:template>
    
    <xsl:template name="getQuntitativeValue">
        <xsl:param name="id"/>
        <xsl:param name="numaricValue"/>
        
        <xsl:variable name="comment">
            <xsl:value-of select="translate($Variables/oval-def:external_variable[@id = $id]/@comment,$uppercase,$smallcase)"/>
        </xsl:variable>
        
        <xsl:variable name="time">
            <xsl:choose>
                
                <xsl:when test="contains($comment, ' milliseconds' )">                    
                            <xsl:value-of select="$numaricValue"/><xsl:text> MilliSeconds</xsl:text>                              
                </xsl:when>
                
                <xsl:when test="contains($comment, ' seconds' )">
                    <xsl:choose>
                        <xsl:when test="number(number($numaricValue) div  number( 60 * 60 * 24 )) &gt;= 1">
                            <xsl:value-of select="number($numaricValue) div  number( 60 * 60 * 24 )"/><xsl:text> Days</xsl:text>                                
                        </xsl:when>
                        <xsl:when test="number(number($numaricValue) div  number( 60 * 60 )) &gt;= 1">
                            <xsl:value-of select="number($numaricValue) div  number( 60 * 60 )"/><xsl:text> Hours</xsl:text>                                
                        </xsl:when>
                        <xsl:when test="number(number($numaricValue) div  60) &gt;= 1">
                            <xsl:value-of select="number($numaricValue) div  60"/><xsl:text> Minutes</xsl:text>                                
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="$numaricValue"/><xsl:text> Seconds</xsl:text>                                
                        </xsl:otherwise>
                    </xsl:choose>
                    
                    
                </xsl:when>
                <xsl:when test="contains($comment, 'minutes' )">
                    <xsl:choose>
                        <xsl:when test="number(number($numaricValue) div  number( 60 * 24 )) &gt;= 1">
                            <xsl:value-of select="number($numaricValue) div  number( 60 * 24 )"/><xsl:text> Days</xsl:text>                                
                        </xsl:when>
                        <xsl:when test="number(number($numaricValue) div  60) &gt;= 1">
                            <xsl:value-of select="number($numaricValue) div  60"/><xsl:text> Hours</xsl:text>                                
                        </xsl:when>                        
                        <xsl:otherwise>
                            <xsl:value-of select="$numaricValue"/><xsl:text> Minutes</xsl:text>                                
                        </xsl:otherwise>
                        </xsl:choose>
                </xsl:when>
                <xsl:when test="contains($comment, 'hours' )">
                    <xsl:choose>
                        <xsl:when test="number(number($numaricValue) div  24) &gt;= 1">
                            <xsl:value-of select="number($numaricValue) div  24"/><xsl:text> Days</xsl:text>                                
                        </xsl:when>                                                
                        <xsl:otherwise>
                            <xsl:value-of select="$numaricValue"/><xsl:text> Hours</xsl:text>                                
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <xsl:when test="contains($comment, 'days' )">
                    <xsl:value-of select="$numaricValue"/> <xsl:text> Days</xsl:text>     
                </xsl:when>
            </xsl:choose>
            
        </xsl:variable>
        
        <xsl:variable name="size">
            <xsl:choose>                
                <xsl:when test="contains($comment, 'kilobytes' )">
                    <xsl:choose>
                        <xsl:when test="number(number($numaricValue) div  1024) &gt;= 1">
                            <xsl:value-of select="number($numaricValue) div  1024"/><xsl:text> MB</xsl:text>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="$numaricValue"/><xsl:text> KB</xsl:text>                                
                        </xsl:otherwise>
                    </xsl:choose>                    
                </xsl:when>
                
                <xsl:when test="contains($comment, 'bytes' )">
                    <xsl:choose>
                        <xsl:when test="number(number($numaricValue) div  number( 1024 *1024 ) ) &gt;= 1">
                            <xsl:value-of select="number($numaricValue) div  number( 1024 * 1024 )"/><xsl:text> MB</xsl:text>
                        </xsl:when>
                        <xsl:when test="number(number($numaricValue) div  1024) &gt;= 1">
                            <xsl:value-of select="number($numaricValue) div  1024"/><xsl:text> KB</xsl:text>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="$numaricValue"/><xsl:text> Bytes</xsl:text>                                
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:when>                
            </xsl:choose>            
        </xsl:variable>
        
        <xsl:choose>
            <xsl:when test="$time != '' ">
                <xsl:value-of select="$time"/>
            </xsl:when>
            <xsl:when test="$size != '' ">
                <xsl:value-of select="$size"/>
            </xsl:when>
        </xsl:choose>
        
        
     </xsl:template>
        
        
    <xsl:template name="getExternalVariablePrintableValue">
        <xsl:param name="id"/>
        <xsl:param name="numaricValue"/>

 
        <xsl:variable name="printableValue">
            <xsl:for-each select="$Variables/oval-def:external_variable[@id = $id]/descendant::oval-def:possible_value">
                <xsl:if test="text() = $numaricValue">
                    <xsl:value-of select="@hint"/>
                </xsl:if>
            </xsl:for-each>
        </xsl:variable>

        <xsl:variable name="datatype">
                <xsl:call-template name="getExternalVariableDataType">
                    <xsl:with-param name="id" select="$id"/>       
                </xsl:call-template>
        </xsl:variable>
    
    <xsl:variable name="time_or_size_value">
            <xsl:if test="$datatype = 'int' ">
                 <xsl:call-template name="getQuntitativeValue">
                     <xsl:with-param name="id" select="$id"/>
                     <xsl:with-param name="numaricValue" select="$numaricValue"/>
                 </xsl:call-template>
            </xsl:if>
    </xsl:variable>
        
     <xsl:variable name="formattedNumaricValue">
         <xsl:if test="$time_or_size_value != '' ">
             <xsl:value-of select="$time_or_size_value"/>
         </xsl:if>
         <xsl:if test="$time_or_size_value = '' ">
             <xsl:value-of select="$numaricValue"/>
         </xsl:if>
     </xsl:variable>   
        
    <xsl:variable name="processValue">
        <xsl:choose>
            <xsl:when test="$printableValue != '' ">
                <xsl:choose>
                    <xsl:when test="contains($printableValue, '-' )">
                        <xsl:value-of select="substring-after($printableValue , '-' )"/>
                    </xsl:when>
                    <xsl:when test="contains($printableValue, ',' )">
                        <xsl:value-of select="substring-after($printableValue , ',' )"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="$printableValue"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$formattedNumaricValue"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    
    
    <xsl:choose>        
        <xsl:when test="$datatype = 'int' and $processValue != $formattedNumaricValue">
            <xsl:value-of select="concat($formattedNumaricValue, ' ( ' , $processValue , ' ) ' )"/>
        </xsl:when>
        <xsl:when test="$datatype = 'int' ">
            <xsl:value-of select="$formattedNumaricValue"/>
        </xsl:when>    
        <xsl:otherwise>
            <xsl:value-of select="$processValue"/>
        </xsl:otherwise>
    </xsl:choose>
        
    </xsl:template>

    <xsl:template name="getExternalVariableDataType">
        <xsl:param name="id"/>

        <xsl:variable name="datatype">
            <xsl:value-of select="$Variables/oval-def:external_variable[@id = $id]/@datatype"/>
        </xsl:variable>

        <xsl:variable name="values">
            <xsl:for-each select="$Variables/oval-def:external_variable[@id = $id]/*">
                <xsl:value-of select="text()"/>
            </xsl:for-each>
        </xsl:variable>

        <xsl:choose>
            <xsl:when test="$values= '01' or $values = '10'  ">
                <xsl:text>boolean</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$datatype"/>
            </xsl:otherwise>
        </xsl:choose>

    </xsl:template>

    
</xsl:stylesheet>
